// Code generated by smithy-go-codegen DO NOT EDIT.

package pcaconnectorscep

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pcaconnectorscep/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the challenge metadata for the specified ARN.
func (c *Client) ListChallengeMetadata(ctx context.Context, params *ListChallengeMetadataInput, optFns ...func(*Options)) (*ListChallengeMetadataOutput, error) {
	if params == nil {
		params = &ListChallengeMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListChallengeMetadata", params, optFns, c.addOperationListChallengeMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListChallengeMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListChallengeMetadataInput struct {

	// The Amazon Resource Name (ARN) of the connector.
	//
	// This member is required.
	ConnectorArn *string

	// The maximum number of objects that you want Connector for SCEP to return for
	// this request. If more objects are available, in the response, Connector for SCEP
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	MaxResults *int32

	// When you request a list of objects with a MaxResults setting, if the number of
	// objects that are still available for retrieval exceeds the maximum you
	// requested, Connector for SCEP returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string

	noSmithyDocumentSerde
}

type ListChallengeMetadataOutput struct {

	// The challenge metadata for the challenges belonging to your Amazon Web Services
	// account.
	Challenges []types.ChallengeMetadataSummary

	// When you request a list of objects with a MaxResults setting, if the number of
	// objects that are still available for retrieval exceeds the maximum you
	// requested, Connector for SCEP returns a NextToken value in the response. To
	// retrieve the next batch of objects, use the token returned from the prior
	// request in your next request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListChallengeMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListChallengeMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListChallengeMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListChallengeMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListChallengeMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListChallengeMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListChallengeMetadataPaginatorOptions is the paginator options for
// ListChallengeMetadata
type ListChallengeMetadataPaginatorOptions struct {
	// The maximum number of objects that you want Connector for SCEP to return for
	// this request. If more objects are available, in the response, Connector for SCEP
	// provides a NextToken value that you can use in a subsequent call to get the
	// next batch of objects.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListChallengeMetadataPaginator is a paginator for ListChallengeMetadata
type ListChallengeMetadataPaginator struct {
	options   ListChallengeMetadataPaginatorOptions
	client    ListChallengeMetadataAPIClient
	params    *ListChallengeMetadataInput
	nextToken *string
	firstPage bool
}

// NewListChallengeMetadataPaginator returns a new ListChallengeMetadataPaginator
func NewListChallengeMetadataPaginator(client ListChallengeMetadataAPIClient, params *ListChallengeMetadataInput, optFns ...func(*ListChallengeMetadataPaginatorOptions)) *ListChallengeMetadataPaginator {
	if params == nil {
		params = &ListChallengeMetadataInput{}
	}

	options := ListChallengeMetadataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListChallengeMetadataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListChallengeMetadataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListChallengeMetadata page.
func (p *ListChallengeMetadataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListChallengeMetadataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListChallengeMetadata(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListChallengeMetadataAPIClient is a client that implements the
// ListChallengeMetadata operation.
type ListChallengeMetadataAPIClient interface {
	ListChallengeMetadata(context.Context, *ListChallengeMetadataInput, ...func(*Options)) (*ListChallengeMetadataOutput, error)
}

var _ ListChallengeMetadataAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListChallengeMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListChallengeMetadata",
	}
}
