// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the details of an engagement invitation shared by AWS with a partner.
// The information includes aspects such as customer, project details, and
// lifecycle information. To connect an engagement invitation with an opportunity,
// match the invitation’s Payload.Project.Title with opportunity Project.Title .
func (c *Client) GetEngagementInvitation(ctx context.Context, params *GetEngagementInvitationInput, optFns ...func(*Options)) (*GetEngagementInvitationOutput, error) {
	if params == nil {
		params = &GetEngagementInvitationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEngagementInvitation", params, optFns, c.addOperationGetEngagementInvitationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEngagementInvitationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEngagementInvitationInput struct {

	// Specifies the catalog associated with the request. The field accepts values
	// from the predefined set: AWS for live operations or Sandbox for testing
	// environments.
	//
	// This member is required.
	Catalog *string

	// Specifies the unique identifier for the retrieved engagement invitation.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetEngagementInvitationOutput struct {

	// Indicates the catalog from which the engagement invitation details are
	// retrieved. This field helps in identifying the appropriate catalog (e.g., AWS
	// or Sandbox ) used in the request.
	//
	// This member is required.
	Catalog *string

	// Unique identifier assigned to the engagement invitation being retrieved.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) that identifies the engagement invitation.
	Arn *string

	// The description of the engagement associated with this invitation.
	EngagementDescription *string

	// The identifier of the engagement associated with this invitation.This ID links
	// the invitation to its corresponding engagement.
	EngagementId *string

	// The title of the engagement invitation, summarizing the purpose or objectives
	// of the opportunity shared by AWS.
	EngagementTitle *string

	// A list of active members currently part of the Engagement. This array contains
	// a maximum of 10 members, each represented by an object with the following
	// properties.
	//
	//   - CompanyName: The name of the member's company.
	//
	//   - WebsiteUrl: The website URL of the member's company.
	ExistingMembers []types.EngagementMemberSummary

	// Indicates the date on which the engagement invitation will expire if not
	// accepted by the partner.
	ExpirationDate *time.Time

	// The date when the engagement invitation was sent to the partner.
	InvitationDate *time.Time

	// The message sent to the invited partner when the invitation was created.
	InvitationMessage *string

	// Details of the engagement invitation payload, including specific data relevant
	// to the invitation's contents, such as customer information and opportunity
	// insights.
	Payload types.Payload

	// The type of payload contained in the engagement invitation, indicating what
	// data or context the payload covers.
	PayloadType types.EngagementInvitationPayloadType

	// Information about the partner organization or team that received the engagement
	// invitation, including contact details and identifiers.
	Receiver types.Receiver

	// If the engagement invitation was rejected, this field specifies the reason
	// provided by the partner for the rejection.
	RejectionReason *string

	// Specifies the AWS Account ID of the sender, which identifies the AWS team
	// responsible for sharing the engagement invitation.
	SenderAwsAccountId *string

	// The name of the AWS organization or team that sent the engagement invitation.
	SenderCompanyName *string

	// The current status of the engagement invitation.
	Status types.InvitationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEngagementInvitationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetEngagementInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetEngagementInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEngagementInvitation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetEngagementInvitationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEngagementInvitation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEngagementInvitation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEngagementInvitation",
	}
}
