// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this action to create a job to generate a snapshot of the specified
// resource within an engagement. It initiates an asynchronous process to create a
// resource snapshot. The job creates a new snapshot only if the resource state has
// changed, adhering to the same access control and immutability rules as direct
// snapshot creation.
func (c *Client) CreateResourceSnapshotJob(ctx context.Context, params *CreateResourceSnapshotJobInput, optFns ...func(*Options)) (*CreateResourceSnapshotJobOutput, error) {
	if params == nil {
		params = &CreateResourceSnapshotJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateResourceSnapshotJob", params, optFns, c.addOperationCreateResourceSnapshotJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateResourceSnapshotJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateResourceSnapshotJobInput struct {

	// Specifies the catalog in which to create the snapshot job. Valid values are AWS
	// and Sandbox .
	//
	// This member is required.
	Catalog *string

	// A client-generated UUID used for idempotency check. The token helps prevent
	// duplicate job creations.
	//
	// This member is required.
	ClientToken *string

	// Specifies the identifier of the engagement associated with the resource to be
	// snapshotted.
	//
	// This member is required.
	EngagementIdentifier *string

	// Specifies the identifier of the specific resource to be snapshotted. The format
	// depends on the ResourceType .
	//
	// This member is required.
	ResourceIdentifier *string

	// Specifies the name of the template that defines the schema for the snapshot.
	//
	// This member is required.
	ResourceSnapshotTemplateIdentifier *string

	// The type of resource for which the snapshot job is being created. Must be one
	// of the supported resource types i.e. Opportunity
	//
	// This member is required.
	ResourceType types.ResourceType

	// A map of the key-value pairs of the tag or tags to assign.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateResourceSnapshotJobOutput struct {

	// The Amazon Resource Name (ARN) of the created snapshot job.
	Arn *string

	// The unique identifier for the created snapshot job.
	Id *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateResourceSnapshotJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateResourceSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateResourceSnapshotJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateResourceSnapshotJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateResourceSnapshotJobMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateResourceSnapshotJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateResourceSnapshotJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateResourceSnapshotJob struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateResourceSnapshotJob) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateResourceSnapshotJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateResourceSnapshotJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateResourceSnapshotJobInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateResourceSnapshotJobMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateResourceSnapshotJob{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateResourceSnapshotJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateResourceSnapshotJob",
	}
}
