// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearchserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/opensearchserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of OpenSearch Serverless lifecycle policies. For more
// information, see [Viewing data lifecycle policies].
//
// [Viewing data lifecycle policies]: https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list
func (c *Client) ListLifecyclePolicies(ctx context.Context, params *ListLifecyclePoliciesInput, optFns ...func(*Options)) (*ListLifecyclePoliciesOutput, error) {
	if params == nil {
		params = &ListLifecyclePoliciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListLifecyclePolicies", params, optFns, c.addOperationListLifecyclePoliciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListLifecyclePoliciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListLifecyclePoliciesInput struct {

	// The type of lifecycle policy.
	//
	// This member is required.
	Type types.LifecyclePolicyType

	// An optional parameter that specifies the maximum number of results to return.
	// You can use use nextToken to get the next page of results. The default is 10.
	MaxResults *int32

	// If your initial ListLifecyclePolicies operation returns a nextToken , you can
	// include the returned nextToken in subsequent ListLifecyclePolicies operations,
	// which returns results in the next page.
	NextToken *string

	// Resource filters that policies can apply to. Currently, the only supported
	// resource type is index .
	Resources []string

	noSmithyDocumentSerde
}

type ListLifecyclePoliciesOutput struct {

	// Details about the requested lifecycle policies.
	LifecyclePolicySummaries []types.LifecyclePolicySummary

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListLifecyclePoliciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListLifecyclePolicies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListLifecyclePolicies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListLifecyclePolicies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListLifecyclePoliciesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListLifecyclePolicies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListLifecyclePoliciesPaginatorOptions is the paginator options for
// ListLifecyclePolicies
type ListLifecyclePoliciesPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListLifecyclePoliciesPaginator is a paginator for ListLifecyclePolicies
type ListLifecyclePoliciesPaginator struct {
	options   ListLifecyclePoliciesPaginatorOptions
	client    ListLifecyclePoliciesAPIClient
	params    *ListLifecyclePoliciesInput
	nextToken *string
	firstPage bool
}

// NewListLifecyclePoliciesPaginator returns a new ListLifecyclePoliciesPaginator
func NewListLifecyclePoliciesPaginator(client ListLifecyclePoliciesAPIClient, params *ListLifecyclePoliciesInput, optFns ...func(*ListLifecyclePoliciesPaginatorOptions)) *ListLifecyclePoliciesPaginator {
	if params == nil {
		params = &ListLifecyclePoliciesInput{}
	}

	options := ListLifecyclePoliciesPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListLifecyclePoliciesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListLifecyclePoliciesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListLifecyclePolicies page.
func (p *ListLifecyclePoliciesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListLifecyclePoliciesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListLifecyclePolicies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListLifecyclePoliciesAPIClient is a client that implements the
// ListLifecyclePolicies operation.
type ListLifecyclePoliciesAPIClient interface {
	ListLifecyclePolicies(context.Context, *ListLifecyclePoliciesInput, ...func(*Options)) (*ListLifecyclePoliciesOutput, error)
}

var _ ListLifecyclePoliciesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListLifecyclePolicies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListLifecyclePolicies",
	}
}
