// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/notifications/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a specified EventRule .
func (c *Client) GetEventRule(ctx context.Context, params *GetEventRuleInput, optFns ...func(*Options)) (*GetEventRuleOutput, error) {
	if params == nil {
		params = &GetEventRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEventRule", params, optFns, c.addOperationGetEventRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEventRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEventRuleInput struct {

	// The Amazon Resource Name (ARN) of the EventRule to return.
	//
	// This member is required.
	Arn *string

	noSmithyDocumentSerde
}

type GetEventRuleOutput struct {

	// The ARN of the resource.
	//
	// This member is required.
	Arn *string

	// The date when the EventRule was created.
	//
	// This member is required.
	CreationTime *time.Time

	// An additional event pattern used to further filter the events this EventRule
	// receives.
	//
	// For more information, see [Amazon EventBridge event patterns] in the Amazon EventBridge User Guide.
	//
	// [Amazon EventBridge event patterns]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html
	//
	// This member is required.
	EventPattern *string

	// The event type to match.
	//
	// Must match one of the valid Amazon EventBridge event types. For example, EC2
	// Instance State-change Notification and Amazon CloudWatch Alarm State Change. For
	// more information, see [Event delivery from Amazon Web Services services]in the Amazon EventBridge User Guide.
	//
	// [Event delivery from Amazon Web Services services]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level
	//
	// This member is required.
	EventType *string

	// A list of managed rules from EventBridge that are associated with this EventRule
	// .
	//
	// These are created by User Notifications within your account so this EventRule
	// functions.
	//
	// This member is required.
	ManagedRules []string

	// The ARN of a NotificationConfiguration .
	//
	// This member is required.
	NotificationConfigurationArn *string

	// A list of Amazon Web Services Regions that send events to this EventRule .
	//
	// This member is required.
	Regions []string

	// The matched event source.
	//
	// Must match one of the valid EventBridge sources. Only Amazon Web Services
	// service sourced events are supported. For example, aws.ec2 and aws.cloudwatch .
	// For more information, see [Event delivery from Amazon Web Services services]in the Amazon EventBridge User Guide.
	//
	// [Event delivery from Amazon Web Services services]: https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-delivery-level
	//
	// This member is required.
	Source *string

	// A list of an EventRule 's status by Region. Regions are mapped to
	// EventRuleStatusSummary .
	//
	// This member is required.
	StatusSummaryByRegion map[string]types.EventRuleStatusSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEventRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEventRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEventRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEventRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetEventRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEventRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEventRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEventRule",
	}
}
