// Code generated by smithy-go-codegen DO NOT EDIT.

package memorydb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/memorydb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns details about one or more multi-Region clusters.
func (c *Client) DescribeMultiRegionClusters(ctx context.Context, params *DescribeMultiRegionClustersInput, optFns ...func(*Options)) (*DescribeMultiRegionClustersOutput, error) {
	if params == nil {
		params = &DescribeMultiRegionClustersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeMultiRegionClusters", params, optFns, c.addOperationDescribeMultiRegionClustersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeMultiRegionClustersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeMultiRegionClustersInput struct {

	// The maximum number of results to return.
	MaxResults *int32

	// The name of a specific multi-Region cluster to describe.
	MultiRegionClusterName *string

	// A token to specify where to start paginating.
	NextToken *string

	// Details about the multi-Region cluster.
	ShowClusterDetails *bool

	noSmithyDocumentSerde
}

type DescribeMultiRegionClustersOutput struct {

	// A list of multi-Region clusters.
	MultiRegionClusters []types.MultiRegionCluster

	// A token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeMultiRegionClustersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeMultiRegionClusters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeMultiRegionClusters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeMultiRegionClusters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeMultiRegionClusters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeMultiRegionClustersPaginatorOptions is the paginator options for
// DescribeMultiRegionClusters
type DescribeMultiRegionClustersPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeMultiRegionClustersPaginator is a paginator for
// DescribeMultiRegionClusters
type DescribeMultiRegionClustersPaginator struct {
	options   DescribeMultiRegionClustersPaginatorOptions
	client    DescribeMultiRegionClustersAPIClient
	params    *DescribeMultiRegionClustersInput
	nextToken *string
	firstPage bool
}

// NewDescribeMultiRegionClustersPaginator returns a new
// DescribeMultiRegionClustersPaginator
func NewDescribeMultiRegionClustersPaginator(client DescribeMultiRegionClustersAPIClient, params *DescribeMultiRegionClustersInput, optFns ...func(*DescribeMultiRegionClustersPaginatorOptions)) *DescribeMultiRegionClustersPaginator {
	if params == nil {
		params = &DescribeMultiRegionClustersInput{}
	}

	options := DescribeMultiRegionClustersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeMultiRegionClustersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeMultiRegionClustersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeMultiRegionClusters page.
func (p *DescribeMultiRegionClustersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeMultiRegionClustersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeMultiRegionClusters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeMultiRegionClustersAPIClient is a client that implements the
// DescribeMultiRegionClusters operation.
type DescribeMultiRegionClustersAPIClient interface {
	DescribeMultiRegionClusters(context.Context, *DescribeMultiRegionClustersInput, ...func(*Options)) (*DescribeMultiRegionClustersOutput, error)
}

var _ DescribeMultiRegionClustersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeMultiRegionClusters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeMultiRegionClusters",
	}
}
