// Code generated by smithy-go-codegen DO NOT EDIT.

package machinelearning

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	mlcust "github.com/aws/aws-sdk-go-v2/service/machinelearning/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/machinelearning/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates a prediction for the observation using the specified ML Model .
//
// Note: Not all response parameters will be populated. Whether a response
// parameter is populated depends on the type of model requested.
func (c *Client) Predict(ctx context.Context, params *PredictInput, optFns ...func(*Options)) (*PredictOutput, error) {
	if params == nil {
		params = &PredictInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "Predict", params, optFns, c.addOperationPredictMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PredictOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PredictInput struct {

	// A unique identifier of the MLModel .
	//
	// This member is required.
	MLModelId *string

	// This member is required.
	PredictEndpoint *string

	// A map of variable name-value pairs that represent an observation.
	//
	// This member is required.
	Record map[string]string

	noSmithyDocumentSerde
}

type PredictOutput struct {

	// The output from a Predict operation:
	//
	//   - Details - Contains the following attributes:
	//   DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS
	//   DetailsAttributes.ALGORITHM - SGD
	//
	//   - PredictedLabel - Present for either a BINARY or MULTICLASS MLModel request.
	//
	//   - PredictedScores - Contains the raw classification score corresponding to
	//   each label.
	//
	//   - PredictedValue - Present for a REGRESSION MLModel request.
	Prediction *types.Prediction

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPredictMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPredict{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPredict{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "Predict"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPredictValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPredict(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = mlcust.AddPredictEndpointMiddleware(stack, getPredictEndpoint); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPredict(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "Predict",
	}
}

func getPredictEndpoint(input interface{}) (*string, error) {
	in, ok := input.(*PredictInput)
	if !ok {
		return nil, &smithy.SerializationError{Err: fmt.Errorf("expected *PredictInput, but was %T", input)}
	}
	return in.PredictEndpoint, nil
}
