// Code generated by smithy-go-codegen DO NOT EDIT.

package m2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/m2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the data set exports for the specified application.
func (c *Client) ListDataSetExportHistory(ctx context.Context, params *ListDataSetExportHistoryInput, optFns ...func(*Options)) (*ListDataSetExportHistoryOutput, error) {
	if params == nil {
		params = &ListDataSetExportHistoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataSetExportHistory", params, optFns, c.addOperationListDataSetExportHistoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataSetExportHistoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataSetExportHistoryInput struct {

	// The unique identifier of the application.
	//
	// This member is required.
	ApplicationId *string

	// The maximum number of objects to return.
	MaxResults *int32

	// A pagination token returned from a previous call to this operation. This
	// specifies the next item to return. To return to the beginning of the list,
	// exclude this parameter.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDataSetExportHistoryOutput struct {

	// The data set export tasks.
	//
	// This member is required.
	DataSetExportTasks []types.DataSetExportTask

	// If there are more items to return, this contains a token that is passed to a
	// subsequent call to this operation to retrieve the next set of items.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataSetExportHistoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataSetExportHistory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataSetExportHistory{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataSetExportHistory"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataSetExportHistoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataSetExportHistory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDataSetExportHistoryPaginatorOptions is the paginator options for
// ListDataSetExportHistory
type ListDataSetExportHistoryPaginatorOptions struct {
	// The maximum number of objects to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataSetExportHistoryPaginator is a paginator for ListDataSetExportHistory
type ListDataSetExportHistoryPaginator struct {
	options   ListDataSetExportHistoryPaginatorOptions
	client    ListDataSetExportHistoryAPIClient
	params    *ListDataSetExportHistoryInput
	nextToken *string
	firstPage bool
}

// NewListDataSetExportHistoryPaginator returns a new
// ListDataSetExportHistoryPaginator
func NewListDataSetExportHistoryPaginator(client ListDataSetExportHistoryAPIClient, params *ListDataSetExportHistoryInput, optFns ...func(*ListDataSetExportHistoryPaginatorOptions)) *ListDataSetExportHistoryPaginator {
	if params == nil {
		params = &ListDataSetExportHistoryInput{}
	}

	options := ListDataSetExportHistoryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataSetExportHistoryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataSetExportHistoryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataSetExportHistory page.
func (p *ListDataSetExportHistoryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataSetExportHistoryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataSetExportHistory(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataSetExportHistoryAPIClient is a client that implements the
// ListDataSetExportHistory operation.
type ListDataSetExportHistoryAPIClient interface {
	ListDataSetExportHistory(context.Context, *ListDataSetExportHistoryInput, ...func(*Options)) (*ListDataSetExportHistoryOutput, error)
}

var _ ListDataSetExportHistoryAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataSetExportHistory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataSetExportHistory",
	}
}
