// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the configuration of an existing slot type.
func (c *Client) UpdateSlotType(ctx context.Context, params *UpdateSlotTypeInput, optFns ...func(*Options)) (*UpdateSlotTypeOutput, error) {
	if params == nil {
		params = &UpdateSlotTypeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSlotType", params, optFns, c.addOperationUpdateSlotTypeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSlotTypeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSlotTypeInput struct {

	// The identifier of the bot that contains the slot type.
	//
	// This member is required.
	BotId *string

	// The version of the bot that contains the slot type. Must be DRAFT .
	//
	// This member is required.
	BotVersion *string

	// The identifier of the language and locale that contains the slot type. The
	// string must match one of the supported locales. For more information, see [Supported languages].
	//
	// [Supported languages]: https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html
	//
	// This member is required.
	LocaleId *string

	// The unique identifier of the slot type to update.
	//
	// This member is required.
	SlotTypeId *string

	// The new name of the slot type.
	//
	// This member is required.
	SlotTypeName *string

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *types.CompositeSlotTypeSetting

	// The new description of the slot type.
	Description *string

	// Provides information about the external source of the slot type's definition.
	ExternalSourceSetting *types.ExternalSourceSetting

	// The new built-in slot type that should be used as the parent of this slot type.
	ParentSlotTypeSignature *string

	// A new list of values and their optional synonyms that define the values that
	// the slot type can take.
	SlotTypeValues []types.SlotTypeValue

	// The strategy that Amazon Lex should use when deciding on a value from the list
	// of slot type values.
	ValueSelectionSetting *types.SlotValueSelectionSetting

	noSmithyDocumentSerde
}

type UpdateSlotTypeOutput struct {

	// The identifier of the bot that contains the slot type.
	BotId *string

	// The version of the bot that contains the slot type. This is always DRAFT .
	BotVersion *string

	// Specifications for a composite slot type.
	CompositeSlotTypeSetting *types.CompositeSlotTypeSetting

	// The timestamp of the date and time that the slot type was created.
	CreationDateTime *time.Time

	// The updated description of the slot type.
	Description *string

	// Provides information about the external source of the slot type's definition.
	ExternalSourceSetting *types.ExternalSourceSetting

	// A timestamp of the date and time that the slot type was last updated.
	LastUpdatedDateTime *time.Time

	// The language and locale of the updated slot type.
	LocaleId *string

	// The updated signature of the built-in slot type that is the parent of this slot
	// type.
	ParentSlotTypeSignature *string

	// The unique identifier of the updated slot type.
	SlotTypeId *string

	// The updated name of the slot type.
	SlotTypeName *string

	// The updated values that the slot type provides.
	SlotTypeValues []types.SlotTypeValue

	// The updated strategy that Amazon Lex uses to determine which value to select
	// from the slot type.
	ValueSelectionSetting *types.SlotValueSelectionSetting

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSlotTypeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSlotType{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSlotType{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSlotType"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateSlotTypeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSlotType(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSlotType(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSlotType",
	}
}
