// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all of the over-the-air (OTA) task configurations.
func (c *Client) ListOtaTaskConfigurations(ctx context.Context, params *ListOtaTaskConfigurationsInput, optFns ...func(*Options)) (*ListOtaTaskConfigurationsOutput, error) {
	if params == nil {
		params = &ListOtaTaskConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOtaTaskConfigurations", params, optFns, c.addOperationListOtaTaskConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOtaTaskConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOtaTaskConfigurationsInput struct {

	// The maximum number of results to return at one time.
	MaxResults *int32

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListOtaTaskConfigurationsOutput struct {

	// The list of the over-the-air (OTA) task configurations.
	Items []types.OtaTaskConfigurationSummary

	// A token that can be used to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOtaTaskConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListOtaTaskConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListOtaTaskConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOtaTaskConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOtaTaskConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListOtaTaskConfigurationsPaginatorOptions is the paginator options for
// ListOtaTaskConfigurations
type ListOtaTaskConfigurationsPaginatorOptions struct {
	// The maximum number of results to return at one time.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOtaTaskConfigurationsPaginator is a paginator for ListOtaTaskConfigurations
type ListOtaTaskConfigurationsPaginator struct {
	options   ListOtaTaskConfigurationsPaginatorOptions
	client    ListOtaTaskConfigurationsAPIClient
	params    *ListOtaTaskConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListOtaTaskConfigurationsPaginator returns a new
// ListOtaTaskConfigurationsPaginator
func NewListOtaTaskConfigurationsPaginator(client ListOtaTaskConfigurationsAPIClient, params *ListOtaTaskConfigurationsInput, optFns ...func(*ListOtaTaskConfigurationsPaginatorOptions)) *ListOtaTaskConfigurationsPaginator {
	if params == nil {
		params = &ListOtaTaskConfigurationsInput{}
	}

	options := ListOtaTaskConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOtaTaskConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOtaTaskConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOtaTaskConfigurations page.
func (p *ListOtaTaskConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOtaTaskConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOtaTaskConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOtaTaskConfigurationsAPIClient is a client that implements the
// ListOtaTaskConfigurations operation.
type ListOtaTaskConfigurationsAPIClient interface {
	ListOtaTaskConfigurations(context.Context, *ListOtaTaskConfigurationsInput, ...func(*Options)) (*ListOtaTaskConfigurationsOutput, error)
}

var _ ListOtaTaskConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOtaTaskConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOtaTaskConfigurations",
	}
}
