// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This retrieves the invoice unit definition.
func (c *Client) GetInvoiceUnit(ctx context.Context, params *GetInvoiceUnitInput, optFns ...func(*Options)) (*GetInvoiceUnitOutput, error) {
	if params == nil {
		params = &GetInvoiceUnitInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetInvoiceUnit", params, optFns, c.addOperationGetInvoiceUnitMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetInvoiceUnitOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetInvoiceUnitInput struct {

	//  The ARN to identify an invoice unit. This information can't be modified or
	// deleted.
	//
	// This member is required.
	InvoiceUnitArn *string

	//  The state of an invoice unit at a specified time. You can see legacy invoice
	// units that are currently deleted if the AsOf time is set to before it was
	// deleted. If an AsOf is not provided, the default value is the current time.
	AsOf *time.Time

	noSmithyDocumentSerde
}

type GetInvoiceUnitOutput struct {

	//  The assigned description for an invoice unit.
	Description *string

	//  The Amazon Web Services account ID chosen to be the receiver of an invoice
	// unit. All invoices generated for that invoice unit will be sent to this account
	// ID.
	InvoiceReceiver *string

	//  The ARN to identify an invoice unit. This information can't be modified or
	// deleted.
	InvoiceUnitArn *string

	//  The most recent date the invoice unit response was updated.
	LastModified *time.Time

	//  The unique name of the invoice unit that is shown on the generated invoice.
	Name *string

	//  This is used to categorize the invoice unit. Values are Amazon Web Services
	// account IDs. Currently, the only supported rule is LINKED_ACCOUNT .
	Rule *types.InvoiceUnitRule

	//  Whether the invoice unit based tax inheritance is/ should be enabled or
	// disabled.
	TaxInheritanceDisabled *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetInvoiceUnitMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetInvoiceUnit{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetInvoiceUnit{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetInvoiceUnit"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetInvoiceUnitValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetInvoiceUnit(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetInvoiceUnit(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetInvoiceUnit",
	}
}
