// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// OptimizeWaypoints calculates the optimal order to travel between a set of
// waypoints to minimize either the travel time or the distance travelled during
// the journey, based on road network restrictions and the traffic pattern data.
func (c *Client) OptimizeWaypoints(ctx context.Context, params *OptimizeWaypointsInput, optFns ...func(*Options)) (*OptimizeWaypointsOutput, error) {
	if params == nil {
		params = &OptimizeWaypointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "OptimizeWaypoints", params, optFns, c.addOperationOptimizeWaypointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*OptimizeWaypointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type OptimizeWaypointsInput struct {

	// The start position for the route.
	//
	// This member is required.
	Origin []float64

	// Features that are avoided. Avoidance is on a best-case basis. If an avoidance
	// can't be satisfied for a particular case, this setting is ignored.
	Avoid *types.WaypointOptimizationAvoidanceOptions

	// Clustering allows you to specify how nearby waypoints can be clustered to
	// improve the optimized sequence.
	Clustering *types.WaypointOptimizationClusteringOptions

	// Departure time from the waypoint.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	DepartureTime *string

	// The final position for the route in the World Geodetic System (WGS 84) format:
	// [longitude, latitude] .
	Destination []float64

	// Destination related options.
	DestinationOptions *types.WaypointOptimizationDestinationOptions

	// Driver related options.
	Driver *types.WaypointOptimizationDriverOptions

	// Features to be strictly excluded while calculating the route.
	Exclude *types.WaypointOptimizationExclusionOptions

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// Specifies the optimization criteria for the calculated sequence.
	//
	// Default Value: FastestRoute .
	OptimizeSequencingFor types.WaypointOptimizationSequencingObjective

	// Origin related options.
	OriginOptions *types.WaypointOptimizationOriginOptions

	// Traffic-related options.
	Traffic *types.WaypointOptimizationTrafficOptions

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// Default Value: Car
	TravelMode types.WaypointOptimizationTravelMode

	// Travel mode related options for the provided travel mode.
	TravelModeOptions *types.WaypointOptimizationTravelModeOptions

	// List of waypoints between the Origin and Destination .
	Waypoints []types.WaypointOptimizationWaypoint

	noSmithyDocumentSerde
}

type OptimizeWaypointsOutput struct {

	// Details about the connection from one waypoint to the next, within the
	// optimized sequence.
	//
	// This member is required.
	Connections []types.WaypointOptimizationConnection

	// Overall distance to travel the whole sequence.
	//
	// This member is required.
	Distance int64

	// Overall duration to travel the whole sequence.
	//
	// Unit: seconds
	//
	// This member is required.
	Duration int64

	// Returns waypoints that caused the optimization problem to fail, and the
	// constraints that were unsatisfied leading to the failure.
	//
	// This member is required.
	ImpedingWaypoints []types.WaypointOptimizationImpedingWaypoint

	// Waypoints in the order of the optimized sequence.
	//
	// This member is required.
	OptimizedWaypoints []types.WaypointOptimizationOptimizedWaypoint

	// The pricing bucket for which the query is charged at.
	//
	// This member is required.
	PricingBucket *string

	// Time breakdown for the sequence.
	//
	// This member is required.
	TimeBreakdown *types.WaypointOptimizationTimeBreakdown

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationOptimizeWaypointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpOptimizeWaypoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpOptimizeWaypoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "OptimizeWaypoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpOptimizeWaypointsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opOptimizeWaypoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opOptimizeWaypoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "OptimizeWaypoints",
	}
}
