// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves container group definitions for the Amazon Web Services account and
// Amazon Web Services Region. Use the pagination parameters to retrieve results in
// a set of sequential pages.
//
// This operation returns only the latest version of each definition. To retrieve
// all versions of a container group definition, use [ListContainerGroupDefinitionVersions].
//
// Request options:
//
//   - Retrieve the most recent versions of all container group definitions.
//
//   - Retrieve the most recent versions of all container group definitions,
//     filtered by type. Specify the container group type to filter on.
//
// Results:
//
// If successful, this operation returns the complete properties of a set of
// container group definition versions that match the request.
//
// This operation returns the list of container group definitions in no particular
// order.
//
// [ListContainerGroupDefinitionVersions]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListContainerGroupDefinitionVersions.html
func (c *Client) ListContainerGroupDefinitions(ctx context.Context, params *ListContainerGroupDefinitionsInput, optFns ...func(*Options)) (*ListContainerGroupDefinitionsOutput, error) {
	if params == nil {
		params = &ListContainerGroupDefinitionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListContainerGroupDefinitions", params, optFns, c.addOperationListContainerGroupDefinitionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListContainerGroupDefinitionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListContainerGroupDefinitionsInput struct {

	// The type of container group to retrieve. Container group type determines how
	// Amazon GameLift deploys the container group on each fleet instance.
	ContainerGroupType types.ContainerGroupType

	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int32

	// A token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this operation. To start at
	// the beginning of the result set, do not specify a value.
	NextToken *string

	noSmithyDocumentSerde
}

type ListContainerGroupDefinitionsOutput struct {

	// A result set of container group definitions that match the request.
	ContainerGroupDefinitions []types.ContainerGroupDefinition

	// A token that indicates where to resume retrieving results on the next call to
	// this operation. If no token is returned, these results represent the end of the
	// list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListContainerGroupDefinitionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListContainerGroupDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListContainerGroupDefinitions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListContainerGroupDefinitions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListContainerGroupDefinitions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListContainerGroupDefinitionsPaginatorOptions is the paginator options for
// ListContainerGroupDefinitions
type ListContainerGroupDefinitionsPaginatorOptions struct {
	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListContainerGroupDefinitionsPaginator is a paginator for
// ListContainerGroupDefinitions
type ListContainerGroupDefinitionsPaginator struct {
	options   ListContainerGroupDefinitionsPaginatorOptions
	client    ListContainerGroupDefinitionsAPIClient
	params    *ListContainerGroupDefinitionsInput
	nextToken *string
	firstPage bool
}

// NewListContainerGroupDefinitionsPaginator returns a new
// ListContainerGroupDefinitionsPaginator
func NewListContainerGroupDefinitionsPaginator(client ListContainerGroupDefinitionsAPIClient, params *ListContainerGroupDefinitionsInput, optFns ...func(*ListContainerGroupDefinitionsPaginatorOptions)) *ListContainerGroupDefinitionsPaginator {
	if params == nil {
		params = &ListContainerGroupDefinitionsInput{}
	}

	options := ListContainerGroupDefinitionsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListContainerGroupDefinitionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListContainerGroupDefinitionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListContainerGroupDefinitions page.
func (p *ListContainerGroupDefinitionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListContainerGroupDefinitionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListContainerGroupDefinitions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListContainerGroupDefinitionsAPIClient is a client that implements the
// ListContainerGroupDefinitions operation.
type ListContainerGroupDefinitionsAPIClient interface {
	ListContainerGroupDefinitions(context.Context, *ListContainerGroupDefinitionsInput, ...func(*Options)) (*ListContainerGroupDefinitionsOutput, error)
}

var _ ListContainerGroupDefinitionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListContainerGroupDefinitions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListContainerGroupDefinitions",
	}
}
