// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The presigned URL properties for the cluster's application user interface.
func (c *Client) GetOnClusterAppUIPresignedURL(ctx context.Context, params *GetOnClusterAppUIPresignedURLInput, optFns ...func(*Options)) (*GetOnClusterAppUIPresignedURLOutput, error) {
	if params == nil {
		params = &GetOnClusterAppUIPresignedURLInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetOnClusterAppUIPresignedURL", params, optFns, c.addOperationGetOnClusterAppUIPresignedURLMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetOnClusterAppUIPresignedURLOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetOnClusterAppUIPresignedURLInput struct {

	// The cluster ID associated with the cluster's application user interface
	// presigned URL.
	//
	// This member is required.
	ClusterId *string

	// The application ID associated with the cluster's application user interface
	// presigned URL.
	ApplicationId *string

	// Determines if the user interface presigned URL is for a dry run.
	DryRun *bool

	// The execution role ARN associated with the cluster's application user interface
	// presigned URL.
	ExecutionRoleArn *string

	// The application UI type associated with the cluster's application user
	// interface presigned URL.
	OnClusterAppUIType types.OnClusterAppUIType

	noSmithyDocumentSerde
}

type GetOnClusterAppUIPresignedURLOutput struct {

	// The cluster's generated presigned URL.
	PresignedURL *string

	// Used to determine if the presigned URL is ready.
	PresignedURLReady *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetOnClusterAppUIPresignedURLMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetOnClusterAppUIPresignedURL{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetOnClusterAppUIPresignedURL{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetOnClusterAppUIPresignedURL"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetOnClusterAppUIPresignedURLValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetOnClusterAppUIPresignedURL(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetOnClusterAppUIPresignedURL(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetOnClusterAppUIPresignedURL",
	}
}
