// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves all of the cost anomalies detected on your account during the time
// period that's specified by the DateInterval object. Anomalies are available for
// up to 90 days.
func (c *Client) GetAnomalies(ctx context.Context, params *GetAnomaliesInput, optFns ...func(*Options)) (*GetAnomaliesOutput, error) {
	if params == nil {
		params = &GetAnomaliesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAnomalies", params, optFns, c.addOperationGetAnomaliesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAnomaliesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAnomaliesInput struct {

	// Assigns the start and end dates for retrieving cost anomalies. The returned
	// anomaly object will have an AnomalyEndDate in the specified time range.
	//
	// This member is required.
	DateInterval *types.AnomalyDateInterval

	// Filters anomaly results by the feedback field on the anomaly object.
	Feedback types.AnomalyFeedbackType

	// The number of entries a paginated response contains.
	MaxResults *int32

	// Retrieves all of the cost anomalies detected for a specific cost anomaly
	// monitor Amazon Resource Name (ARN).
	MonitorArn *string

	// The token to retrieve the next set of results. Amazon Web Services provides the
	// token when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string

	// Filters anomaly results by the total impact field on the anomaly object. For
	// example, you can filter anomalies GREATER_THAN 200.00 to retrieve anomalies,
	// with an estimated dollar impact greater than 200.
	TotalImpact *types.TotalImpactFilter

	noSmithyDocumentSerde
}

type GetAnomaliesOutput struct {

	// A list of cost anomalies.
	//
	// This member is required.
	Anomalies []types.Anomaly

	// The token to retrieve the next set of results. Amazon Web Services provides the
	// token when the response from a previous call has more results than the maximum
	// page size.
	NextPageToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAnomaliesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetAnomalies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetAnomalies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAnomalies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAnomaliesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAnomalies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetAnomaliesPaginatorOptions is the paginator options for GetAnomalies
type GetAnomaliesPaginatorOptions struct {
	// The number of entries a paginated response contains.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetAnomaliesPaginator is a paginator for GetAnomalies
type GetAnomaliesPaginator struct {
	options   GetAnomaliesPaginatorOptions
	client    GetAnomaliesAPIClient
	params    *GetAnomaliesInput
	nextToken *string
	firstPage bool
}

// NewGetAnomaliesPaginator returns a new GetAnomaliesPaginator
func NewGetAnomaliesPaginator(client GetAnomaliesAPIClient, params *GetAnomaliesInput, optFns ...func(*GetAnomaliesPaginatorOptions)) *GetAnomaliesPaginator {
	if params == nil {
		params = &GetAnomaliesInput{}
	}

	options := GetAnomaliesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetAnomaliesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextPageToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetAnomaliesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetAnomalies page.
func (p *GetAnomaliesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetAnomaliesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextPageToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetAnomalies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextPageToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetAnomaliesAPIClient is a client that implements the GetAnomalies operation.
type GetAnomaliesAPIClient interface {
	GetAnomalies(context.Context, *GetAnomaliesInput, ...func(*Options)) (*GetAnomaliesOutput, error)
}

var _ GetAnomaliesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetAnomalies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAnomalies",
	}
}
