// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Initiates a new outbound SMS contact to a customer. Response of this API
// provides the ContactId of the outbound SMS contact created.
//
// SourceEndpoint only supports Endpoints with CONNECT_PHONENUMBER_ARN as Type and
// DestinationEndpoint only supports Endpoints with TELEPHONE_NUMBER as Type.
// ContactFlowId initiates the flow to manage the new SMS contact created.
//
// This API can be used to initiate outbound SMS contacts for an agent, or it can
// also deflect an ongoing contact to an outbound SMS contact by using the [StartOutboundChatContact]Flow
// Action.
//
// For more information about using SMS in Amazon Connect, see the following
// topics in the Amazon Connect Administrator Guide:
//
// [Set up SMS messaging]
//
// [Request an SMS-enabled phone number through AWS End User Messaging SMS]
//
// [Set up SMS messaging]: https://docs.aws.amazon.com/connect/latest/adminguide/setup-sms-messaging.html
// [Request an SMS-enabled phone number through AWS End User Messaging SMS]: https://docs.aws.amazon.com/connect/latest/adminguide/sms-number.html
// [StartOutboundChatContact]: https://docs.aws.amazon.com/connect/latest/APIReference/API_StartOutboundChatContact.html
func (c *Client) StartOutboundChatContact(ctx context.Context, params *StartOutboundChatContactInput, optFns ...func(*Options)) (*StartOutboundChatContactOutput, error) {
	if params == nil {
		params = &StartOutboundChatContactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartOutboundChatContact", params, optFns, c.addOperationStartOutboundChatContactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartOutboundChatContactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartOutboundChatContactInput struct {

	// The identifier of the flow for the call. To see the ContactFlowId in the Amazon
	// Connect console user interface, on the navigation menu go to Routing, Contact
	// Flows. Choose the flow. On the flow page, under the name of the flow, choose
	// Show additional flow information. The ContactFlowId is the last part of the ARN,
	// shown here in bold:
	//
	//   -
	//   arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/123ec456-a007-89c0-1234-xxxxxxxxxxxx
	//
	// This member is required.
	ContactFlowId *string

	// Information about the endpoint.
	//
	// This member is required.
	DestinationEndpoint *types.Endpoint

	// The identifier of the Amazon Connect instance. You can find the instance ID in
	// the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// A set of system defined key-value pairs stored on individual contact segments
	// using an attribute map. The attributes are standard Amazon Connect attributes.
	// They can be accessed in flows.
	//
	//   - Attribute keys can include only alphanumeric, - , and _ .
	//
	//   - This field can be used to show channel subtype, such as connect:Guide and
	//   connect:SMS .
	//
	// This member is required.
	SegmentAttributes map[string]types.SegmentAttributeValue

	// Information about the endpoint.
	//
	// This member is required.
	SourceEndpoint *types.Endpoint

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in flows just like any other
	// contact attributes.
	Attributes map[string]string

	// The total duration of the newly started chat session. If not specified, the
	// chat session duration defaults to 25 hour. The minimum configurable time is 60
	// minutes. The maximum configurable time is 10,080 minutes (7 days).
	ChatDurationInMinutes *int32

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the AWS SDK populates this field. For more
	// information about idempotency, see [Making retries safe with idempotent APIs]. The token is valid for 7 days after
	// creation. If a contact is already started, the contact ID is returned.
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	// A chat message.
	InitialSystemMessage *types.ChatMessage

	// The customer's details.
	ParticipantDetails *types.ParticipantDetails

	// The unique identifier for an Amazon Connect contact. This identifier is related
	// to the contact starting.
	RelatedContactId *string

	// The supported chat message content types. Supported types are:
	//
	//   - text/plain
	//
	//   - text/markdown
	//
	//   - application/json, application/vnd.amazonaws.connect.message.interactive
	//
	//   - application/vnd.amazonaws.connect.message.interactive.response
	//
	// Content types must always contain text/plain . You can then put any other
	// supported type in the list. For example, all the following lists are valid
	// because they contain text/plain :
	//
	//   - [text/plain, text/markdown, application/json]
	//
	//   - [text/markdown, text/plain]
	//
	//   - [text/plain, application/json,
	//   application/vnd.amazonaws.connect.message.interactive.response]
	SupportedMessagingContentTypes []string

	noSmithyDocumentSerde
}

type StartOutboundChatContactOutput struct {

	// The identifier of this contact within the Amazon Connect instance.
	ContactId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartOutboundChatContactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartOutboundChatContact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartOutboundChatContact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartOutboundChatContact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartOutboundChatContactMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartOutboundChatContactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartOutboundChatContact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartOutboundChatContact struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartOutboundChatContact) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartOutboundChatContact) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartOutboundChatContactInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartOutboundChatContactInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartOutboundChatContactMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartOutboundChatContact{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartOutboundChatContact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartOutboundChatContact",
	}
}
