// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtraildata

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cloudtraildata/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpPutAuditEvents struct {
}

func (*validateOpPutAuditEvents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutAuditEvents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutAuditEventsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutAuditEventsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpPutAuditEventsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutAuditEvents{}, middleware.After)
}

func validateAuditEvent(v *types.AuditEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuditEvent"}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.EventData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventData"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAuditEvents(v []types.AuditEvent) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AuditEvents"}
	for i := range v {
		if err := validateAuditEvent(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutAuditEventsInput(v *PutAuditEventsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutAuditEventsInput"}
	if v.AuditEvents == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuditEvents"))
	} else if v.AuditEvents != nil {
		if err := validateAuditEvents(v.AuditEvents); err != nil {
			invalidParams.AddNested("AuditEvents", err.(smithy.InvalidParamsError))
		}
	}
	if v.ChannelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ChannelArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
