// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a prompt router that manages the routing of requests between multiple
// foundation models based on the routing criteria.
func (c *Client) CreatePromptRouter(ctx context.Context, params *CreatePromptRouterInput, optFns ...func(*Options)) (*CreatePromptRouterOutput, error) {
	if params == nil {
		params = &CreatePromptRouterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePromptRouter", params, optFns, c.addOperationCreatePromptRouterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePromptRouterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePromptRouterInput struct {

	// The default model to use when the routing criteria is not met.
	//
	// This member is required.
	FallbackModel *types.PromptRouterTargetModel

	// A list of foundation models that the prompt router can route requests to. At
	// least one model must be specified.
	//
	// This member is required.
	Models []types.PromptRouterTargetModel

	// The name of the prompt router. The name must be unique within your Amazon Web
	// Services account in the current region.
	//
	// This member is required.
	PromptRouterName *string

	// The criteria, which is the response quality difference, used to determine how
	// incoming requests are routed to different models.
	//
	// This member is required.
	RoutingCriteria *types.RoutingCriteria

	// A unique, case-sensitive identifier that you provide to ensure idempotency of
	// your requests. If not specified, the Amazon Web Services SDK automatically
	// generates one for you.
	ClientRequestToken *string

	// An optional description of the prompt router to help identify its purpose.
	Description *string

	// An array of key-value pairs to apply to this resource as tags. You can use tags
	// to categorize and manage your Amazon Web Services resources.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreatePromptRouterOutput struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the prompt router.
	PromptRouterArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePromptRouterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePromptRouter{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePromptRouter{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePromptRouter"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePromptRouterMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePromptRouterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePromptRouter(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePromptRouter struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePromptRouter) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePromptRouter) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePromptRouterInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePromptRouterInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePromptRouterMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePromptRouter{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePromptRouter(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePromptRouter",
	}
}
