// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an endpoint for a model from Amazon Bedrock Marketplace. The endpoint
// is hosted by Amazon SageMaker.
func (c *Client) CreateMarketplaceModelEndpoint(ctx context.Context, params *CreateMarketplaceModelEndpointInput, optFns ...func(*Options)) (*CreateMarketplaceModelEndpointOutput, error) {
	if params == nil {
		params = &CreateMarketplaceModelEndpointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMarketplaceModelEndpoint", params, optFns, c.addOperationCreateMarketplaceModelEndpointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMarketplaceModelEndpointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMarketplaceModelEndpointInput struct {

	// The configuration for the endpoint, including the number and type of instances
	// to use.
	//
	// This member is required.
	EndpointConfig types.EndpointConfig

	// The name of the endpoint. This name must be unique within your Amazon Web
	// Services account and region.
	//
	// This member is required.
	EndpointName *string

	// The ARN of the model from Amazon Bedrock Marketplace that you want to deploy to
	// the endpoint.
	//
	// This member is required.
	ModelSourceIdentifier *string

	// Indicates whether you accept the end-user license agreement (EULA) for the
	// model. Set to true to accept the EULA.
	AcceptEula bool

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. This token is listed as not required because Amazon Web Services
	// SDKs automatically generate it for you and set this parameter. If you're not
	// using the Amazon Web Services SDK or the CLI, you must provide this token or the
	// action will fail.
	ClientRequestToken *string

	// An array of key-value pairs to apply to the underlying Amazon SageMaker
	// endpoint. You can use these tags to organize and identify your Amazon Web
	// Services resources.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateMarketplaceModelEndpointOutput struct {

	// Details about the created endpoint.
	//
	// This member is required.
	MarketplaceModelEndpoint *types.MarketplaceModelEndpoint

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMarketplaceModelEndpointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMarketplaceModelEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMarketplaceModelEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMarketplaceModelEndpoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateMarketplaceModelEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMarketplaceModelEndpointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMarketplaceModelEndpoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateMarketplaceModelEndpoint struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateMarketplaceModelEndpoint) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateMarketplaceModelEndpoint) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateMarketplaceModelEndpointInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateMarketplaceModelEndpointInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateMarketplaceModelEndpointMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateMarketplaceModelEndpoint{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateMarketplaceModelEndpoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMarketplaceModelEndpoint",
	}
}
