// Code generated by smithy-go-codegen DO NOT EDIT.

package apptest

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apptest/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a test run step.
func (c *Client) GetTestRunStep(ctx context.Context, params *GetTestRunStepInput, optFns ...func(*Options)) (*GetTestRunStepOutput, error) {
	if params == nil {
		params = &GetTestRunStepInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTestRunStep", params, optFns, c.addOperationGetTestRunStepMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTestRunStepOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTestRunStepInput struct {

	// The step name of the test run step.
	//
	// This member is required.
	StepName *string

	// The test run ID of the test run step.
	//
	// This member is required.
	TestRunId *string

	// The test case ID of a test run step.
	TestCaseId *string

	// The test suite ID of a test run step.
	TestSuiteId *string

	noSmithyDocumentSerde
}

type GetTestRunStepOutput struct {

	// The run start time of the test run step.
	//
	// This member is required.
	RunStartTime *time.Time

	// The status of the test run step.
	//
	// This member is required.
	Status types.StepRunStatus

	// The step name of the test run step.
	//
	// This member is required.
	StepName *string

	// The test run ID of the test run step.
	//
	// This member is required.
	TestRunId *string

	// The after steps of the test run step.
	AfterStep *bool

	// The before steps of the test run step.
	BeforeStep *bool

	// The run end time of the test run step.
	RunEndTime *time.Time

	// The status reason of the test run step.
	StatusReason *string

	// The step run summary of the test run step.
	StepRunSummary types.StepRunSummary

	// The test case ID of the test run step.
	TestCaseId *string

	// The test case version of the test run step.
	TestCaseVersion *int32

	// The test suite ID of the test run step.
	TestSuiteId *string

	// The test suite version of the test run step.
	TestSuiteVersion *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTestRunStepMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetTestRunStep{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetTestRunStep{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTestRunStep"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetTestRunStepValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTestRunStep(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTestRunStep(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTestRunStep",
	}
}
