//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package rbac

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// Client contains the methods for the Client group.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal *azcore.Client
	endpoint string
}

// CreateOrUpdateRoleDefinition - Creates or updates a custom role definition.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - scope - The scope of the role definition to create or update. Managed HSM only supports '/'.
//   - roleDefinitionName - The name of the role definition to create or update. It can be any valid GUID.
//   - parameters - Parameters for the role definition.
//   - options - CreateOrUpdateRoleDefinitionOptions contains the optional parameters for the Client.CreateOrUpdateRoleDefinition
//     method.
func (client *Client) CreateOrUpdateRoleDefinition(ctx context.Context, scope RoleScope, roleDefinitionName string, parameters RoleDefinitionCreateParameters, options *CreateOrUpdateRoleDefinitionOptions) (CreateOrUpdateRoleDefinitionResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "rbac.Client.CreateOrUpdateRoleDefinition", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateRoleDefinitionCreateRequest(ctx, scope, roleDefinitionName, parameters, options)
	if err != nil {
		return CreateOrUpdateRoleDefinitionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateOrUpdateRoleDefinitionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return CreateOrUpdateRoleDefinitionResponse{}, err
	}
	resp, err := client.createOrUpdateRoleDefinitionHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateRoleDefinitionCreateRequest creates the CreateOrUpdateRoleDefinition request.
func (client *Client) createOrUpdateRoleDefinitionCreateRequest(ctx context.Context, scope RoleScope, roleDefinitionName string, parameters RoleDefinitionCreateParameters, options *CreateOrUpdateRoleDefinitionOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	if roleDefinitionName == "" {
		return nil, errors.New("parameter roleDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleDefinitionName}", url.PathEscape(roleDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateRoleDefinitionHandleResponse handles the CreateOrUpdateRoleDefinition response.
func (client *Client) createOrUpdateRoleDefinitionHandleResponse(resp *http.Response) (CreateOrUpdateRoleDefinitionResponse, error) {
	result := CreateOrUpdateRoleDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleDefinition); err != nil {
		return CreateOrUpdateRoleDefinitionResponse{}, err
	}
	return result, nil
}

// CreateRoleAssignment - Creates a role assignment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - scope - The scope of the role assignment to create.
//   - roleAssignmentName - The name of the role assignment to create. It can be any valid GUID.
//   - parameters - Parameters for the role assignment.
//   - options - CreateRoleAssignmentOptions contains the optional parameters for the Client.CreateRoleAssignment method.
func (client *Client) CreateRoleAssignment(ctx context.Context, scope RoleScope, roleAssignmentName string, parameters RoleAssignmentCreateParameters, options *CreateRoleAssignmentOptions) (CreateRoleAssignmentResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "rbac.Client.CreateRoleAssignment", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createRoleAssignmentCreateRequest(ctx, scope, roleAssignmentName, parameters, options)
	if err != nil {
		return CreateRoleAssignmentResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateRoleAssignmentResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return CreateRoleAssignmentResponse{}, err
	}
	resp, err := client.createRoleAssignmentHandleResponse(httpResp)
	return resp, err
}

// createRoleAssignmentCreateRequest creates the CreateRoleAssignment request.
func (client *Client) createRoleAssignmentCreateRequest(ctx context.Context, scope RoleScope, roleAssignmentName string, parameters RoleAssignmentCreateParameters, options *CreateRoleAssignmentOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	if roleAssignmentName == "" {
		return nil, errors.New("parameter roleAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleAssignmentName}", url.PathEscape(roleAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createRoleAssignmentHandleResponse handles the CreateRoleAssignment response.
func (client *Client) createRoleAssignmentHandleResponse(resp *http.Response) (CreateRoleAssignmentResponse, error) {
	result := CreateRoleAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleAssignment); err != nil {
		return CreateRoleAssignmentResponse{}, err
	}
	return result, nil
}

// DeleteRoleAssignment - Deletes a role assignment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - scope - The scope of the role assignment to delete.
//   - roleAssignmentName - The name of the role assignment to delete.
//   - options - DeleteRoleAssignmentOptions contains the optional parameters for the Client.DeleteRoleAssignment method.
func (client *Client) DeleteRoleAssignment(ctx context.Context, scope RoleScope, roleAssignmentName string, options *DeleteRoleAssignmentOptions) (DeleteRoleAssignmentResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "rbac.Client.DeleteRoleAssignment", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteRoleAssignmentCreateRequest(ctx, scope, roleAssignmentName, options)
	if err != nil {
		return DeleteRoleAssignmentResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteRoleAssignmentResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteRoleAssignmentResponse{}, err
	}
	resp, err := client.deleteRoleAssignmentHandleResponse(httpResp)
	return resp, err
}

// deleteRoleAssignmentCreateRequest creates the DeleteRoleAssignment request.
func (client *Client) deleteRoleAssignmentCreateRequest(ctx context.Context, scope RoleScope, roleAssignmentName string, options *DeleteRoleAssignmentOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	if roleAssignmentName == "" {
		return nil, errors.New("parameter roleAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleAssignmentName}", url.PathEscape(roleAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteRoleAssignmentHandleResponse handles the DeleteRoleAssignment response.
func (client *Client) deleteRoleAssignmentHandleResponse(resp *http.Response) (DeleteRoleAssignmentResponse, error) {
	result := DeleteRoleAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleAssignment); err != nil {
		return DeleteRoleAssignmentResponse{}, err
	}
	return result, nil
}

// DeleteRoleDefinition - Deletes a custom role definition.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - scope - The scope of the role definition to delete. Managed HSM only supports '/'.
//   - roleDefinitionName - The name (GUID) of the role definition to delete.
//   - options - DeleteRoleDefinitionOptions contains the optional parameters for the Client.DeleteRoleDefinition method.
func (client *Client) DeleteRoleDefinition(ctx context.Context, scope RoleScope, roleDefinitionName string, options *DeleteRoleDefinitionOptions) (DeleteRoleDefinitionResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "rbac.Client.DeleteRoleDefinition", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteRoleDefinitionCreateRequest(ctx, scope, roleDefinitionName, options)
	if err != nil {
		return DeleteRoleDefinitionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteRoleDefinitionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteRoleDefinitionResponse{}, err
	}
	resp, err := client.deleteRoleDefinitionHandleResponse(httpResp)
	return resp, err
}

// deleteRoleDefinitionCreateRequest creates the DeleteRoleDefinition request.
func (client *Client) deleteRoleDefinitionCreateRequest(ctx context.Context, scope RoleScope, roleDefinitionName string, options *DeleteRoleDefinitionOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	if roleDefinitionName == "" {
		return nil, errors.New("parameter roleDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleDefinitionName}", url.PathEscape(roleDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteRoleDefinitionHandleResponse handles the DeleteRoleDefinition response.
func (client *Client) deleteRoleDefinitionHandleResponse(resp *http.Response) (DeleteRoleDefinitionResponse, error) {
	result := DeleteRoleDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleDefinition); err != nil {
		return DeleteRoleDefinitionResponse{}, err
	}
	return result, nil
}

// GetRoleAssignment - Get the specified role assignment.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - scope - The scope of the role assignment.
//   - roleAssignmentName - The name of the role assignment to get.
//   - options - GetRoleAssignmentOptions contains the optional parameters for the Client.GetRoleAssignment method.
func (client *Client) GetRoleAssignment(ctx context.Context, scope RoleScope, roleAssignmentName string, options *GetRoleAssignmentOptions) (GetRoleAssignmentResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "rbac.Client.GetRoleAssignment", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getRoleAssignmentCreateRequest(ctx, scope, roleAssignmentName, options)
	if err != nil {
		return GetRoleAssignmentResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetRoleAssignmentResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetRoleAssignmentResponse{}, err
	}
	resp, err := client.getRoleAssignmentHandleResponse(httpResp)
	return resp, err
}

// getRoleAssignmentCreateRequest creates the GetRoleAssignment request.
func (client *Client) getRoleAssignmentCreateRequest(ctx context.Context, scope RoleScope, roleAssignmentName string, options *GetRoleAssignmentOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleAssignments/{roleAssignmentName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	if roleAssignmentName == "" {
		return nil, errors.New("parameter roleAssignmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleAssignmentName}", url.PathEscape(roleAssignmentName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRoleAssignmentHandleResponse handles the GetRoleAssignment response.
func (client *Client) getRoleAssignmentHandleResponse(resp *http.Response) (GetRoleAssignmentResponse, error) {
	result := GetRoleAssignmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleAssignment); err != nil {
		return GetRoleAssignmentResponse{}, err
	}
	return result, nil
}

// GetRoleDefinition - Get the specified role definition.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - scope - The scope of the role definition to get. Managed HSM only supports '/'.
//   - roleDefinitionName - The name of the role definition to get.
//   - options - GetRoleDefinitionOptions contains the optional parameters for the Client.GetRoleDefinition method.
func (client *Client) GetRoleDefinition(ctx context.Context, scope RoleScope, roleDefinitionName string, options *GetRoleDefinitionOptions) (GetRoleDefinitionResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "rbac.Client.GetRoleDefinition", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getRoleDefinitionCreateRequest(ctx, scope, roleDefinitionName, options)
	if err != nil {
		return GetRoleDefinitionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetRoleDefinitionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetRoleDefinitionResponse{}, err
	}
	resp, err := client.getRoleDefinitionHandleResponse(httpResp)
	return resp, err
}

// getRoleDefinitionCreateRequest creates the GetRoleDefinition request.
func (client *Client) getRoleDefinitionCreateRequest(ctx context.Context, scope RoleScope, roleDefinitionName string, options *GetRoleDefinitionOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleDefinitions/{roleDefinitionName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	if roleDefinitionName == "" {
		return nil, errors.New("parameter roleDefinitionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleDefinitionName}", url.PathEscape(roleDefinitionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRoleDefinitionHandleResponse handles the GetRoleDefinition response.
func (client *Client) getRoleDefinitionHandleResponse(resp *http.Response) (GetRoleDefinitionResponse, error) {
	result := GetRoleDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleDefinition); err != nil {
		return GetRoleDefinitionResponse{}, err
	}
	return result, nil
}

// NewListRoleAssignmentsPager - Gets role assignments for a scope.
//
// Generated from API version 7.5
//   - scope - The scope of the role assignments.
//   - options - ListRoleAssignmentsOptions contains the optional parameters for the Client.NewListRoleAssignmentsPager
//     method.
func (client *Client) NewListRoleAssignmentsPager(scope RoleScope, options *ListRoleAssignmentsOptions) *runtime.Pager[ListRoleAssignmentsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListRoleAssignmentsResponse]{
		More: func(page ListRoleAssignmentsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListRoleAssignmentsResponse) (ListRoleAssignmentsResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listRoleAssignmentsCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return ListRoleAssignmentsResponse{}, err
			}
			return client.listRoleAssignmentsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listRoleAssignmentsCreateRequest creates the ListRoleAssignments request.
func (client *Client) listRoleAssignmentsCreateRequest(ctx context.Context, scope RoleScope, options *ListRoleAssignmentsOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleAssignments"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRoleAssignmentsHandleResponse handles the ListRoleAssignments response.
func (client *Client) listRoleAssignmentsHandleResponse(resp *http.Response) (ListRoleAssignmentsResponse, error) {
	result := ListRoleAssignmentsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleAssignmentListResult); err != nil {
		return ListRoleAssignmentsResponse{}, err
	}
	return result, nil
}

// NewListRoleDefinitionsPager - Get all role definitions that are applicable at scope and above.
//
// Generated from API version 7.5
//   - scope - The scope of the role definition.
//   - options - ListRoleDefinitionsOptions contains the optional parameters for the Client.NewListRoleDefinitionsPager
//     method.
func (client *Client) NewListRoleDefinitionsPager(scope RoleScope, options *ListRoleDefinitionsOptions) *runtime.Pager[ListRoleDefinitionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListRoleDefinitionsResponse]{
		More: func(page ListRoleDefinitionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListRoleDefinitionsResponse) (ListRoleDefinitionsResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listRoleDefinitionsCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return ListRoleDefinitionsResponse{}, err
			}
			return client.listRoleDefinitionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listRoleDefinitionsCreateRequest creates the ListRoleDefinitions request.
func (client *Client) listRoleDefinitionsCreateRequest(ctx context.Context, scope RoleScope, options *ListRoleDefinitionsOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleDefinitions"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", string(scope))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRoleDefinitionsHandleResponse handles the ListRoleDefinitions response.
func (client *Client) listRoleDefinitionsHandleResponse(resp *http.Response) (ListRoleDefinitionsResponse, error) {
	result := ListRoleDefinitionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleDefinitionListResult); err != nil {
		return ListRoleDefinitionsResponse{}, err
	}
	return result, nil
}
