//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/trafficmanager/armtrafficmanager"
	"net/http"
)

// GeographicHierarchiesServer is a fake server for instances of the armtrafficmanager.GeographicHierarchiesClient type.
type GeographicHierarchiesServer struct {
	// GetDefault is the fake for method GeographicHierarchiesClient.GetDefault
	// HTTP status codes to indicate success: http.StatusOK
	GetDefault func(ctx context.Context, options *armtrafficmanager.GeographicHierarchiesClientGetDefaultOptions) (resp azfake.Responder[armtrafficmanager.GeographicHierarchiesClientGetDefaultResponse], errResp azfake.ErrorResponder)
}

// NewGeographicHierarchiesServerTransport creates a new instance of GeographicHierarchiesServerTransport with the provided implementation.
// The returned GeographicHierarchiesServerTransport instance is connected to an instance of armtrafficmanager.GeographicHierarchiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGeographicHierarchiesServerTransport(srv *GeographicHierarchiesServer) *GeographicHierarchiesServerTransport {
	return &GeographicHierarchiesServerTransport{srv: srv}
}

// GeographicHierarchiesServerTransport connects instances of armtrafficmanager.GeographicHierarchiesClient to instances of GeographicHierarchiesServer.
// Don't use this type directly, use NewGeographicHierarchiesServerTransport instead.
type GeographicHierarchiesServerTransport struct {
	srv *GeographicHierarchiesServer
}

// Do implements the policy.Transporter interface for GeographicHierarchiesServerTransport.
func (g *GeographicHierarchiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GeographicHierarchiesClient.GetDefault":
		resp, err = g.dispatchGetDefault(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GeographicHierarchiesServerTransport) dispatchGetDefault(req *http.Request) (*http.Response, error) {
	if g.srv.GetDefault == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefault not implemented")}
	}
	respr, errRespr := g.srv.GetDefault(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GeographicHierarchy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
