//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armtestbase_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/testbase/armtestbase"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountsListBySubscription.json
func ExampleAccountsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListBySubscriptionPager(&armtestbase.AccountsClientListBySubscriptionOptions{GetDeleted: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AccountListResult = armtestbase.AccountListResult{
		// 	Value: []*armtestbase.AccountResource{
		// 		{
		// 			Name: to.Ptr("contoso-testBaseAccount1"),
		// 			Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
		// 			ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtestbase.AccountResourceProperties{
		// 				AccessLevel: to.Ptr("EarlyAccess"),
		// 				ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
		// 				SKU: &armtestbase.AccountSKU{
		// 					Name: to.Ptr("S0"),
		// 					Capabilities: []*armtestbase.AccountSKUCapability{
		// 						{
		// 							Name: to.Ptr("SLA"),
		// 							Value: to.Ptr("99.9%"),
		// 						},
		// 						{
		// 							Name: to.Ptr("maximumPackageCount"),
		// 							Value: to.Ptr("5"),
		// 						},
		// 						{
		// 							Name: to.Ptr("packageMaximumRunSeconds"),
		// 							Value: to.Ptr("3600"),
		// 					}},
		// 					Tier: to.Ptr(armtestbase.TierStandard),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("contoso-testBaseAccount2"),
		// 			Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
		// 			ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg2/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount2"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtestbase.AccountResourceProperties{
		// 				AccessLevel: to.Ptr("EarlyAccess"),
		// 				ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
		// 				SKU: &armtestbase.AccountSKU{
		// 					Name: to.Ptr("S0"),
		// 					Capabilities: []*armtestbase.AccountSKUCapability{
		// 						{
		// 							Name: to.Ptr("SLA"),
		// 							Value: to.Ptr("99.999%"),
		// 						},
		// 						{
		// 							Name: to.Ptr("maximumPackageCount"),
		// 							Value: to.Ptr("100"),
		// 						},
		// 						{
		// 							Name: to.Ptr("packageMaximumRunSeconds"),
		// 							Value: to.Ptr("10800"),
		// 					}},
		// 					Tier: to.Ptr(armtestbase.TierStandard),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountsList.json
func ExampleAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListByResourceGroupPager("contoso-rg1", &armtestbase.AccountsClientListByResourceGroupOptions{GetDeleted: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AccountListResult = armtestbase.AccountListResult{
		// 	Value: []*armtestbase.AccountResource{
		// 		{
		// 			Name: to.Ptr("contoso-testBaseAccount1"),
		// 			Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
		// 			ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1"),
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtestbase.AccountResourceProperties{
		// 				AccessLevel: to.Ptr("EarlyAccess"),
		// 				ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
		// 				SKU: &armtestbase.AccountSKU{
		// 					Name: to.Ptr("S0"),
		// 					Capabilities: []*armtestbase.AccountSKUCapability{
		// 						{
		// 							Name: to.Ptr("SLA"),
		// 							Value: to.Ptr("99.9%"),
		// 						},
		// 						{
		// 							Name: to.Ptr("maximumPackageCount"),
		// 							Value: to.Ptr("5"),
		// 						},
		// 						{
		// 							Name: to.Ptr("packageMaximumRunSeconds"),
		// 							Value: to.Ptr("3600"),
		// 					}},
		// 					Tier: to.Ptr(armtestbase.TierStandard),
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("contoso-testBaseAccount2"),
		// 			Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
		// 			ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg2/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount2"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armtestbase.AccountResourceProperties{
		// 				AccessLevel: to.Ptr("EarlyAccess"),
		// 				ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
		// 				SKU: &armtestbase.AccountSKU{
		// 					Name: to.Ptr("S0"),
		// 					Capabilities: []*armtestbase.AccountSKUCapability{
		// 						{
		// 							Name: to.Ptr("SLA"),
		// 							Value: to.Ptr("99.999%"),
		// 						},
		// 						{
		// 							Name: to.Ptr("maximumPackageCount"),
		// 							Value: to.Ptr("100"),
		// 						},
		// 						{
		// 							Name: to.Ptr("packageMaximumRunSeconds"),
		// 							Value: to.Ptr("10800"),
		// 					}},
		// 					Tier: to.Ptr(armtestbase.TierStandard),
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountCreate.json
func ExampleAccountsClient_BeginCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginCreate(ctx, "contoso-rg1", "contoso-testBaseAccount1", armtestbase.AccountResource{
		Location: to.Ptr("westus"),
		Properties: &armtestbase.AccountResourceProperties{
			SKU: &armtestbase.AccountSKU{
				Name: to.Ptr("S0"),
				Tier: to.Ptr(armtestbase.TierStandard),
			},
		},
	}, &armtestbase.AccountsClientBeginCreateOptions{Restore: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountResource = armtestbase.AccountResource{
	// 	Name: to.Ptr("contoso-testBaseAccount1"),
	// 	Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtestbase.AccountResourceProperties{
	// 		AccessLevel: to.Ptr("StandardAccess"),
	// 		ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
	// 		SKU: &armtestbase.AccountSKU{
	// 			Name: to.Ptr("S0"),
	// 			Capabilities: []*armtestbase.AccountSKUCapability{
	// 				{
	// 					Name: to.Ptr("SLA"),
	// 					Value: to.Ptr("99.9%"),
	// 				},
	// 				{
	// 					Name: to.Ptr("maximumPackageCount"),
	// 					Value: to.Ptr("5"),
	// 				},
	// 				{
	// 					Name: to.Ptr("packageMaximumRunSeconds"),
	// 					Value: to.Ptr("3600"),
	// 			}},
	// 			Tier: to.Ptr(armtestbase.TierStandard),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountUpdate.json
func ExampleAccountsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginUpdate(ctx, "contoso-rg1", "contoso-testBaseAccount1", armtestbase.AccountUpdateParameters{
		Properties: &armtestbase.AccountUpdateParameterProperties{
			SKU: &armtestbase.AccountSKU{
				Name: to.Ptr("S0"),
				Tier: to.Ptr(armtestbase.TierStandard),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountResource = armtestbase.AccountResource{
	// 	Name: to.Ptr("contoso-testBaseAccount1"),
	// 	Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtestbase.AccountResourceProperties{
	// 		AccessLevel: to.Ptr("EarlyAccess"),
	// 		ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
	// 		SKU: &armtestbase.AccountSKU{
	// 			Name: to.Ptr("S0"),
	// 			Capabilities: []*armtestbase.AccountSKUCapability{
	// 				{
	// 					Name: to.Ptr("SLA"),
	// 					Value: to.Ptr("99.9%"),
	// 				},
	// 				{
	// 					Name: to.Ptr("maximumPackageCount"),
	// 					Value: to.Ptr("5"),
	// 				},
	// 				{
	// 					Name: to.Ptr("packageMaximumRunSeconds"),
	// 					Value: to.Ptr("3600"),
	// 			}},
	// 			Tier: to.Ptr(armtestbase.TierStandard),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountDelete.json
func ExampleAccountsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginDelete(ctx, "contoso-rg1", "contoso-testBaseAccount1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountGet.json
func ExampleAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Get(ctx, "contoso-rg1", "contoso-testBaseAccount1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountResource = armtestbase.AccountResource{
	// 	Name: to.Ptr("contoso-testBaseAccount1"),
	// 	Type: to.Ptr("Microsoft.TestBase/testBaseAccounts"),
	// 	ID: to.Ptr("/subscriptions/476f61a4-952c-422a-b4db-568a828f35df/resourceGroups/contoso-rg1/providers/Microsoft.TestBase/testBaseAccounts/contoso-testBaseAccount1"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armtestbase.AccountResourceProperties{
	// 		AccessLevel: to.Ptr("EarlyAccess"),
	// 		ProvisioningState: to.Ptr(armtestbase.ProvisioningStateSucceeded),
	// 		SKU: &armtestbase.AccountSKU{
	// 			Name: to.Ptr("S0"),
	// 			Capabilities: []*armtestbase.AccountSKUCapability{
	// 				{
	// 					Name: to.Ptr("SLA"),
	// 					Value: to.Ptr("99.9%"),
	// 				},
	// 				{
	// 					Name: to.Ptr("maximumPackageCount"),
	// 					Value: to.Ptr("5"),
	// 				},
	// 				{
	// 					Name: to.Ptr("packageMaximumRunSeconds"),
	// 					Value: to.Ptr("3600"),
	// 			}},
	// 			Tier: to.Ptr(armtestbase.TierStandard),
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountOffboard.json
func ExampleAccountsClient_BeginOffboard() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAccountsClient().BeginOffboard(ctx, "contoso-rg1", "contoso-testBaseAccount1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/TestBaseAccountGetFileUploadUrl.json
func ExampleAccountsClient_GetFileUploadURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().GetFileUploadURL(ctx, "contoso-rg1", "contoso-testBaseAccount1", &armtestbase.AccountsClientGetFileUploadURLOptions{Parameters: &armtestbase.GetFileUploadURLParameters{
		BlobName: to.Ptr("package.zip"),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.FileUploadURLResponse = armtestbase.FileUploadURLResponse{
	// 	BlobPath: to.Ptr("https://uslwestusdevsa.blob.core.windows.net/usltest/temp/20c0d7e0-1bb6-477f-bc04-57c734453000/package.zip"),
	// 	UploadURL: to.Ptr("https://uslwestusdevsa.blob.core.windows.net/usltest/temp/20c0d7e0-1bb6-477f-bc04-57c734453000/token"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/testbase/resource-manager/Microsoft.TestBase/preview/2020-12-16-preview/examples/CheckPackageNameAvailability.json
func ExampleAccountsClient_CheckPackageNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armtestbase.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CheckPackageNameAvailability(ctx, "contoso-rg1", "contoso-testBaseAccount1", armtestbase.PackageCheckNameAvailabilityParameters{
		Name:            to.Ptr("testApp"),
		Type:            to.Ptr("Microsoft.TestBase/testBaseAccounts/packages"),
		ApplicationName: to.Ptr("testApp"),
		Version:         to.Ptr("1.0.0"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResult = armtestbase.CheckNameAvailabilityResult{
	// }
}
