//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// WorkspaceManagedSQLServerRecoverableSQLPoolsServer is a fake server for instances of the armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClient type.
type WorkspaceManagedSQLServerRecoverableSQLPoolsServer struct {
	// Get is the fake for method WorkspaceManagedSQLServerRecoverableSQLPoolsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, options *armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientGetOptions) (resp azfake.Responder[armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method WorkspaceManagedSQLServerRecoverableSQLPoolsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, workspaceName string, options *armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientListOptions) (resp azfake.PagerResponder[armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientListResponse])
}

// NewWorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport creates a new instance of WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport with the provided implementation.
// The returned WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport instance is connected to an instance of armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewWorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport(srv *WorkspaceManagedSQLServerRecoverableSQLPoolsServer) *WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport {
	return &WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientListResponse]](),
	}
}

// WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport connects instances of armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClient to instances of WorkspaceManagedSQLServerRecoverableSQLPoolsServer.
// Don't use this type directly, use NewWorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport instead.
type WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport struct {
	srv          *WorkspaceManagedSQLServerRecoverableSQLPoolsServer
	newListPager *tracker[azfake.PagerResponder[armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientListResponse]]
}

// Do implements the policy.Transporter interface for WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport.
func (w *WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "WorkspaceManagedSQLServerRecoverableSQLPoolsClient.Get":
		resp, err = w.dispatchGet(req)
	case "WorkspaceManagedSQLServerRecoverableSQLPoolsClient.NewListPager":
		resp, err = w.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (w *WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if w.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoverableSqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := w.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RecoverableSQLPool, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (w *WorkspaceManagedSQLServerRecoverableSQLPoolsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if w.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := w.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recoverableSqlPools`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
		if err != nil {
			return nil, err
		}
		resp := w.srv.NewListPager(resourceGroupNameParam, workspaceNameParam, nil)
		newListPager = &resp
		w.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsynapse.WorkspaceManagedSQLServerRecoverableSQLPoolsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		w.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		w.newListPager.remove(req)
	}
	return resp, nil
}
