//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// KustoPoolChildResourceServer is a fake server for instances of the armsynapse.KustoPoolChildResourceClient type.
type KustoPoolChildResourceServer struct {
	// CheckNameAvailability is the fake for method KustoPoolChildResourceClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, workspaceName string, kustoPoolName string, resourceGroupName string, resourceName armsynapse.DatabaseCheckNameRequest, options *armsynapse.KustoPoolChildResourceClientCheckNameAvailabilityOptions) (resp azfake.Responder[armsynapse.KustoPoolChildResourceClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)
}

// NewKustoPoolChildResourceServerTransport creates a new instance of KustoPoolChildResourceServerTransport with the provided implementation.
// The returned KustoPoolChildResourceServerTransport instance is connected to an instance of armsynapse.KustoPoolChildResourceClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewKustoPoolChildResourceServerTransport(srv *KustoPoolChildResourceServer) *KustoPoolChildResourceServerTransport {
	return &KustoPoolChildResourceServerTransport{srv: srv}
}

// KustoPoolChildResourceServerTransport connects instances of armsynapse.KustoPoolChildResourceClient to instances of KustoPoolChildResourceServer.
// Don't use this type directly, use NewKustoPoolChildResourceServerTransport instead.
type KustoPoolChildResourceServerTransport struct {
	srv *KustoPoolChildResourceServer
}

// Do implements the policy.Transporter interface for KustoPoolChildResourceServerTransport.
func (k *KustoPoolChildResourceServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "KustoPoolChildResourceClient.CheckNameAvailability":
		resp, err = k.dispatchCheckNameAvailability(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (k *KustoPoolChildResourceServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if k.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/kustoPools/(?P<kustoPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.DatabaseCheckNameRequest](req)
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	kustoPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("kustoPoolName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := k.srv.CheckNameAvailability(req.Context(), workspaceNameParam, kustoPoolNameParam, resourceGroupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
