//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// IntegrationRuntimeAuthKeysServer is a fake server for instances of the armsynapse.IntegrationRuntimeAuthKeysClient type.
type IntegrationRuntimeAuthKeysServer struct {
	// List is the fake for method IntegrationRuntimeAuthKeysClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimeAuthKeysClientListOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimeAuthKeysClientListResponse], errResp azfake.ErrorResponder)

	// Regenerate is the fake for method IntegrationRuntimeAuthKeysClient.Regenerate
	// HTTP status codes to indicate success: http.StatusOK
	Regenerate func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, regenerateKeyParameters armsynapse.IntegrationRuntimeRegenerateKeyParameters, options *armsynapse.IntegrationRuntimeAuthKeysClientRegenerateOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimeAuthKeysClientRegenerateResponse], errResp azfake.ErrorResponder)
}

// NewIntegrationRuntimeAuthKeysServerTransport creates a new instance of IntegrationRuntimeAuthKeysServerTransport with the provided implementation.
// The returned IntegrationRuntimeAuthKeysServerTransport instance is connected to an instance of armsynapse.IntegrationRuntimeAuthKeysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationRuntimeAuthKeysServerTransport(srv *IntegrationRuntimeAuthKeysServer) *IntegrationRuntimeAuthKeysServerTransport {
	return &IntegrationRuntimeAuthKeysServerTransport{srv: srv}
}

// IntegrationRuntimeAuthKeysServerTransport connects instances of armsynapse.IntegrationRuntimeAuthKeysClient to instances of IntegrationRuntimeAuthKeysServer.
// Don't use this type directly, use NewIntegrationRuntimeAuthKeysServerTransport instead.
type IntegrationRuntimeAuthKeysServerTransport struct {
	srv *IntegrationRuntimeAuthKeysServer
}

// Do implements the policy.Transporter interface for IntegrationRuntimeAuthKeysServerTransport.
func (i *IntegrationRuntimeAuthKeysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationRuntimeAuthKeysClient.List":
		resp, err = i.dispatchList(req)
	case "IntegrationRuntimeAuthKeysClient.Regenerate":
		resp, err = i.dispatchRegenerate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationRuntimeAuthKeysServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if i.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listAuthKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.List(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeAuthKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *IntegrationRuntimeAuthKeysServerTransport) dispatchRegenerate(req *http.Request) (*http.Response, error) {
	if i.srv.Regenerate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Regenerate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateAuthKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.IntegrationRuntimeRegenerateKeyParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Regenerate(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeAuthKeys, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
