//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// GetServer is a fake server for instances of the armsynapse.GetClient type.
type GetServer struct {
	// IntegrationRuntimeEnableInteractivequery is the fake for method GetClient.IntegrationRuntimeEnableInteractivequery
	// HTTP status codes to indicate success: http.StatusOK
	IntegrationRuntimeEnableInteractivequery func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, integrationRuntimeOperationID string, options *armsynapse.GetClientIntegrationRuntimeEnableInteractivequeryOptions) (resp azfake.Responder[armsynapse.GetClientIntegrationRuntimeEnableInteractivequeryResponse], errResp azfake.ErrorResponder)

	// IntegrationRuntimeStart is the fake for method GetClient.IntegrationRuntimeStart
	// HTTP status codes to indicate success: http.StatusOK
	IntegrationRuntimeStart func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, integrationRuntimeOperationID string, options *armsynapse.GetClientIntegrationRuntimeStartOptions) (resp azfake.Responder[armsynapse.GetClientIntegrationRuntimeStartResponse], errResp azfake.ErrorResponder)

	// IntegrationRuntimeStop is the fake for method GetClient.IntegrationRuntimeStop
	// HTTP status codes to indicate success: http.StatusOK
	IntegrationRuntimeStop func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, integrationRuntimeOperationID string, options *armsynapse.GetClientIntegrationRuntimeStopOptions) (resp azfake.Responder[armsynapse.GetClientIntegrationRuntimeStopResponse], errResp azfake.ErrorResponder)
}

// NewGetServerTransport creates a new instance of GetServerTransport with the provided implementation.
// The returned GetServerTransport instance is connected to an instance of armsynapse.GetClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewGetServerTransport(srv *GetServer) *GetServerTransport {
	return &GetServerTransport{srv: srv}
}

// GetServerTransport connects instances of armsynapse.GetClient to instances of GetServer.
// Don't use this type directly, use NewGetServerTransport instead.
type GetServerTransport struct {
	srv *GetServer
}

// Do implements the policy.Transporter interface for GetServerTransport.
func (g *GetServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "GetClient.IntegrationRuntimeEnableInteractivequery":
		resp, err = g.dispatchIntegrationRuntimeEnableInteractivequery(req)
	case "GetClient.IntegrationRuntimeStart":
		resp, err = g.dispatchIntegrationRuntimeStart(req)
	case "GetClient.IntegrationRuntimeStop":
		resp, err = g.dispatchIntegrationRuntimeStop(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (g *GetServerTransport) dispatchIntegrationRuntimeEnableInteractivequery(req *http.Request) (*http.Response, error) {
	if g.srv.IntegrationRuntimeEnableInteractivequery == nil {
		return nil, &nonRetriableError{errors.New("fake for method IntegrationRuntimeEnableInteractivequery not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enableinteractivequery/operationstatuses/(?P<integrationRuntimeOperationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeOperationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeOperationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.IntegrationRuntimeEnableInteractivequery(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, integrationRuntimeOperationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeEnableinteractivequery, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GetServerTransport) dispatchIntegrationRuntimeStart(req *http.Request) (*http.Response, error) {
	if g.srv.IntegrationRuntimeStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method IntegrationRuntimeStart not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start/operationstatuses/(?P<integrationRuntimeOperationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeOperationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeOperationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.IntegrationRuntimeStart(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, integrationRuntimeOperationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeOperationStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (g *GetServerTransport) dispatchIntegrationRuntimeStop(req *http.Request) (*http.Response, error) {
	if g.srv.IntegrationRuntimeStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method IntegrationRuntimeStop not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop/operationstatuses/(?P<integrationRuntimeOperationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeOperationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeOperationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := g.srv.IntegrationRuntimeStop(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, integrationRuntimeOperationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeStopOperationStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
