//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAzureADOnlyAuthenticationsClient creates a new instance of AzureADOnlyAuthenticationsClient.
func (c *ClientFactory) NewAzureADOnlyAuthenticationsClient() *AzureADOnlyAuthenticationsClient {
	subClient, _ := NewAzureADOnlyAuthenticationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewBigDataPoolsClient creates a new instance of BigDataPoolsClient.
func (c *ClientFactory) NewBigDataPoolsClient() *BigDataPoolsClient {
	subClient, _ := NewBigDataPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataMaskingPoliciesClient creates a new instance of DataMaskingPoliciesClient.
func (c *ClientFactory) NewDataMaskingPoliciesClient() *DataMaskingPoliciesClient {
	subClient, _ := NewDataMaskingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDataMaskingRulesClient creates a new instance of DataMaskingRulesClient.
func (c *ClientFactory) NewDataMaskingRulesClient() *DataMaskingRulesClient {
	subClient, _ := NewDataMaskingRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewExtendedSQLPoolBlobAuditingPoliciesClient creates a new instance of ExtendedSQLPoolBlobAuditingPoliciesClient.
func (c *ClientFactory) NewExtendedSQLPoolBlobAuditingPoliciesClient() *ExtendedSQLPoolBlobAuditingPoliciesClient {
	subClient, _ := NewExtendedSQLPoolBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGetClient creates a new instance of GetClient.
func (c *ClientFactory) NewGetClient() *GetClient {
	subClient, _ := NewGetClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIPFirewallRulesClient creates a new instance of IPFirewallRulesClient.
func (c *ClientFactory) NewIPFirewallRulesClient() *IPFirewallRulesClient {
	subClient, _ := NewIPFirewallRulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeAuthKeysClient creates a new instance of IntegrationRuntimeAuthKeysClient.
func (c *ClientFactory) NewIntegrationRuntimeAuthKeysClient() *IntegrationRuntimeAuthKeysClient {
	subClient, _ := NewIntegrationRuntimeAuthKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeConnectionInfosClient creates a new instance of IntegrationRuntimeConnectionInfosClient.
func (c *ClientFactory) NewIntegrationRuntimeConnectionInfosClient() *IntegrationRuntimeConnectionInfosClient {
	subClient, _ := NewIntegrationRuntimeConnectionInfosClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeCredentialsClient creates a new instance of IntegrationRuntimeCredentialsClient.
func (c *ClientFactory) NewIntegrationRuntimeCredentialsClient() *IntegrationRuntimeCredentialsClient {
	subClient, _ := NewIntegrationRuntimeCredentialsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeMonitoringDataClient creates a new instance of IntegrationRuntimeMonitoringDataClient.
func (c *ClientFactory) NewIntegrationRuntimeMonitoringDataClient() *IntegrationRuntimeMonitoringDataClient {
	subClient, _ := NewIntegrationRuntimeMonitoringDataClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeNodeIPAddressClient creates a new instance of IntegrationRuntimeNodeIPAddressClient.
func (c *ClientFactory) NewIntegrationRuntimeNodeIPAddressClient() *IntegrationRuntimeNodeIPAddressClient {
	subClient, _ := NewIntegrationRuntimeNodeIPAddressClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeNodesClient creates a new instance of IntegrationRuntimeNodesClient.
func (c *ClientFactory) NewIntegrationRuntimeNodesClient() *IntegrationRuntimeNodesClient {
	subClient, _ := NewIntegrationRuntimeNodesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeObjectMetadataClient creates a new instance of IntegrationRuntimeObjectMetadataClient.
func (c *ClientFactory) NewIntegrationRuntimeObjectMetadataClient() *IntegrationRuntimeObjectMetadataClient {
	subClient, _ := NewIntegrationRuntimeObjectMetadataClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimeStatusClient creates a new instance of IntegrationRuntimeStatusClient.
func (c *ClientFactory) NewIntegrationRuntimeStatusClient() *IntegrationRuntimeStatusClient {
	subClient, _ := NewIntegrationRuntimeStatusClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewIntegrationRuntimesClient creates a new instance of IntegrationRuntimesClient.
func (c *ClientFactory) NewIntegrationRuntimesClient() *IntegrationRuntimesClient {
	subClient, _ := NewIntegrationRuntimesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKeysClient creates a new instance of KeysClient.
func (c *ClientFactory) NewKeysClient() *KeysClient {
	subClient, _ := NewKeysClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoOperationsClient creates a new instance of KustoOperationsClient.
func (c *ClientFactory) NewKustoOperationsClient() *KustoOperationsClient {
	subClient, _ := NewKustoOperationsClient(c.credential, c.options)
	return subClient
}

// NewKustoPoolAttachedDatabaseConfigurationsClient creates a new instance of KustoPoolAttachedDatabaseConfigurationsClient.
func (c *ClientFactory) NewKustoPoolAttachedDatabaseConfigurationsClient() *KustoPoolAttachedDatabaseConfigurationsClient {
	subClient, _ := NewKustoPoolAttachedDatabaseConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolChildResourceClient creates a new instance of KustoPoolChildResourceClient.
func (c *ClientFactory) NewKustoPoolChildResourceClient() *KustoPoolChildResourceClient {
	subClient, _ := NewKustoPoolChildResourceClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolDataConnectionsClient creates a new instance of KustoPoolDataConnectionsClient.
func (c *ClientFactory) NewKustoPoolDataConnectionsClient() *KustoPoolDataConnectionsClient {
	subClient, _ := NewKustoPoolDataConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolDatabasePrincipalAssignmentsClient creates a new instance of KustoPoolDatabasePrincipalAssignmentsClient.
func (c *ClientFactory) NewKustoPoolDatabasePrincipalAssignmentsClient() *KustoPoolDatabasePrincipalAssignmentsClient {
	subClient, _ := NewKustoPoolDatabasePrincipalAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolDatabasesClient creates a new instance of KustoPoolDatabasesClient.
func (c *ClientFactory) NewKustoPoolDatabasesClient() *KustoPoolDatabasesClient {
	subClient, _ := NewKustoPoolDatabasesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolPrincipalAssignmentsClient creates a new instance of KustoPoolPrincipalAssignmentsClient.
func (c *ClientFactory) NewKustoPoolPrincipalAssignmentsClient() *KustoPoolPrincipalAssignmentsClient {
	subClient, _ := NewKustoPoolPrincipalAssignmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolPrivateLinkResourcesClient creates a new instance of KustoPoolPrivateLinkResourcesClient.
func (c *ClientFactory) NewKustoPoolPrivateLinkResourcesClient() *KustoPoolPrivateLinkResourcesClient {
	subClient, _ := NewKustoPoolPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewKustoPoolsClient creates a new instance of KustoPoolsClient.
func (c *ClientFactory) NewKustoPoolsClient() *KustoPoolsClient {
	subClient, _ := NewKustoPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLibrariesClient creates a new instance of LibrariesClient.
func (c *ClientFactory) NewLibrariesClient() *LibrariesClient {
	subClient, _ := NewLibrariesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLibraryClient creates a new instance of LibraryClient.
func (c *ClientFactory) NewLibraryClient() *LibraryClient {
	subClient, _ := NewLibraryClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsPrivateLinkHubClient creates a new instance of PrivateEndpointConnectionsPrivateLinkHubClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsPrivateLinkHubClient() *PrivateEndpointConnectionsPrivateLinkHubClient {
	subClient, _ := NewPrivateEndpointConnectionsPrivateLinkHubClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkHubPrivateLinkResourcesClient creates a new instance of PrivateLinkHubPrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkHubPrivateLinkResourcesClient() *PrivateLinkHubPrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkHubPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkHubsClient creates a new instance of PrivateLinkHubsClient.
func (c *ClientFactory) NewPrivateLinkHubsClient() *PrivateLinkHubsClient {
	subClient, _ := NewPrivateLinkHubsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewRestorableDroppedSQLPoolsClient creates a new instance of RestorableDroppedSQLPoolsClient.
func (c *ClientFactory) NewRestorableDroppedSQLPoolsClient() *RestorableDroppedSQLPoolsClient {
	subClient, _ := NewRestorableDroppedSQLPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolBlobAuditingPoliciesClient creates a new instance of SQLPoolBlobAuditingPoliciesClient.
func (c *ClientFactory) NewSQLPoolBlobAuditingPoliciesClient() *SQLPoolBlobAuditingPoliciesClient {
	subClient, _ := NewSQLPoolBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolColumnsClient creates a new instance of SQLPoolColumnsClient.
func (c *ClientFactory) NewSQLPoolColumnsClient() *SQLPoolColumnsClient {
	subClient, _ := NewSQLPoolColumnsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolConnectionPoliciesClient creates a new instance of SQLPoolConnectionPoliciesClient.
func (c *ClientFactory) NewSQLPoolConnectionPoliciesClient() *SQLPoolConnectionPoliciesClient {
	subClient, _ := NewSQLPoolConnectionPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolDataWarehouseUserActivitiesClient creates a new instance of SQLPoolDataWarehouseUserActivitiesClient.
func (c *ClientFactory) NewSQLPoolDataWarehouseUserActivitiesClient() *SQLPoolDataWarehouseUserActivitiesClient {
	subClient, _ := NewSQLPoolDataWarehouseUserActivitiesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolGeoBackupPoliciesClient creates a new instance of SQLPoolGeoBackupPoliciesClient.
func (c *ClientFactory) NewSQLPoolGeoBackupPoliciesClient() *SQLPoolGeoBackupPoliciesClient {
	subClient, _ := NewSQLPoolGeoBackupPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolMaintenanceWindowOptionsClient creates a new instance of SQLPoolMaintenanceWindowOptionsClient.
func (c *ClientFactory) NewSQLPoolMaintenanceWindowOptionsClient() *SQLPoolMaintenanceWindowOptionsClient {
	subClient, _ := NewSQLPoolMaintenanceWindowOptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolMaintenanceWindowsClient creates a new instance of SQLPoolMaintenanceWindowsClient.
func (c *ClientFactory) NewSQLPoolMaintenanceWindowsClient() *SQLPoolMaintenanceWindowsClient {
	subClient, _ := NewSQLPoolMaintenanceWindowsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolMetadataSyncConfigsClient creates a new instance of SQLPoolMetadataSyncConfigsClient.
func (c *ClientFactory) NewSQLPoolMetadataSyncConfigsClient() *SQLPoolMetadataSyncConfigsClient {
	subClient, _ := NewSQLPoolMetadataSyncConfigsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolOperationResultsClient creates a new instance of SQLPoolOperationResultsClient.
func (c *ClientFactory) NewSQLPoolOperationResultsClient() *SQLPoolOperationResultsClient {
	subClient, _ := NewSQLPoolOperationResultsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolOperationsClient creates a new instance of SQLPoolOperationsClient.
func (c *ClientFactory) NewSQLPoolOperationsClient() *SQLPoolOperationsClient {
	subClient, _ := NewSQLPoolOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolRecommendedSensitivityLabelsClient creates a new instance of SQLPoolRecommendedSensitivityLabelsClient.
func (c *ClientFactory) NewSQLPoolRecommendedSensitivityLabelsClient() *SQLPoolRecommendedSensitivityLabelsClient {
	subClient, _ := NewSQLPoolRecommendedSensitivityLabelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolReplicationLinksClient creates a new instance of SQLPoolReplicationLinksClient.
func (c *ClientFactory) NewSQLPoolReplicationLinksClient() *SQLPoolReplicationLinksClient {
	subClient, _ := NewSQLPoolReplicationLinksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolRestorePointsClient creates a new instance of SQLPoolRestorePointsClient.
func (c *ClientFactory) NewSQLPoolRestorePointsClient() *SQLPoolRestorePointsClient {
	subClient, _ := NewSQLPoolRestorePointsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolSchemasClient creates a new instance of SQLPoolSchemasClient.
func (c *ClientFactory) NewSQLPoolSchemasClient() *SQLPoolSchemasClient {
	subClient, _ := NewSQLPoolSchemasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolSecurityAlertPoliciesClient creates a new instance of SQLPoolSecurityAlertPoliciesClient.
func (c *ClientFactory) NewSQLPoolSecurityAlertPoliciesClient() *SQLPoolSecurityAlertPoliciesClient {
	subClient, _ := NewSQLPoolSecurityAlertPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolSensitivityLabelsClient creates a new instance of SQLPoolSensitivityLabelsClient.
func (c *ClientFactory) NewSQLPoolSensitivityLabelsClient() *SQLPoolSensitivityLabelsClient {
	subClient, _ := NewSQLPoolSensitivityLabelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolTableColumnsClient creates a new instance of SQLPoolTableColumnsClient.
func (c *ClientFactory) NewSQLPoolTableColumnsClient() *SQLPoolTableColumnsClient {
	subClient, _ := NewSQLPoolTableColumnsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolTablesClient creates a new instance of SQLPoolTablesClient.
func (c *ClientFactory) NewSQLPoolTablesClient() *SQLPoolTablesClient {
	subClient, _ := NewSQLPoolTablesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolTransparentDataEncryptionsClient creates a new instance of SQLPoolTransparentDataEncryptionsClient.
func (c *ClientFactory) NewSQLPoolTransparentDataEncryptionsClient() *SQLPoolTransparentDataEncryptionsClient {
	subClient, _ := NewSQLPoolTransparentDataEncryptionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolUsagesClient creates a new instance of SQLPoolUsagesClient.
func (c *ClientFactory) NewSQLPoolUsagesClient() *SQLPoolUsagesClient {
	subClient, _ := NewSQLPoolUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient creates a new instance of SQLPoolVulnerabilityAssessmentRuleBaselinesClient.
func (c *ClientFactory) NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient() *SQLPoolVulnerabilityAssessmentRuleBaselinesClient {
	subClient, _ := NewSQLPoolVulnerabilityAssessmentRuleBaselinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolVulnerabilityAssessmentScansClient creates a new instance of SQLPoolVulnerabilityAssessmentScansClient.
func (c *ClientFactory) NewSQLPoolVulnerabilityAssessmentScansClient() *SQLPoolVulnerabilityAssessmentScansClient {
	subClient, _ := NewSQLPoolVulnerabilityAssessmentScansClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolVulnerabilityAssessmentsClient creates a new instance of SQLPoolVulnerabilityAssessmentsClient.
func (c *ClientFactory) NewSQLPoolVulnerabilityAssessmentsClient() *SQLPoolVulnerabilityAssessmentsClient {
	subClient, _ := NewSQLPoolVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolWorkloadClassifierClient creates a new instance of SQLPoolWorkloadClassifierClient.
func (c *ClientFactory) NewSQLPoolWorkloadClassifierClient() *SQLPoolWorkloadClassifierClient {
	subClient, _ := NewSQLPoolWorkloadClassifierClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolWorkloadGroupClient creates a new instance of SQLPoolWorkloadGroupClient.
func (c *ClientFactory) NewSQLPoolWorkloadGroupClient() *SQLPoolWorkloadGroupClient {
	subClient, _ := NewSQLPoolWorkloadGroupClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSQLPoolsClient creates a new instance of SQLPoolsClient.
func (c *ClientFactory) NewSQLPoolsClient() *SQLPoolsClient {
	subClient, _ := NewSQLPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSparkConfigurationClient creates a new instance of SparkConfigurationClient.
func (c *ClientFactory) NewSparkConfigurationClient() *SparkConfigurationClient {
	subClient, _ := NewSparkConfigurationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSparkConfigurationsClient creates a new instance of SparkConfigurationsClient.
func (c *ClientFactory) NewSparkConfigurationsClient() *SparkConfigurationsClient {
	subClient, _ := NewSparkConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceAADAdminsClient creates a new instance of WorkspaceAADAdminsClient.
func (c *ClientFactory) NewWorkspaceAADAdminsClient() *WorkspaceAADAdminsClient {
	subClient, _ := NewWorkspaceAADAdminsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedIdentitySQLControlSettingsClient creates a new instance of WorkspaceManagedIdentitySQLControlSettingsClient.
func (c *ClientFactory) NewWorkspaceManagedIdentitySQLControlSettingsClient() *WorkspaceManagedIdentitySQLControlSettingsClient {
	subClient, _ := NewWorkspaceManagedIdentitySQLControlSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerBlobAuditingPoliciesClient creates a new instance of WorkspaceManagedSQLServerBlobAuditingPoliciesClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerBlobAuditingPoliciesClient() *WorkspaceManagedSQLServerBlobAuditingPoliciesClient {
	subClient, _ := NewWorkspaceManagedSQLServerBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient creates a new instance of WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient() *WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient {
	subClient, _ := NewWorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerEncryptionProtectorClient creates a new instance of WorkspaceManagedSQLServerEncryptionProtectorClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerEncryptionProtectorClient() *WorkspaceManagedSQLServerEncryptionProtectorClient {
	subClient, _ := NewWorkspaceManagedSQLServerEncryptionProtectorClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient creates a new instance of WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient() *WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient {
	subClient, _ := NewWorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerRecoverableSQLPoolsClient creates a new instance of WorkspaceManagedSQLServerRecoverableSQLPoolsClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerRecoverableSQLPoolsClient() *WorkspaceManagedSQLServerRecoverableSQLPoolsClient {
	subClient, _ := NewWorkspaceManagedSQLServerRecoverableSQLPoolsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerSecurityAlertPolicyClient creates a new instance of WorkspaceManagedSQLServerSecurityAlertPolicyClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerSecurityAlertPolicyClient() *WorkspaceManagedSQLServerSecurityAlertPolicyClient {
	subClient, _ := NewWorkspaceManagedSQLServerSecurityAlertPolicyClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerUsagesClient creates a new instance of WorkspaceManagedSQLServerUsagesClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerUsagesClient() *WorkspaceManagedSQLServerUsagesClient {
	subClient, _ := NewWorkspaceManagedSQLServerUsagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient creates a new instance of WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.
func (c *ClientFactory) NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient() *WorkspaceManagedSQLServerVulnerabilityAssessmentsClient {
	subClient, _ := NewWorkspaceManagedSQLServerVulnerabilityAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspaceSQLAADAdminsClient creates a new instance of WorkspaceSQLAADAdminsClient.
func (c *ClientFactory) NewWorkspaceSQLAADAdminsClient() *WorkspaceSQLAADAdminsClient {
	subClient, _ := NewWorkspaceSQLAADAdminsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewWorkspacesClient creates a new instance of WorkspacesClient.
func (c *ClientFactory) NewWorkspacesClient() *WorkspacesClient {
	subClient, _ := NewWorkspacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
