//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple8000series

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storsimple8000series/armstorsimple8000series"
	moduleVersion = "v1.2.0"
)

// AlertEmailNotificationStatus - Indicates whether email notification enabled or not.
type AlertEmailNotificationStatus string

const (
	AlertEmailNotificationStatusDisabled AlertEmailNotificationStatus = "Disabled"
	AlertEmailNotificationStatusEnabled  AlertEmailNotificationStatus = "Enabled"
)

// PossibleAlertEmailNotificationStatusValues returns the possible values for the AlertEmailNotificationStatus const type.
func PossibleAlertEmailNotificationStatusValues() []AlertEmailNotificationStatus {
	return []AlertEmailNotificationStatus{
		AlertEmailNotificationStatusDisabled,
		AlertEmailNotificationStatusEnabled,
	}
}

// AlertScope - The scope of the alert
type AlertScope string

const (
	AlertScopeDevice   AlertScope = "Device"
	AlertScopeResource AlertScope = "Resource"
)

// PossibleAlertScopeValues returns the possible values for the AlertScope const type.
func PossibleAlertScopeValues() []AlertScope {
	return []AlertScope{
		AlertScopeDevice,
		AlertScopeResource,
	}
}

// AlertSeverity - Specifies the severity of the alerts to be filtered. Only 'Equality' operator is supported for this property.
type AlertSeverity string

const (
	AlertSeverityCritical      AlertSeverity = "Critical"
	AlertSeverityInformational AlertSeverity = "Informational"
	AlertSeverityWarning       AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns the possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{
		AlertSeverityCritical,
		AlertSeverityInformational,
		AlertSeverityWarning,
	}
}

// AlertSourceType - Specifies the source type of the alerts to be filtered. Only 'Equality' operator is supported for this
// property.
type AlertSourceType string

const (
	AlertSourceTypeDevice   AlertSourceType = "Device"
	AlertSourceTypeResource AlertSourceType = "Resource"
)

// PossibleAlertSourceTypeValues returns the possible values for the AlertSourceType const type.
func PossibleAlertSourceTypeValues() []AlertSourceType {
	return []AlertSourceType{
		AlertSourceTypeDevice,
		AlertSourceTypeResource,
	}
}

// AlertStatus - Specifies the status of the alerts to be filtered. Only 'Equality' operator is supported for this property.
type AlertStatus string

const (
	AlertStatusActive  AlertStatus = "Active"
	AlertStatusCleared AlertStatus = "Cleared"
)

// PossibleAlertStatusValues returns the possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{
		AlertStatusActive,
		AlertStatusCleared,
	}
}

// AuthenticationType - The authentication type.
type AuthenticationType string

const (
	AuthenticationTypeBasic   AuthenticationType = "Basic"
	AuthenticationTypeInvalid AuthenticationType = "Invalid"
	AuthenticationTypeNTLM    AuthenticationType = "NTLM"
	AuthenticationTypeNone    AuthenticationType = "None"
)

// PossibleAuthenticationTypeValues returns the possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{
		AuthenticationTypeBasic,
		AuthenticationTypeInvalid,
		AuthenticationTypeNTLM,
		AuthenticationTypeNone,
	}
}

// AuthorizationEligibility - The eligibility status of device for service data encryption key rollover.
type AuthorizationEligibility string

const (
	AuthorizationEligibilityEligible   AuthorizationEligibility = "Eligible"
	AuthorizationEligibilityInEligible AuthorizationEligibility = "InEligible"
)

// PossibleAuthorizationEligibilityValues returns the possible values for the AuthorizationEligibility const type.
func PossibleAuthorizationEligibilityValues() []AuthorizationEligibility {
	return []AuthorizationEligibility{
		AuthorizationEligibilityEligible,
		AuthorizationEligibilityInEligible,
	}
}

// AuthorizationStatus - The authorization status of the device for service data encryption key rollover.
type AuthorizationStatus string

const (
	AuthorizationStatusDisabled AuthorizationStatus = "Disabled"
	AuthorizationStatusEnabled  AuthorizationStatus = "Enabled"
)

// PossibleAuthorizationStatusValues returns the possible values for the AuthorizationStatus const type.
func PossibleAuthorizationStatusValues() []AuthorizationStatus {
	return []AuthorizationStatus{
		AuthorizationStatusDisabled,
		AuthorizationStatusEnabled,
	}
}

// BackupJobCreationType - The backup job creation type.
type BackupJobCreationType string

const (
	BackupJobCreationTypeAdhoc      BackupJobCreationType = "Adhoc"
	BackupJobCreationTypeBySSM      BackupJobCreationType = "BySSM"
	BackupJobCreationTypeBySchedule BackupJobCreationType = "BySchedule"
)

// PossibleBackupJobCreationTypeValues returns the possible values for the BackupJobCreationType const type.
func PossibleBackupJobCreationTypeValues() []BackupJobCreationType {
	return []BackupJobCreationType{
		BackupJobCreationTypeAdhoc,
		BackupJobCreationTypeBySSM,
		BackupJobCreationTypeBySchedule,
	}
}

// BackupPolicyCreationType - The backup policy creation type. Indicates whether this was created through SaaS or through
// StorSimple Snapshot Manager.
type BackupPolicyCreationType string

const (
	BackupPolicyCreationTypeBySSM  BackupPolicyCreationType = "BySSM"
	BackupPolicyCreationTypeBySaaS BackupPolicyCreationType = "BySaaS"
)

// PossibleBackupPolicyCreationTypeValues returns the possible values for the BackupPolicyCreationType const type.
func PossibleBackupPolicyCreationTypeValues() []BackupPolicyCreationType {
	return []BackupPolicyCreationType{
		BackupPolicyCreationTypeBySSM,
		BackupPolicyCreationTypeBySaaS,
	}
}

// BackupStatus - The backup status of the volume.
type BackupStatus string

const (
	BackupStatusDisabled BackupStatus = "Disabled"
	BackupStatusEnabled  BackupStatus = "Enabled"
)

// PossibleBackupStatusValues returns the possible values for the BackupStatus const type.
func PossibleBackupStatusValues() []BackupStatus {
	return []BackupStatus{
		BackupStatusDisabled,
		BackupStatusEnabled,
	}
}

// BackupType - The type of the backup.
type BackupType string

const (
	BackupTypeCloudSnapshot BackupType = "CloudSnapshot"
	BackupTypeLocalSnapshot BackupType = "LocalSnapshot"
)

// PossibleBackupTypeValues returns the possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{
		BackupTypeCloudSnapshot,
		BackupTypeLocalSnapshot,
	}
}

// ControllerID - The active controller that the request is expecting on the device.
type ControllerID string

const (
	ControllerIDController0 ControllerID = "Controller0"
	ControllerIDController1 ControllerID = "Controller1"
	ControllerIDNone        ControllerID = "None"
	ControllerIDUnknown     ControllerID = "Unknown"
)

// PossibleControllerIDValues returns the possible values for the ControllerID const type.
func PossibleControllerIDValues() []ControllerID {
	return []ControllerID{
		ControllerIDController0,
		ControllerIDController1,
		ControllerIDNone,
		ControllerIDUnknown,
	}
}

// ControllerPowerStateAction - The power state that the request is expecting for the controller of the device.
type ControllerPowerStateAction string

const (
	ControllerPowerStateActionRestart  ControllerPowerStateAction = "Restart"
	ControllerPowerStateActionShutdown ControllerPowerStateAction = "Shutdown"
	ControllerPowerStateActionStart    ControllerPowerStateAction = "Start"
)

// PossibleControllerPowerStateActionValues returns the possible values for the ControllerPowerStateAction const type.
func PossibleControllerPowerStateActionValues() []ControllerPowerStateAction {
	return []ControllerPowerStateAction{
		ControllerPowerStateActionRestart,
		ControllerPowerStateActionShutdown,
		ControllerPowerStateActionStart,
	}
}

// ControllerStatus - The controller 0's status that the request is expecting on the device.
type ControllerStatus string

const (
	ControllerStatusFailure    ControllerStatus = "Failure"
	ControllerStatusNotPresent ControllerStatus = "NotPresent"
	ControllerStatusOk         ControllerStatus = "Ok"
	ControllerStatusPoweredOff ControllerStatus = "PoweredOff"
	ControllerStatusRecovering ControllerStatus = "Recovering"
	ControllerStatusWarning    ControllerStatus = "Warning"
)

// PossibleControllerStatusValues returns the possible values for the ControllerStatus const type.
func PossibleControllerStatusValues() []ControllerStatus {
	return []ControllerStatus{
		ControllerStatusFailure,
		ControllerStatusNotPresent,
		ControllerStatusOk,
		ControllerStatusPoweredOff,
		ControllerStatusRecovering,
		ControllerStatusWarning,
	}
}

type DayOfWeek string

const (
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekFriday,
		DayOfWeekMonday,
		DayOfWeekSaturday,
		DayOfWeekSunday,
		DayOfWeekThursday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
	}
}

// DeviceConfigurationStatus - The current configuration status of the device.
type DeviceConfigurationStatus string

const (
	DeviceConfigurationStatusComplete DeviceConfigurationStatus = "Complete"
	DeviceConfigurationStatusPending  DeviceConfigurationStatus = "Pending"
)

// PossibleDeviceConfigurationStatusValues returns the possible values for the DeviceConfigurationStatus const type.
func PossibleDeviceConfigurationStatusValues() []DeviceConfigurationStatus {
	return []DeviceConfigurationStatus{
		DeviceConfigurationStatusComplete,
		DeviceConfigurationStatusPending,
	}
}

// DeviceStatus - The current status of the device.
type DeviceStatus string

const (
	DeviceStatusCreating          DeviceStatus = "Creating"
	DeviceStatusDeactivated       DeviceStatus = "Deactivated"
	DeviceStatusDeactivating      DeviceStatus = "Deactivating"
	DeviceStatusDeleted           DeviceStatus = "Deleted"
	DeviceStatusMaintenanceMode   DeviceStatus = "MaintenanceMode"
	DeviceStatusOffline           DeviceStatus = "Offline"
	DeviceStatusOnline            DeviceStatus = "Online"
	DeviceStatusProvisioning      DeviceStatus = "Provisioning"
	DeviceStatusReadyToSetup      DeviceStatus = "ReadyToSetup"
	DeviceStatusRequiresAttention DeviceStatus = "RequiresAttention"
	DeviceStatusUnknown           DeviceStatus = "Unknown"
)

// PossibleDeviceStatusValues returns the possible values for the DeviceStatus const type.
func PossibleDeviceStatusValues() []DeviceStatus {
	return []DeviceStatus{
		DeviceStatusCreating,
		DeviceStatusDeactivated,
		DeviceStatusDeactivating,
		DeviceStatusDeleted,
		DeviceStatusMaintenanceMode,
		DeviceStatusOffline,
		DeviceStatusOnline,
		DeviceStatusProvisioning,
		DeviceStatusReadyToSetup,
		DeviceStatusRequiresAttention,
		DeviceStatusUnknown,
	}
}

// DeviceType - The type of the device.
type DeviceType string

const (
	DeviceTypeInvalid                     DeviceType = "Invalid"
	DeviceTypeSeries8000PhysicalAppliance DeviceType = "Series8000PhysicalAppliance"
	DeviceTypeSeries8000VirtualAppliance  DeviceType = "Series8000VirtualAppliance"
)

// PossibleDeviceTypeValues returns the possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{
		DeviceTypeInvalid,
		DeviceTypeSeries8000PhysicalAppliance,
		DeviceTypeSeries8000VirtualAppliance,
	}
}

// EncryptionAlgorithm - The algorithm used to encrypt "Value".
type EncryptionAlgorithm string

const (
	EncryptionAlgorithmAES256        EncryptionAlgorithm = "AES256"
	EncryptionAlgorithmNone          EncryptionAlgorithm = "None"
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns the possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{
		EncryptionAlgorithmAES256,
		EncryptionAlgorithmNone,
		EncryptionAlgorithmRSAESPKCS1V15,
	}
}

// EncryptionStatus - The encryption status to indicates if encryption is enabled or not.
type EncryptionStatus string

const (
	EncryptionStatusDisabled EncryptionStatus = "Disabled"
	EncryptionStatusEnabled  EncryptionStatus = "Enabled"
)

// PossibleEncryptionStatusValues returns the possible values for the EncryptionStatus const type.
func PossibleEncryptionStatusValues() []EncryptionStatus {
	return []EncryptionStatus{
		EncryptionStatusDisabled,
		EncryptionStatusEnabled,
	}
}

// FeatureSupportStatus - The feature support status.
type FeatureSupportStatus string

const (
	FeatureSupportStatusNotAvailable             FeatureSupportStatus = "NotAvailable"
	FeatureSupportStatusSupported                FeatureSupportStatus = "Supported"
	FeatureSupportStatusUnsupportedDeviceVersion FeatureSupportStatus = "UnsupportedDeviceVersion"
)

// PossibleFeatureSupportStatusValues returns the possible values for the FeatureSupportStatus const type.
func PossibleFeatureSupportStatusValues() []FeatureSupportStatus {
	return []FeatureSupportStatus{
		FeatureSupportStatusNotAvailable,
		FeatureSupportStatusSupported,
		FeatureSupportStatusUnsupportedDeviceVersion,
	}
}

// HardwareComponentStatus - The status of the hardware component.
type HardwareComponentStatus string

const (
	HardwareComponentStatusFailure    HardwareComponentStatus = "Failure"
	HardwareComponentStatusNotPresent HardwareComponentStatus = "NotPresent"
	HardwareComponentStatusOk         HardwareComponentStatus = "Ok"
	HardwareComponentStatusPoweredOff HardwareComponentStatus = "PoweredOff"
	HardwareComponentStatusRecovering HardwareComponentStatus = "Recovering"
	HardwareComponentStatusUnknown    HardwareComponentStatus = "Unknown"
	HardwareComponentStatusWarning    HardwareComponentStatus = "Warning"
)

// PossibleHardwareComponentStatusValues returns the possible values for the HardwareComponentStatus const type.
func PossibleHardwareComponentStatusValues() []HardwareComponentStatus {
	return []HardwareComponentStatus{
		HardwareComponentStatusFailure,
		HardwareComponentStatusNotPresent,
		HardwareComponentStatusOk,
		HardwareComponentStatusPoweredOff,
		HardwareComponentStatusRecovering,
		HardwareComponentStatusUnknown,
		HardwareComponentStatusWarning,
	}
}

// ISCSIAndCloudStatus - Value indicating cloud and ISCSI status of network adapter.
type ISCSIAndCloudStatus string

const (
	ISCSIAndCloudStatusCloudEnabled         ISCSIAndCloudStatus = "CloudEnabled"
	ISCSIAndCloudStatusDisabled             ISCSIAndCloudStatus = "Disabled"
	ISCSIAndCloudStatusIscsiAndCloudEnabled ISCSIAndCloudStatus = "IscsiAndCloudEnabled"
	ISCSIAndCloudStatusIscsiEnabled         ISCSIAndCloudStatus = "IscsiEnabled"
)

// PossibleISCSIAndCloudStatusValues returns the possible values for the ISCSIAndCloudStatus const type.
func PossibleISCSIAndCloudStatusValues() []ISCSIAndCloudStatus {
	return []ISCSIAndCloudStatus{
		ISCSIAndCloudStatusCloudEnabled,
		ISCSIAndCloudStatusDisabled,
		ISCSIAndCloudStatusIscsiAndCloudEnabled,
		ISCSIAndCloudStatusIscsiEnabled,
	}
}

// InEligibilityCategory - The reason for inEligibility of device, in case it's not eligible for service data encryption key
// rollover.
type InEligibilityCategory string

const (
	InEligibilityCategoryDeviceNotOnline       InEligibilityCategory = "DeviceNotOnline"
	InEligibilityCategoryNotSupportedAppliance InEligibilityCategory = "NotSupportedAppliance"
	InEligibilityCategoryRolloverPending       InEligibilityCategory = "RolloverPending"
)

// PossibleInEligibilityCategoryValues returns the possible values for the InEligibilityCategory const type.
func PossibleInEligibilityCategoryValues() []InEligibilityCategory {
	return []InEligibilityCategory{
		InEligibilityCategoryDeviceNotOnline,
		InEligibilityCategoryNotSupportedAppliance,
		InEligibilityCategoryRolloverPending,
	}
}

// JobStatus - The current status of the job.
type JobStatus string

const (
	JobStatusCanceled  JobStatus = "Canceled"
	JobStatusFailed    JobStatus = "Failed"
	JobStatusRunning   JobStatus = "Running"
	JobStatusSucceeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns the possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{
		JobStatusCanceled,
		JobStatusFailed,
		JobStatusRunning,
		JobStatusSucceeded,
	}
}

// JobType - The type of the job.
type JobType string

const (
	JobTypeCloneVolume               JobType = "CloneVolume"
	JobTypeCreateCloudAppliance      JobType = "CreateCloudAppliance"
	JobTypeCreateLocallyPinnedVolume JobType = "CreateLocallyPinnedVolume"
	JobTypeFailoverVolumeContainers  JobType = "FailoverVolumeContainers"
	JobTypeInstallUpdates            JobType = "InstallUpdates"
	JobTypeManualBackup              JobType = "ManualBackup"
	JobTypeModifyVolume              JobType = "ModifyVolume"
	JobTypeRestoreBackup             JobType = "RestoreBackup"
	JobTypeScheduledBackup           JobType = "ScheduledBackup"
	JobTypeSupportPackageLogs        JobType = "SupportPackageLogs"
)

// PossibleJobTypeValues returns the possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{
		JobTypeCloneVolume,
		JobTypeCreateCloudAppliance,
		JobTypeCreateLocallyPinnedVolume,
		JobTypeFailoverVolumeContainers,
		JobTypeInstallUpdates,
		JobTypeManualBackup,
		JobTypeModifyVolume,
		JobTypeRestoreBackup,
		JobTypeScheduledBackup,
		JobTypeSupportPackageLogs,
	}
}

// KeyRolloverStatus - The key rollover status to indicates if key rollover is required or not. If secret's encryption has
// been upgraded, then it requires key rollover.
type KeyRolloverStatus string

const (
	KeyRolloverStatusNotRequired KeyRolloverStatus = "NotRequired"
	KeyRolloverStatusRequired    KeyRolloverStatus = "Required"
)

// PossibleKeyRolloverStatusValues returns the possible values for the KeyRolloverStatus const type.
func PossibleKeyRolloverStatusValues() []KeyRolloverStatus {
	return []KeyRolloverStatus{
		KeyRolloverStatusNotRequired,
		KeyRolloverStatusRequired,
	}
}

// ManagerType - The type of StorSimple Manager.
type ManagerType string

const (
	ManagerTypeGardaV1    ManagerType = "GardaV1"
	ManagerTypeHelsinkiV1 ManagerType = "HelsinkiV1"
)

// PossibleManagerTypeValues returns the possible values for the ManagerType const type.
func PossibleManagerTypeValues() []ManagerType {
	return []ManagerType{
		ManagerTypeGardaV1,
		ManagerTypeHelsinkiV1,
	}
}

// MetricAggregationType - The metric aggregation type.
type MetricAggregationType string

const (
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	MetricAggregationTypeLast    MetricAggregationType = "Last"
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	MetricAggregationTypeNone    MetricAggregationType = "None"
	MetricAggregationTypeTotal   MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns the possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{
		MetricAggregationTypeAverage,
		MetricAggregationTypeLast,
		MetricAggregationTypeMaximum,
		MetricAggregationTypeMinimum,
		MetricAggregationTypeNone,
		MetricAggregationTypeTotal,
	}
}

// MetricUnit - The metric unit.
type MetricUnit string

const (
	MetricUnitBytes          MetricUnit = "Bytes"
	MetricUnitBytesPerSecond MetricUnit = "BytesPerSecond"
	MetricUnitCount          MetricUnit = "Count"
	MetricUnitCountPerSecond MetricUnit = "CountPerSecond"
	MetricUnitPercent        MetricUnit = "Percent"
	MetricUnitSeconds        MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns the possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{
		MetricUnitBytes,
		MetricUnitBytesPerSecond,
		MetricUnitCount,
		MetricUnitCountPerSecond,
		MetricUnitPercent,
		MetricUnitSeconds,
	}
}

// MonitoringStatus - The monitoring status of the volume.
type MonitoringStatus string

const (
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	MonitoringStatusEnabled  MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns the possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{
		MonitoringStatusDisabled,
		MonitoringStatusEnabled,
	}
}

// NetInterfaceID - The ID of the network adapter.
type NetInterfaceID string

const (
	NetInterfaceIDData0   NetInterfaceID = "Data0"
	NetInterfaceIDData1   NetInterfaceID = "Data1"
	NetInterfaceIDData2   NetInterfaceID = "Data2"
	NetInterfaceIDData3   NetInterfaceID = "Data3"
	NetInterfaceIDData4   NetInterfaceID = "Data4"
	NetInterfaceIDData5   NetInterfaceID = "Data5"
	NetInterfaceIDInvalid NetInterfaceID = "Invalid"
)

// PossibleNetInterfaceIDValues returns the possible values for the NetInterfaceID const type.
func PossibleNetInterfaceIDValues() []NetInterfaceID {
	return []NetInterfaceID{
		NetInterfaceIDData0,
		NetInterfaceIDData1,
		NetInterfaceIDData2,
		NetInterfaceIDData3,
		NetInterfaceIDData4,
		NetInterfaceIDData5,
		NetInterfaceIDInvalid,
	}
}

// NetInterfaceStatus - Value indicating status of network adapter.
type NetInterfaceStatus string

const (
	NetInterfaceStatusDisabled NetInterfaceStatus = "Disabled"
	NetInterfaceStatusEnabled  NetInterfaceStatus = "Enabled"
)

// PossibleNetInterfaceStatusValues returns the possible values for the NetInterfaceStatus const type.
func PossibleNetInterfaceStatusValues() []NetInterfaceStatus {
	return []NetInterfaceStatus{
		NetInterfaceStatusDisabled,
		NetInterfaceStatusEnabled,
	}
}

// NetworkMode - The mode of network adapter, either IPv4, IPv6 or both.
type NetworkMode string

const (
	NetworkModeBOTH    NetworkMode = "BOTH"
	NetworkModeIPV4    NetworkMode = "IPV4"
	NetworkModeIPV6    NetworkMode = "IPV6"
	NetworkModeInvalid NetworkMode = "Invalid"
)

// PossibleNetworkModeValues returns the possible values for the NetworkMode const type.
func PossibleNetworkModeValues() []NetworkMode {
	return []NetworkMode{
		NetworkModeBOTH,
		NetworkModeIPV4,
		NetworkModeIPV6,
		NetworkModeInvalid,
	}
}

// OperationStatus - The operation status on the volume.
type OperationStatus string

const (
	OperationStatusDeleting  OperationStatus = "Deleting"
	OperationStatusNone      OperationStatus = "None"
	OperationStatusRestoring OperationStatus = "Restoring"
	OperationStatusUpdating  OperationStatus = "Updating"
)

// PossibleOperationStatusValues returns the possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{
		OperationStatusDeleting,
		OperationStatusNone,
		OperationStatusRestoring,
		OperationStatusUpdating,
	}
}

// OwnerShipStatus - The owner ship status of the volume container. Only when the status is "NotOwned", the delete operation
// on the volume container is permitted.
type OwnerShipStatus string

const (
	OwnerShipStatusNotOwned OwnerShipStatus = "NotOwned"
	OwnerShipStatusOwned    OwnerShipStatus = "Owned"
)

// PossibleOwnerShipStatusValues returns the possible values for the OwnerShipStatus const type.
func PossibleOwnerShipStatusValues() []OwnerShipStatus {
	return []OwnerShipStatus{
		OwnerShipStatusNotOwned,
		OwnerShipStatusOwned,
	}
}

// RecurrenceType - The recurrence type.
type RecurrenceType string

const (
	RecurrenceTypeDaily   RecurrenceType = "Daily"
	RecurrenceTypeHourly  RecurrenceType = "Hourly"
	RecurrenceTypeMinutes RecurrenceType = "Minutes"
	RecurrenceTypeWeekly  RecurrenceType = "Weekly"
)

// PossibleRecurrenceTypeValues returns the possible values for the RecurrenceType const type.
func PossibleRecurrenceTypeValues() []RecurrenceType {
	return []RecurrenceType{
		RecurrenceTypeDaily,
		RecurrenceTypeHourly,
		RecurrenceTypeMinutes,
		RecurrenceTypeWeekly,
	}
}

// RemoteManagementModeConfiguration - The remote management mode.
type RemoteManagementModeConfiguration string

const (
	RemoteManagementModeConfigurationDisabled            RemoteManagementModeConfiguration = "Disabled"
	RemoteManagementModeConfigurationHTTPSAndHTTPEnabled RemoteManagementModeConfiguration = "HttpsAndHttpEnabled"
	RemoteManagementModeConfigurationHTTPSEnabled        RemoteManagementModeConfiguration = "HttpsEnabled"
	RemoteManagementModeConfigurationUnknown             RemoteManagementModeConfiguration = "Unknown"
)

// PossibleRemoteManagementModeConfigurationValues returns the possible values for the RemoteManagementModeConfiguration const type.
func PossibleRemoteManagementModeConfigurationValues() []RemoteManagementModeConfiguration {
	return []RemoteManagementModeConfiguration{
		RemoteManagementModeConfigurationDisabled,
		RemoteManagementModeConfigurationHTTPSAndHTTPEnabled,
		RemoteManagementModeConfigurationHTTPSEnabled,
		RemoteManagementModeConfigurationUnknown,
	}
}

// SSLStatus - Signifies whether SSL needs to be enabled or not.
type SSLStatus string

const (
	SSLStatusDisabled SSLStatus = "Disabled"
	SSLStatusEnabled  SSLStatus = "Enabled"
)

// PossibleSSLStatusValues returns the possible values for the SSLStatus const type.
func PossibleSSLStatusValues() []SSLStatus {
	return []SSLStatus{
		SSLStatusDisabled,
		SSLStatusEnabled,
	}
}

// ScheduleStatus - The schedule status.
type ScheduleStatus string

const (
	ScheduleStatusDisabled ScheduleStatus = "Disabled"
	ScheduleStatusEnabled  ScheduleStatus = "Enabled"
)

// PossibleScheduleStatusValues returns the possible values for the ScheduleStatus const type.
func PossibleScheduleStatusValues() []ScheduleStatus {
	return []ScheduleStatus{
		ScheduleStatusDisabled,
		ScheduleStatusEnabled,
	}
}

// ScheduledBackupStatus - Indicates whether at least one of the schedules in the backup policy is active or not.
type ScheduledBackupStatus string

const (
	ScheduledBackupStatusDisabled ScheduledBackupStatus = "Disabled"
	ScheduledBackupStatusEnabled  ScheduledBackupStatus = "Enabled"
)

// PossibleScheduledBackupStatusValues returns the possible values for the ScheduledBackupStatus const type.
func PossibleScheduledBackupStatusValues() []ScheduledBackupStatus {
	return []ScheduledBackupStatus{
		ScheduledBackupStatusDisabled,
		ScheduledBackupStatusEnabled,
	}
}

// TargetEligibilityResultCode - The result code for the error, due to which the device does not qualify as a failover target
// device.
type TargetEligibilityResultCode string

const (
	TargetEligibilityResultCodeLocalToTieredVolumesConversionWarning     TargetEligibilityResultCode = "LocalToTieredVolumesConversionWarning"
	TargetEligibilityResultCodeTargetAndSourceCannotBeSameError          TargetEligibilityResultCode = "TargetAndSourceCannotBeSameError"
	TargetEligibilityResultCodeTargetInsufficientCapacityError           TargetEligibilityResultCode = "TargetInsufficientCapacityError"
	TargetEligibilityResultCodeTargetInsufficientLocalVolumeMemoryError  TargetEligibilityResultCode = "TargetInsufficientLocalVolumeMemoryError"
	TargetEligibilityResultCodeTargetInsufficientTieredVolumeMemoryError TargetEligibilityResultCode = "TargetInsufficientTieredVolumeMemoryError"
	TargetEligibilityResultCodeTargetIsNotOnlineError                    TargetEligibilityResultCode = "TargetIsNotOnlineError"
	TargetEligibilityResultCodeTargetSourceIncompatibleVersionError      TargetEligibilityResultCode = "TargetSourceIncompatibleVersionError"
)

// PossibleTargetEligibilityResultCodeValues returns the possible values for the TargetEligibilityResultCode const type.
func PossibleTargetEligibilityResultCodeValues() []TargetEligibilityResultCode {
	return []TargetEligibilityResultCode{
		TargetEligibilityResultCodeLocalToTieredVolumesConversionWarning,
		TargetEligibilityResultCodeTargetAndSourceCannotBeSameError,
		TargetEligibilityResultCodeTargetInsufficientCapacityError,
		TargetEligibilityResultCodeTargetInsufficientLocalVolumeMemoryError,
		TargetEligibilityResultCodeTargetInsufficientTieredVolumeMemoryError,
		TargetEligibilityResultCodeTargetIsNotOnlineError,
		TargetEligibilityResultCodeTargetSourceIncompatibleVersionError,
	}
}

// TargetEligibilityStatus - The eligibility status of device, as a failover target device.
type TargetEligibilityStatus string

const (
	TargetEligibilityStatusEligible    TargetEligibilityStatus = "Eligible"
	TargetEligibilityStatusNotEligible TargetEligibilityStatus = "NotEligible"
)

// PossibleTargetEligibilityStatusValues returns the possible values for the TargetEligibilityStatus const type.
func PossibleTargetEligibilityStatusValues() []TargetEligibilityStatus {
	return []TargetEligibilityStatus{
		TargetEligibilityStatusEligible,
		TargetEligibilityStatusNotEligible,
	}
}

// VirtualMachineAPIType - The virtual machine API type.
type VirtualMachineAPIType string

const (
	VirtualMachineAPITypeArm     VirtualMachineAPIType = "Arm"
	VirtualMachineAPITypeClassic VirtualMachineAPIType = "Classic"
)

// PossibleVirtualMachineAPITypeValues returns the possible values for the VirtualMachineAPIType const type.
func PossibleVirtualMachineAPITypeValues() []VirtualMachineAPIType {
	return []VirtualMachineAPIType{
		VirtualMachineAPITypeArm,
		VirtualMachineAPITypeClassic,
	}
}

// VolumeStatus - The volume status.
type VolumeStatus string

const (
	VolumeStatusOffline VolumeStatus = "Offline"
	VolumeStatusOnline  VolumeStatus = "Online"
)

// PossibleVolumeStatusValues returns the possible values for the VolumeStatus const type.
func PossibleVolumeStatusValues() []VolumeStatus {
	return []VolumeStatus{
		VolumeStatusOffline,
		VolumeStatusOnline,
	}
}

// VolumeType - The volume type.
type VolumeType string

const (
	VolumeTypeArchival      VolumeType = "Archival"
	VolumeTypeLocallyPinned VolumeType = "LocallyPinned"
	VolumeTypeTiered        VolumeType = "Tiered"
)

// PossibleVolumeTypeValues returns the possible values for the VolumeType const type.
func PossibleVolumeTypeValues() []VolumeType {
	return []VolumeType{
		VolumeTypeArchival,
		VolumeTypeLocallyPinned,
		VolumeTypeTiered,
	}
}
