//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorage

import "time"

type AccessPolicy struct {
	// Expiry time of the access policy
	ExpiryTime *time.Time

	// List of abbreviated permissions.
	Permission *string

	// Start time of the access policy
	StartTime *time.Time
}

// Account - The storage account.
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The extendedLocation of the resource.
	ExtendedLocation *ExtendedLocation

	// The identity of the resource.
	Identity *Identity

	// Properties of the storage account.
	Properties *AccountProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; Gets the Kind.
	Kind *Kind

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Gets the SKU.
	SKU *SKU

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccountCheckNameAvailabilityParameters - The parameters used to check the availability of the storage account name.
type AccountCheckNameAvailabilityParameters struct {
	// REQUIRED; The storage account name.
	Name *string

	// CONSTANT; The type of resource, Microsoft.Storage/storageAccounts
	// Field has constant value "Microsoft.Storage/storageAccounts", any specified value is ignored.
	Type *string
}

// AccountCreateParameters - The parameters used when creating a storage account.
type AccountCreateParameters struct {
	// REQUIRED; Required. Indicates the type of storage account.
	Kind *Kind

	// REQUIRED; Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo
	// Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource
	// cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string

	// REQUIRED; Required. Gets or sets the SKU name.
	SKU *SKU

	// Optional. Set the extended location of the resource. If not set, the storage account will be created in Azure main region.
	// Otherwise it will be created in the specified extended location
	ExtendedLocation *ExtendedLocation

	// The identity of the resource.
	Identity *Identity

	// The parameters used to create the storage account.
	Properties *AccountPropertiesCreateParameters

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than
	// 256 characters.
	Tags map[string]*string
}

// AccountImmutabilityPolicyProperties - This defines account-level immutability policy properties.
type AccountImmutabilityPolicyProperties struct {
	// This property can only be changed for disabled and unlocked time-based retention policies. When enabled, new blocks can
	// be written to an append blob while maintaining immutability protection and
	// compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
	AllowProtectedAppendWrites *bool

	// The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32

	// The ImmutabilityPolicy state defines the mode of the policy. Disabled state disables the policy, Unlocked state allows
	// increase and decrease of immutability retention time and also allows toggling
	// allowProtectedAppendWrites property, Locked state only allows the increase of the immutability retention time. A policy
	// can only be created in a Disabled or Unlocked state and can be toggled between
	// the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted.
	State *AccountImmutabilityPolicyState
}

// AccountInternetEndpoints - The URIs that are used to perform a retrieval of a public blob, file, web or dfs object via
// a internet routing endpoint.
type AccountInternetEndpoints struct {
	// READ-ONLY; Gets the blob endpoint.
	Blob *string

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string

	// READ-ONLY; Gets the file endpoint.
	File *string

	// READ-ONLY; Gets the web endpoint.
	Web *string
}

// AccountKey - An access key for the storage account.
type AccountKey struct {
	// READ-ONLY; Creation time of the key, in round trip date format.
	CreationTime *time.Time

	// READ-ONLY; Name of the key.
	KeyName *string

	// READ-ONLY; Permissions for the key -- read-only or full permissions.
	Permissions *KeyPermission

	// READ-ONLY; Base 64-encoded value of the key.
	Value *string
}

// AccountListKeysResult - The response from the ListKeys operation.
type AccountListKeysResult struct {
	// READ-ONLY; Gets the list of storage account keys and their properties for the specified storage account.
	Keys []*AccountKey
}

// AccountListResult - The response from the List Storage Accounts operation.
type AccountListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of storage accounts. Returned when total number of requested
	// storage accounts exceed maximum page size.
	NextLink *string

	// READ-ONLY; Gets the list of storage accounts and their properties.
	Value []*Account
}

// AccountMicrosoftEndpoints - The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object
// via a microsoft routing endpoint.
type AccountMicrosoftEndpoints struct {
	// READ-ONLY; Gets the blob endpoint.
	Blob *string

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string

	// READ-ONLY; Gets the file endpoint.
	File *string

	// READ-ONLY; Gets the queue endpoint.
	Queue *string

	// READ-ONLY; Gets the table endpoint.
	Table *string

	// READ-ONLY; Gets the web endpoint.
	Web *string
}

// AccountMigration - The parameters or status associated with an ongoing or enqueued storage account migration in order to
// update its current SKU or region.
type AccountMigration struct {
	// REQUIRED; The properties of a storage account’s ongoing or enqueued migration.
	StorageAccountMigrationDetails *AccountMigrationProperties

	// current value is 'default' for customer initiated migration
	Name *string

	// SrpAccountMigrationType in ARM contract which is 'accountMigrations'
	Type *string

	// READ-ONLY; Migration Resource Id
	ID *string
}

// AccountMigrationProperties - The properties of a storage account’s ongoing or enqueued migration.
type AccountMigrationProperties struct {
	// REQUIRED; Target sku name for the account
	TargetSKUName *SKUName

	// READ-ONLY; Reason for migration failure
	MigrationFailedDetailedReason *string

	// READ-ONLY; Error code for migration failure
	MigrationFailedReason *string

	// READ-ONLY; Current status of migration
	MigrationStatus *MigrationStatus
}

// AccountProperties - Properties of the storage account.
type AccountProperties struct {
	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is false
	// for this property.
	AllowBlobPublicAccess *bool

	// Allow or disallow cross AAD tenant object replication. Set this property to true for new or existing accounts only if object
	// replication policies will involve storage accounts in different AAD
	// tenants. The default interpretation is false for new accounts to follow best security practices by default.
	AllowCrossTenantReplication *bool

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool

	// Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
	AllowedCopyScope *AllowedCopyScope

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication

	// Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription,
	// which creates accounts in an Azure DNS Zone and the endpoint URL
	// will have an alphanumeric DNS Zone identifier.
	DNSEndpointType *DNSEndpointType

	// A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false
	// for this property.
	DefaultToOAuthAuthentication *bool

	// Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool

	// NFS 3.0 protocol support enabled if set to true.
	EnableNfsV3 *bool

	// The property is immutable and can only be set to true at the account creation time. When set to true, it enables object
	// level immutability for all the containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount

	// Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool

	// Enables local users feature, if set to true
	IsLocalUserEnabled *bool

	// Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion

	// Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
	PublicNetworkAccess *PublicNetworkAccess

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference

	// This property is readOnly and is set by server during asynchronous storage account sku conversion operations.
	StorageAccountSKUConversionStatus *AccountSKUConversionStatus

	// READ-ONLY; Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access
	// tier is the default value for premium block blobs storage account type and it cannot
	// be changed for the premium block blobs storage account type.
	AccessTier *AccessTier

	// READ-ONLY; If customer initiated account migration is in progress, the value will be true else it will be null.
	AccountMigrationInProgress *bool

	// READ-ONLY; Blob restore status
	BlobRestoreStatus *BlobRestoreStatus

	// READ-ONLY; Gets the creation date and time of the storage account in UTC.
	CreationTime *time.Time

	// READ-ONLY; Gets the custom domain the user assigned to this storage account.
	CustomDomain *CustomDomain

	// READ-ONLY; Encryption settings to be used for server-side encryption for the storage account.
	Encryption *Encryption

	// READ-ONLY; If the failover is in progress, the value will be true, otherwise, it will be null.
	FailoverInProgress *bool

	// READ-ONLY; Geo Replication Stats
	GeoReplicationStats *GeoReplicationStats

	// READ-ONLY; This property will be set to true or false on an event of ongoing migration. Default value is null.
	IsSKUConversionBlocked *bool

	// READ-ONLY; Storage account keys creation time.
	KeyCreationTime *KeyCreationTime

	// READ-ONLY; KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy

	// READ-ONLY; Gets the timestamp of the most recent instance of a failover to the secondary location. Only the most recent
	// timestamp is retained. This element is not returned if there has never been a failover
	// instance. Only available if the accountType is StandardGRS or StandardRAGRS.
	LastGeoFailoverTime *time.Time

	// READ-ONLY; Network rule set
	NetworkRuleSet *NetworkRuleSet

	// READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object. Note that StandardZRS
	// and PremiumLRS accounts only return the blob endpoint.
	PrimaryEndpoints *Endpoints

	// READ-ONLY; Gets the location of the primary data center for the storage account.
	PrimaryLocation *string

	// READ-ONLY; List of private endpoint connection associated with the specified storage account
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Gets the status of the storage account at the time the operation was called.
	ProvisioningState *ProvisioningState

	// READ-ONLY; SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy

	// READ-ONLY; Gets the URLs that are used to perform a retrieval of a public blob, queue, or table object from the secondary
	// location of the storage account. Only available if the SKU name is Standard_RAGRS.
	SecondaryEndpoints *Endpoints

	// READ-ONLY; Gets the location of the geo-replicated secondary for the storage account. Only available if the accountType
	// is StandardGRS or StandardRAGRS.
	SecondaryLocation *string

	// READ-ONLY; Gets the status indicating whether the primary location of the storage account is available or unavailable.
	StatusOfPrimary *AccountStatus

	// READ-ONLY; Gets the status indicating whether the secondary location of the storage account is available or unavailable.
	// Only available if the SKU name is StandardGRS or StandardRAGRS.
	StatusOfSecondary *AccountStatus
}

// AccountPropertiesCreateParameters - The parameters used to create the storage account.
type AccountPropertiesCreateParameters struct {
	// Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier
	// is the default value for premium block blobs storage account type and it cannot
	// be changed for the premium block blobs storage account type.
	AccessTier *AccessTier

	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is false
	// for this property.
	AllowBlobPublicAccess *bool

	// Allow or disallow cross AAD tenant object replication. Set this property to true for new or existing accounts only if object
	// replication policies will involve storage accounts in different AAD
	// tenants. The default interpretation is false for new accounts to follow best security practices by default.
	AllowCrossTenantReplication *bool

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool

	// Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
	AllowedCopyScope *AllowedCopyScope

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication

	// User domain assigned to the storage account. Name is the CNAME source. Only one custom domain is supported per storage
	// account at this time. To clear the existing custom domain, use an empty string
	// for the custom domain name property.
	CustomDomain *CustomDomain

	// Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription,
	// which creates accounts in an Azure DNS Zone and the endpoint URL
	// will have an alphanumeric DNS Zone identifier.
	DNSEndpointType *DNSEndpointType

	// A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false
	// for this property.
	DefaultToOAuthAuthentication *bool

	// Allows https traffic only to storage service if sets to true. The default value is true since API version 2019-04-01.
	EnableHTTPSTrafficOnly *bool

	// NFS 3.0 protocol support enabled if set to true.
	EnableNfsV3 *bool

	// Encryption settings to be used for server-side encryption for the storage account.
	Encryption *Encryption

	// The property is immutable and can only be set to true at the account creation time. When set to true, it enables object
	// level immutability for all the new containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount

	// Account HierarchicalNamespace enabled if sets to true.
	IsHnsEnabled *bool

	// Enables local users feature, if set to true
	IsLocalUserEnabled *bool

	// Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool

	// KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion

	// Network rule set
	NetworkRuleSet *NetworkRuleSet

	// Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
	PublicNetworkAccess *PublicNetworkAccess

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference

	// SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy
}

// AccountPropertiesUpdateParameters - The parameters used when updating a storage account.
type AccountPropertiesUpdateParameters struct {
	// Required for storage accounts where kind = BlobStorage. The access tier is used for billing. The 'Premium' access tier
	// is the default value for premium block blobs storage account type and it cannot
	// be changed for the premium block blobs storage account type.
	AccessTier *AccessTier

	// Allow or disallow public access to all blobs or containers in the storage account. The default interpretation is false
	// for this property.
	AllowBlobPublicAccess *bool

	// Allow or disallow cross AAD tenant object replication. Set this property to true for new or existing accounts only if object
	// replication policies will involve storage accounts in different AAD
	// tenants. The default interpretation is false for new accounts to follow best security practices by default.
	AllowCrossTenantReplication *bool

	// Indicates whether the storage account permits requests to be authorized with the account access key via Shared Key. If
	// false, then all requests, including shared access signatures, must be authorized
	// with Azure Active Directory (Azure AD). The default value is null, which is equivalent to true.
	AllowSharedKeyAccess *bool

	// Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet.
	AllowedCopyScope *AllowedCopyScope

	// Provides the identity based authentication settings for Azure Files.
	AzureFilesIdentityBasedAuthentication *AzureFilesIdentityBasedAuthentication

	// Custom domain assigned to the storage account by the user. Name is the CNAME source. Only one custom domain is supported
	// per storage account at this time. To clear the existing custom domain, use an
	// empty string for the custom domain name property.
	CustomDomain *CustomDomain

	// Allows you to specify the type of endpoint. Set this to AzureDNSZone to create a large number of accounts in a single subscription,
	// which creates accounts in an Azure DNS Zone and the endpoint URL
	// will have an alphanumeric DNS Zone identifier.
	DNSEndpointType *DNSEndpointType

	// A boolean flag which indicates whether the default authentication is OAuth or not. The default interpretation is false
	// for this property.
	DefaultToOAuthAuthentication *bool

	// Allows https traffic only to storage service if sets to true.
	EnableHTTPSTrafficOnly *bool

	// Not applicable. Azure Storage encryption at rest is enabled by default for all storage accounts and cannot be disabled.
	Encryption *Encryption

	// The property is immutable and can only be set to true at the account creation time. When set to true, it enables object
	// level immutability for all the containers in the account by default.
	ImmutableStorageWithVersioning *ImmutableStorageAccount

	// Enables local users feature, if set to true
	IsLocalUserEnabled *bool

	// Enables Secure File Transfer Protocol, if set to true
	IsSftpEnabled *bool

	// KeyPolicy assigned to the storage account.
	KeyPolicy *KeyPolicy

	// Allow large file shares if sets to Enabled. It cannot be disabled once it is enabled.
	LargeFileSharesState *LargeFileSharesState

	// Set the minimum TLS version to be permitted on requests to storage. The default interpretation is TLS 1.0 for this property.
	MinimumTLSVersion *MinimumTLSVersion

	// Network rule set
	NetworkRuleSet *NetworkRuleSet

	// Allow or disallow public network access to Storage Account. Value is optional but if passed in, must be 'Enabled' or 'Disabled'.
	PublicNetworkAccess *PublicNetworkAccess

	// Maintains information about the network routing choice opted by the user for data transfer
	RoutingPreference *RoutingPreference

	// SasPolicy assigned to the storage account.
	SasPolicy *SasPolicy
}

// AccountRegenerateKeyParameters - The parameters used to regenerate the storage account key.
type AccountRegenerateKeyParameters struct {
	// REQUIRED; The name of storage keys that want to be regenerated, possible values are key1, key2, kerb1, kerb2.
	KeyName *string
}

// AccountSKUConversionStatus - This defines the sku conversion status object for asynchronous sku conversions.
type AccountSKUConversionStatus struct {
	// This property represents the target sku name to which the account sku is being converted asynchronously.
	TargetSKUName *SKUName

	// READ-ONLY; This property represents the sku conversion end time.
	EndTime *string

	// READ-ONLY; This property indicates the current sku conversion status.
	SKUConversionStatus *SKUConversionStatus

	// READ-ONLY; This property represents the sku conversion start time.
	StartTime *string
}

// AccountSasParameters - The parameters to list SAS credentials of a storage account.
type AccountSasParameters struct {
	// REQUIRED; The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l),
	// Add (a), Create (c), Update (u) and Process (p).
	Permissions *Permissions

	// REQUIRED; The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs;
	// Container (c): Access to container-level APIs; Object (o): Access to object-level APIs
	// for blobs, queue messages, table entities, and files.
	ResourceTypes *SignedResourceTypes

	// REQUIRED; The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t),
	// File (f).
	Services *Services

	// REQUIRED; The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *time.Time

	// An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string

	// The key to sign the account SAS token with.
	KeyToSign *string

	// The protocol permitted for a request made with the account SAS.
	Protocols *HTTPProtocol

	// The time at which the SAS becomes valid.
	SharedAccessStartTime *time.Time
}

// AccountUpdateParameters - The parameters that can be provided when updating the storage account properties.
type AccountUpdateParameters struct {
	// The identity of the resource.
	Identity *Identity

	// Optional. Indicates the type of storage account. Currently only StorageV2 value supported by server.
	Kind *Kind

	// The parameters used when updating a storage account.
	Properties *AccountPropertiesUpdateParameters

	// Gets or sets the SKU name. Note that the SKU name cannot be updated to StandardZRS, PremiumLRS or Premium_ZRS, nor can
	// accounts of those SKU names be updated to any other value.
	SKU *SKU

	// Gets or sets a list of key value pairs that describe the resource. These tags can be used in viewing and grouping this
	// resource (across resource groups). A maximum of 15 tags can be provided for a
	// resource. Each tag must have a key no greater in length than 128 characters and a value no greater in length than 256 characters.
	Tags map[string]*string
}

// ActiveDirectoryProperties - Settings properties for Active Directory (AD).
type ActiveDirectoryProperties struct {
	// REQUIRED; Specifies the domain GUID.
	DomainGUID *string

	// REQUIRED; Specifies the primary domain that the AD DNS server is authoritative for.
	DomainName *string

	// Specifies the Active Directory account type for Azure Storage.
	AccountType *ActiveDirectoryPropertiesAccountType

	// Specifies the security identifier (SID) for Azure Storage.
	AzureStorageSid *string

	// Specifies the security identifier (SID).
	DomainSid *string

	// Specifies the Active Directory forest to get.
	ForestName *string

	// Specifies the NetBIOS domain name.
	NetBiosDomainName *string

	// Specifies the Active Directory SAMAccountName for Azure Storage.
	SamAccountName *string
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AzureFilesIdentityBasedAuthentication - Settings for Azure Files identity based authentication.
type AzureFilesIdentityBasedAuthentication struct {
	// REQUIRED; Indicates the directory service used. Note that this enum may be extended in the future.
	DirectoryServiceOptions *DirectoryServiceOptions

	// Required if directoryServiceOptions are AD, optional if they are AADKERB.
	ActiveDirectoryProperties *ActiveDirectoryProperties

	// Default share permission for users using Kerberos authentication if RBAC role is not assigned.
	DefaultSharePermission *DefaultSharePermission
}

// BlobContainer - Properties of the blob container, including Id, resource name, resource type, Etag.
type BlobContainer struct {
	// Properties of the blob container.
	ContainerProperties *ContainerProperties

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BlobInventoryCreationTime - This property defines the creation time based filtering condition. Blob Inventory schema parameter
// 'Creation-Time' is mandatory with this filter.
type BlobInventoryCreationTime struct {
	// When set the policy filters the objects that are created in the last N days. Where N is an integer value between 1 to 36500.
	LastNDays *int32
}

// BlobInventoryPolicy - The storage account blob inventory policy.
type BlobInventoryPolicy struct {
	// Returns the storage account blob inventory policy rules.
	Properties *BlobInventoryPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BlobInventoryPolicyDefinition - An object that defines the blob inventory rule.
type BlobInventoryPolicyDefinition struct {
	// REQUIRED; This is a required field, it specifies the format for the inventory files.
	Format *Format

	// REQUIRED; This is a required field. This field specifies the scope of the inventory created either at the blob or container
	// level.
	ObjectType *ObjectType

	// REQUIRED; This is a required field. This field is used to schedule an inventory formation.
	Schedule *Schedule

	// REQUIRED; This is a required field. This field specifies the fields and properties of the object to be included in the
	// inventory. The Schema field value 'Name' is always required. The valid values for this
	// field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType,
	// AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time,
	// hdiisfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag,
	// ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl,
	// ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays,
	// ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold,
	// CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority,
	// ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope,
	// IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts.
	// The valid values for 'Container' definition.objectType include 'Name,
	// Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag,
	// DefaultEncryptionScope, DenyEncryptionScopeOverride,
	// ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time,
	// hdiisfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only
	// for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
	SchemaFields []*string

	// An object that defines the filter set.
	Filters *BlobInventoryPolicyFilter
}

// BlobInventoryPolicyFilter - An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType
// all filter properties are applicable, 'blobTypes' is required and others are optional. For
// 'Container' definition.objectType only prefixMatch is applicable and is optional.
type BlobInventoryPolicyFilter struct {
	// An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support
	// pageBlobs. This field is required when definition.objectType property is set to
	// 'Blob'.
	BlobTypes []*string

	// This property is used to filter objects based on the object creation time
	CreationTime *BlobInventoryCreationTime

	// An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
	ExcludePrefix []*string

	// Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion'
	// are required if this property is set to true, else they must be
	// excluded.
	IncludeBlobVersions *bool

	// For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'.
	// For 'Blob' definition.objectType and HNS enabled storage
	// accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for
	// Hns disabled accounts the definition.schemaFields must include 'Deleted and
	// RemainingRetentionDays', else it must be excluded.
	IncludeDeleted *bool

	// Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required
	// if this property is set to true, else it must be excluded.
	IncludeSnapshots *bool

	// An array of strings with maximum 10 blob prefixes to be included in the inventory.
	PrefixMatch []*string
}

// BlobInventoryPolicyProperties - The storage account blob inventory policy properties.
type BlobInventoryPolicyProperties struct {
	// REQUIRED; The storage account blob inventory policy object. It is composed of policy rules.
	Policy *BlobInventoryPolicySchema

	// READ-ONLY; Returns the last modified date and time of the blob inventory policy.
	LastModifiedTime *time.Time
}

// BlobInventoryPolicyRule - An object that wraps the blob inventory rule. Each rule is uniquely defined by name.
type BlobInventoryPolicyRule struct {
	// REQUIRED; An object that defines the blob inventory policy rule.
	Definition *BlobInventoryPolicyDefinition

	// REQUIRED; Container name where blob inventory files are stored. Must be pre-created.
	Destination *string

	// REQUIRED; Rule is enabled when set to true.
	Enabled *bool

	// REQUIRED; A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
	// unique within a policy.
	Name *string
}

// BlobInventoryPolicySchema - The storage account blob inventory policy rules.
type BlobInventoryPolicySchema struct {
	// REQUIRED; Policy is enabled if set to true.
	Enabled *bool

	// REQUIRED; The storage account blob inventory policy rules. The rule is applied when it is enabled.
	Rules []*BlobInventoryPolicyRule

	// REQUIRED; The valid value is Inventory
	Type *InventoryRuleType

	// READ-ONLY; Deprecated Property from API version 2021-04-01 onwards, the required destination container name must be specified
	// at the rule level 'policy.rule.destination'
	Destination *string
}

// BlobRestoreParameters - Blob restore parameters
type BlobRestoreParameters struct {
	// REQUIRED; Blob ranges to restore.
	BlobRanges []*BlobRestoreRange

	// REQUIRED; Restore blob to the specified time.
	TimeToRestore *time.Time
}

// BlobRestoreRange - Blob range
type BlobRestoreRange struct {
	// REQUIRED; Blob end range. This is exclusive. Empty means account end.
	EndRange *string

	// REQUIRED; Blob start range. This is inclusive. Empty means account start.
	StartRange *string
}

// BlobRestoreStatus - Blob restore status.
type BlobRestoreStatus struct {
	// READ-ONLY; Failure reason when blob restore is failed.
	FailureReason *string

	// READ-ONLY; Blob restore request parameters.
	Parameters *BlobRestoreParameters

	// READ-ONLY; Id for tracking blob restore request.
	RestoreID *string

	// READ-ONLY; The status of blob restore progress. Possible values are: - InProgress: Indicates that blob restore is ongoing.
	// - Complete: Indicates that blob restore has been completed successfully. - Failed:
	// Indicates that blob restore is failed.
	Status *BlobRestoreProgressStatus
}

type BlobServiceItems struct {
	// READ-ONLY; List of blob services returned.
	Value []*BlobServiceProperties
}

// BlobServiceProperties - The properties of a storage account’s Blob service.
type BlobServiceProperties struct {
	// The properties of a storage account’s Blob service.
	BlobServiceProperties *BlobServicePropertiesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Sku name and tier.
	SKU *SKU

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BlobServicePropertiesProperties - The properties of a storage account’s Blob service.
type BlobServicePropertiesProperties struct {
	// Deprecated in favor of isVersioningEnabled property.
	AutomaticSnapshotPolicyEnabled *bool

	// The blob service properties for change feed events.
	ChangeFeed *ChangeFeed

	// The blob service properties for container soft delete.
	ContainerDeleteRetentionPolicy *DeleteRetentionPolicy

	// Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the Blob service.
	Cors *CorsRules

	// DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version
	// is not specified. Possible values include version 2008-10-27 and all more
	// recent versions.
	DefaultServiceVersion *string

	// The blob service properties for blob soft delete.
	DeleteRetentionPolicy *DeleteRetentionPolicy

	// Versioning is enabled if set to true.
	IsVersioningEnabled *bool

	// The blob service property to configure last access time based tracking policy.
	LastAccessTimeTrackingPolicy *LastAccessTimeTrackingPolicy

	// The blob service properties for blob restore policy.
	RestorePolicy *RestorePolicyProperties
}

// ChangeFeed - The blob service properties for change feed events.
type ChangeFeed struct {
	// Indicates whether change feed event logging is enabled for the Blob service.
	Enabled *bool

	// Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years).
	// A null value indicates an infinite retention of the change feed.
	RetentionInDays *int32
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string

	// READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool

	// READ-ONLY; Gets the reason that a storage account name could not be used. The Reason element is only returned if NameAvailable
	// is false.
	Reason *Reason
}

// ContainerProperties - The properties of a container.
type ContainerProperties struct {
	// Default the container to use specified encryption scope for all writes.
	DefaultEncryptionScope *string

	// Block override of encryption scope from the container default.
	DenyEncryptionScopeOverride *bool

	// Enable NFSv3 all squash on blob container.
	EnableNfsV3AllSquash *bool

	// Enable NFSv3 root squash on blob container.
	EnableNfsV3RootSquash *bool

	// The object level immutability property of the container. The property is immutable and can only be set to true at the container
	// creation time. Existing containers must undergo a migration process.
	ImmutableStorageWithVersioning *ImmutableStorageWithVersioning

	// A name-value pair to associate with the container as metadata.
	Metadata map[string]*string

	// Specifies whether data in the container may be accessed publicly and the level of access.
	PublicAccess *PublicAccess

	// READ-ONLY; Indicates whether the blob container was deleted.
	Deleted *bool

	// READ-ONLY; Blob container deletion time.
	DeletedTime *time.Time

	// READ-ONLY; The hasImmutabilityPolicy public property is set to true by SRP if ImmutabilityPolicy has been created for this
	// container. The hasImmutabilityPolicy public property is set to false by SRP if
	// ImmutabilityPolicy has not been created for this container.
	HasImmutabilityPolicy *bool

	// READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
	// public property is set to false by SRP if all existing legal hold tags are cleared out.
	// There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool

	// READ-ONLY; The ImmutabilityPolicy property of the container.
	ImmutabilityPolicy *ImmutabilityPolicyProperties

	// READ-ONLY; Returns the date and time the container was last modified.
	LastModifiedTime *time.Time

	// READ-ONLY; Specifies whether the lease on a container is of infinite or fixed duration, only when the container is leased.
	LeaseDuration *LeaseDuration

	// READ-ONLY; Lease state of the container.
	LeaseState *LeaseState

	// READ-ONLY; The lease status of the container.
	LeaseStatus *LeaseStatus

	// READ-ONLY; The LegalHold property of the container.
	LegalHold *LegalHoldProperties

	// READ-ONLY; Remaining retention days for soft deleted blob container.
	RemainingRetentionDays *int32

	// READ-ONLY; The version of the deleted blob container.
	Version *string
}

// CorsRule - Specifies a CORS rule for the Blob service.
type CorsRule struct {
	// REQUIRED; Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
	AllowedHeaders []*string

	// REQUIRED; Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
	AllowedMethods []*CorsRuleAllowedMethodsItem

	// REQUIRED; Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow
	// all domains
	AllowedOrigins []*string

	// REQUIRED; Required if CorsRule element is present. A list of response headers to expose to CORS clients.
	ExposedHeaders []*string

	// REQUIRED; Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight
	// response.
	MaxAgeInSeconds *int32
}

// CorsRules - Sets the CORS rules. You can include up to five CorsRule elements in the request.
type CorsRules struct {
	// The List of CORS rules. You can include up to five CorsRule elements in the request.
	CorsRules []*CorsRule
}

// CustomDomain - The custom domain assigned to this storage account. This can be set via Update.
type CustomDomain struct {
	// REQUIRED; Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
	Name *string

	// Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
	UseSubDomainName *bool
}

// DateAfterCreation - Object to define snapshot and version action conditions.
type DateAfterCreation struct {
	// REQUIRED; Value indicating the age in days after creation
	DaysAfterCreationGreaterThan *float32

	// Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions
	// and requires daysAfterCreationGreaterThan to be set for snapshots and blob
	// version based actions. The blob will be archived if both the conditions are satisfied.
	DaysAfterLastTierChangeGreaterThan *float32
}

// DateAfterModification - Object to define the base blob action conditions. Properties daysAfterModificationGreaterThan,
// daysAfterLastAccessTimeGreaterThan and daysAfterCreationGreaterThan are mutually exclusive. The
// daysAfterLastTierChangeGreaterThan property is only applicable for tierToArchive actions which requires daysAfterModificationGreaterThan
// to be set, also it cannot be used in conjunction with
// daysAfterLastAccessTimeGreaterThan or daysAfterCreationGreaterThan.
type DateAfterModification struct {
	// Value indicating the age in days after blob creation.
	DaysAfterCreationGreaterThan *float32

	// Value indicating the age in days after last blob access. This property can only be used in conjunction with last access
	// time tracking policy
	DaysAfterLastAccessTimeGreaterThan *float32

	// Value indicating the age in days after last blob tier change time. This property is only applicable for tierToArchive actions
	// and requires daysAfterModificationGreaterThan to be set for baseBlobs
	// based actions. The blob will be archived if both the conditions are satisfied.
	DaysAfterLastTierChangeGreaterThan *float32

	// Value indicating the age in days after last modification
	DaysAfterModificationGreaterThan *float32
}

// DeleteRetentionPolicy - The service properties for soft delete.
type DeleteRetentionPolicy struct {
	// This property when set to true allows deletion of the soft deleted blob versions and snapshots. This property cannot be
	// used blob restore policy. This property only applies to blob service and does
	// not apply to containers or file share.
	AllowPermanentDelete *bool

	// Indicates the number of days that the deleted item should be retained. The minimum specified value can be 1 and the maximum
	// value can be 365.
	Days *int32

	// Indicates whether DeleteRetentionPolicy is enabled.
	Enabled *bool
}

// DeletedAccount - Deleted storage account
type DeletedAccount struct {
	// Properties of the deleted account.
	Properties *DeletedAccountProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DeletedAccountListResult - The response from the List Deleted Accounts operation.
type DeletedAccountListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of deleted accounts. Returned when total number of requested
	// deleted accounts exceed maximum page size.
	NextLink *string

	// READ-ONLY; Gets the list of deleted accounts and their properties.
	Value []*DeletedAccount
}

// DeletedAccountProperties - Attributes of a deleted storage account.
type DeletedAccountProperties struct {
	// READ-ONLY; Creation time of the deleted account.
	CreationTime *string

	// READ-ONLY; Deletion time of the deleted account.
	DeletionTime *string

	// READ-ONLY; Location of the deleted account.
	Location *string

	// READ-ONLY; Can be used to attempt recovering this deleted account via PutStorageAccount API.
	RestoreReference *string

	// READ-ONLY; Full resource id of the original storage account.
	StorageAccountResourceID *string
}

// DeletedShare - The deleted share to be restored.
type DeletedShare struct {
	// REQUIRED; Required. Identify the name of the deleted share that will be restored.
	DeletedShareName *string

	// REQUIRED; Required. Identify the version of the deleted share that will be restored.
	DeletedShareVersion *string
}

// Dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Display name of dimension.
	DisplayName *string

	// Display name of dimension.
	Name *string
}

// Encryption - The encryption settings on the storage account.
type Encryption struct {
	// The identity to be used with service-side encryption at rest.
	EncryptionIdentity *EncryptionIdentity

	// The encryption keySource (provider). Possible values (case-insensitive): Microsoft.Storage, Microsoft.Keyvault
	KeySource *KeySource

	// Properties provided by key vault.
	KeyVaultProperties *KeyVaultProperties

	// A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for
	// data at rest.
	RequireInfrastructureEncryption *bool

	// List of services which support encryption.
	Services *EncryptionServices
}

// EncryptionIdentity - Encryption identity for the storage account.
type EncryptionIdentity struct {
	// ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys
	// server-side encryption on the storage account.
	EncryptionFederatedIdentityClientID *string

	// Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
	EncryptionUserAssignedIdentity *string
}

// EncryptionScope - The Encryption Scope resource.
type EncryptionScope struct {
	// Properties of the encryption scope.
	EncryptionScopeProperties *EncryptionScopeProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EncryptionScopeKeyVaultProperties - The key vault properties for the encryption scope. This is a required field if encryption
// scope 'source' attribute is set to 'Microsoft.KeyVault'.
type EncryptionScopeKeyVaultProperties struct {
	// The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the
	// identifier to enable customer-managed key support on this encryption scope.
	KeyURI *string

	// READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string

	// READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *time.Time
}

// EncryptionScopeListResult - List of encryption scopes requested, and if paging is required, a URL to the next page of encryption
// scopes.
type EncryptionScopeListResult struct {
	// READ-ONLY; Request URL that can be used to query next page of encryption scopes. Returned when total number of requested
	// encryption scopes exceeds the maximum page size.
	NextLink *string

	// READ-ONLY; List of encryption scopes requested.
	Value []*EncryptionScope
}

// EncryptionScopeProperties - Properties of the encryption scope.
type EncryptionScopeProperties struct {
	// The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set
	// to 'Microsoft.KeyVault'.
	KeyVaultProperties *EncryptionScopeKeyVaultProperties

	// A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for
	// data at rest.
	RequireInfrastructureEncryption *bool

	// The provider for the encryption scope. Possible values (case-insensitive): Microsoft.Storage, Microsoft.KeyVault.
	Source *EncryptionScopeSource

	// The state of the encryption scope. Possible values (case-insensitive): Enabled, Disabled.
	State *EncryptionScopeState

	// READ-ONLY; Gets the creation date and time of the encryption scope in UTC.
	CreationTime *time.Time

	// READ-ONLY; Gets the last modification date and time of the encryption scope in UTC.
	LastModifiedTime *time.Time
}

// EncryptionService - A service that allows server-side encryption to be used.
type EncryptionService struct {
	// A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default
	// today and cannot be disabled.
	Enabled *bool

	// Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption
	// key will be used. 'Service' key type implies that a default service key is used.
	KeyType *KeyType

	// READ-ONLY; Gets a rough estimate of the date/time when the encryption was last enabled by the user. Data is encrypted at
	// rest by default today and cannot be disabled.
	LastEnabledTime *time.Time
}

// EncryptionServices - A list of services that support encryption.
type EncryptionServices struct {
	// The encryption function of the blob storage service.
	Blob *EncryptionService

	// The encryption function of the file storage service.
	File *EncryptionService

	// The encryption function of the queue storage service.
	Queue *EncryptionService

	// The encryption function of the table storage service.
	Table *EncryptionService
}

// Endpoints - The URIs that are used to perform a retrieval of a public blob, queue, table, web or dfs object.
type Endpoints struct {
	// Gets the internet routing storage endpoints
	InternetEndpoints *AccountInternetEndpoints

	// Gets the microsoft routing storage endpoints.
	MicrosoftEndpoints *AccountMicrosoftEndpoints

	// READ-ONLY; Gets the blob endpoint.
	Blob *string

	// READ-ONLY; Gets the dfs endpoint.
	Dfs *string

	// READ-ONLY; Gets the file endpoint.
	File *string

	// READ-ONLY; Gets the queue endpoint.
	Queue *string

	// READ-ONLY; Gets the table endpoint.
	Table *string

	// READ-ONLY; Gets the web endpoint.
	Web *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - An error response from the storage resource provider.
type ErrorResponse struct {
	// Azure Storage Resource Provider error response body.
	Error *ErrorResponseBody
}

// ErrorResponseAutoGenerated - Common error response for all Azure Resource Manager APIs to return error details for failed
// operations. (This also follows the OData error response format.).
type ErrorResponseAutoGenerated struct {
	// The error object.
	Error *ErrorDetail
}

// ErrorResponseBody - Error response body contract.
type ErrorResponseBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string
}

// ExtendedLocation - The complex type of the extended location.
type ExtendedLocation struct {
	// The name of the extended location.
	Name *string

	// The type of the extended location.
	Type *ExtendedLocationTypes
}

type FileServiceItems struct {
	// READ-ONLY; List of file services returned.
	Value []*FileServiceProperties
}

// FileServiceProperties - The properties of File services in storage account.
type FileServiceProperties struct {
	// The properties of File services in storage account.
	FileServiceProperties *FileServicePropertiesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Sku name and tier.
	SKU *SKU

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FileServicePropertiesProperties - The properties of File services in storage account.
type FileServicePropertiesProperties struct {
	// Specifies CORS rules for the File service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the File service.
	Cors *CorsRules

	// Protocol settings for file service
	ProtocolSettings *ProtocolSettings

	// The file service properties for share soft delete.
	ShareDeleteRetentionPolicy *DeleteRetentionPolicy
}

// FileShare - Properties of the file share, including Id, resource name, resource type, Etag.
type FileShare struct {
	// Properties of the file share.
	FileShareProperties *FileShareProperties

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FileShareItem - The file share properties be listed out.
type FileShareItem struct {
	// The file share properties be listed out.
	Properties *FileShareProperties

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FileShareItems - Response schema. Contains list of shares returned, and if paging is requested or required, a URL to next
// page of shares.
type FileShareItems struct {
	// READ-ONLY; Request URL that can be used to query next page of shares. Returned when total number of requested shares exceed
	// maximum page size.
	NextLink *string

	// READ-ONLY; List of file shares returned.
	Value []*FileShareItem
}

// FileShareProperties - The properties of the file share.
type FileShareProperties struct {
	// Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage
	// account can choose Premium.
	AccessTier *ShareAccessTier

	// The authentication protocol that is used for the file share. Can only be specified when creating a share.
	EnabledProtocols *EnabledProtocols

	// A name-value pair to associate with the share as metadata.
	Metadata map[string]*string

	// The property is for NFS share only. The default is NoRootSquash.
	RootSquash *RootSquashType

	// The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File
	// Shares, the maximum size is 102400.
	ShareQuota *int32

	// List of stored access policies specified on the share.
	SignedIdentifiers []*SignedIdentifier

	// READ-ONLY; Indicates the last modification time for share access tier.
	AccessTierChangeTime *time.Time

	// READ-ONLY; Indicates if there is a pending transition for access tier.
	AccessTierStatus *string

	// READ-ONLY; Indicates whether the share was deleted.
	Deleted *bool

	// READ-ONLY; The deleted time if the share was deleted.
	DeletedTime *time.Time

	// READ-ONLY; Returns the date and time the share was last modified.
	LastModifiedTime *time.Time

	// READ-ONLY; Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased.
	LeaseDuration *LeaseDuration

	// READ-ONLY; Lease state of the share.
	LeaseState *LeaseState

	// READ-ONLY; The lease status of the share.
	LeaseStatus *LeaseStatus

	// READ-ONLY; Remaining retention days for share that was soft deleted.
	RemainingRetentionDays *int32

	// READ-ONLY; The approximate size of the data stored on the share. Note that this value may not include all recently created
	// or recently resized files.
	ShareUsageBytes *int64

	// READ-ONLY; Creation time of share snapshot returned in the response of list shares with expand param "snapshots".
	SnapshotTime *time.Time

	// READ-ONLY; The version of the share.
	Version *string
}

// GeoReplicationStats - Statistics related to replication for storage account's Blob, Table, Queue and File services. It
// is only available when geo-redundant replication is enabled for the storage account.
type GeoReplicationStats struct {
	// READ-ONLY; A boolean flag which indicates whether or not account failover is supported for the account.
	CanFailover *bool

	// READ-ONLY; A boolean flag which indicates whether or not planned account failover is supported for the account.
	CanPlannedFailover *bool

	// READ-ONLY; All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary
	// writes following this point in time may or may not be available for reads. Element may
	// be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap.
	LastSyncTime *time.Time

	// READ-ONLY; The redundancy type of the account after an account failover is performed.
	PostFailoverRedundancy *PostFailoverRedundancy

	// READ-ONLY; The redundancy type of the account after a planned account failover is performed.
	PostPlannedFailoverRedundancy *PostPlannedFailoverRedundancy

	// READ-ONLY; The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is
	// active and operational. - Bootstrap: Indicates initial synchronization from the primary
	// location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable:
	// Indicates that the secondary location is temporarily unavailable.
	Status *GeoReplicationStatus
}

// IPRule - IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// REQUIRED; Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string

	// The action of IP ACL rule.
	Action *string
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; The identity type.
	Type *IdentityType

	// Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage
	// account. The key is the ARM resource identifier of the identity. Only 1
	// User Assigned identity is permitted here.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// ImmutabilityPolicy - The ImmutabilityPolicy property of a blob container, including Id, resource name, resource type, Etag.
type ImmutabilityPolicy struct {
	// REQUIRED; The properties of an ImmutabilityPolicy of a blob container.
	Properties *ImmutabilityPolicyProperty

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ImmutabilityPolicyProperties - The properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperties struct {
	// The properties of an ImmutabilityPolicy of a blob container.
	Properties *ImmutabilityPolicyProperty

	// READ-ONLY; ImmutabilityPolicy Etag.
	Etag *string

	// READ-ONLY; The ImmutabilityPolicy update history of the blob container.
	UpdateHistory []*UpdateHistoryProperty
}

// ImmutabilityPolicyProperty - The properties of an ImmutabilityPolicy of a blob container.
type ImmutabilityPolicyProperty struct {
	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// an append blob while maintaining immutability protection and compliance. Only
	// new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
	// API.
	AllowProtectedAppendWrites *bool

	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// both 'Append and Bock Blobs' while maintaining immutability protection and
	// compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be
	// changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
	// 'allowProtectedAppendWritesAll' properties are mutually exclusive.
	AllowProtectedAppendWritesAll *bool

	// The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32

	// READ-ONLY; The ImmutabilityPolicy state of a blob container, possible values include: Locked and Unlocked.
	State *ImmutabilityPolicyState
}

// ImmutableStorageAccount - This property enables and defines account-level immutability. Enabling the feature auto-enables
// Blob Versioning.
type ImmutableStorageAccount struct {
	// A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability
	// enabled by default.
	Enabled *bool

	// Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an
	// explicit immutability policy at the object level. The object-level immutability
	// policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level
	// immutability policy.
	ImmutabilityPolicy *AccountImmutabilityPolicyProperties
}

// ImmutableStorageWithVersioning - Object level immutability properties of the container.
type ImmutableStorageWithVersioning struct {
	// This is an immutable property, when set to true it enables object level immutability at the container level.
	Enabled *bool

	// READ-ONLY; This property denotes the container level immutability to object level immutability migration state.
	MigrationState *MigrationState

	// READ-ONLY; Returns the date and time the object level immutability was enabled.
	TimeStamp *time.Time
}

// KeyCreationTime - Storage account keys creation time.
type KeyCreationTime struct {
	Key1 *time.Time
	Key2 *time.Time
}

// KeyPolicy assigned to the storage account.
type KeyPolicy struct {
	// REQUIRED; The key expiration period in days.
	KeyExpirationPeriodInDays *int32
}

// KeyVaultProperties - Properties of key vault.
type KeyVaultProperties struct {
	// The name of KeyVault key.
	KeyName *string

	// The Uri of KeyVault.
	KeyVaultURI *string

	// The version of KeyVault key.
	KeyVersion *string

	// READ-ONLY; This is a read only property that represents the expiration time of the current version of the customer managed
	// key used for encryption.
	CurrentVersionedKeyExpirationTimestamp *time.Time

	// READ-ONLY; The object identifier of the current versioned Key Vault Key in use.
	CurrentVersionedKeyIdentifier *string

	// READ-ONLY; Timestamp of last rotation of the Key Vault Key.
	LastKeyRotationTimestamp *time.Time
}

// LastAccessTimeTrackingPolicy - The blob service properties for Last access time based tracking policy.
type LastAccessTimeTrackingPolicy struct {
	// REQUIRED; When set to true last access time based tracking is enabled.
	Enable *bool

	// An array of predefined supported blob types. Only blockBlob is the supported value. This field is currently read only
	BlobType []*string

	// Name of the policy. The valid value is AccessTimeTracking. This field is currently read only
	Name *Name

	// The field specifies blob object tracking granularity in days, typically how often the blob object should be tracked.This
	// field is currently read only with value as 1
	TrackingGranularityInDays *int32
}

// LeaseContainerRequest - Lease Container request schema.
type LeaseContainerRequest struct {
	// REQUIRED; Specifies the lease action. Can be one of the available actions.
	Action *LeaseContainerRequestAction

	// Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and
	// 60.
	BreakPeriod *int32

	// Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32

	// Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string

	// Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string
}

// LeaseContainerResponse - Lease Container response schema.
type LeaseContainerResponse struct {
	// Returned unique lease ID that must be included with any request to delete the container, or to renew, change, or release
	// the lease.
	LeaseID *string

	// Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string
}

// LeaseShareRequest - Lease Share request schema.
type LeaseShareRequest struct {
	// REQUIRED; Specifies the lease action. Can be one of the available actions.
	Action *LeaseShareAction

	// Optional. For a break action, proposed duration the lease should continue before it is broken, in seconds, between 0 and
	// 60.
	BreakPeriod *int32

	// Required for acquire. Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires.
	LeaseDuration *int32

	// Identifies the lease. Can be specified in any valid GUID string format.
	LeaseID *string

	// Optional for acquire, required for change. Proposed lease ID, in a GUID string format.
	ProposedLeaseID *string
}

// LeaseShareResponse - Lease Share response schema.
type LeaseShareResponse struct {
	// Returned unique lease ID that must be included with any request to delete the share, or to renew, change, or release the
	// lease.
	LeaseID *string

	// Approximate time remaining in the lease period, in seconds.
	LeaseTimeSeconds *string
}

// LegalHold - The LegalHold property of a blob container.
type LegalHold struct {
	// REQUIRED; Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
	Tags []*string

	// When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance.
	// Only new blocks can be added and any existing blocks cannot be modified
	// or deleted.
	AllowProtectedAppendWritesAll *bool

	// READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
	// public property is set to false by SRP if all existing legal hold tags are cleared out.
	// There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool
}

// LegalHoldProperties - The LegalHold property of a blob container.
type LegalHoldProperties struct {
	// Protected append blob writes history.
	ProtectedAppendWritesHistory *ProtectedAppendWritesHistory

	// The list of LegalHold tags of a blob container.
	Tags []*TagProperty

	// READ-ONLY; The hasLegalHold public property is set to true by SRP if there are at least one existing tag. The hasLegalHold
	// public property is set to false by SRP if all existing legal hold tags are cleared out.
	// There can be a maximum of 1000 blob containers with hasLegalHold=true for a given account.
	HasLegalHold *bool
}

// ListAccountSasResponse - The List SAS credentials operation response.
type ListAccountSasResponse struct {
	// READ-ONLY; List SAS credentials of storage account.
	AccountSasToken *string
}

// ListBlobInventoryPolicy - List of blob inventory policies returned.
type ListBlobInventoryPolicy struct {
	// READ-ONLY; List of blob inventory policies.
	Value []*BlobInventoryPolicy
}

// ListContainerItem - The blob container properties be listed out.
type ListContainerItem struct {
	// The blob container properties be listed out.
	Properties *ContainerProperties

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ListContainerItems - Response schema. Contains list of blobs returned, and if paging is requested or required, a URL to
// next page of containers.
type ListContainerItems struct {
	// READ-ONLY; Request URL that can be used to query next page of containers. Returned when total number of requested containers
	// exceed maximum page size.
	NextLink *string

	// READ-ONLY; List of blobs containers returned.
	Value []*ListContainerItem
}

type ListQueue struct {
	// List Queue resource properties.
	QueueProperties *ListQueueProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ListQueueProperties struct {
	// A name-value pair that represents queue metadata.
	Metadata map[string]*string
}

// ListQueueResource - Response schema. Contains list of queues returned
type ListQueueResource struct {
	// READ-ONLY; Request URL that can be used to list next page of queues
	NextLink *string

	// READ-ONLY; List of queues returned.
	Value []*ListQueue
}

type ListQueueServices struct {
	// READ-ONLY; List of queue services returned.
	Value []*QueueServiceProperties
}

// ListServiceSasResponse - The List service SAS credentials operation response.
type ListServiceSasResponse struct {
	// READ-ONLY; List service SAS credentials of specific resource.
	ServiceSasToken *string
}

// ListTableResource - Response schema. Contains list of tables returned
type ListTableResource struct {
	// READ-ONLY; Request URL that can be used to query next page of tables
	NextLink *string

	// READ-ONLY; List of tables returned.
	Value []*Table
}

type ListTableServices struct {
	// READ-ONLY; List of table services returned.
	Value []*TableServiceProperties
}

// LocalUser - The local user associated with the storage accounts.
type LocalUser struct {
	// Storage account local user properties.
	Properties *LocalUserProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LocalUserKeys - The Storage Account Local User keys.
type LocalUserKeys struct {
	// Optional, local user ssh authorized keys for SFTP.
	SSHAuthorizedKeys []*SSHPublicKey

	// READ-ONLY; Auto generated by the server for SMB authentication.
	SharedKey *string
}

// LocalUserProperties - The Storage Account Local User properties.
type LocalUserProperties struct {
	// Indicates whether ssh key exists. Set it to false to remove existing SSH key.
	HasSSHKey *bool

	// Indicates whether ssh password exists. Set it to false to remove existing SSH password.
	HasSSHPassword *bool

	// Indicates whether shared key exists. Set it to false to remove existing shared key.
	HasSharedKey *bool

	// Optional, local user home directory.
	HomeDirectory *string

	// The permission scopes of the local user.
	PermissionScopes []*PermissionScope

	// Optional, local user ssh authorized keys for SFTP.
	SSHAuthorizedKeys []*SSHPublicKey

	// READ-ONLY; A unique Security Identifier that is generated by the server.
	Sid *string
}

// LocalUserRegeneratePasswordResult - The secrets of Storage Account Local User.
type LocalUserRegeneratePasswordResult struct {
	// READ-ONLY; Auto generated password by the server for SSH authentication if hasSshPassword is set to true on the creation
	// of local user.
	SSHPassword *string
}

// LocalUsers - List storage account local users.
type LocalUsers struct {
	// The local users associated with the storage account.
	Value []*LocalUser
}

// ManagementPolicy - The Get Storage Account ManagementPolicies operation response.
type ManagementPolicy struct {
	// Returns the Storage Account Data Policies Rules.
	Properties *ManagementPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagementPolicyAction - Actions are applied to the filtered blobs when the execution condition is met.
type ManagementPolicyAction struct {
	// The management policy action for base blob
	BaseBlob *ManagementPolicyBaseBlob

	// The management policy action for snapshot
	Snapshot *ManagementPolicySnapShot

	// The management policy action for version
	Version *ManagementPolicyVersion
}

// ManagementPolicyBaseBlob - Management policy action for base blob.
type ManagementPolicyBaseBlob struct {
	// The function to delete the blob
	Delete *DateAfterModification

	// This property enables auto tiering of a blob from cool to hot on a blob access. This property requires tierToCool.daysAfterLastAccessTimeGreaterThan.
	EnableAutoTierToHotFromCool *bool

	// The function to tier blobs to archive storage.
	TierToArchive *DateAfterModification

	// The function to tier blobs to cold storage.
	TierToCold *DateAfterModification

	// The function to tier blobs to cool storage.
	TierToCool *DateAfterModification

	// The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
	TierToHot *DateAfterModification
}

// ManagementPolicyDefinition - An object that defines the Lifecycle rule. Each definition is made up with a filters set and
// an actions set.
type ManagementPolicyDefinition struct {
	// REQUIRED; An object that defines the action set.
	Actions *ManagementPolicyAction

	// An object that defines the filter set.
	Filters *ManagementPolicyFilter
}

// ManagementPolicyFilter - Filters limit rule actions to a subset of blobs within the storage account. If multiple filters
// are defined, a logical AND is performed on all filters.
type ManagementPolicyFilter struct {
	// REQUIRED; An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete
	// actions are supported for appendBlob.
	BlobTypes []*string

	// An array of blob index tag based filters, there can be at most 10 tag filters
	BlobIndexMatch []*TagFilter

	// An array of strings for prefixes to be match.
	PrefixMatch []*string
}

// ManagementPolicyProperties - The Storage Account ManagementPolicy properties.
type ManagementPolicyProperties struct {
	// REQUIRED; The Storage Account ManagementPolicy, in JSON format. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Policy *ManagementPolicySchema

	// READ-ONLY; Returns the date and time the ManagementPolicies was last modified.
	LastModifiedTime *time.Time
}

// ManagementPolicyRule - An object that wraps the Lifecycle rule. Each rule is uniquely defined by name.
type ManagementPolicyRule struct {
	// REQUIRED; An object that defines the Lifecycle rule.
	Definition *ManagementPolicyDefinition

	// REQUIRED; A rule name can contain any combination of alpha numeric characters. Rule name is case-sensitive. It must be
	// unique within a policy.
	Name *string

	// REQUIRED; The valid value is Lifecycle
	Type *RuleType

	// Rule is enabled if set to true.
	Enabled *bool
}

// ManagementPolicySchema - The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
type ManagementPolicySchema struct {
	// REQUIRED; The Storage Account ManagementPolicies Rules. See more details in: https://docs.microsoft.com/en-us/azure/storage/common/storage-lifecycle-managment-concepts.
	Rules []*ManagementPolicyRule
}

// ManagementPolicySnapShot - Management policy action for snapshot.
type ManagementPolicySnapShot struct {
	// The function to delete the blob snapshot
	Delete *DateAfterCreation

	// The function to tier blob snapshot to archive storage.
	TierToArchive *DateAfterCreation

	// The function to tier blobs to cold storage.
	TierToCold *DateAfterCreation

	// The function to tier blob snapshot to cool storage.
	TierToCool *DateAfterCreation

	// The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
	TierToHot *DateAfterCreation
}

// ManagementPolicyVersion - Management policy action for blob version.
type ManagementPolicyVersion struct {
	// The function to delete the blob version
	Delete *DateAfterCreation

	// The function to tier blob version to archive storage.
	TierToArchive *DateAfterCreation

	// The function to tier blobs to cold storage.
	TierToCold *DateAfterCreation

	// The function to tier blob version to cool storage.
	TierToCool *DateAfterCreation

	// The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts
	TierToHot *DateAfterCreation
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// Aggregation type could be Average.
	AggregationType *string

	// The category this metric specification belong to, could be Capacity.
	Category *string

	// Dimensions of blobs, including blob type and access tier.
	Dimensions []*Dimension

	// Display description of metric specification.
	DisplayDescription *string

	// Display name of metric specification.
	DisplayName *string

	// The property to decide fill gap with zero or not.
	FillGapWithZero *bool

	// Name of metric specification.
	Name *string

	// Account Resource Id.
	ResourceIDDimensionNameOverride *string

	// Unit could be Bytes or Count.
	Unit *string
}

// Multichannel setting. Applies to Premium FileStorage only.
type Multichannel struct {
	// Indicates whether multichannel is enabled
	Enabled *bool
}

// NetworkRuleSet - Network rule set
type NetworkRuleSet struct {
	// REQUIRED; Specifies the default action of allow or deny when no other rules match.
	DefaultAction *DefaultAction

	// Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Possible values are any combination of Logging|Metrics|AzureServices
	// (For example, "Logging, Metrics"), or None to bypass none
	// of those traffics.
	Bypass *Bypass

	// Sets the IP ACL rules
	IPRules []*IPRule

	// Sets the resource access rules
	ResourceAccessRules []*ResourceAccessRule

	// Sets the virtual network rules
	VirtualNetworkRules []*VirtualNetworkRule
}

// ObjectReplicationPolicies - List storage account object replication policies.
type ObjectReplicationPolicies struct {
	// The replication policy between two storage accounts.
	Value []*ObjectReplicationPolicy
}

// ObjectReplicationPolicy - The replication policy between two storage accounts. Multiple rules can be defined in one policy.
type ObjectReplicationPolicy struct {
	// Returns the Storage Account Object Replication Policy.
	Properties *ObjectReplicationPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ObjectReplicationPolicyFilter - Filters limit replication to a subset of blobs within the storage account. A logical OR
// is performed on values in the filter. If multiple filters are defined, a logical AND is performed on all
// filters.
type ObjectReplicationPolicyFilter struct {
	// Blobs created after the time will be replicated to the destination. It must be in datetime format 'yyyy-MM-ddTHH:mm:ssZ'.
	// Example: 2020-02-19T16:05:00Z
	MinCreationTime *string

	// Optional. Filters the results to replicate only blobs whose names begin with the specified prefix.
	PrefixMatch []*string
}

// ObjectReplicationPolicyProperties - The Storage Account ObjectReplicationPolicy properties.
type ObjectReplicationPolicyProperties struct {
	// REQUIRED; Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
	DestinationAccount *string

	// REQUIRED; Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
	SourceAccount *string

	// The storage account object replication rules.
	Rules []*ObjectReplicationPolicyRule

	// READ-ONLY; Indicates when the policy is enabled on the source account.
	EnabledTime *time.Time

	// READ-ONLY; A unique id for object replication policy.
	PolicyID *string
}

// ObjectReplicationPolicyRule - The replication policy rule between two containers.
type ObjectReplicationPolicyRule struct {
	// REQUIRED; Required. Destination container name.
	DestinationContainer *string

	// REQUIRED; Required. Source container name.
	SourceContainer *string

	// Optional. An object that defines the filter set.
	Filters *ObjectReplicationPolicyFilter

	// Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account.
	RuleID *string
}

// Operation - Storage REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties

	// The origin of operations.
	Origin *string
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Service provider: Microsoft Storage.
	Provider *string

	// Resource on which the operation is performed etc.
	Resource *string
}

// OperationListResult - Result of the request to list Storage operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification
}

type PermissionScope struct {
	// REQUIRED; The permissions for the local user. Possible values include: Read (r), Write (w), Delete (d), List (l), and Create
	// (c).
	Permissions *string

	// REQUIRED; The name of resource, normally the container name or the file share name, used by the local user.
	ResourceName *string

	// REQUIRED; The service used by the local user, e.g. blob, file.
	Service *string
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProtectedAppendWritesHistory - Protected append writes history setting for the blob container with Legal holds.
type ProtectedAppendWritesHistory struct {
	// When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance.
	// Only new blocks can be added and any existing blocks cannot be modified
	// or deleted.
	AllowProtectedAppendWritesAll *bool

	// READ-ONLY; Returns the date and time the tag was added.
	Timestamp *time.Time
}

// ProtocolSettings - Protocol settings for file service
type ProtocolSettings struct {
	// Setting for SMB protocol
	Smb *SmbSetting
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type Queue struct {
	// Queue resource properties.
	QueueProperties *QueueProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type QueueProperties struct {
	// A name-value pair that represents queue metadata.
	Metadata map[string]*string

	// READ-ONLY; Integer indicating an approximate number of messages in the queue. This number is not lower than the actual
	// number of messages in the queue, but could be higher.
	ApproximateMessageCount *int32
}

// QueueServiceProperties - The properties of a storage account’s Queue service.
type QueueServiceProperties struct {
	// The properties of a storage account’s Queue service.
	QueueServiceProperties *QueueServicePropertiesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// QueueServicePropertiesProperties - The properties of a storage account’s Queue service.
type QueueServicePropertiesProperties struct {
	// Specifies CORS rules for the Queue service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the Queue service.
	Cors *CorsRules
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResourceAccessRule - Resource Access Rule.
type ResourceAccessRule struct {
	// Resource Id
	ResourceID *string

	// Tenant Id
	TenantID *string
}

// RestorePolicyProperties - The blob service properties for blob restore policy
type RestorePolicyProperties struct {
	// REQUIRED; Blob restore is enabled if set to true.
	Enabled *bool

	// how long this blob can be restored. It should be great than zero and less than DeleteRetentionPolicy.days.
	Days *int32

	// READ-ONLY; Deprecated in favor of minRestoreTime property.
	LastEnabledTime *time.Time

	// READ-ONLY; Returns the minimum date and time that the restore can be started.
	MinRestoreTime *time.Time
}

// Restriction - The restriction because of which SKU cannot be used.
type Restriction struct {
	// The reason for the restriction. As of now this can be "QuotaId" or "NotAvailableForSubscription". Quota Id is set when
	// the SKU has requiredQuotas parameter as the subscription does not belong to that
	// quota. The "NotAvailableForSubscription" is related to capacity at DC.
	ReasonCode *ReasonCode

	// READ-ONLY; The type of restrictions. As of now only possible value for this is location.
	Type *string

	// READ-ONLY; The value of restrictions. If the restriction type is set to location. This would be different locations where
	// the SKU is restricted.
	Values []*string
}

// RoutingPreference - Routing preference defines the type of network, either microsoft or internet routing to be used to
// deliver the user data, the default option is microsoft routing
type RoutingPreference struct {
	// A boolean flag which indicates whether internet routing storage endpoints are to be published
	PublishInternetEndpoints *bool

	// A boolean flag which indicates whether microsoft routing storage endpoints are to be published
	PublishMicrosoftEndpoints *bool

	// Routing Choice defines the kind of network routing opted by the user.
	RoutingChoice *RoutingChoice
}

// SKU - The SKU of the storage account.
type SKU struct {
	// REQUIRED; The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called
	// accountType.
	Name *SKUName

	// READ-ONLY; The SKU tier. This is based on the SKU name.
	Tier *SKUTier
}

// SKUCapability - The capability information in the specified SKU, including file encryption, network ACLs, change notification,
// etc.
type SKUCapability struct {
	// READ-ONLY; The name of capability, The capability information in the specified SKU, including file encryption, network
	// ACLs, change notification, etc.
	Name *string

	// READ-ONLY; A string value to indicate states of given capability. Possibly 'true' or 'false'.
	Value *string
}

// SKUInformation - Storage SKU and its properties
type SKUInformation struct {
	// REQUIRED; The SKU name. Required for account creation; optional for update. Note that in older versions, SKU name was called
	// accountType.
	Name *SKUName

	// The restrictions because of which SKU cannot be used. This is empty if there are no restrictions.
	Restrictions []*Restriction

	// READ-ONLY; The capability information in the specified SKU, including file encryption, network ACLs, change notification,
	// etc.
	Capabilities []*SKUCapability

	// READ-ONLY; Indicates the type of storage account.
	Kind *Kind

	// READ-ONLY; The set of locations that the SKU is available. This will be supported and registered Azure Geo Regions (e.g.
	// West US, East US, Southeast Asia, etc.).
	Locations []*string

	// READ-ONLY; The type of the resource, usually it is 'storageAccounts'.
	ResourceType *string

	// READ-ONLY; The SKU tier. This is based on the SKU name.
	Tier *SKUTier
}

// SKUListResult - The response from the List Storage SKUs operation.
type SKUListResult struct {
	// READ-ONLY; Get the list result of storage SKUs and their properties.
	Value []*SKUInformation
}

type SSHPublicKey struct {
	// Optional. It is used to store the function/usage of the key
	Description *string

	// Ssh public key base64 encoded. The format should be: ' ', e.g. ssh-rsa AAAABBBB
	Key *string
}

// SasPolicy assigned to the storage account.
type SasPolicy struct {
	// REQUIRED; The SAS expiration action. Can only be Log.
	ExpirationAction *ExpirationAction

	// REQUIRED; The SAS expiration period, DD.HH:MM:SS.
	SasExpirationPeriod *string
}

// ServiceSasParameters - The parameters to list service SAS credentials of a specific resource.
type ServiceSasParameters struct {
	// REQUIRED; The canonical path to the signed resource.
	CanonicalizedResource *string

	// The response header override for cache control.
	CacheControl *string

	// The response header override for content disposition.
	ContentDisposition *string

	// The response header override for content encoding.
	ContentEncoding *string

	// The response header override for content language.
	ContentLanguage *string

	// The response header override for content type.
	ContentType *string

	// An IP address or a range of IP addresses from which to accept requests.
	IPAddressOrRange *string

	// A unique value up to 64 characters in length that correlates to an access policy specified for the container, queue, or
	// table.
	Identifier *string

	// The key to sign the account SAS token with.
	KeyToSign *string

	// The end of partition key.
	PartitionKeyEnd *string

	// The start of partition key.
	PartitionKeyStart *string

	// The signed permissions for the service SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a),
	// Create (c), Update (u) and Process (p).
	Permissions *Permissions

	// The protocol permitted for a request made with the account SAS.
	Protocols *HTTPProtocol

	// The signed services accessible with the service SAS. Possible values include: Blob (b), Container (c), File (f), Share
	// (s).
	Resource *SignedResource

	// The end of row key.
	RowKeyEnd *string

	// The start of row key.
	RowKeyStart *string

	// The time at which the shared access signature becomes invalid.
	SharedAccessExpiryTime *time.Time

	// The time at which the SAS becomes valid.
	SharedAccessStartTime *time.Time
}

// ServiceSpecification - One property of operation, include metric specifications.
type ServiceSpecification struct {
	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification
}

type SignedIdentifier struct {
	// Access policy
	AccessPolicy *AccessPolicy

	// An unique identifier of the stored access policy.
	ID *string
}

// SmbSetting - Setting for SMB protocol
type SmbSetting struct {
	// SMB authentication methods supported by server. Valid values are NTLMv2, Kerberos. Should be passed as a string with delimiter
	// ';'.
	AuthenticationMethods *string

	// SMB channel encryption supported by server. Valid values are AES-128-CCM, AES-128-GCM, AES-256-GCM. Should be passed as
	// a string with delimiter ';'.
	ChannelEncryption *string

	// Kerberos ticket encryption supported by server. Valid values are RC4-HMAC, AES-256. Should be passed as a string with delimiter
	// ';'
	KerberosTicketEncryption *string

	// Multichannel setting. Applies to Premium FileStorage only.
	Multichannel *Multichannel

	// SMB protocol versions supported by server. Valid values are SMB2.1, SMB3.0, SMB3.1.1. Should be passed as a string with
	// delimiter ';'.
	Versions *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// Table - Properties of the table, including Id, resource name, resource type.
type Table struct {
	// Table resource properties.
	TableProperties *TableProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TableAccessPolicy - Table Access Policy Properties Object.
type TableAccessPolicy struct {
	// REQUIRED; Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
	Permission *string

	// Expiry time of the access policy
	ExpiryTime *time.Time

	// Start time of the access policy
	StartTime *time.Time
}

type TableProperties struct {
	// List of stored access policies specified on the table.
	SignedIdentifiers []*TableSignedIdentifier

	// READ-ONLY; Table name under the specified account
	TableName *string
}

// TableServiceProperties - The properties of a storage account’s Table service.
type TableServiceProperties struct {
	// The properties of a storage account’s Table service.
	TableServiceProperties *TableServicePropertiesProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TableServicePropertiesProperties - The properties of a storage account’s Table service.
type TableServicePropertiesProperties struct {
	// Specifies CORS rules for the Table service. You can include up to five CorsRule elements in the request. If no CorsRule
	// elements are included in the request body, all CORS rules will be deleted, and
	// CORS will be disabled for the Table service.
	Cors *CorsRules
}

// TableSignedIdentifier - Object to set Table Access Policy.
type TableSignedIdentifier struct {
	// REQUIRED; unique-64-character-value of the stored access policy.
	ID *string

	// Access policy
	AccessPolicy *TableAccessPolicy
}

// TagFilter - Blob index tag based filtering for blob objects
type TagFilter struct {
	// REQUIRED; This is the filter tag name, it can have 1 - 128 characters
	Name *string

	// REQUIRED; This is the comparison operator which is used for object comparison and filtering. Only == (equality operator)
	// is currently supported
	Op *string

	// REQUIRED; This is the filter tag value field used for tag based filtering, it can have 0 - 256 characters
	Value *string
}

// TagProperty - A tag of the LegalHold of a blob container.
type TagProperty struct {
	// READ-ONLY; Returns the Object ID of the user who added the tag.
	ObjectIdentifier *string

	// READ-ONLY; The tag value.
	Tag *string

	// READ-ONLY; Returns the Tenant ID that issued the token for the user who added the tag.
	TenantID *string

	// READ-ONLY; Returns the date and time the tag was added.
	Timestamp *time.Time

	// READ-ONLY; Returns the User Principal Name of the user who added the tag.
	Upn *string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UpdateHistoryProperty - An update history of the ImmutabilityPolicy of a blob container.
type UpdateHistoryProperty struct {
	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// an append blob while maintaining immutability protection and compliance. Only
	// new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be changed with ExtendImmutabilityPolicy
	// API.
	AllowProtectedAppendWrites *bool

	// This property can only be changed for unlocked time-based retention policies. When enabled, new blocks can be written to
	// both 'Append and Bock Blobs' while maintaining immutability protection and
	// compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. This property cannot be
	// changed with ExtendImmutabilityPolicy API. The 'allowProtectedAppendWrites' and
	// 'allowProtectedAppendWritesAll' properties are mutually exclusive.
	AllowProtectedAppendWritesAll *bool

	// READ-ONLY; The immutability period for the blobs in the container since the policy creation, in days.
	ImmutabilityPeriodSinceCreationInDays *int32

	// READ-ONLY; Returns the Object ID of the user who updated the ImmutabilityPolicy.
	ObjectIdentifier *string

	// READ-ONLY; Returns the Tenant ID that issued the token for the user who updated the ImmutabilityPolicy.
	TenantID *string

	// READ-ONLY; Returns the date and time the ImmutabilityPolicy was updated.
	Timestamp *time.Time

	// READ-ONLY; The ImmutabilityPolicy update type of a blob container, possible values include: put, lock and extend.
	Update *ImmutabilityPolicyUpdateType

	// READ-ONLY; Returns the User Principal Name of the user who updated the ImmutabilityPolicy.
	Upn *string
}

// Usage - Describes Storage Resource Usage.
type Usage struct {
	// READ-ONLY; Gets the current count of the allocated resources in the subscription.
	CurrentValue *int32

	// READ-ONLY; Gets the maximum count of the resources that can be allocated in the subscription.
	Limit *int32

	// READ-ONLY; Gets the name of the type of usage.
	Name *UsageName

	// READ-ONLY; Gets the unit of measurement.
	Unit *UsageUnit
}

// UsageListResult - The response from the List Usages operation.
type UsageListResult struct {
	// Gets or sets the list of Storage Resource Usages.
	Value []*Usage
}

// UsageName - The usage names that can be used; currently limited to StorageAccount.
type UsageName struct {
	// READ-ONLY; Gets a localized string describing the resource name.
	LocalizedValue *string

	// READ-ONLY; Gets a string describing the resource name.
	Value *string
}

// UserAssignedIdentity for the resource.
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the identity.
	ClientID *string

	// READ-ONLY; The principal ID of the identity.
	PrincipalID *string
}

// VirtualNetworkRule - Virtual Network rule.
type VirtualNetworkRule struct {
	// REQUIRED; Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string

	// The action of virtual network rule.
	Action *string

	// Gets the state of virtual network rule.
	State *State
}
