//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseVulnerabilityAssessmentScansServer is a fake server for instances of the armsql.DatabaseVulnerabilityAssessmentScansClient type.
type DatabaseVulnerabilityAssessmentScansServer struct {
	// Export is the fake for method DatabaseVulnerabilityAssessmentScansClient.Export
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Export func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.DatabaseVulnerabilityAssessmentScansClientExportOptions) (resp azfake.Responder[armsql.DatabaseVulnerabilityAssessmentScansClientExportResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DatabaseVulnerabilityAssessmentScansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.DatabaseVulnerabilityAssessmentScansClientGetOptions) (resp azfake.Responder[armsql.DatabaseVulnerabilityAssessmentScansClientGetResponse], errResp azfake.ErrorResponder)

	// BeginInitiateScan is the fake for method DatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginInitiateScan func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.DatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (resp azfake.PollerResponder[armsql.DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method DatabaseVulnerabilityAssessmentScansClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.DatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse])
}

// NewDatabaseVulnerabilityAssessmentScansServerTransport creates a new instance of DatabaseVulnerabilityAssessmentScansServerTransport with the provided implementation.
// The returned DatabaseVulnerabilityAssessmentScansServerTransport instance is connected to an instance of armsql.DatabaseVulnerabilityAssessmentScansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseVulnerabilityAssessmentScansServerTransport(srv *DatabaseVulnerabilityAssessmentScansServer) *DatabaseVulnerabilityAssessmentScansServerTransport {
	return &DatabaseVulnerabilityAssessmentScansServerTransport{
		srv:                    srv,
		beginInitiateScan:      newTracker[azfake.PollerResponder[armsql.DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse]](),
		newListByDatabasePager: newTracker[azfake.PagerResponder[armsql.DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse]](),
	}
}

// DatabaseVulnerabilityAssessmentScansServerTransport connects instances of armsql.DatabaseVulnerabilityAssessmentScansClient to instances of DatabaseVulnerabilityAssessmentScansServer.
// Don't use this type directly, use NewDatabaseVulnerabilityAssessmentScansServerTransport instead.
type DatabaseVulnerabilityAssessmentScansServerTransport struct {
	srv                    *DatabaseVulnerabilityAssessmentScansServer
	beginInitiateScan      *tracker[azfake.PollerResponder[armsql.DatabaseVulnerabilityAssessmentScansClientInitiateScanResponse]]
	newListByDatabasePager *tracker[azfake.PagerResponder[armsql.DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse]]
}

// Do implements the policy.Transporter interface for DatabaseVulnerabilityAssessmentScansServerTransport.
func (d *DatabaseVulnerabilityAssessmentScansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseVulnerabilityAssessmentScansClient.Export":
		resp, err = d.dispatchExport(req)
	case "DatabaseVulnerabilityAssessmentScansClient.Get":
		resp, err = d.dispatchGet(req)
	case "DatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan":
		resp, err = d.dispatchBeginInitiateScan(req)
	case "DatabaseVulnerabilityAssessmentScansClient.NewListByDatabasePager":
		resp, err = d.dispatchNewListByDatabasePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseVulnerabilityAssessmentScansServerTransport) dispatchExport(req *http.Request) (*http.Response, error) {
	if d.srv.Export == nil {
		return nil, &nonRetriableError{errors.New("fake for method Export not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/export`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Export(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseVulnerabilityAssessmentScansExport, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseVulnerabilityAssessmentScansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VulnerabilityAssessmentScanRecord, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseVulnerabilityAssessmentScansServerTransport) dispatchBeginInitiateScan(req *http.Request) (*http.Response, error) {
	if d.srv.BeginInitiateScan == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInitiateScan not implemented")}
	}
	beginInitiateScan := d.beginInitiateScan.get(req)
	if beginInitiateScan == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/initiateScan`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginInitiateScan(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInitiateScan = &respr
		d.beginInitiateScan.add(req, beginInitiateScan)
	}

	resp, err := server.PollerResponderNext(beginInitiateScan, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginInitiateScan.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInitiateScan) {
		d.beginInitiateScan.remove(req)
	}

	return resp, nil
}

func (d *DatabaseVulnerabilityAssessmentScansServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := d.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByDatabasePager(resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, nil)
		newListByDatabasePager = &resp
		d.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.DatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		d.newListByDatabasePager.remove(req)
	}
	return resp, nil
}
