//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DiagnosticsServer is a fake server for instances of the armselfhelp.DiagnosticsClient type.
type DiagnosticsServer struct {
	// BeginCreate is the fake for method DiagnosticsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, scope string, diagnosticsResourceName string, diagnosticResourceRequest armselfhelp.DiagnosticResource, options *armselfhelp.DiagnosticsClientBeginCreateOptions) (resp azfake.PollerResponder[armselfhelp.DiagnosticsClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DiagnosticsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, diagnosticsResourceName string, options *armselfhelp.DiagnosticsClientGetOptions) (resp azfake.Responder[armselfhelp.DiagnosticsClientGetResponse], errResp azfake.ErrorResponder)
}

// NewDiagnosticsServerTransport creates a new instance of DiagnosticsServerTransport with the provided implementation.
// The returned DiagnosticsServerTransport instance is connected to an instance of armselfhelp.DiagnosticsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiagnosticsServerTransport(srv *DiagnosticsServer) *DiagnosticsServerTransport {
	return &DiagnosticsServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armselfhelp.DiagnosticsClientCreateResponse]](),
	}
}

// DiagnosticsServerTransport connects instances of armselfhelp.DiagnosticsClient to instances of DiagnosticsServer.
// Don't use this type directly, use NewDiagnosticsServerTransport instead.
type DiagnosticsServerTransport struct {
	srv         *DiagnosticsServer
	beginCreate *tracker[azfake.PollerResponder[armselfhelp.DiagnosticsClientCreateResponse]]
}

// Do implements the policy.Transporter interface for DiagnosticsServerTransport.
func (d *DiagnosticsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiagnosticsClient.BeginCreate":
		resp, err = d.dispatchBeginCreate(req)
	case "DiagnosticsClient.Get":
		resp, err = d.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := d.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/diagnostics/(?P<diagnosticsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armselfhelp.DiagnosticResource](req)
		if err != nil {
			return nil, err
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		diagnosticsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticsResourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreate(req.Context(), scopeParam, diagnosticsResourceNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		d.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		d.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		d.beginCreate.remove(req)
	}

	return resp, nil
}

func (d *DiagnosticsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/diagnostics/(?P<diagnosticsResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	diagnosticsResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("diagnosticsResourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), scopeParam, diagnosticsResourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DiagnosticResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
