//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurityinsights

import "time"

// AADDataConnector - Represents AAD (Azure Active Directory) data connector.
type AADDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// AAD (Azure Active Directory) data connector properties.
	Properties *AADDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type AADDataConnector.
func (a *AADDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       a.Etag,
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// AADDataConnectorProperties - AAD (Azure Active Directory) data connector properties.
type AADDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector

	// The tenant id to connect to, and get the data from.
	TenantID *string
}

// AATPDataConnector - Represents AATP (Azure Advanced Threat Protection) data connector.
type AATPDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// AATP (Azure Advanced Threat Protection) data connector properties.
	Properties *AATPDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type AATPDataConnector.
func (a *AATPDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       a.Etag,
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// AATPDataConnectorProperties - AATP (Azure Advanced Threat Protection) data connector properties.
type AATPDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector

	// The tenant id to connect to, and get the data from.
	TenantID *string
}

// ASCDataConnector - Represents ASC (Azure Security Center) data connector.
type ASCDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// ASC (Azure Security Center) data connector properties.
	Properties *ASCDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type ASCDataConnector.
func (a *ASCDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       a.Etag,
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ASCDataConnectorProperties - ASC (Azure Security Center) data connector properties.
type ASCDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector

	// The subscription id to connect to, and get the data from.
	SubscriptionID *string
}

// AccountEntity - Represents an account entity.
type AccountEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Account entity properties
	Properties *AccountEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type AccountEntity.
func (a *AccountEntity) GetEntity() *Entity {
	return &Entity{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// AccountEntityProperties - Account entity property bag.
type AccountEntityProperties struct {
	// READ-ONLY; The Azure Active Directory tenant id.
	AADTenantID *string

	// READ-ONLY; The Azure Active Directory user id.
	AADUserID *string

	// READ-ONLY; The name of the account. This field should hold only the name without any domain added to it, i.e. administrator.
	AccountName *string

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The fully qualified domain DNS name.
	DNSDomain *string

	// READ-ONLY; The display name of the account.
	DisplayName *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The Host entity id that contains the account in case it is a local account (not domain joined)
	HostEntityID *string

	// READ-ONLY; Determines whether this is a domain account.
	IsDomainJoined *bool

	// READ-ONLY; The NetBIOS domain name as it appears in the alert format - domain\username. Examples: NT AUTHORITY.
	NtDomain *string

	// READ-ONLY; The objectGUID attribute is a single-value attribute that is the unique identifier for the object, assigned
	// by active directory.
	ObjectGUID *string

	// READ-ONLY; The Azure Active Directory Passport User ID.
	Puid *string

	// READ-ONLY; The account security identifier, e.g. S-1-5-18.
	Sid *string

	// READ-ONLY; The user principal name suffix for the account, in some cases it is also the domain name. Examples: contoso.com.
	UpnSuffix *string
}

// ActionRequest - Action for alert rule.
type ActionRequest struct {
	// Etag of the azure resource
	Etag *string

	// Action properties for put request
	Properties *ActionRequestProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ActionRequestProperties - Action property bag.
type ActionRequestProperties struct {
	// REQUIRED; Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string

	// REQUIRED; Logic App Callback URL for this specific workflow.
	TriggerURI *string
}

// ActionResponse - Action for alert rule.
type ActionResponse struct {
	// Etag of the action.
	Etag *string

	// Action properties for get request
	Properties *ActionResponseProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ActionResponseProperties - Action property bag.
type ActionResponseProperties struct {
	// REQUIRED; Logic App Resource Id, /subscriptions/{my-subscription}/resourceGroups/{my-resource-group}/providers/Microsoft.Logic/workflows/{my-workflow-id}.
	LogicAppResourceID *string

	// The name of the logic app's workflow.
	WorkflowID *string
}

// ActionsList - List all the actions.
type ActionsList struct {
	// REQUIRED; Array of actions.
	Value []*ActionResponse

	// READ-ONLY; URL to fetch the next set of actions.
	NextLink *string
}

// AlertDetailsOverride - Settings for how to dynamically override alert static details
type AlertDetailsOverride struct {
	// the format containing columns name(s) to override the alert description
	AlertDescriptionFormat *string

	// the format containing columns name(s) to override the alert name
	AlertDisplayNameFormat *string

	// the column name to take the alert severity from
	AlertSeverityColumnName *string

	// the column name to take the alert tactics from
	AlertTacticsColumnName *string
}

// AlertRule - Alert rule.
type AlertRule struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// Etag of the azure resource
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRule implements the AlertRuleClassification interface for type AlertRule.
func (a *AlertRule) GetAlertRule() *AlertRule { return a }

// AlertRuleTemplate - Alert rule template.
type AlertRuleTemplate struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRuleTemplate implements the AlertRuleTemplateClassification interface for type AlertRuleTemplate.
func (a *AlertRuleTemplate) GetAlertRuleTemplate() *AlertRuleTemplate { return a }

// AlertRuleTemplateDataSource - alert rule template data sources
type AlertRuleTemplateDataSource struct {
	// The connector id that provides the following data types
	ConnectorID *string

	// The data types used by the alert rule template
	DataTypes []*string
}

// AlertRuleTemplatesList - List all the alert rule templates.
type AlertRuleTemplatesList struct {
	// REQUIRED; Array of alert rule templates.
	Value []AlertRuleTemplateClassification

	// READ-ONLY; URL to fetch the next set of alert rule templates.
	NextLink *string
}

// AlertRulesList - List all the alert rules.
type AlertRulesList struct {
	// REQUIRED; Array of alert rules.
	Value []AlertRuleClassification

	// READ-ONLY; URL to fetch the next set of alert rules.
	NextLink *string
}

// AlertsDataTypeOfDataConnector - Alerts data type for data connectors.
type AlertsDataTypeOfDataConnector struct {
	// Alerts data type connection.
	Alerts *DataConnectorDataTypeCommon
}

type AutomationRule struct {
	// REQUIRED; Automation rule properties
	Properties *AutomationRuleProperties

	// Etag of the azure resource
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AutomationRuleAction - Describes an automation rule action
type AutomationRuleAction struct {
	// REQUIRED; The type of the automation rule action
	ActionType *ActionType

	// REQUIRED
	Order *int32
}

// GetAutomationRuleAction implements the AutomationRuleActionClassification interface for type AutomationRuleAction.
func (a *AutomationRuleAction) GetAutomationRuleAction() *AutomationRuleAction { return a }

// AutomationRuleCondition - Describes an automation rule condition
type AutomationRuleCondition struct {
	// REQUIRED
	ConditionType *ConditionType
}

// GetAutomationRuleCondition implements the AutomationRuleConditionClassification interface for type AutomationRuleCondition.
func (a *AutomationRuleCondition) GetAutomationRuleCondition() *AutomationRuleCondition { return a }

// AutomationRuleModifyPropertiesAction - Describes an automation rule action to modify an object's properties.
type AutomationRuleModifyPropertiesAction struct {
	// REQUIRED; The type of the automation rule action
	ActionType *ActionType

	// REQUIRED
	Order               *int32
	ActionConfiguration *IncidentPropertiesAction
}

// GetAutomationRuleAction implements the AutomationRuleActionClassification interface for type AutomationRuleModifyPropertiesAction.
func (a *AutomationRuleModifyPropertiesAction) GetAutomationRuleAction() *AutomationRuleAction {
	return &AutomationRuleAction{
		ActionType: a.ActionType,
		Order:      a.Order,
	}
}

// AutomationRuleProperties - Automation rule properties
type AutomationRuleProperties struct {
	// REQUIRED; The actions to execute when the automation rule is triggered
	Actions []AutomationRuleActionClassification

	// REQUIRED; The display name of the automation rule
	DisplayName *string

	// REQUIRED; The order of execution of the automation rule
	Order *int32

	// REQUIRED; Describes automation rule triggering logic
	TriggeringLogic *AutomationRuleTriggeringLogic

	// READ-ONLY; Information on the client (user or application) that made some action
	CreatedBy *ClientInfo

	// READ-ONLY; The time the automation rule was created
	CreatedTimeUTC *time.Time

	// READ-ONLY; Information on the client (user or application) that made some action
	LastModifiedBy *ClientInfo

	// READ-ONLY; The last time the automation rule was updated
	LastModifiedTimeUTC *time.Time
}

type AutomationRulePropertyValuesCondition struct {
	Operator *AutomationRulePropertyConditionSupportedOperator

	// The property to evaluate in an automation rule property condition
	PropertyName   *AutomationRulePropertyConditionSupportedProperty
	PropertyValues []*string
}

// AutomationRuleRunPlaybookAction - Describes an automation rule action to run a playbook
type AutomationRuleRunPlaybookAction struct {
	// REQUIRED; The type of the automation rule action
	ActionType *ActionType

	// REQUIRED
	Order               *int32
	ActionConfiguration *PlaybookActionProperties
}

// GetAutomationRuleAction implements the AutomationRuleActionClassification interface for type AutomationRuleRunPlaybookAction.
func (a *AutomationRuleRunPlaybookAction) GetAutomationRuleAction() *AutomationRuleAction {
	return &AutomationRuleAction{
		ActionType: a.ActionType,
		Order:      a.Order,
	}
}

// AutomationRuleTriggeringLogic - Describes automation rule triggering logic
type AutomationRuleTriggeringLogic struct {
	// REQUIRED; Determines whether the automation rule is enabled or disabled
	IsEnabled *bool

	// REQUIRED
	TriggersOn *TriggersOn

	// REQUIRED
	TriggersWhen *TriggersWhen

	// The conditions to evaluate to determine if the automation rule should be triggered on a given object
	Conditions []AutomationRuleConditionClassification

	// Determines when the automation rule should automatically expire and be disabled.
	ExpirationTimeUTC *time.Time
}

type AutomationRulesList struct {
	NextLink *string
	Value    []*AutomationRule
}

// AwsCloudTrailDataConnector - Represents Amazon Web Services CloudTrail data connector.
type AwsCloudTrailDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// Amazon Web Services CloudTrail data connector properties.
	Properties *AwsCloudTrailDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type AwsCloudTrailDataConnector.
func (a *AwsCloudTrailDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       a.Etag,
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// AwsCloudTrailDataConnectorDataTypes - The available data types for Amazon Web Services CloudTrail data connector.
type AwsCloudTrailDataConnectorDataTypes struct {
	// Logs data type.
	Logs *AwsCloudTrailDataConnectorDataTypesLogs
}

// AwsCloudTrailDataConnectorDataTypesLogs - Logs data type.
type AwsCloudTrailDataConnectorDataTypesLogs struct {
	// Describe whether this data type connection is enabled or not.
	State *DataTypeState
}

// AwsCloudTrailDataConnectorProperties - Amazon Web Services CloudTrail data connector properties.
type AwsCloudTrailDataConnectorProperties struct {
	// The Aws Role Arn (with CloudTrailReadOnly policy) that is used to access the Aws account.
	AwsRoleArn *string

	// The available data types for the connector.
	DataTypes *AwsCloudTrailDataConnectorDataTypes
}

// AzureResourceEntity - Represents an azure resource entity.
type AzureResourceEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// AzureResource entity properties
	Properties *AzureResourceEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type AzureResourceEntity.
func (a *AzureResourceEntity) GetEntity() *Entity {
	return &Entity{
		ID:         a.ID,
		Kind:       a.Kind,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// AzureResourceEntityProperties - AzureResource entity property bag.
type AzureResourceEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The azure resource id of the resource
	ResourceID *string

	// READ-ONLY; The subscription id of the resource
	SubscriptionID *string
}

// Bookmark - Represents a bookmark in Azure Security Insights.
type Bookmark struct {
	// Etag of the azure resource
	Etag *string

	// Bookmark properties
	Properties *BookmarkProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BookmarkList - List all the bookmarks.
type BookmarkList struct {
	// REQUIRED; Array of bookmarks.
	Value []*Bookmark

	// READ-ONLY; URL to fetch the next set of cases.
	NextLink *string
}

// BookmarkProperties - Describes bookmark properties
type BookmarkProperties struct {
	// REQUIRED; The display name of the bookmark
	DisplayName *string

	// REQUIRED; The query of the bookmark.
	Query *string

	// The time the bookmark was created
	Created *time.Time

	// Describes a user that created the bookmark
	CreatedBy *UserInfo

	// The bookmark event time
	EventTime *time.Time

	// Describes an incident that relates to bookmark
	IncidentInfo *IncidentInfo

	// List of labels relevant to this bookmark
	Labels []*string

	// The notes of the bookmark
	Notes *string

	// The end time for the query
	QueryEndTime *time.Time

	// The query result of the bookmark.
	QueryResult *string

	// The start time for the query
	QueryStartTime *time.Time

	// The last time the bookmark was updated
	Updated *time.Time

	// Describes a user that updated the bookmark
	UpdatedBy *UserInfo
}

// ClientInfo - Information on the client (user or application) that made some action
type ClientInfo struct {
	// The email of the client.
	Email *string

	// The name of the client.
	Name *string

	// The object id of the client.
	ObjectID *string

	// The user principal name of the client.
	UserPrincipalName *string
}

// CloudApplicationEntity - Represents a cloud application entity.
type CloudApplicationEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// CloudApplication entity properties
	Properties *CloudApplicationEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type CloudApplicationEntity.
func (c *CloudApplicationEntity) GetEntity() *Entity {
	return &Entity{
		ID:         c.ID,
		Kind:       c.Kind,
		Name:       c.Name,
		SystemData: c.SystemData,
		Type:       c.Type,
	}
}

// CloudApplicationEntityProperties - CloudApplication entity property bag.
type CloudApplicationEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The technical identifier of the application.
	AppID *int32

	// READ-ONLY; The name of the related cloud application.
	AppName *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The user defined instance name of the cloud application. It is often used to distinguish between several applications
	// of the same type that a customer has.
	InstanceName *string
}

// DNSEntity - Represents a dns entity.
type DNSEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Dns entity properties
	Properties *DNSEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type DNSEntity.
func (d *DNSEntity) GetEntity() *Entity {
	return &Entity{
		ID:         d.ID,
		Kind:       d.Kind,
		Name:       d.Name,
		SystemData: d.SystemData,
		Type:       d.Type,
	}
}

// DNSEntityProperties - Dns entity property bag.
type DNSEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; An ip entity id for the dns server resolving the request
	DNSServerIPEntityID *string

	// READ-ONLY; The name of the dns record associated with the alert
	DomainName *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; An ip entity id for the dns request client
	HostIPAddressEntityID *string

	// READ-ONLY; Ip entity identifiers for the resolved ip address.
	IPAddressEntityIDs []*string
}

// DataConnector - Data connector.
type DataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type DataConnector.
func (d *DataConnector) GetDataConnector() *DataConnector { return d }

// DataConnectorDataTypeCommon - Common field for data type in data connectors.
type DataConnectorDataTypeCommon struct {
	// Describe whether this data type connection is enabled or not.
	State *DataTypeState
}

// DataConnectorList - List all the data connectors.
type DataConnectorList struct {
	// REQUIRED; Array of data connectors.
	Value []DataConnectorClassification

	// READ-ONLY; URL to fetch the next set of data connectors.
	NextLink *string
}

// Entity - Specific entity.
type Entity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type Entity.
func (e *Entity) GetEntity() *Entity { return e }

// EntityMapping - Single entity mapping for the alert rule
type EntityMapping struct {
	// The V3 type of the mapped entity
	EntityType *EntityMappingType

	// array of field mappings for the given entity mapping
	FieldMappings []*FieldMapping
}

// EventGroupingSettings - Event grouping settings property bag.
type EventGroupingSettings struct {
	// The event grouping aggregation kinds
	AggregationKind *EventGroupingAggregationKind
}

// FieldMapping - A single field mapping of the mapped entity
type FieldMapping struct {
	// the column name to be mapped to the identifier
	ColumnName *string

	// the V3 identifier of the entity
	Identifier *string
}

// FileEntity - Represents a file entity.
type FileEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// File entity properties
	Properties *FileEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type FileEntity.
func (f *FileEntity) GetEntity() *Entity {
	return &Entity{
		ID:         f.ID,
		Kind:       f.Kind,
		Name:       f.Name,
		SystemData: f.SystemData,
		Type:       f.Type,
	}
}

// FileEntityProperties - File entity property bag.
type FileEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The full path to the file.
	Directory *string

	// READ-ONLY; The file hash entity identifiers associated with this file
	FileHashEntityIDs []*string

	// READ-ONLY; The file name without path (some alerts might not include path).
	FileName *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The Host entity id which the file belongs to
	HostEntityID *string
}

// FileHashEntity - Represents a file hash entity.
type FileHashEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// FileHash entity properties
	Properties *FileHashEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type FileHashEntity.
func (f *FileHashEntity) GetEntity() *Entity {
	return &Entity{
		ID:         f.ID,
		Kind:       f.Kind,
		Name:       f.Name,
		SystemData: f.SystemData,
		Type:       f.Type,
	}
}

// FileHashEntityProperties - FileHash entity property bag.
type FileHashEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The hash algorithm type.
	Algorithm *FileHashAlgorithm

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The file hash value.
	HashValue *string
}

// FusionAlertRule - Represents Fusion alert rule.
type FusionAlertRule struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// Etag of the azure resource
	Etag *string

	// Fusion alert rule properties
	Properties *FusionAlertRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRule implements the AlertRuleClassification interface for type FusionAlertRule.
func (f *FusionAlertRule) GetAlertRule() *AlertRule {
	return &AlertRule{
		Etag:       f.Etag,
		ID:         f.ID,
		Kind:       f.Kind,
		Name:       f.Name,
		SystemData: f.SystemData,
		Type:       f.Type,
	}
}

// FusionAlertRuleProperties - Fusion alert rule base property bag.
type FusionAlertRuleProperties struct {
	// REQUIRED; The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string

	// REQUIRED; Determines whether this alert rule is enabled or disabled.
	Enabled *bool

	// READ-ONLY; The description of the alert rule.
	Description *string

	// READ-ONLY; The display name for alerts created by this alert rule.
	DisplayName *string

	// READ-ONLY; The last time that this alert has been modified.
	LastModifiedUTC *time.Time

	// READ-ONLY; The severity for alerts created by this alert rule.
	Severity *AlertSeverity

	// READ-ONLY; The tactics of the alert rule
	Tactics []*AttackTactic
}

// FusionAlertRuleTemplate - Represents Fusion alert rule template.
type FusionAlertRuleTemplate struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// Fusion alert rule template properties
	Properties *FusionAlertRuleTemplateProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRuleTemplate implements the AlertRuleTemplateClassification interface for type FusionAlertRuleTemplate.
func (f *FusionAlertRuleTemplate) GetAlertRuleTemplate() *AlertRuleTemplate {
	return &AlertRuleTemplate{
		ID:         f.ID,
		Kind:       f.Kind,
		Name:       f.Name,
		SystemData: f.SystemData,
		Type:       f.Type,
	}
}

// FusionAlertRuleTemplateProperties - Represents Fusion alert rule template properties
type FusionAlertRuleTemplateProperties struct {
	// the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32

	// The description of the alert rule template.
	Description *string

	// The display name for alert rule template.
	DisplayName *string

	// The required data connectors for this template
	RequiredDataConnectors []*AlertRuleTemplateDataSource

	// The severity for alerts created by this alert rule.
	Severity *AlertSeverity

	// The alert rule template status.
	Status *TemplateStatus

	// The tactics of the alert rule template
	Tactics []*AttackTactic

	// READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *time.Time

	// READ-ONLY; The time that this alert rule template was last updated.
	LastUpdatedDateUTC *time.Time
}

// GeoLocation - The geo-location context attached to the ip entity
type GeoLocation struct {
	// READ-ONLY; Autonomous System Number
	Asn *int32

	// READ-ONLY; City name
	City *string

	// READ-ONLY; The country code according to ISO 3166 format
	CountryCode *string

	// READ-ONLY; Country name according to ISO 3166 Alpha 2: the lowercase of the English Short Name
	CountryName *string

	// READ-ONLY; The longitude of the identified location, expressed as a floating point number with range of -180 to 180, with
	// positive numbers representing East and negative numbers representing West. Latitude and
	// longitude are derived from the city or postal code.
	Latitude *float64

	// READ-ONLY; The latitude of the identified location, expressed as a floating point number with range of - 90 to 90, with
	// positive numbers representing North and negative numbers representing South. Latitude and
	// longitude are derived from the city or postal code.
	Longitude *float64

	// READ-ONLY; State name
	State *string
}

// GroupingConfiguration - Grouping configuration property bag.
type GroupingConfiguration struct {
	// REQUIRED; Grouping enabled
	Enabled *bool

	// REQUIRED; Limit the group to alerts created within the lookback duration (in ISO 8601 duration format)
	LookbackDuration *string

	// REQUIRED; Grouping matching method. When method is Selected at least one of groupByEntities, groupByAlertDetails, groupByCustomDetails
	// must be provided and not empty.
	MatchingMethod *MatchingMethod

	// REQUIRED; Re-open closed matching incidents
	ReopenClosedIncident *bool

	// A list of alert details to group by (when matchingMethod is Selected)
	GroupByAlertDetails []*AlertDetail

	// A list of custom details keys to group by (when matchingMethod is Selected). Only keys defined in the current alert rule
	// may be used.
	GroupByCustomDetails []*string

	// A list of entity types to group by (when matchingMethod is Selected). Only entities defined in the current alert rule may
	// be used.
	GroupByEntities []*EntityMappingType
}

// HostEntity - Represents a host entity.
type HostEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Host entity properties
	Properties *HostEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type HostEntity.
func (h *HostEntity) GetEntity() *Entity {
	return &Entity{
		ID:         h.ID,
		Kind:       h.Kind,
		Name:       h.Name,
		SystemData: h.SystemData,
		Type:       h.Type,
	}
}

// HostEntityProperties - Host entity property bag.
type HostEntityProperties struct {
	// The operating system type.
	OSFamily *OSFamily

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The azure resource id of the VM.
	AzureID *string

	// READ-ONLY; The DNS domain that this host belongs to. Should contain the compete DNS suffix for the domain
	DNSDomain *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The hostname without the domain suffix.
	HostName *string

	// READ-ONLY; Determines whether this host belongs to a domain.
	IsDomainJoined *bool

	// READ-ONLY; The host name (pre-windows2000).
	NetBiosName *string

	// READ-ONLY; The NT domain that this host belongs to.
	NtDomain *string

	// READ-ONLY; A free text representation of the operating system. This field is meant to hold specific versions the are more
	// fine grained than OSFamily or future values not supported by OSFamily enumeration
	OSVersion *string

	// READ-ONLY; The OMS agent id, if the host has OMS agent installed.
	OmsAgentID *string
}

// HuntingBookmark - Represents a Hunting bookmark entity.
type HuntingBookmark struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// HuntingBookmark entity properties
	Properties *HuntingBookmarkProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type HuntingBookmark.
func (h *HuntingBookmark) GetEntity() *Entity {
	return &Entity{
		ID:         h.ID,
		Kind:       h.Kind,
		Name:       h.Name,
		SystemData: h.SystemData,
		Type:       h.Type,
	}
}

// HuntingBookmarkProperties - Describes bookmark properties
type HuntingBookmarkProperties struct {
	// REQUIRED; The display name of the bookmark
	DisplayName *string

	// REQUIRED; The query of the bookmark.
	Query *string

	// The time the bookmark was created
	Created *time.Time

	// Describes a user that created the bookmark
	CreatedBy *UserInfo

	// The time of the event
	EventTime *time.Time

	// Describes an incident that relates to bookmark
	IncidentInfo *IncidentInfo

	// List of labels relevant to this bookmark
	Labels []*string

	// The notes of the bookmark
	Notes *string

	// The query result of the bookmark.
	QueryResult *string

	// The last time the bookmark was updated
	Updated *time.Time

	// Describes a user that updated the bookmark
	UpdatedBy *UserInfo

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string
}

// IPEntity - Represents an ip entity.
type IPEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Ip entity properties
	Properties *IPEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type IPEntity.
func (i *IPEntity) GetEntity() *Entity {
	return &Entity{
		ID:         i.ID,
		Kind:       i.Kind,
		Name:       i.Name,
		SystemData: i.SystemData,
		Type:       i.Type,
	}
}

// IPEntityProperties - Ip entity property bag.
type IPEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The IP address as string, e.g. 127.0.0.1 (either in Ipv4 or Ipv6)
	Address *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The geo-location context attached to the ip entity
	Location *GeoLocation

	// READ-ONLY; A list of TI contexts attached to the ip entity.
	ThreatIntelligence []*ThreatIntelligence
}

// Incident - Represents an incident in Azure Security Insights.
type Incident struct {
	// Etag of the azure resource
	Etag *string

	// Incident properties
	Properties *IncidentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IncidentAdditionalData - Incident additional data property bag.
type IncidentAdditionalData struct {
	// READ-ONLY; List of product names of alerts in the incident
	AlertProductNames []*string

	// READ-ONLY; The number of alerts in the incident
	AlertsCount *int32

	// READ-ONLY; The number of bookmarks in the incident
	BookmarksCount *int32

	// READ-ONLY; The number of comments in the incident
	CommentsCount *int32

	// READ-ONLY; The tactics associated with incident
	Tactics []*AttackTactic
}

// IncidentAlertList - List of incident alerts.
type IncidentAlertList struct {
	// REQUIRED; Array of incident alerts.
	Value []*SecurityAlert
}

// IncidentBookmarkList - List of incident bookmarks.
type IncidentBookmarkList struct {
	// REQUIRED; Array of incident bookmarks.
	Value []*HuntingBookmark
}

// IncidentComment - Represents an incident comment
type IncidentComment struct {
	// Etag of the azure resource
	Etag *string

	// Incident comment properties
	Properties *IncidentCommentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IncidentCommentList - List of incident comments.
type IncidentCommentList struct {
	// REQUIRED; Array of comments.
	Value []*IncidentComment

	// READ-ONLY; URL to fetch the next set of comments.
	NextLink *string
}

// IncidentCommentProperties - Incident comment property bag.
type IncidentCommentProperties struct {
	// REQUIRED; The comment message
	Message *string

	// READ-ONLY; Describes the client that created the comment
	Author *ClientInfo

	// READ-ONLY; The time the comment was created
	CreatedTimeUTC *time.Time

	// READ-ONLY; The time the comment was updated
	LastModifiedTimeUTC *time.Time
}

// IncidentConfiguration - Incident Configuration property bag.
type IncidentConfiguration struct {
	// REQUIRED; Create incidents from alerts triggered by this analytics rule
	CreateIncident *bool

	// Set how the alerts that are triggered by this analytics rule, are grouped into incidents
	GroupingConfiguration *GroupingConfiguration
}

// IncidentEntitiesResponse - The incident related entities response.
type IncidentEntitiesResponse struct {
	// Array of the incident related entities.
	Entities []EntityClassification

	// The metadata from the incident related entities results.
	MetaData []*IncidentEntitiesResultsMetadata
}

// IncidentEntitiesResultsMetadata - Information of a specific aggregation in the incident related entities result.
type IncidentEntitiesResultsMetadata struct {
	// REQUIRED; Total number of aggregations of the given kind in the incident related entities result.
	Count *int32

	// REQUIRED; The kind of the aggregated entity.
	EntityKind *EntityKindEnum
}

// IncidentInfo - Describes related incident information for the bookmark
type IncidentInfo struct {
	// Incident Id
	IncidentID *string

	// Relation Name
	RelationName *string

	// The severity of the incident
	Severity *IncidentSeverity

	// The title of the incident
	Title *string
}

// IncidentLabel - Represents an incident label
type IncidentLabel struct {
	// REQUIRED; The name of the label
	LabelName *string

	// READ-ONLY; The type of the label
	LabelType *IncidentLabelType
}

// IncidentList - List all the incidents.
type IncidentList struct {
	// REQUIRED; Array of incidents.
	Value []*Incident

	// READ-ONLY; URL to fetch the next set of incidents.
	NextLink *string
}

// IncidentOwnerInfo - Information on the user an incident is assigned to
type IncidentOwnerInfo struct {
	// The name of the user the incident is assigned to.
	AssignedTo *string

	// The email of the user the incident is assigned to.
	Email *string

	// The object id of the user the incident is assigned to.
	ObjectID *string

	// The user principal name of the user the incident is assigned to.
	UserPrincipalName *string
}

// IncidentOwnerInfoAutoGenerated - Information on the user an incident is assigned to
type IncidentOwnerInfoAutoGenerated struct {
	// The name of the user the incident is assigned to.
	AssignedTo *string

	// The email of the user the incident is assigned to.
	Email *string

	// The object id of the user the incident is assigned to.
	ObjectID *string

	// The type of the owner the incident is assigned to.
	OwnerType *OwnerType

	// The user principal name of the user the incident is assigned to.
	UserPrincipalName *string
}

// IncidentProperties - Describes incident properties
type IncidentProperties struct {
	// REQUIRED; The severity of the incident
	Severity *IncidentSeverity

	// REQUIRED; The status of the incident
	Status *IncidentStatus

	// REQUIRED; The title of the incident
	Title *string

	// The reason the incident was closed
	Classification *IncidentClassification

	// Describes the reason the incident was closed
	ClassificationComment *string

	// The classification reason the incident was closed with
	ClassificationReason *IncidentClassificationReason

	// The description of the incident
	Description *string

	// The time of the first activity in the incident
	FirstActivityTimeUTC *time.Time

	// List of labels relevant to this incident
	Labels []*IncidentLabel

	// The time of the last activity in the incident
	LastActivityTimeUTC *time.Time

	// Describes a user that the incident is assigned to
	Owner *IncidentOwnerInfo

	// READ-ONLY; Additional data on the incident
	AdditionalData *IncidentAdditionalData

	// READ-ONLY; The time the incident was created
	CreatedTimeUTC *time.Time

	// READ-ONLY; A sequential number
	IncidentNumber *int32

	// READ-ONLY; The deep-link url to the incident in Azure portal
	IncidentURL *string

	// READ-ONLY; The last time the incident was updated
	LastModifiedTimeUTC *time.Time

	// READ-ONLY; List of resource ids of Analytic rules related to the incident
	RelatedAnalyticRuleIDs []*string
}

type IncidentPropertiesAction struct {
	// The reason the incident was closed
	Classification *IncidentClassification

	// Describes the reason the incident was closed
	ClassificationComment *string

	// The classification reason the incident was closed with
	ClassificationReason *IncidentClassificationReason

	// List of labels to add to the incident
	Labels []*IncidentLabel

	// Information on the user an incident is assigned to
	Owner *IncidentOwnerInfoAutoGenerated

	// The severity of the incident
	Severity *IncidentSeverity

	// The status of the incident
	Status *IncidentStatus
}

// IoTDeviceEntity - Represents an IoT device entity.
type IoTDeviceEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// IoTDevice entity properties
	Properties *IoTDeviceEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type IoTDeviceEntity.
func (i *IoTDeviceEntity) GetEntity() *Entity {
	return &Entity{
		ID:         i.ID,
		Kind:       i.Kind,
		Name:       i.Name,
		SystemData: i.SystemData,
		Type:       i.Type,
	}
}

// IoTDeviceEntityProperties - IoTDevice entity property bag.
type IoTDeviceEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The ID of the IoT Device in the IoT Hub
	DeviceID *string

	// READ-ONLY; The friendly name of the device
	DeviceName *string

	// READ-ONLY; The type of the device
	DeviceType *string

	// READ-ONLY; The ID of the edge device
	EdgeID *string

	// READ-ONLY; The firmware version of the device
	FirmwareVersion *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The Host entity id of this device
	HostEntityID *string

	// READ-ONLY; The IP entity if of this device
	IPAddressEntityID *string

	// READ-ONLY; The AzureResource entity id of the IoT Hub
	IotHubEntityID *string

	// READ-ONLY; The ID of the security agent running on the device
	IotSecurityAgentID *string

	// READ-ONLY; The MAC address of the device
	MacAddress *string

	// READ-ONLY; The model of the device
	Model *string

	// READ-ONLY; The operating system of the device
	OperatingSystem *string

	// READ-ONLY; A list of protocols of the IoTDevice entity.
	Protocols []*string

	// READ-ONLY; The serial number of the device
	SerialNumber *string

	// READ-ONLY; The source of the device
	Source *string

	// READ-ONLY; A list of TI contexts attached to the IoTDevice entity.
	ThreatIntelligence []*ThreatIntelligence

	// READ-ONLY; The vendor of the device
	Vendor *string
}

// MCASDataConnector - Represents MCAS (Microsoft Cloud App Security) data connector.
type MCASDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// MCAS (Microsoft Cloud App Security) data connector properties.
	Properties *MCASDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type MCASDataConnector.
func (m *MCASDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       m.Etag,
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MCASDataConnectorDataTypes - The available data types for MCAS (Microsoft Cloud App Security) data connector.
type MCASDataConnectorDataTypes struct {
	// Alerts data type connection.
	Alerts *DataConnectorDataTypeCommon

	// Discovery log data type connection.
	DiscoveryLogs *DataConnectorDataTypeCommon
}

// MCASDataConnectorProperties - MCAS (Microsoft Cloud App Security) data connector properties.
type MCASDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *MCASDataConnectorDataTypes

	// The tenant id to connect to, and get the data from.
	TenantID *string
}

// MDATPDataConnector - Represents MDATP (Microsoft Defender Advanced Threat Protection) data connector.
type MDATPDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.
	Properties *MDATPDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type MDATPDataConnector.
func (m *MDATPDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       m.Etag,
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MDATPDataConnectorProperties - MDATP (Microsoft Defender Advanced Threat Protection) data connector properties.
type MDATPDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *AlertsDataTypeOfDataConnector

	// The tenant id to connect to, and get the data from.
	TenantID *string
}

// MailClusterEntity - Represents a mail cluster entity.
type MailClusterEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Mail cluster entity properties
	Properties *MailClusterEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type MailClusterEntity.
func (m *MailClusterEntity) GetEntity() *Entity {
	return &Entity{
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MailClusterEntityProperties - Mail cluster entity property bag.
type MailClusterEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The cluster group
	ClusterGroup *string

	// READ-ONLY; The cluster query end time
	ClusterQueryEndTime *time.Time

	// READ-ONLY; The cluster query start time
	ClusterQueryStartTime *time.Time

	// READ-ONLY; The id of the cluster source
	ClusterSourceIdentifier *string

	// READ-ONLY; The type of the cluster source
	ClusterSourceType *string

	// READ-ONLY; Count of mail messages by DeliveryStatus string representation
	CountByDeliveryStatus any

	// READ-ONLY; Count of mail messages by ProtectionStatus string representation
	CountByProtectionStatus any

	// READ-ONLY; Count of mail messages by ThreatType string representation
	CountByThreatType any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; Is this a volume anomaly mail cluster
	IsVolumeAnomaly *bool

	// READ-ONLY; The number of mail messages that are part of the mail cluster
	MailCount *int32

	// READ-ONLY; The mail message IDs that are part of the mail cluster
	NetworkMessageIDs []*string

	// READ-ONLY; The query that was used to identify the messages of the mail cluster
	Query *string

	// READ-ONLY; The query time
	QueryTime *time.Time

	// READ-ONLY; The source of the mail cluster (default is 'O365 ATP')
	Source *string

	// READ-ONLY; The threats of mail messages that are part of the mail cluster
	Threats []*string
}

// MailMessageEntity - Represents a mail message entity.
type MailMessageEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Mail message entity properties
	Properties *MailMessageEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type MailMessageEntity.
func (m *MailMessageEntity) GetEntity() *Entity {
	return &Entity{
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MailMessageEntityProperties - Mail message entity property bag.
type MailMessageEntityProperties struct {
	// The directionality of this mail message
	AntispamDirection *AntispamMailDirection

	// The bodyFingerprintBin1
	BodyFingerprintBin1 *int32

	// The bodyFingerprintBin2
	BodyFingerprintBin2 *int32

	// The bodyFingerprintBin3
	BodyFingerprintBin3 *int32

	// The bodyFingerprintBin4
	BodyFingerprintBin4 *int32

	// The bodyFingerprintBin5
	BodyFingerprintBin5 *int32

	// The delivery action of this mail message like Delivered, Blocked, Replaced etc
	DeliveryAction *DeliveryAction

	// The delivery location of this mail message like Inbox, JunkFolder etc
	DeliveryLocation *DeliveryLocation

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The File entity ids of this mail message's attachments
	FileEntityIDs []*string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The internet message id of this mail message
	InternetMessageID *string

	// READ-ONLY; The language of this mail message
	Language *string

	// READ-ONLY; The network message id of this mail message
	NetworkMessageID *string

	// READ-ONLY; The p1 sender's email address
	P1Sender *string

	// READ-ONLY; The p1 sender's display name
	P1SenderDisplayName *string

	// READ-ONLY; The p1 sender's domain
	P1SenderDomain *string

	// READ-ONLY; The p2 sender's email address
	P2Sender *string

	// READ-ONLY; The p2 sender's display name
	P2SenderDisplayName *string

	// READ-ONLY; The p2 sender's domain
	P2SenderDomain *string

	// READ-ONLY; The receive date of this message
	ReceiveDate *time.Time

	// READ-ONLY; The recipient of this mail message. Note that in case of multiple recipients the mail message is forked and
	// each copy has one recipient
	Recipient *string

	// READ-ONLY; The sender's IP address
	SenderIP *string

	// READ-ONLY; The subject of this mail message
	Subject *string

	// READ-ONLY; The threat detection methods
	ThreatDetectionMethods []*string

	// READ-ONLY; The threats of this mail message
	Threats []*string

	// READ-ONLY; The Urls contained in this mail message
	Urls []*string
}

// MailboxEntity - Represents a mailbox entity.
type MailboxEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Mailbox entity properties
	Properties *MailboxEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type MailboxEntity.
func (m *MailboxEntity) GetEntity() *Entity {
	return &Entity{
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MailboxEntityProperties - Mailbox entity property bag.
type MailboxEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The mailbox's display name
	DisplayName *string

	// READ-ONLY; The AzureAD identifier of mailbox. Similar to AadUserId in account entity but this property is specific to mailbox
	// object on office side
	ExternalDirectoryObjectID *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The mailbox's primary address
	MailboxPrimaryAddress *string

	// READ-ONLY; The mailbox's UPN
	Upn *string
}

// MalwareEntity - Represents a malware entity.
type MalwareEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// File entity properties
	Properties *MalwareEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type MalwareEntity.
func (m *MalwareEntity) GetEntity() *Entity {
	return &Entity{
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MalwareEntityProperties - Malware entity property bag.
type MalwareEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The malware category by the vendor, e.g. Trojan
	Category *string

	// READ-ONLY; List of linked file entity identifiers on which the malware was found
	FileEntityIDs []*string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The malware name by the vendor, e.g. Win32/Toga!rfn
	MalwareName *string

	// READ-ONLY; List of linked process entity identifiers on which the malware was found.
	ProcessEntityIDs []*string
}

// MicrosoftSecurityIncidentCreationAlertRule - Represents MicrosoftSecurityIncidentCreation rule.
type MicrosoftSecurityIncidentCreationAlertRule struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// Etag of the azure resource
	Etag *string

	// MicrosoftSecurityIncidentCreation rule properties
	Properties *MicrosoftSecurityIncidentCreationAlertRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRule implements the AlertRuleClassification interface for type MicrosoftSecurityIncidentCreationAlertRule.
func (m *MicrosoftSecurityIncidentCreationAlertRule) GetAlertRule() *AlertRule {
	return &AlertRule{
		Etag:       m.Etag,
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MicrosoftSecurityIncidentCreationAlertRuleProperties - MicrosoftSecurityIncidentCreation rule property bag.
type MicrosoftSecurityIncidentCreationAlertRuleProperties struct {
	// REQUIRED; The display name for alerts created by this alert rule.
	DisplayName *string

	// REQUIRED; Determines whether this alert rule is enabled or disabled.
	Enabled *bool

	// REQUIRED; The alerts' productName on which the cases will be generated
	ProductFilter *MicrosoftSecurityProductName

	// The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string

	// The description of the alert rule.
	Description *string

	// the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter []*string

	// the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter []*string

	// the alerts' severities on which the cases will be generated
	SeveritiesFilter []*AlertSeverity

	// READ-ONLY; The last time that this alert has been modified.
	LastModifiedUTC *time.Time
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplate - Represents MicrosoftSecurityIncidentCreation rule template.
type MicrosoftSecurityIncidentCreationAlertRuleTemplate struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// MicrosoftSecurityIncidentCreation rule template properties
	Properties *MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRuleTemplate implements the AlertRuleTemplateClassification interface for type MicrosoftSecurityIncidentCreationAlertRuleTemplate.
func (m *MicrosoftSecurityIncidentCreationAlertRuleTemplate) GetAlertRuleTemplate() *AlertRuleTemplate {
	return &AlertRuleTemplate{
		ID:         m.ID,
		Kind:       m.Kind,
		Name:       m.Name,
		SystemData: m.SystemData,
		Type:       m.Type,
	}
}

// MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties - MicrosoftSecurityIncidentCreation rule template properties
type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties struct {
	// REQUIRED; The alerts' productName on which the cases will be generated
	ProductFilter *MicrosoftSecurityProductName

	// the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32

	// The description of the alert rule template.
	Description *string

	// The display name for alert rule template.
	DisplayName *string

	// the alerts' displayNames on which the cases will not be generated
	DisplayNamesExcludeFilter []*string

	// the alerts' displayNames on which the cases will be generated
	DisplayNamesFilter []*string

	// The required data connectors for this template
	RequiredDataConnectors []*AlertRuleTemplateDataSource

	// the alerts' severities on which the cases will be generated
	SeveritiesFilter []*AlertSeverity

	// The alert rule template status.
	Status *TemplateStatus

	// READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *time.Time

	// READ-ONLY; The time that this alert rule template was last updated.
	LastUpdatedDateUTC *time.Time
}

// OfficeDataConnector - Represents office data connector.
type OfficeDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// Office data connector properties.
	Properties *OfficeDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type OfficeDataConnector.
func (o *OfficeDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       o.Etag,
		ID:         o.ID,
		Kind:       o.Kind,
		Name:       o.Name,
		SystemData: o.SystemData,
		Type:       o.Type,
	}
}

// OfficeDataConnectorDataTypes - The available data types for office data connector.
type OfficeDataConnectorDataTypes struct {
	// Exchange data type connection.
	Exchange *OfficeDataConnectorDataTypesExchange

	// SharePoint data type connection.
	SharePoint *OfficeDataConnectorDataTypesSharePoint

	// Teams data type connection.
	Teams *OfficeDataConnectorDataTypesTeams
}

// OfficeDataConnectorDataTypesExchange - Exchange data type connection.
type OfficeDataConnectorDataTypesExchange struct {
	// Describe whether this data type connection is enabled or not.
	State *DataTypeState
}

// OfficeDataConnectorDataTypesSharePoint - SharePoint data type connection.
type OfficeDataConnectorDataTypesSharePoint struct {
	// Describe whether this data type connection is enabled or not.
	State *DataTypeState
}

// OfficeDataConnectorDataTypesTeams - Teams data type connection.
type OfficeDataConnectorDataTypesTeams struct {
	// Describe whether this data type connection is enabled or not.
	State *DataTypeState
}

// OfficeDataConnectorProperties - Office data connector properties.
type OfficeDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *OfficeDataConnectorDataTypes

	// The tenant id to connect to, and get the data from.
	TenantID *string
}

// Operation provided by provider
type Operation struct {
	// Properties of the operation
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Name of the operation
	Name *string

	// The origin of the operation
	Origin *string
}

// OperationDisplay - Properties of the operation
type OperationDisplay struct {
	// Description of the operation
	Description *string

	// Operation name
	Operation *string

	// Provider name
	Provider *string

	// Resource name
	Resource *string
}

// OperationsList - Lists the operations available in the SecurityInsights RP.
type OperationsList struct {
	// REQUIRED; Array of operations
	Value []*Operation

	// READ-ONLY; URL to fetch the next set of operations.
	NextLink *string
}

type PlaybookActionProperties struct {
	// REQUIRED; The resource id of the playbook resource
	LogicAppResourceID *string

	// The tenant id of the playbook resource
	TenantID *string
}

// ProcessEntity - Represents a process entity.
type ProcessEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Process entity properties
	Properties *ProcessEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type ProcessEntity.
func (p *ProcessEntity) GetEntity() *Entity {
	return &Entity{
		ID:         p.ID,
		Kind:       p.Kind,
		Name:       p.Name,
		SystemData: p.SystemData,
		Type:       p.Type,
	}
}

// ProcessEntityProperties - Process entity property bag.
type ProcessEntityProperties struct {
	// The elevation token associated with the process.
	ElevationToken *ElevationToken

	// READ-ONLY; The account entity id running the processes.
	AccountEntityID *string

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The command line used to create the process
	CommandLine *string

	// READ-ONLY; The time when the process started to run
	CreationTimeUTC *time.Time

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The host entity id on which the process was running
	HostEntityID *string

	// READ-ONLY; The session entity id in which the process was running
	HostLogonSessionEntityID *string

	// READ-ONLY; Image file entity id
	ImageFileEntityID *string

	// READ-ONLY; The parent process entity id.
	ParentProcessEntityID *string

	// READ-ONLY; The process ID
	ProcessID *string
}

// PropertyConditionProperties - Describes an automation rule condition that evaluates a property's value
type PropertyConditionProperties struct {
	// REQUIRED
	ConditionType       *ConditionType
	ConditionProperties *AutomationRulePropertyValuesCondition
}

// GetAutomationRuleCondition implements the AutomationRuleConditionClassification interface for type PropertyConditionProperties.
func (p *PropertyConditionProperties) GetAutomationRuleCondition() *AutomationRuleCondition {
	return &AutomationRuleCondition{
		ConditionType: p.ConditionType,
	}
}

// RegistryKeyEntity - Represents a registry key entity.
type RegistryKeyEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// RegistryKey entity properties
	Properties *RegistryKeyEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type RegistryKeyEntity.
func (r *RegistryKeyEntity) GetEntity() *Entity {
	return &Entity{
		ID:         r.ID,
		Kind:       r.Kind,
		Name:       r.Name,
		SystemData: r.SystemData,
		Type:       r.Type,
	}
}

// RegistryKeyEntityProperties - RegistryKey entity property bag.
type RegistryKeyEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; the hive that holds the registry key.
	Hive *RegistryHive

	// READ-ONLY; The registry key path.
	Key *string
}

// RegistryValueEntity - Represents a registry value entity.
type RegistryValueEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// RegistryKey entity properties
	Properties *RegistryValueEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type RegistryValueEntity.
func (r *RegistryValueEntity) GetEntity() *Entity {
	return &Entity{
		ID:         r.ID,
		Kind:       r.Kind,
		Name:       r.Name,
		SystemData: r.SystemData,
		Type:       r.Type,
	}
}

// RegistryValueEntityProperties - RegistryValue entity property bag.
type RegistryValueEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The registry key entity id.
	KeyEntityID *string

	// READ-ONLY; String formatted representation of the value data.
	ValueData *string

	// READ-ONLY; The registry value name.
	ValueName *string

	// READ-ONLY; Specifies the data types to use when storing values in the registry, or identifies the data type of a value
	// in the registry.
	ValueType *RegistryValueKind
}

// Relation - Represents a relation between two resources
type Relation struct {
	// Etag of the azure resource
	Etag *string

	// Relation properties
	Properties *RelationProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RelationList - List of relations.
type RelationList struct {
	// REQUIRED; Array of relations.
	Value []*Relation

	// READ-ONLY; URL to fetch the next set of relations.
	NextLink *string
}

// RelationProperties - Relation property bag.
type RelationProperties struct {
	// REQUIRED; The resource ID of the related resource
	RelatedResourceID *string

	// READ-ONLY; The resource kind of the related resource
	RelatedResourceKind *string

	// READ-ONLY; The name of the related resource
	RelatedResourceName *string

	// READ-ONLY; The resource type of the related resource
	RelatedResourceType *string
}

// ScheduledAlertRule - Represents scheduled alert rule.
type ScheduledAlertRule struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// Etag of the azure resource
	Etag *string

	// Scheduled alert rule properties
	Properties *ScheduledAlertRuleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRule implements the AlertRuleClassification interface for type ScheduledAlertRule.
func (s *ScheduledAlertRule) GetAlertRule() *AlertRule {
	return &AlertRule{
		Etag:       s.Etag,
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// ScheduledAlertRuleProperties - Scheduled alert rule base property bag.
type ScheduledAlertRuleProperties struct {
	// REQUIRED; The display name for alerts created by this alert rule.
	DisplayName *string

	// REQUIRED; Determines whether this alert rule is enabled or disabled.
	Enabled *bool

	// REQUIRED; The suppression (in ISO 8601 duration format) to wait since last time this alert rule been triggered.
	SuppressionDuration *string

	// REQUIRED; Determines whether the suppression for this alert rule is enabled or disabled.
	SuppressionEnabled *bool

	// The alert details override settings
	AlertDetailsOverride *AlertDetailsOverride

	// The Name of the alert rule template used to create this rule.
	AlertRuleTemplateName *string

	// Dictionary of string key-value pairs of columns to be attached to the alert
	CustomDetails map[string]*string

	// The description of the alert rule.
	Description *string

	// Array of the entity mappings of the alert rule
	EntityMappings []*EntityMapping

	// The event grouping settings.
	EventGroupingSettings *EventGroupingSettings

	// The settings of the incidents that created from alerts triggered by this analytics rule
	IncidentConfiguration *IncidentConfiguration

	// The query that creates alerts for this rule.
	Query *string

	// The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string

	// The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string

	// The severity for alerts created by this alert rule.
	Severity *AlertSeverity

	// The tactics of the alert rule
	Tactics []*AttackTactic

	// The version of the alert rule template used to create this rule - in format , where all are numbers, for example 0
	TemplateVersion *string

	// The operation against the threshold that triggers alert rule.
	TriggerOperator *TriggerOperator

	// The threshold triggers this alert rule.
	TriggerThreshold *int32

	// READ-ONLY; The last time that this alert rule has been modified.
	LastModifiedUTC *time.Time
}

// ScheduledAlertRuleTemplate - Represents scheduled alert rule template.
type ScheduledAlertRuleTemplate struct {
	// REQUIRED; The alert rule kind
	Kind *AlertRuleKind

	// Scheduled alert rule template properties
	Properties *ScheduledAlertRuleTemplateProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetAlertRuleTemplate implements the AlertRuleTemplateClassification interface for type ScheduledAlertRuleTemplate.
func (s *ScheduledAlertRuleTemplate) GetAlertRuleTemplate() *AlertRuleTemplate {
	return &AlertRuleTemplate{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// ScheduledAlertRuleTemplateProperties - Scheduled alert rule template properties
type ScheduledAlertRuleTemplateProperties struct {
	// The alert details override settings
	AlertDetailsOverride *AlertDetailsOverride

	// the number of alert rules that were created by this template
	AlertRulesCreatedByTemplateCount *int32

	// Dictionary of string key-value pairs of columns to be attached to the alert
	CustomDetails map[string]*string

	// The description of the alert rule template.
	Description *string

	// The display name for alert rule template.
	DisplayName *string

	// Array of the entity mappings of the alert rule
	EntityMappings []*EntityMapping

	// The event grouping settings.
	EventGroupingSettings *EventGroupingSettings

	// The query that creates alerts for this rule.
	Query *string

	// The frequency (in ISO 8601 duration format) for this alert rule to run.
	QueryFrequency *string

	// The period (in ISO 8601 duration format) that this alert rule looks at.
	QueryPeriod *string

	// The required data connectors for this template
	RequiredDataConnectors []*AlertRuleTemplateDataSource

	// The severity for alerts created by this alert rule.
	Severity *AlertSeverity

	// The alert rule template status.
	Status *TemplateStatus

	// The tactics of the alert rule template
	Tactics []*AttackTactic

	// The operation against the threshold that triggers alert rule.
	TriggerOperator *TriggerOperator

	// The threshold triggers this alert rule.
	TriggerThreshold *int32

	// The version of this template - in format , where all are numbers. For example .
	Version *string

	// READ-ONLY; The time that this alert rule template has been added.
	CreatedDateUTC *time.Time

	// READ-ONLY; The time that this alert rule template was last updated.
	LastUpdatedDateUTC *time.Time
}

// SecurityAlert - Represents a security alert entity.
type SecurityAlert struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// SecurityAlert entity properties
	Properties *SecurityAlertProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type SecurityAlert.
func (s *SecurityAlert) GetEntity() *Entity {
	return &Entity{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SecurityAlertProperties - SecurityAlert entity property bag.
type SecurityAlertProperties struct {
	// The severity of the alert
	Severity *AlertSeverity

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The display name of the alert.
	AlertDisplayName *string

	// READ-ONLY; The uri link of the alert.
	AlertLink *string

	// READ-ONLY; The type name of the alert.
	AlertType *string

	// READ-ONLY; Display name of the main entity being reported on.
	CompromisedEntity *string

	// READ-ONLY; The confidence level of this alert.
	ConfidenceLevel *ConfidenceLevel

	// READ-ONLY; The confidence reasons
	ConfidenceReasons []*SecurityAlertPropertiesConfidenceReasonsItem

	// READ-ONLY; The confidence score of the alert.
	ConfidenceScore *float64

	// READ-ONLY; The confidence score calculation status, i.e. indicating if score calculation is pending for this alert, not
	// applicable or final.
	ConfidenceScoreStatus *ConfidenceScoreStatus

	// READ-ONLY; Alert description.
	Description *string

	// READ-ONLY; The impact end time of the alert (the time of the last event contributing to the alert).
	EndTimeUTC *time.Time

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; Holds the alert intent stage(s) mapping for this alert.
	Intent *KillChainIntent

	// READ-ONLY; The time the alert was made available for consumption.
	ProcessingEndTime *time.Time

	// READ-ONLY; The name of a component inside the product which generated the alert.
	ProductComponentName *string

	// READ-ONLY; The name of the product which published this alert.
	ProductName *string

	// READ-ONLY; The version of the product generating the alert.
	ProductVersion *string

	// READ-ONLY; The identifier of the alert inside the product which generated the alert.
	ProviderAlertID *string

	// READ-ONLY; Manual action items to take to remediate the alert.
	RemediationSteps []*string

	// READ-ONLY; The list of resource identifiers of the alert.
	ResourceIdentifiers []any

	// READ-ONLY; The impact start time of the alert (the time of the first event contributing to the alert).
	StartTimeUTC *time.Time

	// READ-ONLY; The lifecycle status of the alert.
	Status *AlertStatus

	// READ-ONLY; Holds the product identifier of the alert for the product.
	SystemAlertID *string

	// READ-ONLY; The tactics of the alert
	Tactics []*AttackTactic

	// READ-ONLY; The time the alert was generated.
	TimeGenerated *time.Time

	// READ-ONLY; The name of the vendor that raise the alert.
	VendorName *string
}

// SecurityAlertPropertiesConfidenceReasonsItem - confidence reason item
type SecurityAlertPropertiesConfidenceReasonsItem struct {
	// READ-ONLY; The reason's description
	Reason *string

	// READ-ONLY; The type (category) of the reason
	ReasonType *string
}

// SecurityGroupEntity - Represents a security group entity.
type SecurityGroupEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// SecurityGroup entity properties
	Properties *SecurityGroupEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type SecurityGroupEntity.
func (s *SecurityGroupEntity) GetEntity() *Entity {
	return &Entity{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SecurityGroupEntityProperties - SecurityGroup entity property bag.
type SecurityGroupEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The group distinguished name
	DistinguishedName *string

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; A single-value attribute that is the unique identifier for the object, assigned by active directory.
	ObjectGUID *string

	// READ-ONLY; The SID attribute is a single-value attribute that specifies the security identifier (SID) of the group
	Sid *string
}

// SentinelOnboardingState - Sentinel onboarding state
type SentinelOnboardingState struct {
	// Etag of the azure resource
	Etag *string

	// The Sentinel onboarding state object
	Properties *SentinelOnboardingStateProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SentinelOnboardingStateProperties - The Sentinel onboarding state properties
type SentinelOnboardingStateProperties struct {
	// Flag that indicates the status of the CMK setting
	CustomerManagedKey *bool
}

// SentinelOnboardingStatesList - List of the Sentinel onboarding states
type SentinelOnboardingStatesList struct {
	// REQUIRED; Array of Sentinel onboarding states
	Value []*SentinelOnboardingState
}

// SubmissionMailEntity - Represents a submission mail entity.
type SubmissionMailEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Submission mail entity properties
	Properties *SubmissionMailEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type SubmissionMailEntity.
func (s *SubmissionMailEntity) GetEntity() *Entity {
	return &Entity{
		ID:         s.ID,
		Kind:       s.Kind,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SubmissionMailEntityProperties - Submission mail entity property bag.
type SubmissionMailEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; The network message id of email to which submission belongs
	NetworkMessageID *string

	// READ-ONLY; The recipient of the mail
	Recipient *string

	// READ-ONLY; The submission type for the given instance. This maps to Junk, Phish, Malware or NotJunk.
	ReportType *string

	// READ-ONLY; The sender of the mail
	Sender *string

	// READ-ONLY; The sender's IP
	SenderIP *string

	// READ-ONLY; The subject of submission mail
	Subject *string

	// READ-ONLY; The submission date
	SubmissionDate *time.Time

	// READ-ONLY; The submission id
	SubmissionID *string

	// READ-ONLY; The submitter
	Submitter *string

	// READ-ONLY; The Time stamp when the message is received (Mail)
	Timestamp *time.Time
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TIDataConnector - Represents threat intelligence data connector.
type TIDataConnector struct {
	// REQUIRED; The data connector kind
	Kind *DataConnectorKind

	// Etag of the azure resource
	Etag *string

	// TI (Threat Intelligence) data connector properties.
	Properties *TIDataConnectorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetDataConnector implements the DataConnectorClassification interface for type TIDataConnector.
func (t *TIDataConnector) GetDataConnector() *DataConnector {
	return &DataConnector{
		Etag:       t.Etag,
		ID:         t.ID,
		Kind:       t.Kind,
		Name:       t.Name,
		SystemData: t.SystemData,
		Type:       t.Type,
	}
}

// TIDataConnectorDataTypes - The available data types for TI (Threat Intelligence) data connector.
type TIDataConnectorDataTypes struct {
	// Data type for indicators connection.
	Indicators *TIDataConnectorDataTypesIndicators
}

// TIDataConnectorDataTypesIndicators - Data type for indicators connection.
type TIDataConnectorDataTypesIndicators struct {
	// Describe whether this data type connection is enabled or not.
	State *DataTypeState
}

// TIDataConnectorProperties - TI (Threat Intelligence) data connector properties.
type TIDataConnectorProperties struct {
	// The available data types for the connector.
	DataTypes *TIDataConnectorDataTypes

	// The tenant id to connect to, and get the data from.
	TenantID *string

	// The lookback period for the feed to be imported.
	TipLookbackPeriod *time.Time
}

// ThreatIntelligence property bag.
type ThreatIntelligence struct {
	// READ-ONLY; Confidence (must be between 0 and 1)
	Confidence *float64

	// READ-ONLY; Name of the provider from whom this Threat Intelligence information was received
	ProviderName *string

	// READ-ONLY; Report link
	ReportLink *string

	// READ-ONLY; Threat description (free text)
	ThreatDescription *string

	// READ-ONLY; Threat name (e.g. "Jedobot malware")
	ThreatName *string

	// READ-ONLY; Threat type (e.g. "Botnet")
	ThreatType *string
}

// ThreatIntelligenceAppendTags - Array of tags to be appended to the threat intelligence indicator.
type ThreatIntelligenceAppendTags struct {
	// List of tags to be appended.
	ThreatIntelligenceTags []*string
}

// ThreatIntelligenceExternalReference - Describes external reference
type ThreatIntelligenceExternalReference struct {
	// External reference description
	Description *string

	// External reference ID
	ExternalID *string

	// External reference hashes
	Hashes map[string]*string

	// External reference source name
	SourceName *string

	// External reference URL
	URL *string
}

// ThreatIntelligenceFilteringCriteria - Filtering criteria for querying threat intelligence indicators.
type ThreatIntelligenceFilteringCriteria struct {
	// Ids of threat intelligence indicators
	IDs []*string

	// Parameter to include/exclude disabled indicators.
	IncludeDisabled *bool

	// Keywords for searching threat intelligence indicators
	Keywords []*string

	// Maximum confidence.
	MaxConfidence *int32

	// End time for ValidUntil filter.
	MaxValidUntil *string

	// Minimum confidence.
	MinConfidence *int32

	// Start time for ValidUntil filter.
	MinValidUntil *string

	// Page size
	PageSize *int32

	// Pattern types
	PatternTypes []*string

	// Skip token.
	SkipToken *string

	// Columns to sort by and sorting order
	SortBy []*ThreatIntelligenceSortingCriteria

	// Sources of threat intelligence indicators
	Sources []*string

	// Threat types of threat intelligence indicators
	ThreatTypes []*string
}

// ThreatIntelligenceGranularMarkingModel - Describes threat granular marking model entity
type ThreatIntelligenceGranularMarkingModel struct {
	// Language granular marking model
	Language *string

	// marking reference granular marking model
	MarkingRef *int32

	// granular marking model selectors
	Selectors []*string
}

// ThreatIntelligenceIndicatorModel - Threat intelligence indicator entity.
type ThreatIntelligenceIndicatorModel struct {
	// REQUIRED; The kind of the entity.
	Kind *ThreatIntelligenceResourceInnerKind

	// Etag of the azure resource
	Etag *string

	// Threat Intelligence Entity properties
	Properties *ThreatIntelligenceIndicatorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetThreatIntelligenceInformation implements the ThreatIntelligenceInformationClassification interface for type ThreatIntelligenceIndicatorModel.
func (t *ThreatIntelligenceIndicatorModel) GetThreatIntelligenceInformation() *ThreatIntelligenceInformation {
	return &ThreatIntelligenceInformation{
		Etag:       t.Etag,
		ID:         t.ID,
		Kind:       t.Kind,
		Name:       t.Name,
		SystemData: t.SystemData,
		Type:       t.Type,
	}
}

// ThreatIntelligenceIndicatorProperties - Describes threat intelligence entity properties
type ThreatIntelligenceIndicatorProperties struct {
	// Confidence of threat intelligence entity
	Confidence *int32

	// Created by
	Created *string

	// Created by reference of threat intelligence entity
	CreatedByRef *string

	// Is threat intelligence entity defanged
	Defanged *bool

	// Description of a threat intelligence entity
	Description *string

	// Display name of a threat intelligence entity
	DisplayName *string

	// Extensions map
	Extensions map[string]any

	// External ID of threat intelligence entity
	ExternalID *string

	// External last updated time in UTC
	ExternalLastUpdatedTimeUTC *string

	// External References
	ExternalReferences []*ThreatIntelligenceExternalReference

	// Granular Markings
	GranularMarkings []*ThreatIntelligenceGranularMarkingModel

	// Indicator types of threat intelligence entities
	IndicatorTypes []*string

	// Kill chain phases
	KillChainPhases []*ThreatIntelligenceKillChainPhase

	// Labels of threat intelligence entity
	Labels []*string

	// Language of threat intelligence entity
	Language *string

	// Last updated time in UTC
	LastUpdatedTimeUTC *string

	// Modified by
	Modified *string

	// Threat intelligence entity object marking references
	ObjectMarkingRefs []*string

	// Parsed patterns
	ParsedPattern []*ThreatIntelligenceParsedPattern

	// Pattern of a threat intelligence entity
	Pattern *string

	// Pattern type of a threat intelligence entity
	PatternType *string

	// Pattern version of a threat intelligence entity
	PatternVersion *string

	// Is threat intelligence entity revoked
	Revoked *bool

	// Source of a threat intelligence entity
	Source *string

	// List of tags
	ThreatIntelligenceTags []*string

	// Threat types
	ThreatTypes []*string

	// Valid from
	ValidFrom *string

	// Valid until
	ValidUntil *string

	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string
}

// ThreatIntelligenceInformation - Threat intelligence information object.
type ThreatIntelligenceInformation struct {
	// REQUIRED; The kind of the entity.
	Kind *ThreatIntelligenceResourceInnerKind

	// Etag of the azure resource
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetThreatIntelligenceInformation implements the ThreatIntelligenceInformationClassification interface for type ThreatIntelligenceInformation.
func (t *ThreatIntelligenceInformation) GetThreatIntelligenceInformation() *ThreatIntelligenceInformation {
	return t
}

// ThreatIntelligenceInformationList - List of all the threat intelligence information objects.
type ThreatIntelligenceInformationList struct {
	// REQUIRED; Array of threat intelligence information objects.
	Value []ThreatIntelligenceInformationClassification

	// READ-ONLY; URL to fetch the next set of information objects.
	NextLink *string
}

// ThreatIntelligenceKillChainPhase - Describes threat kill chain phase entity
type ThreatIntelligenceKillChainPhase struct {
	// Kill chainName name
	KillChainName *string

	// Phase name
	PhaseName *string
}

// ThreatIntelligenceMetric - Describes threat intelligence metric
type ThreatIntelligenceMetric struct {
	// Last updated indicator metric
	LastUpdatedTimeUTC *string

	// Pattern type metrics
	PatternTypeMetrics []*ThreatIntelligenceMetricEntity

	// Source metrics
	SourceMetrics []*ThreatIntelligenceMetricEntity

	// Threat type metrics
	ThreatTypeMetrics []*ThreatIntelligenceMetricEntity
}

// ThreatIntelligenceMetricEntity - Describes threat intelligence metric entity
type ThreatIntelligenceMetricEntity struct {
	// Metric name
	MetricName *string

	// Metric value
	MetricValue *int32
}

// ThreatIntelligenceMetrics - Threat intelligence metrics.
type ThreatIntelligenceMetrics struct {
	// Threat intelligence metrics.
	Properties *ThreatIntelligenceMetric
}

// ThreatIntelligenceMetricsList - List of all the threat intelligence metric fields (type/threat type/source).
type ThreatIntelligenceMetricsList struct {
	// REQUIRED; Array of threat intelligence metric fields (type/threat type/source).
	Value []*ThreatIntelligenceMetrics
}

// ThreatIntelligenceParsedPattern - Describes parsed pattern entity
type ThreatIntelligenceParsedPattern struct {
	// Pattern type key
	PatternTypeKey *string

	// Pattern type keys
	PatternTypeValues []*ThreatIntelligenceParsedPatternTypeValue
}

// ThreatIntelligenceParsedPatternTypeValue - Describes threat kill chain phase entity
type ThreatIntelligenceParsedPatternTypeValue struct {
	// Value of parsed pattern
	Value *string

	// Type of the value
	ValueType *string
}

// ThreatIntelligenceSortingCriteria - List of available columns for sorting
type ThreatIntelligenceSortingCriteria struct {
	// Column name
	ItemKey *string

	// Sorting order (ascending/descending/unsorted).
	SortOrder *ThreatIntelligenceSortingOrder
}

// URLEntity - Represents a url entity.
type URLEntity struct {
	// REQUIRED; The kind of the entity.
	Kind *EntityKindEnum

	// Url entity properties
	Properties *URLEntityProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// GetEntity implements the EntityClassification interface for type URLEntity.
func (u *URLEntity) GetEntity() *Entity {
	return &Entity{
		ID:         u.ID,
		Kind:       u.Kind,
		Name:       u.Name,
		SystemData: u.SystemData,
		Type:       u.Type,
	}
}

// URLEntityProperties - Url entity property bag.
type URLEntityProperties struct {
	// READ-ONLY; A bag of custom fields that should be part of the entity and will be presented to the user.
	AdditionalData map[string]any

	// READ-ONLY; The graph item display name which is a short humanly readable description of the graph item instance. This property
	// is optional and might be system generated.
	FriendlyName *string

	// READ-ONLY; A full URL the entity points to
	URL *string
}

// UserInfo - User information that made some action
type UserInfo struct {
	// The object id of the user.
	ObjectID *string

	// READ-ONLY; The email of the user.
	Email *string

	// READ-ONLY; The name of the user.
	Name *string
}

// Watchlist - Represents a Watchlist in Azure Security Insights.
type Watchlist struct {
	// Etag of the azure resource
	Etag *string

	// Watchlist properties
	Properties *WatchlistProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WatchlistItem - Represents a Watchlist Item in Azure Security Insights.
type WatchlistItem struct {
	// Etag of the azure resource
	Etag *string

	// Watchlist Item properties
	Properties *WatchlistItemProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WatchlistItemList - List all the watchlist items.
type WatchlistItemList struct {
	// REQUIRED; Array of watchlist items.
	Value []*WatchlistItem

	// READ-ONLY; URL to fetch the next set of watchlist items.
	NextLink *string
}

// WatchlistItemProperties - Describes watchlist item properties
type WatchlistItemProperties struct {
	// REQUIRED; key-value pairs for a watchlist item
	ItemsKeyValue any

	// The time the watchlist item was created
	Created *time.Time

	// Describes a user that created the watchlist item
	CreatedBy *UserInfo

	// key-value pairs for a watchlist item entity mapping
	EntityMapping any

	// A flag that indicates if the watchlist item is deleted or not
	IsDeleted *bool

	// The tenantId to which the watchlist item belongs to
	TenantID *string

	// The last time the watchlist item was updated
	Updated *time.Time

	// Describes a user that updated the watchlist item
	UpdatedBy *UserInfo

	// The id (a Guid) of the watchlist item
	WatchlistItemID *string

	// The type of the watchlist item
	WatchlistItemType *string
}

// WatchlistList - List all the watchlists.
type WatchlistList struct {
	// REQUIRED; Array of watchlist.
	Value []*Watchlist

	// READ-ONLY; URL to fetch the next set of watchlists.
	NextLink *string
}

// WatchlistProperties - Describes watchlist properties
type WatchlistProperties struct {
	// REQUIRED; The display name of the watchlist
	DisplayName *string

	// REQUIRED; The search key is used to optimize query performance when using watchlists for joins with other data. For example,
	// enable a column with IP addresses to be the designated SearchKey field, then use this
	// field as the key field when joining to other event data by IP address.
	ItemsSearchKey *string

	// REQUIRED; The provider of the watchlist
	Provider *string

	// REQUIRED; The source of the watchlist
	Source *Source

	// The content type of the raw content. For now, only text/csv is valid
	ContentType *string

	// The time the watchlist was created
	Created *time.Time

	// Describes a user that created the watchlist
	CreatedBy *UserInfo

	// The default duration of a watchlist (in ISO 8601 duration format)
	DefaultDuration *string

	// A description of the watchlist
	Description *string

	// A flag that indicates if the watchlist is deleted or not
	IsDeleted *bool

	// List of labels relevant to this watchlist
	Labels []*string

	// The number of lines in a csv content to skip before the header
	NumberOfLinesToSkip *int32

	// The raw content that represents to watchlist items to create. Example : This line will be skipped header1,header2 value1,value2
	RawContent *string

	// The tenantId where the watchlist belongs to
	TenantID *string

	// The last time the watchlist was updated
	Updated *time.Time

	// Describes a user that updated the watchlist
	UpdatedBy *UserInfo

	// The status of the Watchlist upload : New, InProgress or Complete. Note : When a Watchlist upload status is InProgress,
	// the Watchlist cannot be deleted
	UploadStatus *string

	// The alias of the watchlist
	WatchlistAlias *string

	// The id (a Guid) of the watchlist
	WatchlistID *string

	// The type of the watchlist
	WatchlistType *string
}
