//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// OperatorsClient contains the methods for the SecurityOperators group.
// Don't use this type directly, use NewOperatorsClient() instead.
type OperatorsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewOperatorsClient creates a new instance of OperatorsClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewOperatorsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*OperatorsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &OperatorsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Creates Microsoft Defender for Cloud security operator on the given scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - pricingName - name of the pricing configuration
//   - securityOperatorName - name of the securityOperator
//   - options - OperatorsClientCreateOrUpdateOptions contains the optional parameters for the OperatorsClient.CreateOrUpdate
//     method.
func (client *OperatorsClient) CreateOrUpdate(ctx context.Context, pricingName string, securityOperatorName string, options *OperatorsClientCreateOrUpdateOptions) (OperatorsClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "OperatorsClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, pricingName, securityOperatorName, options)
	if err != nil {
		return OperatorsClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return OperatorsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return OperatorsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *OperatorsClient) createOrUpdateCreateRequest(ctx context.Context, pricingName string, securityOperatorName string, options *OperatorsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if pricingName == "" {
		return nil, errors.New("parameter pricingName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pricingName}", url.PathEscape(pricingName))
	if securityOperatorName == "" {
		return nil, errors.New("parameter securityOperatorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityOperatorName}", url.PathEscape(securityOperatorName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *OperatorsClient) createOrUpdateHandleResponse(resp *http.Response) (OperatorsClientCreateOrUpdateResponse, error) {
	result := OperatorsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperatorResource); err != nil {
		return OperatorsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Delete Microsoft Defender for Cloud securityOperator in the subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - pricingName - name of the pricing configuration
//   - securityOperatorName - name of the securityOperator
//   - options - OperatorsClientDeleteOptions contains the optional parameters for the OperatorsClient.Delete method.
func (client *OperatorsClient) Delete(ctx context.Context, pricingName string, securityOperatorName string, options *OperatorsClientDeleteOptions) (OperatorsClientDeleteResponse, error) {
	var err error
	const operationName = "OperatorsClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, pricingName, securityOperatorName, options)
	if err != nil {
		return OperatorsClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return OperatorsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return OperatorsClientDeleteResponse{}, err
	}
	return OperatorsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *OperatorsClient) deleteCreateRequest(ctx context.Context, pricingName string, securityOperatorName string, options *OperatorsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if pricingName == "" {
		return nil, errors.New("parameter pricingName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pricingName}", url.PathEscape(pricingName))
	if securityOperatorName == "" {
		return nil, errors.New("parameter securityOperatorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityOperatorName}", url.PathEscape(securityOperatorName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a specific security operator for the requested scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - pricingName - name of the pricing configuration
//   - securityOperatorName - name of the securityOperator
//   - options - OperatorsClientGetOptions contains the optional parameters for the OperatorsClient.Get method.
func (client *OperatorsClient) Get(ctx context.Context, pricingName string, securityOperatorName string, options *OperatorsClientGetOptions) (OperatorsClientGetResponse, error) {
	var err error
	const operationName = "OperatorsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, pricingName, securityOperatorName, options)
	if err != nil {
		return OperatorsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return OperatorsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return OperatorsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *OperatorsClient) getCreateRequest(ctx context.Context, pricingName string, securityOperatorName string, options *OperatorsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if pricingName == "" {
		return nil, errors.New("parameter pricingName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pricingName}", url.PathEscape(pricingName))
	if securityOperatorName == "" {
		return nil, errors.New("parameter securityOperatorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityOperatorName}", url.PathEscape(securityOperatorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *OperatorsClient) getHandleResponse(resp *http.Response) (OperatorsClientGetResponse, error) {
	result := OperatorsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperatorResource); err != nil {
		return OperatorsClientGetResponse{}, err
	}
	return result, nil
}

// List - Lists Microsoft Defender for Cloud securityOperators in the subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01-preview
//   - pricingName - name of the pricing configuration
//   - options - OperatorsClientListOptions contains the optional parameters for the OperatorsClient.List method.
func (client *OperatorsClient) List(ctx context.Context, pricingName string, options *OperatorsClientListOptions) (OperatorsClientListResponse, error) {
	var err error
	const operationName = "OperatorsClient.List"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCreateRequest(ctx, pricingName, options)
	if err != nil {
		return OperatorsClientListResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return OperatorsClientListResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return OperatorsClientListResponse{}, err
	}
	resp, err := client.listHandleResponse(httpResp)
	return resp, err
}

// listCreateRequest creates the List request.
func (client *OperatorsClient) listCreateRequest(ctx context.Context, pricingName string, options *OperatorsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if pricingName == "" {
		return nil, errors.New("parameter pricingName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pricingName}", url.PathEscape(pricingName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *OperatorsClient) listHandleResponse(resp *http.Response) (OperatorsClientListResponse, error) {
	result := OperatorsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperatorList); err != nil {
		return OperatorsClientListResponse{}, err
	}
	return result, nil
}
