//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// HealthReportsClient contains the methods for the HealthReports group.
// Don't use this type directly, use NewHealthReportsClient() instead.
type HealthReportsClient struct {
	internal *arm.Client
}

// NewHealthReportsClient creates a new instance of HealthReportsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewHealthReportsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*HealthReportsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &HealthReportsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get health report of resource
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-05-01-preview
//   - resourceID - The identifier of the resource.
//   - healthReportName - The health report Key - Unique key for the health report type
//   - options - HealthReportsClientGetOptions contains the optional parameters for the HealthReportsClient.Get method.
func (client *HealthReportsClient) Get(ctx context.Context, resourceID string, healthReportName string, options *HealthReportsClientGetOptions) (HealthReportsClientGetResponse, error) {
	var err error
	const operationName = "HealthReportsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceID, healthReportName, options)
	if err != nil {
		return HealthReportsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return HealthReportsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return HealthReportsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *HealthReportsClient) getCreateRequest(ctx context.Context, resourceID string, healthReportName string, options *HealthReportsClientGetOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if healthReportName == "" {
		return nil, errors.New("parameter healthReportName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{healthReportName}", url.PathEscape(healthReportName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *HealthReportsClient) getHandleResponse(resp *http.Response) (HealthReportsClientGetResponse, error) {
	result := HealthReportsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HealthReport); err != nil {
		return HealthReportsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get a list of all health reports inside a scope. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'),
// or security connector (format:
// 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
//
// Generated from API version 2023-05-01-preview
//   - scope - The scope at which the operation is performed.
//   - options - HealthReportsClientListOptions contains the optional parameters for the HealthReportsClient.NewListPager method.
func (client *HealthReportsClient) NewListPager(scope string, options *HealthReportsClientListOptions) *runtime.Pager[HealthReportsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[HealthReportsClientListResponse]{
		More: func(page HealthReportsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *HealthReportsClientListResponse) (HealthReportsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "HealthReportsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return HealthReportsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *HealthReportsClient) listCreateRequest(ctx context.Context, scope string, options *HealthReportsClientListOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Security/healthReports"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-05-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *HealthReportsClient) listHandleResponse(resp *http.Response) (HealthReportsClientListResponse, error) {
	result := HealthReportsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HealthReportsList); err != nil {
		return HealthReportsClientListResponse{}, err
	}
	return result, nil
}
