//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SQLVulnerabilityAssessmentScansServer is a fake server for instances of the armsecurity.SQLVulnerabilityAssessmentScansClient type.
type SQLVulnerabilityAssessmentScansServer struct {
	// Get is the fake for method SQLVulnerabilityAssessmentScansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scanID string, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentScansClientGetOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentScansClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SQLVulnerabilityAssessmentScansClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, workspaceID string, resourceID string, options *armsecurity.SQLVulnerabilityAssessmentScansClientListOptions) (resp azfake.Responder[armsecurity.SQLVulnerabilityAssessmentScansClientListResponse], errResp azfake.ErrorResponder)
}

// NewSQLVulnerabilityAssessmentScansServerTransport creates a new instance of SQLVulnerabilityAssessmentScansServerTransport with the provided implementation.
// The returned SQLVulnerabilityAssessmentScansServerTransport instance is connected to an instance of armsecurity.SQLVulnerabilityAssessmentScansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLVulnerabilityAssessmentScansServerTransport(srv *SQLVulnerabilityAssessmentScansServer) *SQLVulnerabilityAssessmentScansServerTransport {
	return &SQLVulnerabilityAssessmentScansServerTransport{srv: srv}
}

// SQLVulnerabilityAssessmentScansServerTransport connects instances of armsecurity.SQLVulnerabilityAssessmentScansClient to instances of SQLVulnerabilityAssessmentScansServer.
// Don't use this type directly, use NewSQLVulnerabilityAssessmentScansServerTransport instead.
type SQLVulnerabilityAssessmentScansServerTransport struct {
	srv *SQLVulnerabilityAssessmentScansServer
}

// Do implements the policy.Transporter interface for SQLVulnerabilityAssessmentScansServerTransport.
func (s *SQLVulnerabilityAssessmentScansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLVulnerabilityAssessmentScansClient.Get":
		resp, err = s.dispatchGet(req)
	case "SQLVulnerabilityAssessmentScansClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLVulnerabilityAssessmentScansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), scanIDParam, workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Scan, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLVulnerabilityAssessmentScansServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/sqlVulnerabilityAssessments/default/scans`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	workspaceIDParam, err := url.QueryUnescape(qp.Get("workspaceId"))
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.List(req.Context(), workspaceIDParam, resourceIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Scans, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
