//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertsSubscription_example.json
func ExampleAlertsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAlertsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AlertList = armsecurity.AlertList{
		// 	Value: []*armsecurity.Alert{
		// 		{
		// 			Name: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 			Type: to.Ptr("Microsoft.Security/Locations/alerts"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/alerts/2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA"),
		// 			Properties: &armsecurity.AlertProperties{
		// 				Description: to.Ptr("This is a test alert generated by Azure Security Center. No further action is needed."),
		// 				AlertDisplayName: to.Ptr("Azure Security Center test alert (not a threat)"),
		// 				AlertType: to.Ptr("VM_EICAR"),
		// 				AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
		// 				CompromisedEntity: to.Ptr("vm1"),
		// 				CorrelationKey: to.Ptr("kso0LFWxzCll5tqrk5hmrBJ+MY1BX806W6q6+0s9Lk="),
		// 				EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 				Entities: []*armsecurity.AlertEntity{
		// 					{
		// 						AdditionalProperties: map[string]any{
		// 							"address": "192.0.2.1",
		// 							"location": map[string]any{
		// 								"asn": float64(6584),
		// 								"city": "sonning",
		// 								"countryCode": "gb",
		// 								"latitude": float64(51.468),
		// 								"longitude": float64(-0.909),
		// 								"state": "wokingham",
		// 							},
		// 						},
		// 						Type: to.Ptr("ip"),
		// 				}},
		// 				ExtendedLinks: []map[string]*string{
		// 					map[string]*string{
		// 						"Category": to.Ptr("threat_reports"),
		// 						"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
		// 						"Label": to.Ptr("Report: RDP Brute Forcing"),
		// 						"Type": to.Ptr("webLink"),
		// 				}},
		// 				ExtendedProperties: map[string]*string{
		// 					"Property1": to.Ptr("Property1 information"),
		// 				},
		// 				Intent: to.Ptr(armsecurity.IntentExecution),
		// 				IsIncident: to.Ptr(true),
		// 				ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.920Z"); return t}()),
		// 				ProductComponentName: to.Ptr("testName"),
		// 				ProductName: to.Ptr("Azure Security Center"),
		// 				RemediationSteps: []*string{
		// 					to.Ptr("No further action is needed.")},
		// 					ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
		// 						&armsecurity.AzureResourceIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
		// 							AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
		// 						},
		// 						&armsecurity.LogAnalyticsIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
		// 							AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
		// 							WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
		// 							WorkspaceResourceGroup: to.Ptr("myRg1"),
		// 							WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 					}},
		// 					Severity: to.Ptr(armsecurity.AlertSeverityHigh),
		// 					StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 					Status: to.Ptr(armsecurity.AlertStatusActive),
		// 					SubTechniques: []*string{
		// 						to.Ptr("T1059.001"),
		// 						to.Ptr("T1059.006"),
		// 						to.Ptr("T1053.002")},
		// 						SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
		// 							AdditionalProperties: map[string]any{
		// 								"columns": []any{
		// 									"Date",
		// 									"Activity",
		// 									"User",
		// 									"TestedText",
		// 									"TestedValue",
		// 								},
		// 								"rows": []any{
		// 									[]any{
		// 										"2022-01-17T07:03:52.034Z",
		// 										"Log on",
		// 										"testUser",
		// 										"false",
		// 										false,
		// 									},
		// 									[]any{
		// 										"2022-01-17T07:03:52.034Z",
		// 										"Log on",
		// 										"testUser2",
		// 										"false",
		// 										false,
		// 									},
		// 									[]any{
		// 										"2022-01-17T07:03:52.034Z",
		// 										"Log on",
		// 										"testUser3",
		// 										"true",
		// 										true,
		// 									},
		// 								},
		// 								"title": "Investigate activity test",
		// 							},
		// 							Type: to.Ptr("tabularEvidences"),
		// 						},
		// 						SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 						Techniques: []*string{
		// 							to.Ptr("T1059"),
		// 							to.Ptr("T1053"),
		// 							to.Ptr("T1072")},
		// 							TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.000Z"); return t}()),
		// 							VendorName: to.Ptr("Microsoft"),
		// 							Version: to.Ptr("2022-01-01"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22"),
		// 						Type: to.Ptr("Microsoft.Security/Locations/alerts"),
		// 						ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg2/providers/Microsoft.Security/locations/westeurope/alerts/2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22"),
		// 						Properties: &armsecurity.AlertProperties{
		// 							Description: to.Ptr("The process ‘c:\\users\\contosoUser\\scrsave.scr’ was observed executing from an uncommon location. Files with the .scr extensions are screen saver files and are normally reside and execute from the Windows system directory."),
		// 							AlertDisplayName: to.Ptr("Suspicious Screensaver process executed"),
		// 							AlertType: to.Ptr("VM_SuspiciousScreenSaver"),
		// 							AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
		// 							CompromisedEntity: to.Ptr("vm2"),
		// 							CorrelationKey: to.Ptr("4hno6LF0xzCl5tqrk4nrBW+MY1BX816W6q6+0srk4"),
		// 							EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:45.004Z"); return t}()),
		// 							Entities: []*armsecurity.AlertEntity{
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"OsVersion": nil,
		// 										"azureID": "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/myRg2/providers/microsoft.compute/virtualmachines/vm2",
		// 										"dnsDomain": "",
		// 										"hostName": "vm2",
		// 										"netBiosName": "vm2",
		// 										"ntDomain": "",
		// 										"omsAgentID": "45b44640-3b94-4892-a28c-4a5cae27065a",
		// 										"operatingSystem": "Unknown",
		// 									},
		// 									Type: to.Ptr("host"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"name": "contosoUser",
		// 										"logonId": "0x61450d87",
		// 										"ntDomain": "vm2",
		// 										"sid": "S-1-5-21-2144575486-8928446540-5163864319-500",
		// 									},
		// 									Type: to.Ptr("account"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"name": "cmd.exe",
		// 										"directory": "c:\\windows\\system32",
		// 									},
		// 									Type: to.Ptr("file"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"processId": "0x3c44",
		// 									},
		// 									Type: to.Ptr("process"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"name": "scrsave.scr",
		// 										"directory": "c:\\users\\contosoUser",
		// 									},
		// 									Type: to.Ptr("file"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"commandLine": "c:\\users\\contosoUser\\scrsave.scr",
		// 										"creationTimeUtc": "2018-05-07T13:51:45.0045913Z",
		// 										"processId": "0x4aec",
		// 									},
		// 									Type: to.Ptr("process"),
		// 							}},
		// 							ExtendedLinks: []map[string]*string{
		// 								map[string]*string{
		// 									"Category": to.Ptr("threat_reports"),
		// 									"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
		// 									"Label": to.Ptr("Report: RDP Brute Forcing"),
		// 									"Type": to.Ptr("webLink"),
		// 							}},
		// 							ExtendedProperties: map[string]*string{
		// 								"account logon id": to.Ptr("0x61450d87"),
		// 								"command line": to.Ptr("c:\\users\\contosoUser\\scrsave.scr"),
		// 								"domain name": to.Ptr("vm2"),
		// 								"parent process": to.Ptr("cmd.exe"),
		// 								"parent process id": to.Ptr("0x3c44"),
		// 								"process id": to.Ptr("0x4aec"),
		// 								"process name": to.Ptr("c:\\users\\contosoUser\\scrsave.scr"),
		// 								"resourceType": to.Ptr("Virtual Machine"),
		// 								"user SID": to.Ptr("S-1-5-21-2144575486-8928446540-5163864319-500"),
		// 								"user name": to.Ptr("vm2\\contosoUser"),
		// 							},
		// 							Intent: to.Ptr(armsecurity.IntentExecution),
		// 							IsIncident: to.Ptr(true),
		// 							ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:48.981Z"); return t}()),
		// 							ProductComponentName: to.Ptr("testName2"),
		// 							ProductName: to.Ptr("Azure Security Center"),
		// 							RemediationSteps: []*string{
		// 								to.Ptr("1. Run Process Explorer and try to identify unknown running processes (see https://technet.microsoft.com/en-us/sysinternals/bb896653.aspx)"),
		// 								to.Ptr("2. Make sure the machine is completely updated and has an updated anti-malware application installed"),
		// 								to.Ptr("3. Run a full anti-malware scan and verify that the threat was removed"),
		// 								to.Ptr("4. Install and run Microsoft’s Malicious Software Removal Tool (see https://www.microsoft.com/en-us/download/malicious-software-removal-tool-details.aspx)"),
		// 								to.Ptr("5. Run Microsoft’s Autoruns utility and try to identify unknown applications that are configured to run at login (see https://technet.microsoft.com/en-us/sysinternals/bb963902.aspx)"),
		// 								to.Ptr("6. Escalate the alert to the information security team")},
		// 								ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
		// 									&armsecurity.AzureResourceIdentifier{
		// 										Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
		// 										AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
		// 									},
		// 									&armsecurity.LogAnalyticsIdentifier{
		// 										Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
		// 										AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
		// 										WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
		// 										WorkspaceResourceGroup: to.Ptr("myRg1"),
		// 										WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 								}},
		// 								Severity: to.Ptr(armsecurity.AlertSeverityMedium),
		// 								StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:45.004Z"); return t}()),
		// 								Status: to.Ptr(armsecurity.AlertStatusActive),
		// 								SubTechniques: []*string{
		// 									to.Ptr("T1059.001"),
		// 									to.Ptr("T1059.006"),
		// 									to.Ptr("T1053.002")},
		// 									SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
		// 										AdditionalProperties: map[string]any{
		// 											"supportingEvidenceList": []any{
		// 												map[string]any{
		// 													"type": "nestedList",
		// 													"evidenceElements":[]any{
		// 														map[string]any{
		// 															"type": "evidenceElement",
		// 															"innerElements": nil,
		// 															"text":map[string]any{
		// 																"arguments":map[string]any{
		// 																	"domainName":map[string]any{
		// 																		"type": "string",
		// 																		"value": "domainName",
		// 																	},
		// 																	"sensitiveEnumerationTypes":map[string]any{
		// 																		"type": "string[]",
		// 																		"value":[]any{
		// 																			"UseDesKey",
		// 																		},
		// 																	},
		// 																},
		// 																"fallback": "Actor enumerated UseDesKey on domain1.test.local",
		// 																"localizationKey": "AATP_ALERTS_LDAP_SENSITIVE_ATTRIBUTE_RECONNAISSANCE_SECURITY_ALERT_EVIDENCE_ENUMERATION_DETAIL_A7C00BD7",
		// 															},
		// 														},
		// 													},
		// 												},
		// 												map[string]any{
		// 													"type": "tabularEvidences",
		// 													"columns":[]any{
		// 														"Date",
		// 														"Activity",
		// 														"User",
		// 														"TestedText",
		// 														"TestedValue",
		// 													},
		// 													"rows":[]any{
		// 														[]any{
		// 															"2022-01-17T07:03:52.034Z",
		// 															"Log on",
		// 															"testUser",
		// 															"false",
		// 															false,
		// 														},
		// 														[]any{
		// 															"2022-01-17T07:03:52.034Z",
		// 															"Log on",
		// 															"testUser2",
		// 															"false",
		// 															false,
		// 														},
		// 														[]any{
		// 															"2022-01-17T07:03:52.034Z",
		// 															"Log on",
		// 															"testUser3",
		// 															"true",
		// 															true,
		// 														},
		// 													},
		// 													"title": "Investigate activity test",
		// 												},
		// 											},
		// 										},
		// 										Type: to.Ptr("supportingEvidenceList"),
		// 									},
		// 									SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 									Techniques: []*string{
		// 										to.Ptr("T1059"),
		// 										to.Ptr("T1053"),
		// 										to.Ptr("T1072")},
		// 										TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:48.381Z"); return t}()),
		// 										VendorName: to.Ptr("Microsoft"),
		// 										Version: to.Ptr("2022-01-01"),
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertsResourceGroup_example.json
func ExampleAlertsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAlertsClient().NewListByResourceGroupPager("myRg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AlertList = armsecurity.AlertList{
		// 	Value: []*armsecurity.Alert{
		// 		{
		// 			Name: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 			Type: to.Ptr("Microsoft.Security/Locations/alerts"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/alerts/2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA"),
		// 			Properties: &armsecurity.AlertProperties{
		// 				Description: to.Ptr("This is a test alert generated by Azure Security Center. No further action is needed."),
		// 				AlertDisplayName: to.Ptr("Azure Security Center test alert (not a threat)"),
		// 				AlertType: to.Ptr("VM_EICAR"),
		// 				AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
		// 				CompromisedEntity: to.Ptr("vm1"),
		// 				CorrelationKey: to.Ptr("kso0LFWxzCll5tqrk5hmrBJ+MY1BX806W6q6+0s9Lk="),
		// 				EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 				Entities: []*armsecurity.AlertEntity{
		// 					{
		// 						AdditionalProperties: map[string]any{
		// 							"address": "192.0.2.1",
		// 							"location": map[string]any{
		// 								"asn": float64(6584),
		// 								"city": "sonning",
		// 								"countryCode": "gb",
		// 								"latitude": float64(51.468),
		// 								"longitude": float64(-0.909),
		// 								"state": "wokingham",
		// 							},
		// 						},
		// 						Type: to.Ptr("ip"),
		// 				}},
		// 				ExtendedLinks: []map[string]*string{
		// 					map[string]*string{
		// 						"Category": to.Ptr("threat_reports"),
		// 						"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
		// 						"Label": to.Ptr("Report: RDP Brute Forcing"),
		// 						"Type": to.Ptr("webLink"),
		// 				}},
		// 				ExtendedProperties: map[string]*string{
		// 					"Property1": to.Ptr("Property1 information"),
		// 				},
		// 				Intent: to.Ptr(armsecurity.IntentExecution),
		// 				IsIncident: to.Ptr(true),
		// 				ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.920Z"); return t}()),
		// 				ProductComponentName: to.Ptr("testName"),
		// 				ProductName: to.Ptr("Azure Security Center"),
		// 				RemediationSteps: []*string{
		// 					to.Ptr("No further action is needed.")},
		// 					ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
		// 						&armsecurity.AzureResourceIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
		// 							AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
		// 						},
		// 						&armsecurity.LogAnalyticsIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
		// 							AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
		// 							WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
		// 							WorkspaceResourceGroup: to.Ptr("myRg1"),
		// 							WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 					}},
		// 					Severity: to.Ptr(armsecurity.AlertSeverityHigh),
		// 					StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 					Status: to.Ptr(armsecurity.AlertStatusActive),
		// 					SubTechniques: []*string{
		// 						to.Ptr("T1059.001"),
		// 						to.Ptr("T1059.006"),
		// 						to.Ptr("T1053.002")},
		// 						SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
		// 							AdditionalProperties: map[string]any{
		// 								"supportingEvidenceList": []any{
		// 									map[string]any{
		// 										"type": "nestedList",
		// 										"evidenceElements":[]any{
		// 											map[string]any{
		// 												"type": "evidenceElement",
		// 												"innerElements": nil,
		// 												"text":map[string]any{
		// 													"arguments":map[string]any{
		// 														"domainName":map[string]any{
		// 															"type": "string",
		// 															"value": "domainName",
		// 														},
		// 														"sensitiveEnumerationTypes":map[string]any{
		// 															"type": "string[]",
		// 															"value":[]any{
		// 																"UseDesKey",
		// 															},
		// 														},
		// 													},
		// 													"fallback": "Actor enumerated UseDesKey on domain1.test.local",
		// 													"localizationKey": "AATP_ALERTS_LDAP_SENSITIVE_ATTRIBUTE_RECONNAISSANCE_SECURITY_ALERT_EVIDENCE_ENUMERATION_DETAIL_A7C00BD7",
		// 												},
		// 											},
		// 										},
		// 									},
		// 									map[string]any{
		// 										"type": "tabularEvidences",
		// 										"columns":[]any{
		// 											"Date",
		// 											"Activity",
		// 											"User",
		// 											"TestedText",
		// 											"TestedValue",
		// 										},
		// 										"rows":[]any{
		// 											[]any{
		// 												"2022-01-17T07:03:52.034Z",
		// 												"Log on",
		// 												"testUser",
		// 												"false",
		// 												false,
		// 											},
		// 											[]any{
		// 												"2022-01-17T07:03:52.034Z",
		// 												"Log on",
		// 												"testUser2",
		// 												"false",
		// 												false,
		// 											},
		// 											[]any{
		// 												"2022-01-17T07:03:52.034Z",
		// 												"Log on",
		// 												"testUser3",
		// 												"true",
		// 												true,
		// 											},
		// 										},
		// 										"title": "Investigate activity test",
		// 									},
		// 								},
		// 							},
		// 							Type: to.Ptr("supportingEvidenceList"),
		// 						},
		// 						SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 						Techniques: []*string{
		// 							to.Ptr("T1059"),
		// 							to.Ptr("T1053"),
		// 							to.Ptr("T1072")},
		// 							TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.000Z"); return t}()),
		// 							VendorName: to.Ptr("Microsoft"),
		// 							Version: to.Ptr("2022-01-01"),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertsSubscriptionsLocation_example.json
func ExampleAlertsClient_NewListSubscriptionLevelByRegionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAlertsClient().NewListSubscriptionLevelByRegionPager("westeurope", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AlertList = armsecurity.AlertList{
		// 	Value: []*armsecurity.Alert{
		// 		{
		// 			Name: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 			Type: to.Ptr("Microsoft.Security/Locations/alerts"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/alerts/2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA"),
		// 			Properties: &armsecurity.AlertProperties{
		// 				Description: to.Ptr("This is a test alert generated by Azure Security Center. No further action is needed."),
		// 				AlertDisplayName: to.Ptr("Azure Security Center test alert (not a threat)"),
		// 				AlertType: to.Ptr("VM_EICAR"),
		// 				AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
		// 				CompromisedEntity: to.Ptr("vm1"),
		// 				CorrelationKey: to.Ptr("kso0LFWxzCll5tqrk5hmrBJ+MY1BX806W6q6+0s9Lk="),
		// 				EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 				Entities: []*armsecurity.AlertEntity{
		// 					{
		// 						AdditionalProperties: map[string]any{
		// 							"address": "192.0.2.1",
		// 							"location": map[string]any{
		// 								"asn": float64(6584),
		// 								"city": "sonning",
		// 								"countryCode": "gb",
		// 								"latitude": float64(51.468),
		// 								"longitude": float64(-0.909),
		// 								"state": "wokingham",
		// 							},
		// 						},
		// 						Type: to.Ptr("ip"),
		// 				}},
		// 				ExtendedLinks: []map[string]*string{
		// 					map[string]*string{
		// 						"Category": to.Ptr("threat_reports"),
		// 						"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
		// 						"Label": to.Ptr("Report: RDP Brute Forcing"),
		// 						"Type": to.Ptr("webLink"),
		// 				}},
		// 				ExtendedProperties: map[string]*string{
		// 					"Property1": to.Ptr("Property1 information"),
		// 				},
		// 				Intent: to.Ptr(armsecurity.IntentExecution),
		// 				IsIncident: to.Ptr(true),
		// 				ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.920Z"); return t}()),
		// 				ProductComponentName: to.Ptr("testName"),
		// 				ProductName: to.Ptr("Azure Security Center"),
		// 				RemediationSteps: []*string{
		// 					to.Ptr("No further action is needed.")},
		// 					ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
		// 						&armsecurity.AzureResourceIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
		// 							AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
		// 						},
		// 						&armsecurity.LogAnalyticsIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
		// 							AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
		// 							WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
		// 							WorkspaceResourceGroup: to.Ptr("myRg1"),
		// 							WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 					}},
		// 					Severity: to.Ptr(armsecurity.AlertSeverityHigh),
		// 					StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 					Status: to.Ptr(armsecurity.AlertStatusActive),
		// 					SubTechniques: []*string{
		// 						to.Ptr("T1059.001"),
		// 						to.Ptr("T1059.006"),
		// 						to.Ptr("T1053.002")},
		// 						SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
		// 							AdditionalProperties: map[string]any{
		// 								"columns": []any{
		// 									"Date",
		// 									"Activity",
		// 									"User",
		// 									"TestedText",
		// 									"TestedValue",
		// 								},
		// 								"rows": []any{
		// 									[]any{
		// 										"2022-01-17T07:03:52.034Z",
		// 										"Log on",
		// 										"testUser",
		// 										"false",
		// 										false,
		// 									},
		// 									[]any{
		// 										"2022-01-17T07:03:52.034Z",
		// 										"Log on",
		// 										"testUser2",
		// 										"false",
		// 										false,
		// 									},
		// 									[]any{
		// 										"2022-01-17T07:03:52.034Z",
		// 										"Log on",
		// 										"testUser3",
		// 										"true",
		// 										true,
		// 									},
		// 								},
		// 								"title": "Investigate activity test",
		// 							},
		// 							Type: to.Ptr("tabularEvidences"),
		// 						},
		// 						SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 						Techniques: []*string{
		// 							to.Ptr("T1059"),
		// 							to.Ptr("T1053"),
		// 							to.Ptr("T1072")},
		// 							TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.000Z"); return t}()),
		// 							VendorName: to.Ptr("Microsoft"),
		// 							Version: to.Ptr("2022-01-01"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22"),
		// 						Type: to.Ptr("Microsoft.Security/Locations/alerts"),
		// 						ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg2/providers/Microsoft.Security/locations/westeurope/alerts/2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22"),
		// 						Properties: &armsecurity.AlertProperties{
		// 							Description: to.Ptr("The process ‘c:\\users\\contosoUser\\scrsave.scr’ was observed executing from an uncommon location. Files with the .scr extensions are screen saver files and are normally reside and execute from the Windows system directory."),
		// 							AlertDisplayName: to.Ptr("Suspicious Screensaver process executed"),
		// 							AlertType: to.Ptr("VM_SuspiciousScreenSaver"),
		// 							AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
		// 							CompromisedEntity: to.Ptr("vm2"),
		// 							CorrelationKey: to.Ptr("4hno6LF0xzCl5tqrk4nrBW+MY1BX816W6q6+0srk4"),
		// 							EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:45.004Z"); return t}()),
		// 							Entities: []*armsecurity.AlertEntity{
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"OsVersion": nil,
		// 										"azureID": "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourcegroups/myRg2/providers/microsoft.compute/virtualmachines/vm2",
		// 										"dnsDomain": "",
		// 										"hostName": "vm2",
		// 										"netBiosName": "vm2",
		// 										"ntDomain": "",
		// 										"omsAgentID": "45b44640-3b94-4892-a28c-4a5cae27065a",
		// 										"operatingSystem": "Unknown",
		// 									},
		// 									Type: to.Ptr("host"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"name": "contosoUser",
		// 										"logonId": "0x61450d87",
		// 										"ntDomain": "vm2",
		// 										"sid": "S-1-5-21-2144575486-8928446540-5163864319-500",
		// 									},
		// 									Type: to.Ptr("account"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"name": "cmd.exe",
		// 										"directory": "c:\\windows\\system32",
		// 									},
		// 									Type: to.Ptr("file"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"processId": "0x3c44",
		// 									},
		// 									Type: to.Ptr("process"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"name": "scrsave.scr",
		// 										"directory": "c:\\users\\contosoUser",
		// 									},
		// 									Type: to.Ptr("file"),
		// 								},
		// 								{
		// 									AdditionalProperties: map[string]any{
		// 										"commandLine": "c:\\users\\contosoUser\\scrsave.scr",
		// 										"creationTimeUtc": "2018-05-07T13:51:45.0045913Z",
		// 										"processId": "0x4aec",
		// 									},
		// 									Type: to.Ptr("process"),
		// 							}},
		// 							ExtendedLinks: []map[string]*string{
		// 								map[string]*string{
		// 									"Category": to.Ptr("threat_reports"),
		// 									"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
		// 									"Label": to.Ptr("Report: RDP Brute Forcing"),
		// 									"Type": to.Ptr("webLink"),
		// 							}},
		// 							ExtendedProperties: map[string]*string{
		// 								"account logon id": to.Ptr("0x61450d87"),
		// 								"command line": to.Ptr("c:\\users\\contosoUser\\scrsave.scr"),
		// 								"domainName": to.Ptr("vm2"),
		// 								"parent process": to.Ptr("cmd.exe"),
		// 								"parent process id": to.Ptr("0x3c44"),
		// 								"process id": to.Ptr("0x4aec"),
		// 								"processName": to.Ptr("c:\\users\\contosoUser\\scrsave.scr"),
		// 								"resourceType": to.Ptr("Virtual Machine"),
		// 								"user SID": to.Ptr("S-1-5-21-2144575486-8928446540-5163864319-500"),
		// 								"userName": to.Ptr("vm2\\contosoUser"),
		// 							},
		// 							Intent: to.Ptr(armsecurity.IntentExecution),
		// 							IsIncident: to.Ptr(true),
		// 							ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:48.981Z"); return t}()),
		// 							ProductComponentName: to.Ptr("testName2"),
		// 							ProductName: to.Ptr("Azure Security Center"),
		// 							RemediationSteps: []*string{
		// 								to.Ptr("1. Run Process Explorer and try to identify unknown running processes (see https://technet.microsoft.com/en-us/sysinternals/bb896653.aspx)"),
		// 								to.Ptr("2. Make sure the machine is completely updated and has an updated anti-malware application installed"),
		// 								to.Ptr("3. Run a full anti-malware scan and verify that the threat was removed"),
		// 								to.Ptr("4. Install and run Microsoft’s Malicious Software Removal Tool (see https://www.microsoft.com/en-us/download/malicious-software-removal-tool-details.aspx)"),
		// 								to.Ptr("5. Run Microsoft’s Autoruns utility and try to identify unknown applications that are configured to run at login (see https://technet.microsoft.com/en-us/sysinternals/bb963902.aspx)"),
		// 								to.Ptr("6. Escalate the alert to the information security team")},
		// 								ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
		// 									&armsecurity.AzureResourceIdentifier{
		// 										Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
		// 										AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
		// 									},
		// 									&armsecurity.LogAnalyticsIdentifier{
		// 										Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
		// 										AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
		// 										WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
		// 										WorkspaceResourceGroup: to.Ptr("myRg1"),
		// 										WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 								}},
		// 								Severity: to.Ptr(armsecurity.AlertSeverityMedium),
		// 								StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:45.004Z"); return t}()),
		// 								Status: to.Ptr(armsecurity.AlertStatusActive),
		// 								SubTechniques: []*string{
		// 									to.Ptr("T1059.001"),
		// 									to.Ptr("T1059.006"),
		// 									to.Ptr("T1053.002")},
		// 									SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
		// 										AdditionalProperties: map[string]any{
		// 											"supportingEvidenceList": []any{
		// 												map[string]any{
		// 													"type": "nestedList",
		// 													"evidenceElements":[]any{
		// 														map[string]any{
		// 															"type": "evidenceElement",
		// 															"innerElements": nil,
		// 															"text":map[string]any{
		// 																"arguments":map[string]any{
		// 																	"domainName":map[string]any{
		// 																		"type": "string",
		// 																		"value": "domainName",
		// 																	},
		// 																	"sensitiveEnumerationTypes":map[string]any{
		// 																		"type": "string[]",
		// 																		"value":[]any{
		// 																			"UseDesKey",
		// 																		},
		// 																	},
		// 																},
		// 																"fallback": "Actor enumerated UseDesKey on domain1.test.local",
		// 																"localizationKey": "AATP_ALERTS_LDAP_SENSITIVE_ATTRIBUTE_RECONNAISSANCE_SECURITY_ALERT_EVIDENCE_ENUMERATION_DETAIL_A7C00BD7",
		// 															},
		// 														},
		// 													},
		// 												},
		// 												map[string]any{
		// 													"type": "tabularEvidences",
		// 													"columns":[]any{
		// 														"Date",
		// 														"Activity",
		// 														"User",
		// 														"TestedText",
		// 														"TestedValue",
		// 													},
		// 													"rows":[]any{
		// 														[]any{
		// 															"2022-01-17T07:03:52.034Z",
		// 															"Log on",
		// 															"testUser",
		// 															"false",
		// 															false,
		// 														},
		// 														[]any{
		// 															"2022-01-17T07:03:52.034Z",
		// 															"Log on",
		// 															"testUser2",
		// 															"false",
		// 															false,
		// 														},
		// 														[]any{
		// 															"2022-01-17T07:03:52.034Z",
		// 															"Log on",
		// 															"testUser3",
		// 															"true",
		// 															true,
		// 														},
		// 													},
		// 													"title": "Investigate activity test",
		// 												},
		// 											},
		// 										},
		// 										Type: to.Ptr("supportingEvidenceList"),
		// 									},
		// 									SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 									Techniques: []*string{
		// 										to.Ptr("T1059"),
		// 										to.Ptr("T1053"),
		// 										to.Ptr("T1072")},
		// 										TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-05-07T13:51:48.381Z"); return t}()),
		// 										VendorName: to.Ptr("Microsoft"),
		// 										Version: to.Ptr("2022-01-01"),
		// 									},
		// 							}},
		// 						}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertsResourceGroupLocation_example.json
func ExampleAlertsClient_NewListResourceGroupLevelByRegionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAlertsClient().NewListResourceGroupLevelByRegionPager("westeurope", "myRg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AlertList = armsecurity.AlertList{
		// 	Value: []*armsecurity.Alert{
		// 		{
		// 			Name: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 			Type: to.Ptr("Microsoft.Security/Locations/alerts"),
		// 			ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/alerts/2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA"),
		// 			Properties: &armsecurity.AlertProperties{
		// 				Description: to.Ptr("This is a test alert generated by Azure Security Center. No further action is needed."),
		// 				AlertDisplayName: to.Ptr("Azure Security Center test alert (not a threat)"),
		// 				AlertType: to.Ptr("VM_EICAR"),
		// 				AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
		// 				CompromisedEntity: to.Ptr("vm1"),
		// 				CorrelationKey: to.Ptr("kso0LFWxzCll5tqrk5hmrBJ+MY1BX806W6q6+0s9Lk="),
		// 				EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 				Entities: []*armsecurity.AlertEntity{
		// 					{
		// 						AdditionalProperties: map[string]any{
		// 							"address": "192.0.2.1",
		// 							"location": map[string]any{
		// 								"asn": float64(6584),
		// 								"city": "sonning",
		// 								"countryCode": "gb",
		// 								"latitude": float64(51.468),
		// 								"longitude": float64(-0.909),
		// 								"state": "wokingham",
		// 							},
		// 						},
		// 						Type: to.Ptr("ip"),
		// 				}},
		// 				ExtendedLinks: []map[string]*string{
		// 					map[string]*string{
		// 						"Category": to.Ptr("threat_reports"),
		// 						"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
		// 						"Label": to.Ptr("Report: RDP Brute Forcing"),
		// 						"Type": to.Ptr("webLink"),
		// 				}},
		// 				ExtendedProperties: map[string]*string{
		// 					"Property1": to.Ptr("Property1 information"),
		// 				},
		// 				Intent: to.Ptr(armsecurity.IntentExecution),
		// 				IsIncident: to.Ptr(true),
		// 				ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.920Z"); return t}()),
		// 				ProductComponentName: to.Ptr("testName"),
		// 				ProductName: to.Ptr("Azure Security Center"),
		// 				RemediationSteps: []*string{
		// 					to.Ptr("No further action is needed.")},
		// 					ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
		// 						&armsecurity.AzureResourceIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
		// 							AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
		// 						},
		// 						&armsecurity.LogAnalyticsIdentifier{
		// 							Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
		// 							AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
		// 							WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
		// 							WorkspaceResourceGroup: to.Ptr("myRg1"),
		// 							WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
		// 					}},
		// 					Severity: to.Ptr(armsecurity.AlertSeverityHigh),
		// 					StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
		// 					Status: to.Ptr(armsecurity.AlertStatusActive),
		// 					SubTechniques: []*string{
		// 						to.Ptr("T1059.001"),
		// 						to.Ptr("T1059.006"),
		// 						to.Ptr("T1053.002")},
		// 						SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
		// 							AdditionalProperties: map[string]any{
		// 								"supportingEvidenceList": []any{
		// 									map[string]any{
		// 										"type": "nestedList",
		// 										"evidenceElements":[]any{
		// 											map[string]any{
		// 												"type": "evidenceElement",
		// 												"innerElements": nil,
		// 												"text":map[string]any{
		// 													"arguments":map[string]any{
		// 														"domainName":map[string]any{
		// 															"type": "string",
		// 															"value": "domainName",
		// 														},
		// 														"sensitiveEnumerationTypes":map[string]any{
		// 															"type": "string[]",
		// 															"value":[]any{
		// 																"UseDesKey",
		// 															},
		// 														},
		// 													},
		// 													"fallback": "Actor enumerated UseDesKey on domain1.test.local",
		// 													"localizationKey": "AATP_ALERTS_LDAP_SENSITIVE_ATTRIBUTE_RECONNAISSANCE_SECURITY_ALERT_EVIDENCE_ENUMERATION_DETAIL_A7C00BD7",
		// 												},
		// 											},
		// 										},
		// 									},
		// 									map[string]any{
		// 										"type": "tabularEvidences",
		// 										"columns":[]any{
		// 											"Date",
		// 											"Activity",
		// 											"User",
		// 											"TestedText",
		// 											"TestedValue",
		// 										},
		// 										"rows":[]any{
		// 											[]any{
		// 												"2022-01-17T07:03:52.034Z",
		// 												"Log on",
		// 												"testUser",
		// 												"false",
		// 												false,
		// 											},
		// 											[]any{
		// 												"2022-01-17T07:03:52.034Z",
		// 												"Log on",
		// 												"testUser2",
		// 												"false",
		// 												false,
		// 											},
		// 											[]any{
		// 												"2022-01-17T07:03:52.034Z",
		// 												"Log on",
		// 												"testUser3",
		// 												"true",
		// 												true,
		// 											},
		// 										},
		// 										"title": "Investigate activity test",
		// 									},
		// 								},
		// 							},
		// 							Type: to.Ptr("supportingEvidenceList"),
		// 						},
		// 						SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
		// 						Techniques: []*string{
		// 							to.Ptr("T1059"),
		// 							to.Ptr("T1053"),
		// 							to.Ptr("T1072")},
		// 							TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.000Z"); return t}()),
		// 							VendorName: to.Ptr("Microsoft"),
		// 							Version: to.Ptr("2022-01-01"),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertSubscriptionLocation_example.json
func ExampleAlertsClient_GetSubscriptionLevel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().GetSubscriptionLevel(ctx, "westeurope", "2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Alert = armsecurity.Alert{
	// 	Name: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
	// 	Type: to.Ptr("Microsoft.Security/Locations/alerts"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/alerts/2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA"),
	// 	Properties: &armsecurity.AlertProperties{
	// 		Description: to.Ptr("This is a test alert generated by Azure Security Center. No further action is needed."),
	// 		AlertDisplayName: to.Ptr("Azure Security Center test alert (not a threat)"),
	// 		AlertType: to.Ptr("VM_EICAR"),
	// 		AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
	// 		CompromisedEntity: to.Ptr("vm1"),
	// 		CorrelationKey: to.Ptr("kso0LFWxzCll5tqrk5hmrBJ+MY1BX806W6q6+0s9Lk="),
	// 		EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
	// 		Entities: []*armsecurity.AlertEntity{
	// 			{
	// 				AdditionalProperties: map[string]any{
	// 					"address": "192.0.2.1",
	// 					"location": map[string]any{
	// 						"asn": float64(6584),
	// 						"city": "sonning",
	// 						"countryCode": "gb",
	// 						"latitude": float64(51.468),
	// 						"longitude": float64(-0.909),
	// 						"state": "wokingham",
	// 					},
	// 				},
	// 				Type: to.Ptr("ip"),
	// 		}},
	// 		ExtendedLinks: []map[string]*string{
	// 			map[string]*string{
	// 				"Category": to.Ptr("threat_reports"),
	// 				"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
	// 				"Label": to.Ptr("Report: RDP Brute Forcing"),
	// 				"Type": to.Ptr("webLink"),
	// 		}},
	// 		ExtendedProperties: map[string]*string{
	// 			"Property1": to.Ptr("Property1 information"),
	// 		},
	// 		Intent: to.Ptr(armsecurity.IntentExecution),
	// 		IsIncident: to.Ptr(true),
	// 		ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.920Z"); return t}()),
	// 		ProductComponentName: to.Ptr("testName"),
	// 		ProductName: to.Ptr("Azure Security Center"),
	// 		RemediationSteps: []*string{
	// 			to.Ptr("No further action is needed.")},
	// 			ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
	// 				&armsecurity.AzureResourceIdentifier{
	// 					Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
	// 					AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
	// 				},
	// 				&armsecurity.LogAnalyticsIdentifier{
	// 					Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
	// 					AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
	// 					WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
	// 					WorkspaceResourceGroup: to.Ptr("myRg1"),
	// 					WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
	// 			}},
	// 			Severity: to.Ptr(armsecurity.AlertSeverityHigh),
	// 			StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
	// 			Status: to.Ptr(armsecurity.AlertStatusActive),
	// 			SubTechniques: []*string{
	// 				to.Ptr("T1059.001"),
	// 				to.Ptr("T1059.006"),
	// 				to.Ptr("T1053.002")},
	// 				SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
	// 					AdditionalProperties: map[string]any{
	// 						"columns": []any{
	// 							"Date",
	// 							"Activity",
	// 							"User",
	// 							"TestedText",
	// 							"TestedValue",
	// 						},
	// 						"rows": []any{
	// 							[]any{
	// 								"2022-01-17T07:03:52.034Z",
	// 								"Log on",
	// 								"testUser",
	// 								"false",
	// 								false,
	// 							},
	// 							[]any{
	// 								"2022-01-17T07:03:52.034Z",
	// 								"Log on",
	// 								"testUser2",
	// 								"false",
	// 								false,
	// 							},
	// 							[]any{
	// 								"2022-01-17T07:03:52.034Z",
	// 								"Log on",
	// 								"testUser3",
	// 								"true",
	// 								true,
	// 							},
	// 						},
	// 						"title": "Investigate activity test",
	// 					},
	// 					Type: to.Ptr("tabularEvidences"),
	// 				},
	// 				SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
	// 				Techniques: []*string{
	// 					to.Ptr("T1059"),
	// 					to.Ptr("T1053"),
	// 					to.Ptr("T1072")},
	// 					TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.000Z"); return t}()),
	// 					VendorName: to.Ptr("Microsoft"),
	// 					Version: to.Ptr("2022-01-01"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/GetAlertResourceGroupLocation_example.json
func ExampleAlertsClient_GetResourceGroupLevel() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAlertsClient().GetResourceGroupLevel(ctx, "myRg1", "westeurope", "2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Alert = armsecurity.Alert{
	// 	Name: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
	// 	Type: to.Ptr("Microsoft.Security/Locations/alerts"),
	// 	ID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Security/locations/westeurope/alerts/2518770965529163669_F144EE95-A3E5-42DA-A279-967D115809AA"),
	// 	Properties: &armsecurity.AlertProperties{
	// 		Description: to.Ptr("This is a test alert generated by Azure Security Center. No further action is needed."),
	// 		AlertDisplayName: to.Ptr("Azure Security Center test alert (not a threat)"),
	// 		AlertType: to.Ptr("VM_EICAR"),
	// 		AlertURI: to.Ptr("https://portal.azure.com/#blade/Microsoft_Azure_Security/AlertBlade/alertId/2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a/subscriptionId/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroup/myRg1/referencedFrom/alertDeepLink/location/westeurope"),
	// 		CompromisedEntity: to.Ptr("vm1"),
	// 		CorrelationKey: to.Ptr("kso0LFWxzCll5tqrk5hmrBJ+MY1BX806W6q6+0s9Lk="),
	// 		EndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
	// 		Entities: []*armsecurity.AlertEntity{
	// 			{
	// 				AdditionalProperties: map[string]any{
	// 					"address": "192.0.2.1",
	// 					"location": map[string]any{
	// 						"asn": float64(6584),
	// 						"city": "sonning",
	// 						"countryCode": "gb",
	// 						"latitude": float64(51.468),
	// 						"longitude": float64(-0.909),
	// 						"state": "wokingham",
	// 					},
	// 				},
	// 				Type: to.Ptr("ip"),
	// 		}},
	// 		ExtendedLinks: []map[string]*string{
	// 			map[string]*string{
	// 				"Category": to.Ptr("threat_reports"),
	// 				"Href": to.Ptr("https://contoso.com/reports/DisplayReport"),
	// 				"Label": to.Ptr("Report: RDP Brute Forcing"),
	// 				"Type": to.Ptr("webLink"),
	// 		}},
	// 		ExtendedProperties: map[string]*string{
	// 			"Property1": to.Ptr("Property1 information"),
	// 		},
	// 		Intent: to.Ptr(armsecurity.IntentExecution),
	// 		IsIncident: to.Ptr(true),
	// 		ProcessingEndTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.920Z"); return t}()),
	// 		ProductComponentName: to.Ptr("testName"),
	// 		ProductName: to.Ptr("Azure Security Center"),
	// 		RemediationSteps: []*string{
	// 			to.Ptr("No further action is needed.")},
	// 			ResourceIdentifiers: []armsecurity.ResourceIdentifierClassification{
	// 				&armsecurity.AzureResourceIdentifier{
	// 					Type: to.Ptr(armsecurity.ResourceIdentifierTypeAzureResource),
	// 					AzureResourceID: to.Ptr("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
	// 				},
	// 				&armsecurity.LogAnalyticsIdentifier{
	// 					Type: to.Ptr(armsecurity.ResourceIdentifierTypeLogAnalytics),
	// 					AgentID: to.Ptr("75724a01-f021-4aa8-9ec2-329792373e6e"),
	// 					WorkspaceID: to.Ptr("f419f624-acad-4d89-b86d-f62fa387f019"),
	// 					WorkspaceResourceGroup: to.Ptr("myRg1"),
	// 					WorkspaceSubscriptionID: to.Ptr("20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
	// 			}},
	// 			Severity: to.Ptr(armsecurity.AlertSeverityHigh),
	// 			StartTimeUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-22T00:00:00.000Z"); return t}()),
	// 			Status: to.Ptr(armsecurity.AlertStatusActive),
	// 			SubTechniques: []*string{
	// 				to.Ptr("T1059.001"),
	// 				to.Ptr("T1059.006"),
	// 				to.Ptr("T1053.002")},
	// 				SupportingEvidence: &armsecurity.AlertPropertiesSupportingEvidence{
	// 					AdditionalProperties: map[string]any{
	// 						"supportingEvidenceList": []any{
	// 							map[string]any{
	// 								"type": "nestedList",
	// 								"evidenceElements":[]any{
	// 									map[string]any{
	// 										"type": "evidenceElement",
	// 										"innerElements": nil,
	// 										"text":map[string]any{
	// 											"arguments":map[string]any{
	// 												"domainName":map[string]any{
	// 													"type": "string",
	// 													"value": "domainName",
	// 												},
	// 												"sensitiveEnumerationTypes":map[string]any{
	// 													"type": "string[]",
	// 													"value":[]any{
	// 														"UseDesKey",
	// 													},
	// 												},
	// 											},
	// 											"fallback": "Actor enumerated UseDesKey on domain1.test.local",
	// 											"localizationKey": "AATP_ALERTS_LDAP_SENSITIVE_ATTRIBUTE_RECONNAISSANCE_SECURITY_ALERT_EVIDENCE_ENUMERATION_DETAIL_A7C00BD7",
	// 										},
	// 									},
	// 								},
	// 							},
	// 							map[string]any{
	// 								"type": "tabularEvidences",
	// 								"columns":[]any{
	// 									"Date",
	// 									"Activity",
	// 									"User",
	// 									"TestedText",
	// 									"TestedValue",
	// 								},
	// 								"rows":[]any{
	// 									[]any{
	// 										"2022-01-17T07:03:52.034Z",
	// 										"Log on",
	// 										"testUser",
	// 										"false",
	// 										false,
	// 									},
	// 									[]any{
	// 										"2022-01-17T07:03:52.034Z",
	// 										"Log on",
	// 										"testUser2",
	// 										"false",
	// 										false,
	// 									},
	// 									[]any{
	// 										"2022-01-17T07:03:52.034Z",
	// 										"Log on",
	// 										"testUser3",
	// 										"true",
	// 										true,
	// 									},
	// 								},
	// 								"title": "Investigate activity test",
	// 							},
	// 						},
	// 					},
	// 					Type: to.Ptr("supportingEvidenceList"),
	// 				},
	// 				SystemAlertID: to.Ptr("2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a"),
	// 				Techniques: []*string{
	// 					to.Ptr("T1059"),
	// 					to.Ptr("T1053"),
	// 					to.Ptr("T1072")},
	// 					TimeGeneratedUTC: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-02-23T13:47:58.000Z"); return t}()),
	// 					VendorName: to.Ptr("Microsoft"),
	// 					Version: to.Ptr("2022-01-01"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertSubscriptionLocation_dismiss_example.json
func ExampleAlertsClient_UpdateSubscriptionLevelStateToDismiss() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateSubscriptionLevelStateToDismiss(ctx, "westeurope", "2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertSubscriptionLocation_resolve_example.json
func ExampleAlertsClient_UpdateSubscriptionLevelStateToResolve() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateSubscriptionLevelStateToResolve(ctx, "westeurope", "2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertSubscriptionLocation_activate_example.json
func ExampleAlertsClient_UpdateSubscriptionLevelStateToActivate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateSubscriptionLevelStateToActivate(ctx, "westeurope", "2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertSubscriptionLocation_inProgress_example.json
func ExampleAlertsClient_UpdateSubscriptionLevelStateToInProgress() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateSubscriptionLevelStateToInProgress(ctx, "westeurope", "2518298467986649999_4d25bfef-2d77-4a08-adc0-3e35715cc92a", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_resolve_example.json
func ExampleAlertsClient_UpdateResourceGroupLevelStateToResolve() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateResourceGroupLevelStateToResolve(ctx, "myRg2", "westeurope", "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_dismiss_example.json
func ExampleAlertsClient_UpdateResourceGroupLevelStateToDismiss() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateResourceGroupLevelStateToDismiss(ctx, "myRg2", "westeurope", "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_activate_example.json
func ExampleAlertsClient_UpdateResourceGroupLevelStateToActivate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateResourceGroupLevelStateToActivate(ctx, "myRg2", "westeurope", "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/UpdateAlertResourceGroupLocation_inProgress_example.json
func ExampleAlertsClient_UpdateResourceGroupLevelStateToInProgress() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAlertsClient().UpdateResourceGroupLevelStateToInProgress(ctx, "myRg2", "westeurope", "2518765996949954086_2325cf9e-42a2-4f72-ae7f-9b863cba2d22", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b43974e07d3204c4b6f8396627f5430994a7f7c9/specification/security/resource-manager/Microsoft.Security/stable/2022-01-01/examples/Alerts/SimulateAlerts_example.json
func ExampleAlertsClient_BeginSimulate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAlertsClient().BeginSimulate(ctx, "centralus", armsecurity.AlertSimulatorRequestBody{
		Properties: &armsecurity.AlertSimulatorBundlesRequestProperties{
			Kind: to.Ptr(armsecurity.KindBundles),
			Bundles: []*armsecurity.BundleType{
				to.Ptr(armsecurity.BundleTypeAppServices),
				to.Ptr(armsecurity.BundleTypeDNS),
				to.Ptr(armsecurity.BundleTypeKeyVaults),
				to.Ptr(armsecurity.BundleTypeKubernetesService),
				to.Ptr(armsecurity.BundleTypeResourceManager),
				to.Ptr(armsecurity.BundleTypeSQLServers),
				to.Ptr(armsecurity.BundleTypeStorageAccounts),
				to.Ptr(armsecurity.BundleTypeVirtualMachines),
				to.Ptr(armsecurity.BundleTypeCosmosDbs)},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
