//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesdatareplication

import "time"

// AzStackHCIClusterProperties - AzStackHCI cluster properties.
type AzStackHCIClusterProperties struct {
	// REQUIRED; Gets or sets the AzStackHCICluster FQDN name.
	ClusterName *string

	// REQUIRED; Gets or sets the AzStackHCICluster resource name.
	ResourceName *string

	// REQUIRED; Gets or sets the Storage account name.
	StorageAccountName *string

	// REQUIRED; Gets or sets the list of AzStackHCICluster Storage Container.
	StorageContainers []*StorageContainerProperties
}

// AzStackHCIFabricModelCustomProperties - AzStackHCI fabric model custom properties.
type AzStackHCIFabricModelCustomProperties struct {
	// REQUIRED; Gets or sets the ARM Id of the AzStackHCI site.
	AzStackHciSiteID *string

	// REQUIRED; AzStackHCI cluster properties.
	Cluster *AzStackHCIClusterProperties

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the Migration solution ARM Id.
	MigrationSolutionID *string

	// READ-ONLY; Gets or sets the Appliance name.
	ApplianceName []*string

	// READ-ONLY; Gets or sets the fabric container Id.
	FabricContainerID *string

	// READ-ONLY; Gets or sets the fabric resource Id.
	FabricResourceID *string

	// READ-ONLY; Gets or sets the migration hub Uri.
	MigrationHubURI *string
}

// GetFabricModelCustomProperties implements the FabricModelCustomPropertiesClassification interface for type AzStackHCIFabricModelCustomProperties.
func (a *AzStackHCIFabricModelCustomProperties) GetFabricModelCustomProperties() *FabricModelCustomProperties {
	return &FabricModelCustomProperties{
		InstanceType: a.InstanceType,
	}
}

// CheckNameAvailabilityModel - Check name availability model.
type CheckNameAvailabilityModel struct {
	// Gets or sets the resource name.
	Name *string

	// Gets or sets the resource type.
	Type *string
}

// CheckNameAvailabilityResponseModel - Check name availability response model.
type CheckNameAvailabilityResponseModel struct {
	// Gets or sets the message for resource name unavailability.
	Message *string

	// Gets or sets a value indicating whether resource name is available or not.
	NameAvailable *bool

	// Gets or sets the reason for resource name unavailability.
	Reason *string
}

// DeploymentPreflightModel - Deployment preflight model.
type DeploymentPreflightModel struct {
	// Gets or sets the list of resources.
	Resources []*DeploymentPreflightResource
}

// DeploymentPreflightResource - Deployment preflight resource.
type DeploymentPreflightResource struct {
	// Gets or sets the Api version.
	APIVersion *string

	// Gets or sets the location of the resource.
	Location *string

	// Gets or sets the resource name.
	Name *string

	// Gets or sets the resource type.
	Type *string
}

// DraModel - Dra model.
type DraModel struct {
	// REQUIRED; Dra model properties.
	Properties *DraModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *DraModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// DraModelCollection - Dra model collection.
type DraModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of Dras.
	Value []*DraModel
}

// DraModelCustomProperties - Dra model custom properties.
type DraModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetDraModelCustomProperties implements the DraModelCustomPropertiesClassification interface for type DraModelCustomProperties.
func (d *DraModelCustomProperties) GetDraModelCustomProperties() *DraModelCustomProperties { return d }

// DraModelProperties - Dra model properties.
type DraModelProperties struct {
	// REQUIRED; Identity model.
	AuthenticationIdentity *IdentityModel

	// REQUIRED; Dra model custom properties.
	CustomProperties DraModelCustomPropertiesClassification

	// REQUIRED; Gets or sets the machine Id where Dra is running.
	MachineID *string

	// REQUIRED; Gets or sets the machine name where Dra is running.
	MachineName *string

	// REQUIRED; Identity model.
	ResourceAccessIdentity *IdentityModel

	// READ-ONLY; Gets or sets the Dra correlation Id.
	CorrelationID *string

	// READ-ONLY; Gets or sets the list of health errors.
	HealthErrors []*HealthErrorModel

	// READ-ONLY; Gets or sets a value indicating whether Dra is responsive.
	IsResponsive *bool

	// READ-ONLY; Gets or sets the time when last heartbeat was sent by the Dra.
	LastHeartbeat *time.Time

	// READ-ONLY; Gets or sets the provisioning state of the Dra.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets the Dra version.
	VersionNumber *string
}

type DraModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// EmailConfigurationModel - Email configuration model.
type EmailConfigurationModel struct {
	// REQUIRED; Email configuration model properties.
	Properties *EmailConfigurationModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *EmailConfigurationModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// EmailConfigurationModelCollection - Email configuration model collection.
type EmailConfigurationModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of email configurations.
	Value []*EmailConfigurationModel
}

// EmailConfigurationModelProperties - Email configuration model properties.
type EmailConfigurationModelProperties struct {
	// REQUIRED; Gets or sets a value indicating whether to send email to subscription administrator.
	SendToOwners *bool

	// Gets or sets the custom email address for sending emails.
	CustomEmailAddresses []*string

	// Gets or sets the locale for the email notification.
	Locale *string
}

type EmailConfigurationModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// ErrorModel - Error model.
type ErrorModel struct {
	// READ-ONLY; Gets or sets the possible causes of error.
	Causes *string

	// READ-ONLY; Gets or sets the error code.
	Code *string

	// READ-ONLY; Gets or sets the creation time of error.
	CreationTime *time.Time

	// READ-ONLY; Gets or sets the error message.
	Message *string

	// READ-ONLY; Gets or sets the recommended action to resolve error.
	Recommendation *string

	// READ-ONLY; Gets or sets the error severity.
	Severity *string

	// READ-ONLY; Gets or sets the error type.
	Type *string
}

// EventModel - Event model.
type EventModel struct {
	// REQUIRED; Event model properties.
	Properties *EventModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *EventModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// EventModelCollection - Event model collection.
type EventModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of events.
	Value []*EventModel
}

// EventModelCustomProperties - Event model custom properties.
type EventModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetEventModelCustomProperties implements the EventModelCustomPropertiesClassification interface for type EventModelCustomProperties.
func (e *EventModelCustomProperties) GetEventModelCustomProperties() *EventModelCustomProperties {
	return e
}

// EventModelProperties - Event model properties.
type EventModelProperties struct {
	// REQUIRED; Event model custom properties.
	CustomProperties EventModelCustomPropertiesClassification

	// READ-ONLY; Gets or sets the event correlation Id.
	CorrelationID *string

	// READ-ONLY; Gets or sets the event description.
	Description *string

	// READ-ONLY; Gets or sets the event name.
	EventName *string

	// READ-ONLY; Gets or sets the event type.
	EventType *string

	// READ-ONLY; Gets or sets the errors associated with this event.
	HealthErrors []*HealthErrorModel

	// READ-ONLY; Gets or sets the resource name.
	ResourceName *string

	// READ-ONLY; Gets or sets the resource type.
	ResourceType *string

	// READ-ONLY; Gets or sets the event severity.
	Severity *string

	// READ-ONLY; Gets or sets the time at which the event occurred at source.
	TimeOfOccurrence *time.Time
}

type EventModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// FabricModel - Fabric model.
type FabricModel struct {
	// REQUIRED; Gets or sets the location of the fabric.
	Location *string

	// REQUIRED; Fabric model properties.
	Properties *FabricModelProperties

	// Gets or sets the resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *FabricModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// FabricModelCollection - Fabric model collection.
type FabricModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of fabrics.
	Value []*FabricModel
}

// FabricModelCustomProperties - Fabric model custom properties.
type FabricModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetFabricModelCustomProperties implements the FabricModelCustomPropertiesClassification interface for type FabricModelCustomProperties.
func (f *FabricModelCustomProperties) GetFabricModelCustomProperties() *FabricModelCustomProperties {
	return f
}

// FabricModelProperties - Fabric model properties.
type FabricModelProperties struct {
	// REQUIRED; Fabric model custom properties.
	CustomProperties FabricModelCustomPropertiesClassification

	// READ-ONLY; Gets or sets the fabric health.
	Health *HealthStatus

	// READ-ONLY; Gets or sets the list of health errors.
	HealthErrors []*HealthErrorModel

	// READ-ONLY; Gets or sets the provisioning state of the fabric.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets the service endpoint.
	ServiceEndpoint *string

	// READ-ONLY; Gets or sets the service resource Id.
	ServiceResourceID *string
}

type FabricModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// FabricModelUpdate - Fabric model for update.
type FabricModelUpdate struct {
	// Fabric model properties.
	Properties *FabricModelProperties

	// Gets or sets the resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *FabricModelUpdateSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

type FabricModelUpdateSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// FailoverProtectedItemProperties - Failover properties of the protected item.
type FailoverProtectedItemProperties struct {
	// READ-ONLY; Gets or sets the network name.
	NetworkName *string

	// READ-ONLY; Gets or sets the protected item name.
	ProtectedItemName *string

	// READ-ONLY; Gets or sets the recovery point Id.
	RecoveryPointID *string

	// READ-ONLY; Gets or sets the recovery point time.
	RecoveryPointTime *time.Time

	// READ-ONLY; Gets or sets the network subnet.
	Subnet *string

	// READ-ONLY; Gets or sets the test VM name.
	TestVMName *string

	// READ-ONLY; Gets or sets the VM name.
	VMName *string
}

// FailoverWorkflowModelCustomProperties - Failover workflow model custom properties.
type FailoverWorkflowModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// READ-ONLY; Gets or sets any custom properties of the affected object.
	AffectedObjectDetails map[string]*string

	// READ-ONLY; Gets or sets the failed over protected item details.
	ProtectedItemDetails []*FailoverProtectedItemProperties
}

// GetWorkflowModelCustomProperties implements the WorkflowModelCustomPropertiesClassification interface for type FailoverWorkflowModelCustomProperties.
func (f *FailoverWorkflowModelCustomProperties) GetWorkflowModelCustomProperties() *WorkflowModelCustomProperties {
	return &WorkflowModelCustomProperties{
		AffectedObjectDetails: f.AffectedObjectDetails,
		InstanceType:          f.InstanceType,
	}
}

// HealthErrorModel - Health error model.
type HealthErrorModel struct {
	// Gets or sets the list of affected resource correlation Ids. This can be used to uniquely identify the count of items affected
	// by a specific category and severity as well as count of item affected by
	// an specific issue.
	AffectedResourceCorrelationIDs []*string

	// Gets or sets the type of affected resource type.
	AffectedResourceType *string

	// Gets or sets a list of child health errors associated with this error.
	ChildErrors []*InnerHealthErrorModel

	// READ-ONLY; Gets or sets the error category.
	Category *string

	// READ-ONLY; Gets or sets possible causes of the error.
	Causes *string

	// READ-ONLY; Gets or sets the error code.
	Code *string

	// READ-ONLY; Gets or sets the error creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets or sets the health category.
	HealthCategory *string

	// READ-ONLY; Gets or sets a value indicating whether the error is customer resolvable.
	IsCustomerResolvable *bool

	// READ-ONLY; Gets or sets the error message.
	Message *string

	// READ-ONLY; Gets or sets recommended action to resolve the error.
	Recommendation *string

	// READ-ONLY; Gets or sets the error severity.
	Severity *string

	// READ-ONLY; Gets or sets the error source.
	Source *string

	// READ-ONLY; Gets or sets the error summary.
	Summary *string
}

// HyperVMigrateFabricModelCustomProperties - HyperV migrate fabric model custom properties.
type HyperVMigrateFabricModelCustomProperties struct {
	// REQUIRED; Gets or sets the ARM Id of the HyperV site.
	HyperVSiteID *string

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the migration solution ARM Id.
	MigrationSolutionID *string

	// READ-ONLY; Gets or sets the fabric container Id.
	FabricContainerID *string

	// READ-ONLY; Gets or sets the fabric resource Id.
	FabricResourceID *string

	// READ-ONLY; Gets or sets the migration hub Uri.
	MigrationHubURI *string
}

// GetFabricModelCustomProperties implements the FabricModelCustomPropertiesClassification interface for type HyperVMigrateFabricModelCustomProperties.
func (h *HyperVMigrateFabricModelCustomProperties) GetFabricModelCustomProperties() *FabricModelCustomProperties {
	return &FabricModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// HyperVToAzStackHCIDiskInput - HyperVToAzStack disk input.
type HyperVToAzStackHCIDiskInput struct {
	// REQUIRED; Gets or sets the type of the virtual hard disk, vhd or vhdx.
	DiskFileFormat *string

	// REQUIRED; Gets or sets the disk Id.
	DiskID *string

	// REQUIRED; Gets or sets the disk size in GB.
	DiskSizeGB *int64

	// REQUIRED; Gets or sets a value indicating whether disk is os disk.
	IsOsDisk *bool

	// Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk.
	IsDynamic *bool

	// Gets or sets the target storage account ARM Id.
	StorageContainerID *string
}

// HyperVToAzStackHCIEventModelCustomProperties - HyperV to AzStackHCI event model custom properties. This class provides
// provider specific details for events of type DataContract.HealthEvents.HealthEventType.ProtectedItemHealth and
// DataContract.HealthEvents.HealthEventType.AgentHealth.
type HyperVToAzStackHCIEventModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// READ-ONLY; Gets or sets the friendly name of the source which has raised this health event.
	EventSourceFriendlyName *string

	// READ-ONLY; Gets or sets the protected item friendly name.
	ProtectedItemFriendlyName *string

	// READ-ONLY; Gets or sets the server type.
	ServerType *string

	// READ-ONLY; Gets or sets the source appliance name.
	SourceApplianceName *string

	// READ-ONLY; Gets or sets the source target name.
	TargetApplianceName *string
}

// GetEventModelCustomProperties implements the EventModelCustomPropertiesClassification interface for type HyperVToAzStackHCIEventModelCustomProperties.
func (h *HyperVToAzStackHCIEventModelCustomProperties) GetEventModelCustomProperties() *EventModelCustomProperties {
	return &EventModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// HyperVToAzStackHCINicInput - HyperVToAzStackHCI NIC properties.
type HyperVToAzStackHCINicInput struct {
	// REQUIRED; Gets or sets the NIC Id.
	NicID *string

	// REQUIRED; Gets or sets the selection type of the NIC.
	SelectionTypeForFailover *VMNicSelection

	// REQUIRED; Gets or sets the target network Id within AzStackHCI Cluster.
	TargetNetworkID *string

	// REQUIRED; Gets or sets the target test network Id within AzStackHCI Cluster.
	TestNetworkID *string

	// READ-ONLY; Gets or sets the network name.
	NetworkName *string
}

// HyperVToAzStackHCIPlannedFailoverModelCustomProperties - HyperV to AzStackHCI planned failover model custom properties.
type HyperVToAzStackHCIPlannedFailoverModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets a value indicating whether VM needs to be shut down.
	ShutdownSourceVM *bool
}

// GetPlannedFailoverModelCustomProperties implements the PlannedFailoverModelCustomPropertiesClassification interface for
// type HyperVToAzStackHCIPlannedFailoverModelCustomProperties.
func (h *HyperVToAzStackHCIPlannedFailoverModelCustomProperties) GetPlannedFailoverModelCustomProperties() *PlannedFailoverModelCustomProperties {
	return &PlannedFailoverModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// HyperVToAzStackHCIPolicyModelCustomProperties - HyperV To AzStackHCI Policy model custom properties.
type HyperVToAzStackHCIPolicyModelCustomProperties struct {
	// REQUIRED; Gets or sets the app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// REQUIRED; Gets or sets the crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32
}

// GetPolicyModelCustomProperties implements the PolicyModelCustomPropertiesClassification interface for type HyperVToAzStackHCIPolicyModelCustomProperties.
func (h *HyperVToAzStackHCIPolicyModelCustomProperties) GetPolicyModelCustomProperties() *PolicyModelCustomProperties {
	return &PolicyModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// HyperVToAzStackHCIProtectedDiskProperties - HyperVToAzStackHCI protected disk properties.
type HyperVToAzStackHCIProtectedDiskProperties struct {
	// READ-ONLY; Gets or sets the disk capacity in bytes.
	CapacityInBytes *int64

	// READ-ONLY; Gets or sets the disk type.
	DiskType *string

	// READ-ONLY; Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk.
	IsDynamic *bool

	// READ-ONLY; Gets or sets a value indicating whether the disk is the OS disk.
	IsOsDisk *bool

	// READ-ONLY; Gets or sets the failover clone disk.
	MigrateDiskName *string

	// READ-ONLY; Gets or sets the seed disk name.
	SeedDiskName *string

	// READ-ONLY; Gets or sets the source disk Id.
	SourceDiskID *string

	// READ-ONLY; Gets or sets the source disk Name.
	SourceDiskName *string

	// READ-ONLY; Gets or sets the ARM Id of the storage container.
	StorageContainerID *string

	// READ-ONLY; Gets or sets the local path of the storage container.
	StorageContainerLocalPath *string

	// READ-ONLY; Gets or sets the test failover clone disk.
	TestMigrateDiskName *string
}

// HyperVToAzStackHCIProtectedItemModelCustomProperties - HyperV to AzStackHCI Protected item model custom properties.
type HyperVToAzStackHCIProtectedItemModelCustomProperties struct {
	// REQUIRED; Gets or sets the location of Azure Arc HCI custom location resource.
	CustomLocationRegion *string

	// REQUIRED; Gets or sets the list of disks to replicate.
	DisksToInclude []*HyperVToAzStackHCIDiskInput

	// REQUIRED; Gets or sets the ARM Id of the discovered machine.
	FabricDiscoveryMachineID *string

	// REQUIRED; Gets or sets the hypervisor generation of the virtual machine.
	HyperVGeneration *string

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the list of VM NIC to replicate.
	NicsToInclude []*HyperVToAzStackHCINicInput

	// REQUIRED; Gets or sets the Run As account Id.
	RunAsAccountID *string

	// REQUIRED; Gets or sets the source DRA name.
	SourceDraName *string

	// REQUIRED; Gets or sets the target storage container ARM Id.
	StorageContainerID *string

	// REQUIRED; Gets or sets the Target Arc Cluster Custom Location ARM Id.
	TargetArcClusterCustomLocationID *string

	// REQUIRED; Gets or sets the target DRA name.
	TargetDraName *string

	// REQUIRED; Gets or sets the Target HCI Cluster ARM Id.
	TargetHciClusterID *string

	// REQUIRED; Gets or sets the target resource group ARM Id.
	TargetResourceGroupID *string

	// Protected item dynamic memory config.
	DynamicMemoryConfig *ProtectedItemDynamicMemoryConfig

	// Gets or sets a value indicating whether memory is dynamical.
	IsDynamicRAM *bool

	// Gets or sets the target CPU cores.
	TargetCPUCores *int32

	// Gets or sets the target memory in mega-bytes.
	TargetMemoryInMegaBytes *int32

	// Gets or sets the target network Id within AzStackHCI Cluster.
	TargetNetworkID *string

	// Gets or sets the target VM display name.
	TargetVMName *string

	// Gets or sets the target test network Id within AzStackHCI Cluster.
	TestNetworkID *string

	// READ-ONLY; Gets or sets the location of the protected item.
	ActiveLocation *ProtectedItemActiveLocation

	// READ-ONLY; Gets or sets the recovery point Id to which the VM was failed over.
	FailoverRecoveryPointID *string

	// READ-ONLY; Gets or sets the firmware type.
	FirmwareType *string

	// READ-ONLY; Gets or sets the initial replication progress percentage. This is calculated based on total bytes processed
	// for all disks in the source VM.
	InitialReplicationProgressPercentage *int32

	// READ-ONLY; Gets or sets the last recovery point Id.
	LastRecoveryPointID *string

	// READ-ONLY; Gets or sets the last recovery point received time.
	LastRecoveryPointReceived *time.Time

	// READ-ONLY; Gets or sets the latest timestamp that replication status is updated.
	LastReplicationUpdateTime *time.Time

	// READ-ONLY; Gets or sets the name of the OS.
	OSName *string

	// READ-ONLY; Gets or sets the type of the OS.
	OSType *string

	// READ-ONLY; Gets or sets the list of protected disks.
	ProtectedDisks []*HyperVToAzStackHCIProtectedDiskProperties

	// READ-ONLY; Gets or sets the VM NIC details.
	ProtectedNics []*HyperVToAzStackHCIProtectedNicProperties

	// READ-ONLY; Gets or sets the resync progress percentage. This is calculated based on total bytes processed for all disks
	// in the source VM.
	ResyncProgressPercentage *int32

	// READ-ONLY; Gets or sets the source appliance name.
	SourceApplianceName *string

	// READ-ONLY; Gets or sets the source VM CPU cores.
	SourceCPUCores *int32

	// READ-ONLY; Gets or sets the source VM ram memory size in megabytes.
	SourceMemoryInMegaBytes *float64

	// READ-ONLY; Gets or sets the source VM display name.
	SourceVMName *string

	// READ-ONLY; Gets or sets the target appliance name.
	TargetApplianceName *string

	// READ-ONLY; Gets or sets the Target AzStackHCI cluster name.
	TargetAzStackHciClusterName *string

	// READ-ONLY; Gets or sets the target location.
	TargetLocation *string

	// READ-ONLY; Gets or sets the BIOS Id of the target AzStackHCI VM.
	TargetVMBiosID *string
}

// GetProtectedItemModelCustomProperties implements the ProtectedItemModelCustomPropertiesClassification interface for type
// HyperVToAzStackHCIProtectedItemModelCustomProperties.
func (h *HyperVToAzStackHCIProtectedItemModelCustomProperties) GetProtectedItemModelCustomProperties() *ProtectedItemModelCustomProperties {
	return &ProtectedItemModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// HyperVToAzStackHCIProtectedNicProperties - HyperVToAzStackHCI NIC properties.
type HyperVToAzStackHCIProtectedNicProperties struct {
	// READ-ONLY; Gets or sets the NIC mac address.
	MacAddress *string

	// READ-ONLY; Gets or sets the network name.
	NetworkName *string

	// READ-ONLY; Gets or sets the NIC Id.
	NicID *string

	// READ-ONLY; Gets or sets the selection type of the NIC.
	SelectionTypeForFailover *VMNicSelection

	// READ-ONLY; Gets or sets the target network Id within AzStackHCI Cluster.
	TargetNetworkID *string

	// READ-ONLY; Gets or sets the target test network Id within AzStackHCI Cluster.
	TestNetworkID *string
}

// HyperVToAzStackHCIRecoveryPointModelCustomProperties - HyperV to AzStackHCI recovery point model custom properties.
type HyperVToAzStackHCIRecoveryPointModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// READ-ONLY; Gets or sets the list of the disk Ids.
	DiskIDs []*string
}

// GetRecoveryPointModelCustomProperties implements the RecoveryPointModelCustomPropertiesClassification interface for type
// HyperVToAzStackHCIRecoveryPointModelCustomProperties.
func (h *HyperVToAzStackHCIRecoveryPointModelCustomProperties) GetRecoveryPointModelCustomProperties() *RecoveryPointModelCustomProperties {
	return &RecoveryPointModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// HyperVToAzStackHCIReplicationExtensionModelCustomProperties - HyperV to AzStackHCI Replication extension model custom properties.
type HyperVToAzStackHCIReplicationExtensionModelCustomProperties struct {
	// REQUIRED; Gets or sets the ARM Id of the target AzStackHCI fabric.
	AzStackHciFabricArmID *string

	// REQUIRED; Gets or sets the ARM Id of the source HyperV fabric.
	HyperVFabricArmID *string

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// Gets or sets the storage account Id.
	StorageAccountID *string

	// Gets or sets the Sas Secret of storage account.
	StorageAccountSasSecretName *string

	// READ-ONLY; Gets or sets the Uri of ASR.
	AsrServiceURI *string

	// READ-ONLY; Gets or sets the ARM Id of the AzStackHCI site.
	AzStackHciSiteID *string

	// READ-ONLY; Gets or sets the Uri of Gateway.
	GatewayServiceURI *string

	// READ-ONLY; Gets or sets the ARM Id of the HyperV site.
	HyperVSiteID *string

	// READ-ONLY; Gets or sets the Uri of Rcm.
	RcmServiceURI *string

	// READ-ONLY; Gets or sets the resource group.
	ResourceGroup *string

	// READ-ONLY; Gets or sets the resource location.
	ResourceLocation *string

	// READ-ONLY; Gets or sets the gateway service Id of source.
	SourceGatewayServiceID *string

	// READ-ONLY; Gets or sets the source storage container name.
	SourceStorageContainerName *string

	// READ-ONLY; Gets or sets the subscription.
	SubscriptionID *string

	// READ-ONLY; Gets or sets the gateway service Id of target.
	TargetGatewayServiceID *string

	// READ-ONLY; Gets or sets the target storage container name.
	TargetStorageContainerName *string
}

// GetReplicationExtensionModelCustomProperties implements the ReplicationExtensionModelCustomPropertiesClassification interface
// for type HyperVToAzStackHCIReplicationExtensionModelCustomProperties.
func (h *HyperVToAzStackHCIReplicationExtensionModelCustomProperties) GetReplicationExtensionModelCustomProperties() *ReplicationExtensionModelCustomProperties {
	return &ReplicationExtensionModelCustomProperties{
		InstanceType: h.InstanceType,
	}
}

// IdentityModel - Identity model.
type IdentityModel struct {
	// REQUIRED; Gets or sets the authority of the SPN with which Dra communicates to service.
	AADAuthority *string

	// REQUIRED; Gets or sets the client/application Id of the SPN with which Dra communicates to service.
	ApplicationID *string

	// REQUIRED; Gets or sets the audience of the SPN with which Dra communicates to service.
	Audience *string

	// REQUIRED; Gets or sets the object Id of the SPN with which Dra communicates to service.
	ObjectID *string

	// REQUIRED; Gets or sets the tenant Id of the SPN with which Dra communicates to service.
	TenantID *string
}

// InnerHealthErrorModel - Inner health error model.
type InnerHealthErrorModel struct {
	// READ-ONLY; Gets or sets the error category.
	Category *string

	// READ-ONLY; Gets or sets possible causes of the error.
	Causes *string

	// READ-ONLY; Gets or sets the error code.
	Code *string

	// READ-ONLY; Gets or sets the error creation time.
	CreationTime *time.Time

	// READ-ONLY; Gets or sets the health category.
	HealthCategory *string

	// READ-ONLY; Gets or sets a value indicating whether the error is customer resolvable.
	IsCustomerResolvable *bool

	// READ-ONLY; Gets or sets the error message.
	Message *string

	// READ-ONLY; Gets or sets recommended action to resolve the error.
	Recommendation *string

	// READ-ONLY; Gets or sets the error severity.
	Severity *string

	// READ-ONLY; Gets or sets the error source.
	Source *string

	// READ-ONLY; Gets or sets the error summary.
	Summary *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// OperationStatus - Defines the operation status.
type OperationStatus struct {
	// Gets or sets the end time.
	EndTime *string

	// Gets or sets the Id.
	ID *string

	// Gets or sets the operation name.
	Name *string

	// Gets or sets the start time.
	StartTime *string

	// Gets or sets the status of the operation. ARM expects the terminal status to be one of Succeeded/ Failed/ Canceled. All
	// other values imply that the operation is still running.
	Status *string
}

// PlannedFailoverModel - Planned failover model.
type PlannedFailoverModel struct {
	// REQUIRED; Planned failover model properties.
	Properties *PlannedFailoverModelProperties
}

// PlannedFailoverModelCustomProperties - Planned failover model custom properties.
type PlannedFailoverModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetPlannedFailoverModelCustomProperties implements the PlannedFailoverModelCustomPropertiesClassification interface for
// type PlannedFailoverModelCustomProperties.
func (p *PlannedFailoverModelCustomProperties) GetPlannedFailoverModelCustomProperties() *PlannedFailoverModelCustomProperties {
	return p
}

// PlannedFailoverModelProperties - Planned failover model properties.
type PlannedFailoverModelProperties struct {
	// REQUIRED; Planned failover model custom properties.
	CustomProperties PlannedFailoverModelCustomPropertiesClassification
}

// PolicyModel - Policy model.
type PolicyModel struct {
	// REQUIRED; Policy model properties.
	Properties *PolicyModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *PolicyModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// PolicyModelCollection - Policy model collection.
type PolicyModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of policies.
	Value []*PolicyModel
}

// PolicyModelCustomProperties - Policy model custom properties.
type PolicyModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetPolicyModelCustomProperties implements the PolicyModelCustomPropertiesClassification interface for type PolicyModelCustomProperties.
func (p *PolicyModelCustomProperties) GetPolicyModelCustomProperties() *PolicyModelCustomProperties {
	return p
}

// PolicyModelProperties - Policy model properties.
type PolicyModelProperties struct {
	// REQUIRED; Policy model custom properties.
	CustomProperties PolicyModelCustomPropertiesClassification

	// READ-ONLY; Gets or sets the provisioning state of the policy.
	ProvisioningState *ProvisioningState
}

type PolicyModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// ProtectedItemDynamicMemoryConfig - Protected item dynamic memory config.
type ProtectedItemDynamicMemoryConfig struct {
	// REQUIRED; Gets or sets maximum memory in MB.
	MaximumMemoryInMegaBytes *int64

	// REQUIRED; Gets or sets minimum memory in MB.
	MinimumMemoryInMegaBytes *int64

	// REQUIRED; Gets or sets target memory buffer in %.
	TargetMemoryBufferPercentage *int32
}

// ProtectedItemModel - Protected item model.
type ProtectedItemModel struct {
	// REQUIRED; Protected item model properties.
	Properties *ProtectedItemModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *ProtectedItemModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// ProtectedItemModelCollection - Protected item model collection.
type ProtectedItemModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of protected items.
	Value []*ProtectedItemModel
}

// ProtectedItemModelCustomProperties - Protected item model custom properties.
type ProtectedItemModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetProtectedItemModelCustomProperties implements the ProtectedItemModelCustomPropertiesClassification interface for type
// ProtectedItemModelCustomProperties.
func (p *ProtectedItemModelCustomProperties) GetProtectedItemModelCustomProperties() *ProtectedItemModelCustomProperties {
	return p
}

// ProtectedItemModelProperties - Protected item model properties.
type ProtectedItemModelProperties struct {
	// REQUIRED; Protected item model custom properties.
	CustomProperties ProtectedItemModelCustomPropertiesClassification

	// REQUIRED; Gets or sets the policy name.
	PolicyName *string

	// REQUIRED; Gets or sets the replication extension name.
	ReplicationExtensionName *string

	// READ-ONLY; Gets or sets the allowed scenarios on the protected item.
	AllowedJobs []*string

	// READ-ONLY; Gets or sets the protected item correlation Id.
	CorrelationID *string

	// READ-ONLY
	CurrentJob *ProtectedItemModelPropertiesCurrentJob

	// READ-ONLY; Gets or sets the DRA Id.
	DraID *string

	// READ-ONLY; Gets or sets the fabric Id.
	FabricID *string

	// READ-ONLY; Gets or sets the fabric object Id.
	FabricObjectID *string

	// READ-ONLY; Gets or sets the fabric object name.
	FabricObjectName *string

	// READ-ONLY; Gets or sets the list of health errors.
	HealthErrors []*HealthErrorModel

	// READ-ONLY
	LastFailedEnableProtectionJob *ProtectedItemModelPropertiesLastFailedEnableProtectionJob

	// READ-ONLY
	LastFailedPlannedFailoverJob *ProtectedItemModelPropertiesLastFailedPlannedFailoverJob

	// READ-ONLY; Gets or sets the Last successful planned failover time.
	LastSuccessfulPlannedFailoverTime *time.Time

	// READ-ONLY; Gets or sets the Last successful test failover time.
	LastSuccessfulTestFailoverTime *time.Time

	// READ-ONLY; Gets or sets the Last successful unplanned failover time.
	LastSuccessfulUnplannedFailoverTime *time.Time

	// READ-ONLY
	LastTestFailoverJob *ProtectedItemModelPropertiesLastTestFailoverJob

	// READ-ONLY; Gets or sets the protection state.
	ProtectionState *ProtectionState

	// READ-ONLY; Gets or sets the protection state description.
	ProtectionStateDescription *string

	// READ-ONLY; Gets or sets the provisioning state of the Dra.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets protected item replication health.
	ReplicationHealth *HealthStatus

	// READ-ONLY; Gets or sets a value indicating whether resynchronization is required or not.
	ResyncRequired *bool

	// READ-ONLY; Gets or sets the resynchronization state.
	ResynchronizationState *ResynchronizationState

	// READ-ONLY; Gets or sets the source fabric provider Id.
	SourceFabricProviderID *string

	// READ-ONLY; Gets or sets the target DRA Id.
	TargetDraID *string

	// READ-ONLY; Gets or sets the target fabric Id.
	TargetFabricID *string

	// READ-ONLY; Gets or sets the target fabric provider Id.
	TargetFabricProviderID *string

	// READ-ONLY; Gets or sets the test failover state.
	TestFailoverState *TestFailoverState

	// READ-ONLY; Gets or sets the Test failover state description.
	TestFailoverStateDescription *string
}

type ProtectedItemModelPropertiesCurrentJob struct {
	// READ-ONLY; Gets or sets the workflow friendly display name.
	DisplayName *string

	// READ-ONLY; Gets or sets end time of the workflow.
	EndTime *time.Time

	// READ-ONLY; Gets or sets workflow Id.
	ID *string

	// READ-ONLY; Gets or sets workflow name.
	Name *string

	// READ-ONLY; Gets or sets protection scenario name.
	ScenarioName *string

	// READ-ONLY; Gets or sets start time of the workflow.
	StartTime *time.Time

	// READ-ONLY; Gets or sets workflow state.
	State *string
}

type ProtectedItemModelPropertiesLastFailedEnableProtectionJob struct {
	// READ-ONLY; Gets or sets the workflow friendly display name.
	DisplayName *string

	// READ-ONLY; Gets or sets end time of the workflow.
	EndTime *time.Time

	// READ-ONLY; Gets or sets workflow Id.
	ID *string

	// READ-ONLY; Gets or sets workflow name.
	Name *string

	// READ-ONLY; Gets or sets protection scenario name.
	ScenarioName *string

	// READ-ONLY; Gets or sets start time of the workflow.
	StartTime *time.Time

	// READ-ONLY; Gets or sets workflow state.
	State *string
}

type ProtectedItemModelPropertiesLastFailedPlannedFailoverJob struct {
	// READ-ONLY; Gets or sets the workflow friendly display name.
	DisplayName *string

	// READ-ONLY; Gets or sets end time of the workflow.
	EndTime *time.Time

	// READ-ONLY; Gets or sets workflow Id.
	ID *string

	// READ-ONLY; Gets or sets workflow name.
	Name *string

	// READ-ONLY; Gets or sets protection scenario name.
	ScenarioName *string

	// READ-ONLY; Gets or sets start time of the workflow.
	StartTime *time.Time

	// READ-ONLY; Gets or sets workflow state.
	State *string
}

type ProtectedItemModelPropertiesLastTestFailoverJob struct {
	// READ-ONLY; Gets or sets the workflow friendly display name.
	DisplayName *string

	// READ-ONLY; Gets or sets end time of the workflow.
	EndTime *time.Time

	// READ-ONLY; Gets or sets workflow Id.
	ID *string

	// READ-ONLY; Gets or sets workflow name.
	Name *string

	// READ-ONLY; Gets or sets protection scenario name.
	ScenarioName *string

	// READ-ONLY; Gets or sets start time of the workflow.
	StartTime *time.Time

	// READ-ONLY; Gets or sets workflow state.
	State *string
}

type ProtectedItemModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// RecoveryPointModel - Recovery point model.
type RecoveryPointModel struct {
	// REQUIRED; Recovery point model properties.
	Properties *RecoveryPointModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *RecoveryPointModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// RecoveryPointModelCollection - Recovery point model collection.
type RecoveryPointModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of recovery points.
	Value []*RecoveryPointModel
}

// RecoveryPointModelCustomProperties - Recovery point model custom properties.
type RecoveryPointModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetRecoveryPointModelCustomProperties implements the RecoveryPointModelCustomPropertiesClassification interface for type
// RecoveryPointModelCustomProperties.
func (r *RecoveryPointModelCustomProperties) GetRecoveryPointModelCustomProperties() *RecoveryPointModelCustomProperties {
	return r
}

// RecoveryPointModelProperties - Recovery point model properties.
type RecoveryPointModelProperties struct {
	// REQUIRED; Recovery point model custom properties.
	CustomProperties RecoveryPointModelCustomPropertiesClassification

	// REQUIRED; Gets or sets the recovery point time.
	RecoveryPointTime *time.Time

	// REQUIRED; Gets or sets the recovery point type.
	RecoveryPointType *RecoveryPointType
}

type RecoveryPointModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// ReplicationExtensionModel - Replication extension model.
type ReplicationExtensionModel struct {
	// REQUIRED; Replication extension model properties.
	Properties *ReplicationExtensionModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *ReplicationExtensionModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// ReplicationExtensionModelCollection - Replication extension model collection.
type ReplicationExtensionModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of replication extensions.
	Value []*ReplicationExtensionModel
}

// ReplicationExtensionModelCustomProperties - Replication extension model custom properties.
type ReplicationExtensionModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// GetReplicationExtensionModelCustomProperties implements the ReplicationExtensionModelCustomPropertiesClassification interface
// for type ReplicationExtensionModelCustomProperties.
func (r *ReplicationExtensionModelCustomProperties) GetReplicationExtensionModelCustomProperties() *ReplicationExtensionModelCustomProperties {
	return r
}

// ReplicationExtensionModelProperties - Replication extension model properties.
type ReplicationExtensionModelProperties struct {
	// REQUIRED; Replication extension model custom properties.
	CustomProperties ReplicationExtensionModelCustomPropertiesClassification

	// READ-ONLY; Gets or sets the provisioning state of the replication extension.
	ProvisioningState *ProvisioningState
}

type ReplicationExtensionModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// StorageContainerProperties - Storage container properties.
type StorageContainerProperties struct {
	// REQUIRED; Gets or sets the ClusterSharedVolumePath.
	ClusterSharedVolumePath *string

	// REQUIRED; Gets or sets the Name.
	Name *string
}

// TaskModel - Task model.
type TaskModel struct {
	// Gets or sets the list of children workflow models.
	ChildrenWorkflows []*WorkflowModel

	// Task model custom properties.
	CustomProperties *TaskModelCustomProperties

	// READ-ONLY; Gets or sets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets or sets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets or sets the task state.
	State *TaskState

	// READ-ONLY; Gets or sets the task name.
	TaskName *string
}

// TaskModelCustomProperties - Task model custom properties.
type TaskModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string
}

// TestFailoverCleanupWorkflowModelCustomProperties - Test failover cleanup workflow model custom properties.
type TestFailoverCleanupWorkflowModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// READ-ONLY; Gets or sets any custom properties of the affected object.
	AffectedObjectDetails map[string]*string

	// READ-ONLY; Gets or sets the test failover cleanup comments.
	Comments *string
}

// GetWorkflowModelCustomProperties implements the WorkflowModelCustomPropertiesClassification interface for type TestFailoverCleanupWorkflowModelCustomProperties.
func (t *TestFailoverCleanupWorkflowModelCustomProperties) GetWorkflowModelCustomProperties() *WorkflowModelCustomProperties {
	return &WorkflowModelCustomProperties{
		AffectedObjectDetails: t.AffectedObjectDetails,
		InstanceType:          t.InstanceType,
	}
}

// TestFailoverWorkflowModelCustomProperties - Test failover workflow model custom properties.
type TestFailoverWorkflowModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// READ-ONLY; Gets or sets any custom properties of the affected object.
	AffectedObjectDetails map[string]*string

	// READ-ONLY; Gets or sets the test VM details.
	ProtectedItemDetails []*FailoverProtectedItemProperties
}

// GetWorkflowModelCustomProperties implements the WorkflowModelCustomPropertiesClassification interface for type TestFailoverWorkflowModelCustomProperties.
func (t *TestFailoverWorkflowModelCustomProperties) GetWorkflowModelCustomProperties() *WorkflowModelCustomProperties {
	return &WorkflowModelCustomProperties{
		AffectedObjectDetails: t.AffectedObjectDetails,
		InstanceType:          t.InstanceType,
	}
}

// VMwareDraModelCustomProperties - VMware DRA model custom properties.
type VMwareDraModelCustomProperties struct {
	// REQUIRED; Gets or sets the BIOS Id of the DRA machine.
	BiosID *string

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Identity model.
	MarsAuthenticationIdentity *IdentityModel
}

// GetDraModelCustomProperties implements the DraModelCustomPropertiesClassification interface for type VMwareDraModelCustomProperties.
func (v *VMwareDraModelCustomProperties) GetDraModelCustomProperties() *DraModelCustomProperties {
	return &DraModelCustomProperties{
		InstanceType: v.InstanceType,
	}
}

// VMwareMigrateFabricModelCustomProperties - VMware migrate fabric model custom properties.
type VMwareMigrateFabricModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the ARM Id of the migration solution.
	MigrationSolutionID *string

	// REQUIRED; Gets or sets the ARM Id of the VMware site.
	VmwareSiteID *string
}

// GetFabricModelCustomProperties implements the FabricModelCustomPropertiesClassification interface for type VMwareMigrateFabricModelCustomProperties.
func (v *VMwareMigrateFabricModelCustomProperties) GetFabricModelCustomProperties() *FabricModelCustomProperties {
	return &FabricModelCustomProperties{
		InstanceType: v.InstanceType,
	}
}

// VMwareToAzStackHCIDiskInput - VMwareToAzStack disk input.
type VMwareToAzStackHCIDiskInput struct {
	// REQUIRED; Gets or sets the type of the virtual hard disk, vhd or vhdx.
	DiskFileFormat *string

	// REQUIRED; Gets or sets the disk Id.
	DiskID *string

	// REQUIRED; Gets or sets the disk size in GB.
	DiskSizeGB *int64

	// REQUIRED; Gets or sets a value indicating whether disk is os disk.
	IsOsDisk *bool

	// Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk.
	IsDynamic *bool

	// Gets or sets the target storage account ARM Id.
	StorageContainerID *string
}

// VMwareToAzStackHCINicInput - VMwareToAzStackHCI NIC properties.
type VMwareToAzStackHCINicInput struct {
	// REQUIRED; Gets or sets the NIC label.
	Label *string

	// REQUIRED; Gets or sets the NIC Id.
	NicID *string

	// REQUIRED; Gets or sets the selection type of the NIC.
	SelectionTypeForFailover *VMNicSelection

	// REQUIRED; Gets or sets the target network Id within AzStackHCI Cluster.
	TargetNetworkID *string

	// REQUIRED; Gets or sets the target test network Id within AzStackHCI Cluster.
	TestNetworkID *string

	// READ-ONLY; Gets or sets the network name.
	NetworkName *string
}

// VMwareToAzStackHCIPlannedFailoverModelCustomProperties - VMware to AzStackHCI planned failover model custom properties.
type VMwareToAzStackHCIPlannedFailoverModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets a value indicating whether VM needs to be shut down.
	ShutdownSourceVM *bool
}

// GetPlannedFailoverModelCustomProperties implements the PlannedFailoverModelCustomPropertiesClassification interface for
// type VMwareToAzStackHCIPlannedFailoverModelCustomProperties.
func (v *VMwareToAzStackHCIPlannedFailoverModelCustomProperties) GetPlannedFailoverModelCustomProperties() *PlannedFailoverModelCustomProperties {
	return &PlannedFailoverModelCustomProperties{
		InstanceType: v.InstanceType,
	}
}

// VMwareToAzStackHCIPolicyModelCustomProperties - VMware To AzStackHCI Policy model custom properties.
type VMwareToAzStackHCIPolicyModelCustomProperties struct {
	// REQUIRED; Gets or sets the app consistent snapshot frequency (in minutes).
	AppConsistentFrequencyInMinutes *int32

	// REQUIRED; Gets or sets the crash consistent snapshot frequency (in minutes).
	CrashConsistentFrequencyInMinutes *int32

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the duration in minutes until which the recovery points need to be stored.
	RecoveryPointHistoryInMinutes *int32
}

// GetPolicyModelCustomProperties implements the PolicyModelCustomPropertiesClassification interface for type VMwareToAzStackHCIPolicyModelCustomProperties.
func (v *VMwareToAzStackHCIPolicyModelCustomProperties) GetPolicyModelCustomProperties() *PolicyModelCustomProperties {
	return &PolicyModelCustomProperties{
		InstanceType: v.InstanceType,
	}
}

// VMwareToAzStackHCIProtectedDiskProperties - VMwareToAzStackHCI protected disk properties.
type VMwareToAzStackHCIProtectedDiskProperties struct {
	// READ-ONLY; Gets or sets the disk capacity in bytes.
	CapacityInBytes *int64

	// READ-ONLY; Gets or sets the disk type.
	DiskType *string

	// READ-ONLY; Gets or sets a value indicating whether dynamic sizing is enabled on the virtual hard disk.
	IsDynamic *bool

	// READ-ONLY; Gets or sets a value indicating whether the disk is the OS disk.
	IsOsDisk *bool

	// READ-ONLY; Gets or sets the failover clone disk.
	MigrateDiskName *string

	// READ-ONLY; Gets or sets the seed disk name.
	SeedDiskName *string

	// READ-ONLY; Gets or sets the source disk Id.
	SourceDiskID *string

	// READ-ONLY; Gets or sets the source disk Name.
	SourceDiskName *string

	// READ-ONLY; Gets or sets the ARM Id of the storage container.
	StorageContainerID *string

	// READ-ONLY; Gets or sets the local path of the storage container.
	StorageContainerLocalPath *string

	// READ-ONLY; Gets or sets the test failover clone disk.
	TestMigrateDiskName *string
}

// VMwareToAzStackHCIProtectedItemModelCustomProperties - VMware to AzStackHCI Protected item model custom properties.
type VMwareToAzStackHCIProtectedItemModelCustomProperties struct {
	// REQUIRED; Gets or sets the location of Azure Arc HCI custom location resource.
	CustomLocationRegion *string

	// REQUIRED; Gets or sets the list of disks to replicate.
	DisksToInclude []*VMwareToAzStackHCIDiskInput

	// REQUIRED; Gets or sets the ARM Id of the discovered machine.
	FabricDiscoveryMachineID *string

	// REQUIRED; Gets or sets the hypervisor generation of the virtual machine possible values are 1,2.
	HyperVGeneration *string

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the list of VM NIC to replicate.
	NicsToInclude []*VMwareToAzStackHCINicInput

	// REQUIRED; Gets or sets the run as account Id.
	RunAsAccountID *string

	// REQUIRED; Gets or sets the source DRA name.
	SourceDraName *string

	// REQUIRED; Gets or sets the target storage container ARM Id.
	StorageContainerID *string

	// REQUIRED; Gets or sets the Target Arc Cluster Custom Location ARM Id.
	TargetArcClusterCustomLocationID *string

	// REQUIRED; Gets or sets the target DRA name.
	TargetDraName *string

	// REQUIRED; Gets or sets the Target HCI Cluster ARM Id.
	TargetHciClusterID *string

	// REQUIRED; Gets or sets the target resource group ARM Id.
	TargetResourceGroupID *string

	// Protected item dynamic memory config.
	DynamicMemoryConfig *ProtectedItemDynamicMemoryConfig

	// Gets or sets a value indicating whether memory is dynamical.
	IsDynamicRAM *bool

	// Gets or sets a value indicating whether auto resync is to be done.
	PerformAutoResync *bool

	// Gets or sets the target CPU cores.
	TargetCPUCores *int32

	// Gets or sets the target memory in mega-bytes.
	TargetMemoryInMegaBytes *int32

	// Gets or sets the target network Id within AzStackHCI Cluster.
	TargetNetworkID *string

	// Gets or sets the target VM display name.
	TargetVMName *string

	// Gets or sets the target test network Id within AzStackHCI Cluster.
	TestNetworkID *string

	// READ-ONLY; Gets or sets the location of the protected item.
	ActiveLocation *ProtectedItemActiveLocation

	// READ-ONLY; Gets or sets the recovery point Id to which the VM was failed over.
	FailoverRecoveryPointID *string

	// READ-ONLY; Gets or sets the firmware type.
	FirmwareType *string

	// READ-ONLY; Gets or sets the initial replication progress percentage. This is calculated based on total bytes processed
	// for all disks in the source VM.
	InitialReplicationProgressPercentage *int32

	// READ-ONLY; Gets or sets the last recovery point Id.
	LastRecoveryPointID *string

	// READ-ONLY; Gets or sets the last recovery point received time.
	LastRecoveryPointReceived *time.Time

	// READ-ONLY; Gets or sets the latest timestamp that replication status is updated.
	LastReplicationUpdateTime *time.Time

	// READ-ONLY; Gets or sets the migration progress percentage.
	MigrationProgressPercentage *int32

	// READ-ONLY; Gets or sets the name of the OS.
	OSName *string

	// READ-ONLY; Gets or sets the type of the OS.
	OSType *string

	// READ-ONLY; Gets or sets the list of protected disks.
	ProtectedDisks []*VMwareToAzStackHCIProtectedDiskProperties

	// READ-ONLY; Gets or sets the VM NIC details.
	ProtectedNics []*VMwareToAzStackHCIProtectedNicProperties

	// READ-ONLY; Gets or sets the resume progress percentage.
	ResumeProgressPercentage *int32

	// READ-ONLY; Gets or sets the resume retry count.
	ResumeRetryCount *int64

	// READ-ONLY; Gets or sets the resync progress percentage. This is calculated based on total bytes processed for all disks
	// in the source VM.
	ResyncProgressPercentage *int32

	// READ-ONLY; Gets or sets a value indicating whether resync is required.
	ResyncRequired *bool

	// READ-ONLY; Gets or sets the resync retry count.
	ResyncRetryCount *int64

	// READ-ONLY; Gets or sets the resync state.
	ResyncState *VMwareToAzureMigrateResyncState

	// READ-ONLY; Gets or sets the source appliance name.
	SourceApplianceName *string

	// READ-ONLY; Gets or sets the source VM CPU cores.
	SourceCPUCores *int32

	// READ-ONLY; Gets or sets the source VM ram memory size in megabytes.
	SourceMemoryInMegaBytes *float64

	// READ-ONLY; Gets or sets the source VM display name.
	SourceVMName *string

	// READ-ONLY; Gets or sets the target appliance name.
	TargetApplianceName *string

	// READ-ONLY; Gets or sets the Target AzStackHCI cluster name.
	TargetAzStackHciClusterName *string

	// READ-ONLY; Gets or sets the target location.
	TargetLocation *string

	// READ-ONLY; Gets or sets the BIOS Id of the target AzStackHCI VM.
	TargetVMBiosID *string
}

// GetProtectedItemModelCustomProperties implements the ProtectedItemModelCustomPropertiesClassification interface for type
// VMwareToAzStackHCIProtectedItemModelCustomProperties.
func (v *VMwareToAzStackHCIProtectedItemModelCustomProperties) GetProtectedItemModelCustomProperties() *ProtectedItemModelCustomProperties {
	return &ProtectedItemModelCustomProperties{
		InstanceType: v.InstanceType,
	}
}

// VMwareToAzStackHCIProtectedNicProperties - VMwareToAzStackHCI NIC properties.
type VMwareToAzStackHCIProtectedNicProperties struct {
	// Gets or sets a value indicating whether this is the primary NIC.
	IsPrimaryNic *bool

	// READ-ONLY; Gets or sets the NIC label.
	Label *string

	// READ-ONLY; Gets or sets the NIC mac address.
	MacAddress *string

	// READ-ONLY; Gets or sets the network name.
	NetworkName *string

	// READ-ONLY; Gets or sets the NIC Id.
	NicID *string

	// READ-ONLY; Gets or sets the selection type of the NIC.
	SelectionTypeForFailover *VMNicSelection

	// READ-ONLY; Gets or sets the target network Id within AzStackHCI Cluster.
	TargetNetworkID *string

	// READ-ONLY; Gets or sets the target test network Id within AzStackHCI Cluster.
	TestNetworkID *string
}

// VMwareToAzStackHCIReplicationExtensionModelCustomProperties - VMware to AzStackHCI Replication extension model custom properties.
type VMwareToAzStackHCIReplicationExtensionModelCustomProperties struct {
	// REQUIRED; Gets or sets the ARM Id of the target AzStackHCI fabric.
	AzStackHciFabricArmID *string

	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// REQUIRED; Gets or sets the ARM Id of the source VMware fabric.
	VmwareFabricArmID *string

	// Gets or sets the storage account Id.
	StorageAccountID *string

	// Gets or sets the Sas Secret of storage account.
	StorageAccountSasSecretName *string

	// READ-ONLY; Gets or sets the Uri of ASR.
	AsrServiceURI *string

	// READ-ONLY; Gets or sets the ARM Id of the AzStackHCI site.
	AzStackHciSiteID *string

	// READ-ONLY; Gets or sets the Uri of Gateway.
	GatewayServiceURI *string

	// READ-ONLY; Gets or sets the Uri of Rcm.
	RcmServiceURI *string

	// READ-ONLY; Gets or sets the resource group.
	ResourceGroup *string

	// READ-ONLY; Gets or sets the resource location.
	ResourceLocation *string

	// READ-ONLY; Gets or sets the gateway service Id of source.
	SourceGatewayServiceID *string

	// READ-ONLY; Gets or sets the source storage container name.
	SourceStorageContainerName *string

	// READ-ONLY; Gets or sets the subscription.
	SubscriptionID *string

	// READ-ONLY; Gets or sets the gateway service Id of target.
	TargetGatewayServiceID *string

	// READ-ONLY; Gets or sets the target storage container name.
	TargetStorageContainerName *string

	// READ-ONLY; Gets or sets the ARM Id of the VMware site.
	VmwareSiteID *string
}

// GetReplicationExtensionModelCustomProperties implements the ReplicationExtensionModelCustomPropertiesClassification interface
// for type VMwareToAzStackHCIReplicationExtensionModelCustomProperties.
func (v *VMwareToAzStackHCIReplicationExtensionModelCustomProperties) GetReplicationExtensionModelCustomProperties() *ReplicationExtensionModelCustomProperties {
	return &ReplicationExtensionModelCustomProperties{
		InstanceType: v.InstanceType,
	}
}

// VaultModel - Vault model.
type VaultModel struct {
	// REQUIRED; Gets or sets the location of the vault.
	Location *string

	// Vault properties.
	Properties *VaultModelProperties

	// Gets or sets the resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *VaultModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// VaultModelCollection - Vault model collection.
type VaultModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of vaults.
	Value []*VaultModel
}

// VaultModelProperties - Vault properties.
type VaultModelProperties struct {
	// Gets or sets the type of vault.
	VaultType *ReplicationVaultType

	// READ-ONLY; Gets or sets the provisioning state of the vault.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Gets or sets the service resource Id.
	ServiceResourceID *string
}

type VaultModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// VaultModelUpdate - Vault model for update.
type VaultModelUpdate struct {
	// Vault properties.
	Properties *VaultModelProperties

	// Gets or sets the resource tags.
	Tags map[string]*string

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *VaultModelUpdateSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

type VaultModelUpdateSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}

// WorkflowModel - Workflow model.
type WorkflowModel struct {
	// REQUIRED; Workflow model properties.
	Properties *WorkflowModelProperties

	// READ-ONLY; Gets or sets the Id of the resource.
	ID *string

	// READ-ONLY; Gets or sets the name of the resource.
	Name *string

	// READ-ONLY
	SystemData *WorkflowModelSystemData

	// READ-ONLY; Gets or sets the type of the resource.
	Type *string
}

// WorkflowModelCollection - Workflow model collection.
type WorkflowModelCollection struct {
	// Gets or sets the value of next link.
	NextLink *string

	// Gets or sets the list of workflows.
	Value []*WorkflowModel
}

// WorkflowModelCustomProperties - Workflow model custom properties.
type WorkflowModelCustomProperties struct {
	// REQUIRED; Gets or sets the instance type.
	InstanceType *string

	// READ-ONLY; Gets or sets any custom properties of the affected object.
	AffectedObjectDetails map[string]*string
}

// GetWorkflowModelCustomProperties implements the WorkflowModelCustomPropertiesClassification interface for type WorkflowModelCustomProperties.
func (w *WorkflowModelCustomProperties) GetWorkflowModelCustomProperties() *WorkflowModelCustomProperties {
	return w
}

// WorkflowModelProperties - Workflow model properties.
type WorkflowModelProperties struct {
	// REQUIRED; Workflow model custom properties.
	CustomProperties WorkflowModelCustomPropertiesClassification

	// READ-ONLY; Gets or sets the workflow activity id.
	ActivityID *string

	// READ-ONLY; Gets or sets the list of allowed actions on the workflow.
	AllowedActions []*string

	// READ-ONLY; Gets or sets the friendly display name.
	DisplayName *string

	// READ-ONLY; Gets or sets the end time.
	EndTime *time.Time

	// READ-ONLY; Gets or sets the list of errors.
	Errors []*ErrorModel

	// READ-ONLY; Gets or sets the affected object Id.
	ObjectID *string

	// READ-ONLY; Gets or sets the affected object internal Id.
	ObjectInternalID *string

	// READ-ONLY; Gets or sets the affected object internal name.
	ObjectInternalName *string

	// READ-ONLY; Gets or sets the affected object name.
	ObjectName *string

	// READ-ONLY; Gets or sets the object type.
	ObjectType *WorkflowObjectType

	// READ-ONLY; Gets or sets the replication provider.
	ReplicationProviderID *string

	// READ-ONLY; Gets or sets the source fabric provider.
	SourceFabricProviderID *string

	// READ-ONLY; Gets or sets the start time.
	StartTime *time.Time

	// READ-ONLY; Gets or sets the workflow state.
	State *WorkflowState

	// READ-ONLY; Gets or sets the target fabric provider.
	TargetFabricProviderID *string

	// READ-ONLY; Gets or sets the list of tasks.
	Tasks []*TaskModel
}

type WorkflowModelSystemData struct {
	// Gets or sets the timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// Gets or sets identity that created the resource.
	CreatedBy *string

	// Gets or sets the type of identity that created the resource: user, application, managedIdentity.
	CreatedByType *string

	// Gets or sets the timestamp of resource last modification (UTC).
	LastModifiedAt *time.Time

	// Gets or sets the identity that last modified the resource.
	LastModifiedBy *string

	// Gets or sets the type of identity that last modified the resource: user, application, managedIdentity.
	LastModifiedByType *string
}
