//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armrecoveryservicesdatareplication.ClientFactory type.
type ServerFactory struct {
	AzureSiteRecoveryManagementServiceAPIServer AzureSiteRecoveryManagementServiceAPIServer
	DraServer                                   DraServer
	DraOperationStatusServer                    DraOperationStatusServer
	EmailConfigurationServer                    EmailConfigurationServer
	EventServer                                 EventServer
	FabricServer                                FabricServer
	FabricOperationsStatusServer                FabricOperationsStatusServer
	OperationsServer                            OperationsServer
	PolicyServer                                PolicyServer
	PolicyOperationStatusServer                 PolicyOperationStatusServer
	ProtectedItemServer                         ProtectedItemServer
	ProtectedItemOperationStatusServer          ProtectedItemOperationStatusServer
	RecoveryPointsServer                        RecoveryPointsServer
	ReplicationExtensionServer                  ReplicationExtensionServer
	ReplicationExtensionOperationStatusServer   ReplicationExtensionOperationStatusServer
	VaultServer                                 VaultServer
	VaultOperationStatusServer                  VaultOperationStatusServer
	WorkflowServer                              WorkflowServer
	WorkflowOperationStatusServer               WorkflowOperationStatusServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armrecoveryservicesdatareplication.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armrecoveryservicesdatareplication.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                           *ServerFactory
	trMu                                          sync.Mutex
	trAzureSiteRecoveryManagementServiceAPIServer *AzureSiteRecoveryManagementServiceAPIServerTransport
	trDraServer                                   *DraServerTransport
	trDraOperationStatusServer                    *DraOperationStatusServerTransport
	trEmailConfigurationServer                    *EmailConfigurationServerTransport
	trEventServer                                 *EventServerTransport
	trFabricServer                                *FabricServerTransport
	trFabricOperationsStatusServer                *FabricOperationsStatusServerTransport
	trOperationsServer                            *OperationsServerTransport
	trPolicyServer                                *PolicyServerTransport
	trPolicyOperationStatusServer                 *PolicyOperationStatusServerTransport
	trProtectedItemServer                         *ProtectedItemServerTransport
	trProtectedItemOperationStatusServer          *ProtectedItemOperationStatusServerTransport
	trRecoveryPointsServer                        *RecoveryPointsServerTransport
	trReplicationExtensionServer                  *ReplicationExtensionServerTransport
	trReplicationExtensionOperationStatusServer   *ReplicationExtensionOperationStatusServerTransport
	trVaultServer                                 *VaultServerTransport
	trVaultOperationStatusServer                  *VaultOperationStatusServerTransport
	trWorkflowServer                              *WorkflowServerTransport
	trWorkflowOperationStatusServer               *WorkflowOperationStatusServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "AzureSiteRecoveryManagementServiceAPIClient":
		initServer(s, &s.trAzureSiteRecoveryManagementServiceAPIServer, func() *AzureSiteRecoveryManagementServiceAPIServerTransport {
			return NewAzureSiteRecoveryManagementServiceAPIServerTransport(&s.srv.AzureSiteRecoveryManagementServiceAPIServer)
		})
		resp, err = s.trAzureSiteRecoveryManagementServiceAPIServer.Do(req)
	case "DraClient":
		initServer(s, &s.trDraServer, func() *DraServerTransport { return NewDraServerTransport(&s.srv.DraServer) })
		resp, err = s.trDraServer.Do(req)
	case "DraOperationStatusClient":
		initServer(s, &s.trDraOperationStatusServer, func() *DraOperationStatusServerTransport {
			return NewDraOperationStatusServerTransport(&s.srv.DraOperationStatusServer)
		})
		resp, err = s.trDraOperationStatusServer.Do(req)
	case "EmailConfigurationClient":
		initServer(s, &s.trEmailConfigurationServer, func() *EmailConfigurationServerTransport {
			return NewEmailConfigurationServerTransport(&s.srv.EmailConfigurationServer)
		})
		resp, err = s.trEmailConfigurationServer.Do(req)
	case "EventClient":
		initServer(s, &s.trEventServer, func() *EventServerTransport { return NewEventServerTransport(&s.srv.EventServer) })
		resp, err = s.trEventServer.Do(req)
	case "FabricClient":
		initServer(s, &s.trFabricServer, func() *FabricServerTransport { return NewFabricServerTransport(&s.srv.FabricServer) })
		resp, err = s.trFabricServer.Do(req)
	case "FabricOperationsStatusClient":
		initServer(s, &s.trFabricOperationsStatusServer, func() *FabricOperationsStatusServerTransport {
			return NewFabricOperationsStatusServerTransport(&s.srv.FabricOperationsStatusServer)
		})
		resp, err = s.trFabricOperationsStatusServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PolicyClient":
		initServer(s, &s.trPolicyServer, func() *PolicyServerTransport { return NewPolicyServerTransport(&s.srv.PolicyServer) })
		resp, err = s.trPolicyServer.Do(req)
	case "PolicyOperationStatusClient":
		initServer(s, &s.trPolicyOperationStatusServer, func() *PolicyOperationStatusServerTransport {
			return NewPolicyOperationStatusServerTransport(&s.srv.PolicyOperationStatusServer)
		})
		resp, err = s.trPolicyOperationStatusServer.Do(req)
	case "ProtectedItemClient":
		initServer(s, &s.trProtectedItemServer, func() *ProtectedItemServerTransport {
			return NewProtectedItemServerTransport(&s.srv.ProtectedItemServer)
		})
		resp, err = s.trProtectedItemServer.Do(req)
	case "ProtectedItemOperationStatusClient":
		initServer(s, &s.trProtectedItemOperationStatusServer, func() *ProtectedItemOperationStatusServerTransport {
			return NewProtectedItemOperationStatusServerTransport(&s.srv.ProtectedItemOperationStatusServer)
		})
		resp, err = s.trProtectedItemOperationStatusServer.Do(req)
	case "RecoveryPointsClient":
		initServer(s, &s.trRecoveryPointsServer, func() *RecoveryPointsServerTransport {
			return NewRecoveryPointsServerTransport(&s.srv.RecoveryPointsServer)
		})
		resp, err = s.trRecoveryPointsServer.Do(req)
	case "ReplicationExtensionClient":
		initServer(s, &s.trReplicationExtensionServer, func() *ReplicationExtensionServerTransport {
			return NewReplicationExtensionServerTransport(&s.srv.ReplicationExtensionServer)
		})
		resp, err = s.trReplicationExtensionServer.Do(req)
	case "ReplicationExtensionOperationStatusClient":
		initServer(s, &s.trReplicationExtensionOperationStatusServer, func() *ReplicationExtensionOperationStatusServerTransport {
			return NewReplicationExtensionOperationStatusServerTransport(&s.srv.ReplicationExtensionOperationStatusServer)
		})
		resp, err = s.trReplicationExtensionOperationStatusServer.Do(req)
	case "VaultClient":
		initServer(s, &s.trVaultServer, func() *VaultServerTransport { return NewVaultServerTransport(&s.srv.VaultServer) })
		resp, err = s.trVaultServer.Do(req)
	case "VaultOperationStatusClient":
		initServer(s, &s.trVaultOperationStatusServer, func() *VaultOperationStatusServerTransport {
			return NewVaultOperationStatusServerTransport(&s.srv.VaultOperationStatusServer)
		})
		resp, err = s.trVaultOperationStatusServer.Do(req)
	case "WorkflowClient":
		initServer(s, &s.trWorkflowServer, func() *WorkflowServerTransport { return NewWorkflowServerTransport(&s.srv.WorkflowServer) })
		resp, err = s.trWorkflowServer.Do(req)
	case "WorkflowOperationStatusClient":
		initServer(s, &s.trWorkflowOperationStatusServer, func() *WorkflowOperationStatusServerTransport {
			return NewWorkflowOperationStatusServerTransport(&s.srv.WorkflowOperationStatusServer)
		})
		resp, err = s.trWorkflowOperationStatusServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
