//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GroupQuotaUsagesClient contains the methods for the GroupQuotaUsages group.
// Don't use this type directly, use NewGroupQuotaUsagesClient() instead.
type GroupQuotaUsagesClient struct {
	internal *arm.Client
}

// NewGroupQuotaUsagesClient creates a new instance of GroupQuotaUsagesClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGroupQuotaUsagesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GroupQuotaUsagesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GroupQuotaUsagesClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Gets the GroupQuotas usages and limits(quota). Location is required paramter.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - location - The name of the Azure region.
//   - options - GroupQuotaUsagesClientListOptions contains the optional parameters for the GroupQuotaUsagesClient.NewListPager
//     method.
func (client *GroupQuotaUsagesClient) NewListPager(managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaUsagesClientListOptions) *runtime.Pager[GroupQuotaUsagesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GroupQuotaUsagesClientListResponse]{
		More: func(page GroupQuotaUsagesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GroupQuotaUsagesClientListResponse) (GroupQuotaUsagesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GroupQuotaUsagesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, location, options)
			}, nil)
			if err != nil {
				return GroupQuotaUsagesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GroupQuotaUsagesClient) listCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaUsagesClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationUsages/{location}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GroupQuotaUsagesClient) listHandleResponse(resp *http.Response) (GroupQuotaUsagesClientListResponse, error) {
	result := GroupQuotaUsagesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceUsageList); err != nil {
		return GroupQuotaUsagesClientListResponse{}, err
	}
	return result, nil
}
