//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GroupQuotaSubscriptionAllocationClient contains the methods for the GroupQuotaSubscriptionAllocation group.
// Don't use this type directly, use NewGroupQuotaSubscriptionAllocationClient() instead.
type GroupQuotaSubscriptionAllocationClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewGroupQuotaSubscriptionAllocationClient creates a new instance of GroupQuotaSubscriptionAllocationClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGroupQuotaSubscriptionAllocationClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GroupQuotaSubscriptionAllocationClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GroupQuotaSubscriptionAllocationClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets Quota allocated to a subscription for the specific Resource Provider, Location, ResourceName. This will include
// the GroupQuota and total quota allocated to the subscription. Only the Group quota
// allocated to the subscription can be allocated back to the MG Group Quota.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceName - Resource name.
//   - filter - FIELD SUPPORTED OPERATORS
//     location eq {location}
//     Example: $filter=location eq eastus
//   - options - GroupQuotaSubscriptionAllocationClientGetOptions contains the optional parameters for the GroupQuotaSubscriptionAllocationClient.Get
//     method.
func (client *GroupQuotaSubscriptionAllocationClient) Get(ctx context.Context, managementGroupID string, groupQuotaName string, resourceName string, filter string, options *GroupQuotaSubscriptionAllocationClientGetOptions) (GroupQuotaSubscriptionAllocationClientGetResponse, error) {
	var err error
	const operationName = "GroupQuotaSubscriptionAllocationClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, managementGroupID, groupQuotaName, resourceName, filter, options)
	if err != nil {
		return GroupQuotaSubscriptionAllocationClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GroupQuotaSubscriptionAllocationClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GroupQuotaSubscriptionAllocationClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GroupQuotaSubscriptionAllocationClient) getCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceName string, filter string, options *GroupQuotaSubscriptionAllocationClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations/{resourceName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("$filter", filter)
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GroupQuotaSubscriptionAllocationClient) getHandleResponse(resp *http.Response) (GroupQuotaSubscriptionAllocationClientGetResponse, error) {
	result := GroupQuotaSubscriptionAllocationClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionQuotaAllocations); err != nil {
		return GroupQuotaSubscriptionAllocationClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets all the quota allocated to a subscription for the specific Resource Provider, Location. This will include
// the GroupQuota and total quota allocated to the subscription. Only the Group quota
// allocated to the subscription can be allocated back to the MG Group Quota. Use the $filter parameter to filter out the
// specific resource based on the ResourceProvider/Location. $filter is a required
// parameter.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - filter - FIELD SUPPORTED OPERATORS
//     location eq {location}
//     Example: $filter=location eq eastus
//   - options - GroupQuotaSubscriptionAllocationClientListOptions contains the optional parameters for the GroupQuotaSubscriptionAllocationClient.NewListPager
//     method.
func (client *GroupQuotaSubscriptionAllocationClient) NewListPager(managementGroupID string, groupQuotaName string, filter string, options *GroupQuotaSubscriptionAllocationClientListOptions) *runtime.Pager[GroupQuotaSubscriptionAllocationClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GroupQuotaSubscriptionAllocationClientListResponse]{
		More: func(page GroupQuotaSubscriptionAllocationClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GroupQuotaSubscriptionAllocationClientListResponse) (GroupQuotaSubscriptionAllocationClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GroupQuotaSubscriptionAllocationClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, managementGroupID, groupQuotaName, filter, options)
			}, nil)
			if err != nil {
				return GroupQuotaSubscriptionAllocationClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GroupQuotaSubscriptionAllocationClient) listCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, filter string, options *GroupQuotaSubscriptionAllocationClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/subscriptions/{subscriptionId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/quotaAllocations"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("$filter", filter)
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GroupQuotaSubscriptionAllocationClient) listHandleResponse(resp *http.Response) (GroupQuotaSubscriptionAllocationClientListResponse, error) {
	result := GroupQuotaSubscriptionAllocationClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionQuotaAllocationsList); err != nil {
		return GroupQuotaSubscriptionAllocationClientListResponse{}, err
	}
	return result, nil
}
