//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicyinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// RemediationsClient contains the methods for the Remediations group.
// Don't use this type directly, use NewRemediationsClient() instead.
type RemediationsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewRemediationsClient creates a new instance of RemediationsClient with the specified values.
//   - subscriptionID - Microsoft Azure subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewRemediationsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*RemediationsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &RemediationsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CancelAtManagementGroup - Cancels a remediation at management group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - managementGroupID - Management group ID.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientCancelAtManagementGroupOptions contains the optional parameters for the RemediationsClient.CancelAtManagementGroup
//     method.
func (client *RemediationsClient) CancelAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string, options *RemediationsClientCancelAtManagementGroupOptions) (RemediationsClientCancelAtManagementGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.CancelAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.cancelAtManagementGroupCreateRequest(ctx, managementGroupID, remediationName, options)
	if err != nil {
		return RemediationsClientCancelAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCancelAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCancelAtManagementGroupResponse{}, err
	}
	resp, err := client.cancelAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// cancelAtManagementGroupCreateRequest creates the CancelAtManagementGroup request.
func (client *RemediationsClient) cancelAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, remediationName string, options *RemediationsClientCancelAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// cancelAtManagementGroupHandleResponse handles the CancelAtManagementGroup response.
func (client *RemediationsClient) cancelAtManagementGroupHandleResponse(resp *http.Response) (RemediationsClientCancelAtManagementGroupResponse, error) {
	result := RemediationsClientCancelAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCancelAtManagementGroupResponse{}, err
	}
	return result, nil
}

// CancelAtResource - Cancel a remediation at resource scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceID - Resource ID.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientCancelAtResourceOptions contains the optional parameters for the RemediationsClient.CancelAtResource
//     method.
func (client *RemediationsClient) CancelAtResource(ctx context.Context, resourceID string, remediationName string, options *RemediationsClientCancelAtResourceOptions) (RemediationsClientCancelAtResourceResponse, error) {
	var err error
	const operationName = "RemediationsClient.CancelAtResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.cancelAtResourceCreateRequest(ctx, resourceID, remediationName, options)
	if err != nil {
		return RemediationsClientCancelAtResourceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCancelAtResourceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCancelAtResourceResponse{}, err
	}
	resp, err := client.cancelAtResourceHandleResponse(httpResp)
	return resp, err
}

// cancelAtResourceCreateRequest creates the CancelAtResource request.
func (client *RemediationsClient) cancelAtResourceCreateRequest(ctx context.Context, resourceID string, remediationName string, options *RemediationsClientCancelAtResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// cancelAtResourceHandleResponse handles the CancelAtResource response.
func (client *RemediationsClient) cancelAtResourceHandleResponse(resp *http.Response) (RemediationsClientCancelAtResourceResponse, error) {
	result := RemediationsClientCancelAtResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCancelAtResourceResponse{}, err
	}
	return result, nil
}

// CancelAtResourceGroup - Cancels a remediation at resource group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceGroupName - Resource group name.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientCancelAtResourceGroupOptions contains the optional parameters for the RemediationsClient.CancelAtResourceGroup
//     method.
func (client *RemediationsClient) CancelAtResourceGroup(ctx context.Context, resourceGroupName string, remediationName string, options *RemediationsClientCancelAtResourceGroupOptions) (RemediationsClientCancelAtResourceGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.CancelAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.cancelAtResourceGroupCreateRequest(ctx, resourceGroupName, remediationName, options)
	if err != nil {
		return RemediationsClientCancelAtResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCancelAtResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCancelAtResourceGroupResponse{}, err
	}
	resp, err := client.cancelAtResourceGroupHandleResponse(httpResp)
	return resp, err
}

// cancelAtResourceGroupCreateRequest creates the CancelAtResourceGroup request.
func (client *RemediationsClient) cancelAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, remediationName string, options *RemediationsClientCancelAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// cancelAtResourceGroupHandleResponse handles the CancelAtResourceGroup response.
func (client *RemediationsClient) cancelAtResourceGroupHandleResponse(resp *http.Response) (RemediationsClientCancelAtResourceGroupResponse, error) {
	result := RemediationsClientCancelAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCancelAtResourceGroupResponse{}, err
	}
	return result, nil
}

// CancelAtSubscription - Cancels a remediation at subscription scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientCancelAtSubscriptionOptions contains the optional parameters for the RemediationsClient.CancelAtSubscription
//     method.
func (client *RemediationsClient) CancelAtSubscription(ctx context.Context, remediationName string, options *RemediationsClientCancelAtSubscriptionOptions) (RemediationsClientCancelAtSubscriptionResponse, error) {
	var err error
	const operationName = "RemediationsClient.CancelAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.cancelAtSubscriptionCreateRequest(ctx, remediationName, options)
	if err != nil {
		return RemediationsClientCancelAtSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCancelAtSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCancelAtSubscriptionResponse{}, err
	}
	resp, err := client.cancelAtSubscriptionHandleResponse(httpResp)
	return resp, err
}

// cancelAtSubscriptionCreateRequest creates the CancelAtSubscription request.
func (client *RemediationsClient) cancelAtSubscriptionCreateRequest(ctx context.Context, remediationName string, options *RemediationsClientCancelAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/cancel"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// cancelAtSubscriptionHandleResponse handles the CancelAtSubscription response.
func (client *RemediationsClient) cancelAtSubscriptionHandleResponse(resp *http.Response) (RemediationsClientCancelAtSubscriptionResponse, error) {
	result := RemediationsClientCancelAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCancelAtSubscriptionResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtManagementGroup - Creates or updates a remediation at management group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - managementGroupID - Management group ID.
//   - remediationName - The name of the remediation.
//   - parameters - The remediation parameters.
//   - options - RemediationsClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtManagementGroup
//     method.
func (client *RemediationsClient) CreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtManagementGroupOptions) (RemediationsClientCreateOrUpdateAtManagementGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.CreateOrUpdateAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtManagementGroupCreateRequest(ctx, managementGroupID, remediationName, parameters, options)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	resp, err := client.createOrUpdateAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtManagementGroupCreateRequest creates the CreateOrUpdateAtManagementGroup request.
func (client *RemediationsClient) createOrUpdateAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtManagementGroupHandleResponse handles the CreateOrUpdateAtManagementGroup response.
func (client *RemediationsClient) createOrUpdateAtManagementGroupHandleResponse(resp *http.Response) (RemediationsClientCreateOrUpdateAtManagementGroupResponse, error) {
	result := RemediationsClientCreateOrUpdateAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtResource - Creates or updates a remediation at resource scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceID - Resource ID.
//   - remediationName - The name of the remediation.
//   - parameters - The remediation parameters.
//   - options - RemediationsClientCreateOrUpdateAtResourceOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtResource
//     method.
func (client *RemediationsClient) CreateOrUpdateAtResource(ctx context.Context, resourceID string, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtResourceOptions) (RemediationsClientCreateOrUpdateAtResourceResponse, error) {
	var err error
	const operationName = "RemediationsClient.CreateOrUpdateAtResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtResourceCreateRequest(ctx, resourceID, remediationName, parameters, options)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtResourceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtResourceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCreateOrUpdateAtResourceResponse{}, err
	}
	resp, err := client.createOrUpdateAtResourceHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtResourceCreateRequest creates the CreateOrUpdateAtResource request.
func (client *RemediationsClient) createOrUpdateAtResourceCreateRequest(ctx context.Context, resourceID string, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtResourceHandleResponse handles the CreateOrUpdateAtResource response.
func (client *RemediationsClient) createOrUpdateAtResourceHandleResponse(resp *http.Response) (RemediationsClientCreateOrUpdateAtResourceResponse, error) {
	result := RemediationsClientCreateOrUpdateAtResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCreateOrUpdateAtResourceResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtResourceGroup - Creates or updates a remediation at resource group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceGroupName - Resource group name.
//   - remediationName - The name of the remediation.
//   - parameters - The remediation parameters.
//   - options - RemediationsClientCreateOrUpdateAtResourceGroupOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtResourceGroup
//     method.
func (client *RemediationsClient) CreateOrUpdateAtResourceGroup(ctx context.Context, resourceGroupName string, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtResourceGroupOptions) (RemediationsClientCreateOrUpdateAtResourceGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.CreateOrUpdateAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtResourceGroupCreateRequest(ctx, resourceGroupName, remediationName, parameters, options)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCreateOrUpdateAtResourceGroupResponse{}, err
	}
	resp, err := client.createOrUpdateAtResourceGroupHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtResourceGroupCreateRequest creates the CreateOrUpdateAtResourceGroup request.
func (client *RemediationsClient) createOrUpdateAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtResourceGroupHandleResponse handles the CreateOrUpdateAtResourceGroup response.
func (client *RemediationsClient) createOrUpdateAtResourceGroupHandleResponse(resp *http.Response) (RemediationsClientCreateOrUpdateAtResourceGroupResponse, error) {
	result := RemediationsClientCreateOrUpdateAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCreateOrUpdateAtResourceGroupResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtSubscription - Creates or updates a remediation at subscription scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - remediationName - The name of the remediation.
//   - parameters - The remediation parameters.
//   - options - RemediationsClientCreateOrUpdateAtSubscriptionOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtSubscription
//     method.
func (client *RemediationsClient) CreateOrUpdateAtSubscription(ctx context.Context, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtSubscriptionOptions) (RemediationsClientCreateOrUpdateAtSubscriptionResponse, error) {
	var err error
	const operationName = "RemediationsClient.CreateOrUpdateAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtSubscriptionCreateRequest(ctx, remediationName, parameters, options)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientCreateOrUpdateAtSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientCreateOrUpdateAtSubscriptionResponse{}, err
	}
	resp, err := client.createOrUpdateAtSubscriptionHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtSubscriptionCreateRequest creates the CreateOrUpdateAtSubscription request.
func (client *RemediationsClient) createOrUpdateAtSubscriptionCreateRequest(ctx context.Context, remediationName string, parameters Remediation, options *RemediationsClientCreateOrUpdateAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtSubscriptionHandleResponse handles the CreateOrUpdateAtSubscription response.
func (client *RemediationsClient) createOrUpdateAtSubscriptionHandleResponse(resp *http.Response) (RemediationsClientCreateOrUpdateAtSubscriptionResponse, error) {
	result := RemediationsClientCreateOrUpdateAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientCreateOrUpdateAtSubscriptionResponse{}, err
	}
	return result, nil
}

// DeleteAtManagementGroup - Deletes an existing remediation at management group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - managementGroupID - Management group ID.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientDeleteAtManagementGroupOptions contains the optional parameters for the RemediationsClient.DeleteAtManagementGroup
//     method.
func (client *RemediationsClient) DeleteAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string, options *RemediationsClientDeleteAtManagementGroupOptions) (RemediationsClientDeleteAtManagementGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.DeleteAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtManagementGroupCreateRequest(ctx, managementGroupID, remediationName, options)
	if err != nil {
		return RemediationsClientDeleteAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientDeleteAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientDeleteAtManagementGroupResponse{}, err
	}
	resp, err := client.deleteAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// deleteAtManagementGroupCreateRequest creates the DeleteAtManagementGroup request.
func (client *RemediationsClient) deleteAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, remediationName string, options *RemediationsClientDeleteAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAtManagementGroupHandleResponse handles the DeleteAtManagementGroup response.
func (client *RemediationsClient) deleteAtManagementGroupHandleResponse(resp *http.Response) (RemediationsClientDeleteAtManagementGroupResponse, error) {
	result := RemediationsClientDeleteAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientDeleteAtManagementGroupResponse{}, err
	}
	return result, nil
}

// DeleteAtResource - Deletes an existing remediation at individual resource scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceID - Resource ID.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientDeleteAtResourceOptions contains the optional parameters for the RemediationsClient.DeleteAtResource
//     method.
func (client *RemediationsClient) DeleteAtResource(ctx context.Context, resourceID string, remediationName string, options *RemediationsClientDeleteAtResourceOptions) (RemediationsClientDeleteAtResourceResponse, error) {
	var err error
	const operationName = "RemediationsClient.DeleteAtResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtResourceCreateRequest(ctx, resourceID, remediationName, options)
	if err != nil {
		return RemediationsClientDeleteAtResourceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientDeleteAtResourceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientDeleteAtResourceResponse{}, err
	}
	resp, err := client.deleteAtResourceHandleResponse(httpResp)
	return resp, err
}

// deleteAtResourceCreateRequest creates the DeleteAtResource request.
func (client *RemediationsClient) deleteAtResourceCreateRequest(ctx context.Context, resourceID string, remediationName string, options *RemediationsClientDeleteAtResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAtResourceHandleResponse handles the DeleteAtResource response.
func (client *RemediationsClient) deleteAtResourceHandleResponse(resp *http.Response) (RemediationsClientDeleteAtResourceResponse, error) {
	result := RemediationsClientDeleteAtResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientDeleteAtResourceResponse{}, err
	}
	return result, nil
}

// DeleteAtResourceGroup - Deletes an existing remediation at resource group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceGroupName - Resource group name.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientDeleteAtResourceGroupOptions contains the optional parameters for the RemediationsClient.DeleteAtResourceGroup
//     method.
func (client *RemediationsClient) DeleteAtResourceGroup(ctx context.Context, resourceGroupName string, remediationName string, options *RemediationsClientDeleteAtResourceGroupOptions) (RemediationsClientDeleteAtResourceGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.DeleteAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtResourceGroupCreateRequest(ctx, resourceGroupName, remediationName, options)
	if err != nil {
		return RemediationsClientDeleteAtResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientDeleteAtResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientDeleteAtResourceGroupResponse{}, err
	}
	resp, err := client.deleteAtResourceGroupHandleResponse(httpResp)
	return resp, err
}

// deleteAtResourceGroupCreateRequest creates the DeleteAtResourceGroup request.
func (client *RemediationsClient) deleteAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, remediationName string, options *RemediationsClientDeleteAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAtResourceGroupHandleResponse handles the DeleteAtResourceGroup response.
func (client *RemediationsClient) deleteAtResourceGroupHandleResponse(resp *http.Response) (RemediationsClientDeleteAtResourceGroupResponse, error) {
	result := RemediationsClientDeleteAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientDeleteAtResourceGroupResponse{}, err
	}
	return result, nil
}

// DeleteAtSubscription - Deletes an existing remediation at subscription scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientDeleteAtSubscriptionOptions contains the optional parameters for the RemediationsClient.DeleteAtSubscription
//     method.
func (client *RemediationsClient) DeleteAtSubscription(ctx context.Context, remediationName string, options *RemediationsClientDeleteAtSubscriptionOptions) (RemediationsClientDeleteAtSubscriptionResponse, error) {
	var err error
	const operationName = "RemediationsClient.DeleteAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtSubscriptionCreateRequest(ctx, remediationName, options)
	if err != nil {
		return RemediationsClientDeleteAtSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientDeleteAtSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientDeleteAtSubscriptionResponse{}, err
	}
	resp, err := client.deleteAtSubscriptionHandleResponse(httpResp)
	return resp, err
}

// deleteAtSubscriptionCreateRequest creates the DeleteAtSubscription request.
func (client *RemediationsClient) deleteAtSubscriptionCreateRequest(ctx context.Context, remediationName string, options *RemediationsClientDeleteAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteAtSubscriptionHandleResponse handles the DeleteAtSubscription response.
func (client *RemediationsClient) deleteAtSubscriptionHandleResponse(resp *http.Response) (RemediationsClientDeleteAtSubscriptionResponse, error) {
	result := RemediationsClientDeleteAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientDeleteAtSubscriptionResponse{}, err
	}
	return result, nil
}

// GetAtManagementGroup - Gets an existing remediation at management group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - managementGroupID - Management group ID.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientGetAtManagementGroupOptions contains the optional parameters for the RemediationsClient.GetAtManagementGroup
//     method.
func (client *RemediationsClient) GetAtManagementGroup(ctx context.Context, managementGroupID string, remediationName string, options *RemediationsClientGetAtManagementGroupOptions) (RemediationsClientGetAtManagementGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.GetAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtManagementGroupCreateRequest(ctx, managementGroupID, remediationName, options)
	if err != nil {
		return RemediationsClientGetAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientGetAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientGetAtManagementGroupResponse{}, err
	}
	resp, err := client.getAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// getAtManagementGroupCreateRequest creates the GetAtManagementGroup request.
func (client *RemediationsClient) getAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, remediationName string, options *RemediationsClientGetAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtManagementGroupHandleResponse handles the GetAtManagementGroup response.
func (client *RemediationsClient) getAtManagementGroupHandleResponse(resp *http.Response) (RemediationsClientGetAtManagementGroupResponse, error) {
	result := RemediationsClientGetAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientGetAtManagementGroupResponse{}, err
	}
	return result, nil
}

// GetAtResource - Gets an existing remediation at resource scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceID - Resource ID.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientGetAtResourceOptions contains the optional parameters for the RemediationsClient.GetAtResource
//     method.
func (client *RemediationsClient) GetAtResource(ctx context.Context, resourceID string, remediationName string, options *RemediationsClientGetAtResourceOptions) (RemediationsClientGetAtResourceResponse, error) {
	var err error
	const operationName = "RemediationsClient.GetAtResource"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtResourceCreateRequest(ctx, resourceID, remediationName, options)
	if err != nil {
		return RemediationsClientGetAtResourceResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientGetAtResourceResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientGetAtResourceResponse{}, err
	}
	resp, err := client.getAtResourceHandleResponse(httpResp)
	return resp, err
}

// getAtResourceCreateRequest creates the GetAtResource request.
func (client *RemediationsClient) getAtResourceCreateRequest(ctx context.Context, resourceID string, remediationName string, options *RemediationsClientGetAtResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceHandleResponse handles the GetAtResource response.
func (client *RemediationsClient) getAtResourceHandleResponse(resp *http.Response) (RemediationsClientGetAtResourceResponse, error) {
	result := RemediationsClientGetAtResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientGetAtResourceResponse{}, err
	}
	return result, nil
}

// GetAtResourceGroup - Gets an existing remediation at resource group scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - resourceGroupName - Resource group name.
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientGetAtResourceGroupOptions contains the optional parameters for the RemediationsClient.GetAtResourceGroup
//     method.
func (client *RemediationsClient) GetAtResourceGroup(ctx context.Context, resourceGroupName string, remediationName string, options *RemediationsClientGetAtResourceGroupOptions) (RemediationsClientGetAtResourceGroupResponse, error) {
	var err error
	const operationName = "RemediationsClient.GetAtResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtResourceGroupCreateRequest(ctx, resourceGroupName, remediationName, options)
	if err != nil {
		return RemediationsClientGetAtResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientGetAtResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientGetAtResourceGroupResponse{}, err
	}
	resp, err := client.getAtResourceGroupHandleResponse(httpResp)
	return resp, err
}

// getAtResourceGroupCreateRequest creates the GetAtResourceGroup request.
func (client *RemediationsClient) getAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, remediationName string, options *RemediationsClientGetAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceGroupHandleResponse handles the GetAtResourceGroup response.
func (client *RemediationsClient) getAtResourceGroupHandleResponse(resp *http.Response) (RemediationsClientGetAtResourceGroupResponse, error) {
	result := RemediationsClientGetAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientGetAtResourceGroupResponse{}, err
	}
	return result, nil
}

// GetAtSubscription - Gets an existing remediation at subscription scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-10-01
//   - remediationName - The name of the remediation.
//   - options - RemediationsClientGetAtSubscriptionOptions contains the optional parameters for the RemediationsClient.GetAtSubscription
//     method.
func (client *RemediationsClient) GetAtSubscription(ctx context.Context, remediationName string, options *RemediationsClientGetAtSubscriptionOptions) (RemediationsClientGetAtSubscriptionResponse, error) {
	var err error
	const operationName = "RemediationsClient.GetAtSubscription"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtSubscriptionCreateRequest(ctx, remediationName, options)
	if err != nil {
		return RemediationsClientGetAtSubscriptionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RemediationsClientGetAtSubscriptionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RemediationsClientGetAtSubscriptionResponse{}, err
	}
	resp, err := client.getAtSubscriptionHandleResponse(httpResp)
	return resp, err
}

// getAtSubscriptionCreateRequest creates the GetAtSubscription request.
func (client *RemediationsClient) getAtSubscriptionCreateRequest(ctx context.Context, remediationName string, options *RemediationsClientGetAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtSubscriptionHandleResponse handles the GetAtSubscription response.
func (client *RemediationsClient) getAtSubscriptionHandleResponse(resp *http.Response) (RemediationsClientGetAtSubscriptionResponse, error) {
	result := RemediationsClientGetAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Remediation); err != nil {
		return RemediationsClientGetAtSubscriptionResponse{}, err
	}
	return result, nil
}

// NewListDeploymentsAtManagementGroupPager - Gets all deployments for a remediation at management group scope.
//
// Generated from API version 2021-10-01
//   - managementGroupID - Management group ID.
//   - remediationName - The name of the remediation.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListDeploymentsAtManagementGroupOptions contains the optional parameters for the RemediationsClient.NewListDeploymentsAtManagementGroupPager
//     method.
func (client *RemediationsClient) NewListDeploymentsAtManagementGroupPager(managementGroupID string, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtManagementGroupOptions) *runtime.Pager[RemediationsClientListDeploymentsAtManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListDeploymentsAtManagementGroupResponse]{
		More: func(page RemediationsClientListDeploymentsAtManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListDeploymentsAtManagementGroupResponse) (RemediationsClientListDeploymentsAtManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListDeploymentsAtManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDeploymentsAtManagementGroupCreateRequest(ctx, managementGroupID, remediationName, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListDeploymentsAtManagementGroupResponse{}, err
			}
			return client.listDeploymentsAtManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDeploymentsAtManagementGroupCreateRequest creates the ListDeploymentsAtManagementGroup request.
func (client *RemediationsClient) listDeploymentsAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentsAtManagementGroupHandleResponse handles the ListDeploymentsAtManagementGroup response.
func (client *RemediationsClient) listDeploymentsAtManagementGroupHandleResponse(resp *http.Response) (RemediationsClientListDeploymentsAtManagementGroupResponse, error) {
	result := RemediationsClientListDeploymentsAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationDeploymentsListResult); err != nil {
		return RemediationsClientListDeploymentsAtManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListDeploymentsAtResourcePager - Gets all deployments for a remediation at resource scope.
//
// Generated from API version 2021-10-01
//   - resourceID - Resource ID.
//   - remediationName - The name of the remediation.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListDeploymentsAtResourceOptions contains the optional parameters for the RemediationsClient.NewListDeploymentsAtResourcePager
//     method.
func (client *RemediationsClient) NewListDeploymentsAtResourcePager(resourceID string, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtResourceOptions) *runtime.Pager[RemediationsClientListDeploymentsAtResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListDeploymentsAtResourceResponse]{
		More: func(page RemediationsClientListDeploymentsAtResourceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListDeploymentsAtResourceResponse) (RemediationsClientListDeploymentsAtResourceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListDeploymentsAtResourcePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDeploymentsAtResourceCreateRequest(ctx, resourceID, remediationName, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListDeploymentsAtResourceResponse{}, err
			}
			return client.listDeploymentsAtResourceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDeploymentsAtResourceCreateRequest creates the ListDeploymentsAtResource request.
func (client *RemediationsClient) listDeploymentsAtResourceCreateRequest(ctx context.Context, resourceID string, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentsAtResourceHandleResponse handles the ListDeploymentsAtResource response.
func (client *RemediationsClient) listDeploymentsAtResourceHandleResponse(resp *http.Response) (RemediationsClientListDeploymentsAtResourceResponse, error) {
	result := RemediationsClientListDeploymentsAtResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationDeploymentsListResult); err != nil {
		return RemediationsClientListDeploymentsAtResourceResponse{}, err
	}
	return result, nil
}

// NewListDeploymentsAtResourceGroupPager - Gets all deployments for a remediation at resource group scope.
//
// Generated from API version 2021-10-01
//   - resourceGroupName - Resource group name.
//   - remediationName - The name of the remediation.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListDeploymentsAtResourceGroupOptions contains the optional parameters for the RemediationsClient.NewListDeploymentsAtResourceGroupPager
//     method.
func (client *RemediationsClient) NewListDeploymentsAtResourceGroupPager(resourceGroupName string, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtResourceGroupOptions) *runtime.Pager[RemediationsClientListDeploymentsAtResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListDeploymentsAtResourceGroupResponse]{
		More: func(page RemediationsClientListDeploymentsAtResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListDeploymentsAtResourceGroupResponse) (RemediationsClientListDeploymentsAtResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListDeploymentsAtResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDeploymentsAtResourceGroupCreateRequest(ctx, resourceGroupName, remediationName, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListDeploymentsAtResourceGroupResponse{}, err
			}
			return client.listDeploymentsAtResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDeploymentsAtResourceGroupCreateRequest creates the ListDeploymentsAtResourceGroup request.
func (client *RemediationsClient) listDeploymentsAtResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentsAtResourceGroupHandleResponse handles the ListDeploymentsAtResourceGroup response.
func (client *RemediationsClient) listDeploymentsAtResourceGroupHandleResponse(resp *http.Response) (RemediationsClientListDeploymentsAtResourceGroupResponse, error) {
	result := RemediationsClientListDeploymentsAtResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationDeploymentsListResult); err != nil {
		return RemediationsClientListDeploymentsAtResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListDeploymentsAtSubscriptionPager - Gets all deployments for a remediation at subscription scope.
//
// Generated from API version 2021-10-01
//   - remediationName - The name of the remediation.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListDeploymentsAtSubscriptionOptions contains the optional parameters for the RemediationsClient.NewListDeploymentsAtSubscriptionPager
//     method.
func (client *RemediationsClient) NewListDeploymentsAtSubscriptionPager(remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtSubscriptionOptions) *runtime.Pager[RemediationsClientListDeploymentsAtSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListDeploymentsAtSubscriptionResponse]{
		More: func(page RemediationsClientListDeploymentsAtSubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListDeploymentsAtSubscriptionResponse) (RemediationsClientListDeploymentsAtSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListDeploymentsAtSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDeploymentsAtSubscriptionCreateRequest(ctx, remediationName, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListDeploymentsAtSubscriptionResponse{}, err
			}
			return client.listDeploymentsAtSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDeploymentsAtSubscriptionCreateRequest creates the ListDeploymentsAtSubscription request.
func (client *RemediationsClient) listDeploymentsAtSubscriptionCreateRequest(ctx context.Context, remediationName string, queryOptions *QueryOptions, options *RemediationsClientListDeploymentsAtSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations/{remediationName}/listDeployments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if remediationName == "" {
		return nil, errors.New("parameter remediationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{remediationName}", url.PathEscape(remediationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeploymentsAtSubscriptionHandleResponse handles the ListDeploymentsAtSubscription response.
func (client *RemediationsClient) listDeploymentsAtSubscriptionHandleResponse(resp *http.Response) (RemediationsClientListDeploymentsAtSubscriptionResponse, error) {
	result := RemediationsClientListDeploymentsAtSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationDeploymentsListResult); err != nil {
		return RemediationsClientListDeploymentsAtSubscriptionResponse{}, err
	}
	return result, nil
}

// NewListForManagementGroupPager - Gets all remediations for the management group.
//
// Generated from API version 2021-10-01
//   - managementGroupID - Management group ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListForManagementGroupOptions contains the optional parameters for the RemediationsClient.NewListForManagementGroupPager
//     method.
func (client *RemediationsClient) NewListForManagementGroupPager(managementGroupID string, queryOptions *QueryOptions, options *RemediationsClientListForManagementGroupOptions) *runtime.Pager[RemediationsClientListForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListForManagementGroupResponse]{
		More: func(page RemediationsClientListForManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListForManagementGroupResponse) (RemediationsClientListForManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListForManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForManagementGroupCreateRequest(ctx, managementGroupID, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListForManagementGroupResponse{}, err
			}
			return client.listForManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForManagementGroupCreateRequest creates the ListForManagementGroup request.
func (client *RemediationsClient) listForManagementGroupCreateRequest(ctx context.Context, managementGroupID string, queryOptions *QueryOptions, options *RemediationsClientListForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/{managementGroupsNamespace}/managementGroups/{managementGroupId}/providers/Microsoft.PolicyInsights/remediations"
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupsNamespace}", url.PathEscape("Microsoft.Management"))
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForManagementGroupHandleResponse handles the ListForManagementGroup response.
func (client *RemediationsClient) listForManagementGroupHandleResponse(resp *http.Response) (RemediationsClientListForManagementGroupResponse, error) {
	result := RemediationsClientListForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationListResult); err != nil {
		return RemediationsClientListForManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListForResourcePager - Gets all remediations for a resource.
//
// Generated from API version 2021-10-01
//   - resourceID - Resource ID.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListForResourceOptions contains the optional parameters for the RemediationsClient.NewListForResourcePager
//     method.
func (client *RemediationsClient) NewListForResourcePager(resourceID string, queryOptions *QueryOptions, options *RemediationsClientListForResourceOptions) *runtime.Pager[RemediationsClientListForResourceResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListForResourceResponse]{
		More: func(page RemediationsClientListForResourceResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListForResourceResponse) (RemediationsClientListForResourceResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListForResourcePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForResourceCreateRequest(ctx, resourceID, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListForResourceResponse{}, err
			}
			return client.listForResourceHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForResourceCreateRequest creates the ListForResource request.
func (client *RemediationsClient) listForResourceCreateRequest(ctx context.Context, resourceID string, queryOptions *QueryOptions, options *RemediationsClientListForResourceOptions) (*policy.Request, error) {
	urlPath := "/{resourceId}/providers/Microsoft.PolicyInsights/remediations"
	urlPath = strings.ReplaceAll(urlPath, "{resourceId}", resourceID)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForResourceHandleResponse handles the ListForResource response.
func (client *RemediationsClient) listForResourceHandleResponse(resp *http.Response) (RemediationsClientListForResourceResponse, error) {
	result := RemediationsClientListForResourceResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationListResult); err != nil {
		return RemediationsClientListForResourceResponse{}, err
	}
	return result, nil
}

// NewListForResourceGroupPager - Gets all remediations for the subscription.
//
// Generated from API version 2021-10-01
//   - resourceGroupName - Resource group name.
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListForResourceGroupOptions contains the optional parameters for the RemediationsClient.NewListForResourceGroupPager
//     method.
func (client *RemediationsClient) NewListForResourceGroupPager(resourceGroupName string, queryOptions *QueryOptions, options *RemediationsClientListForResourceGroupOptions) *runtime.Pager[RemediationsClientListForResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListForResourceGroupResponse]{
		More: func(page RemediationsClientListForResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListForResourceGroupResponse) (RemediationsClientListForResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListForResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForResourceGroupCreateRequest(ctx, resourceGroupName, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListForResourceGroupResponse{}, err
			}
			return client.listForResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForResourceGroupCreateRequest creates the ListForResourceGroup request.
func (client *RemediationsClient) listForResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, queryOptions *QueryOptions, options *RemediationsClientListForResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PolicyInsights/remediations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForResourceGroupHandleResponse handles the ListForResourceGroup response.
func (client *RemediationsClient) listForResourceGroupHandleResponse(resp *http.Response) (RemediationsClientListForResourceGroupResponse, error) {
	result := RemediationsClientListForResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationListResult); err != nil {
		return RemediationsClientListForResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListForSubscriptionPager - Gets all remediations for the subscription.
//
// Generated from API version 2021-10-01
//   - QueryOptions - QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
//     method.
//   - options - RemediationsClientListForSubscriptionOptions contains the optional parameters for the RemediationsClient.NewListForSubscriptionPager
//     method.
func (client *RemediationsClient) NewListForSubscriptionPager(queryOptions *QueryOptions, options *RemediationsClientListForSubscriptionOptions) *runtime.Pager[RemediationsClientListForSubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[RemediationsClientListForSubscriptionResponse]{
		More: func(page RemediationsClientListForSubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RemediationsClientListForSubscriptionResponse) (RemediationsClientListForSubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RemediationsClient.NewListForSubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForSubscriptionCreateRequest(ctx, queryOptions, options)
			}, nil)
			if err != nil {
				return RemediationsClientListForSubscriptionResponse{}, err
			}
			return client.listForSubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForSubscriptionCreateRequest creates the ListForSubscription request.
func (client *RemediationsClient) listForSubscriptionCreateRequest(ctx context.Context, queryOptions *QueryOptions, options *RemediationsClientListForSubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.PolicyInsights/remediations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if queryOptions != nil && queryOptions.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*queryOptions.Top), 10))
	}
	if queryOptions != nil && queryOptions.Filter != nil {
		reqQP.Set("$filter", *queryOptions.Filter)
	}
	reqQP.Set("api-version", "2021-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForSubscriptionHandleResponse handles the ListForSubscription response.
func (client *RemediationsClient) listForSubscriptionHandleResponse(resp *http.Response) (RemediationsClientListForSubscriptionResponse, error) {
	result := RemediationsClientListForSubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RemediationListResult); err != nil {
		return RemediationsClientListForSubscriptionResponse{}, err
	}
	return result, nil
}
