//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpeering

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ReceivedRoutesClient contains the methods for the ReceivedRoutes group.
// Don't use this type directly, use NewReceivedRoutesClient() instead.
type ReceivedRoutesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewReceivedRoutesClient creates a new instance of ReceivedRoutesClient with the specified values.
//   - subscriptionID - The Azure subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewReceivedRoutesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ReceivedRoutesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ReceivedRoutesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListByPeeringPager - Lists the prefixes received over the specified peering under the given subscription and resource
// group.
//
// Generated from API version 2022-01-01
//   - resourceGroupName - The name of the resource group.
//   - peeringName - The name of the peering.
//   - options - ReceivedRoutesClientListByPeeringOptions contains the optional parameters for the ReceivedRoutesClient.NewListByPeeringPager
//     method.
func (client *ReceivedRoutesClient) NewListByPeeringPager(resourceGroupName string, peeringName string, options *ReceivedRoutesClientListByPeeringOptions) *runtime.Pager[ReceivedRoutesClientListByPeeringResponse] {
	return runtime.NewPager(runtime.PagingHandler[ReceivedRoutesClientListByPeeringResponse]{
		More: func(page ReceivedRoutesClientListByPeeringResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ReceivedRoutesClientListByPeeringResponse) (ReceivedRoutesClientListByPeeringResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ReceivedRoutesClient.NewListByPeeringPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByPeeringCreateRequest(ctx, resourceGroupName, peeringName, options)
			}, nil)
			if err != nil {
				return ReceivedRoutesClientListByPeeringResponse{}, err
			}
			return client.listByPeeringHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByPeeringCreateRequest creates the ListByPeering request.
func (client *ReceivedRoutesClient) listByPeeringCreateRequest(ctx context.Context, resourceGroupName string, peeringName string, options *ReceivedRoutesClientListByPeeringOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peerings/{peeringName}/receivedRoutes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if peeringName == "" {
		return nil, errors.New("parameter peeringName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{peeringName}", url.PathEscape(peeringName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Prefix != nil {
		reqQP.Set("prefix", *options.Prefix)
	}
	if options != nil && options.AsPath != nil {
		reqQP.Set("asPath", *options.AsPath)
	}
	if options != nil && options.OriginAsValidationState != nil {
		reqQP.Set("originAsValidationState", *options.OriginAsValidationState)
	}
	if options != nil && options.RpkiValidationState != nil {
		reqQP.Set("rpkiValidationState", *options.RpkiValidationState)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	reqQP.Set("api-version", "2022-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByPeeringHandleResponse handles the ListByPeering response.
func (client *ReceivedRoutesClient) listByPeeringHandleResponse(resp *http.Response) (ReceivedRoutesClientListByPeeringResponse, error) {
	result := ReceivedRoutesClientListByPeeringResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ReceivedRouteListResult); err != nil {
		return ReceivedRoutesClientListByPeeringResponse{}, err
	}
	return result, nil
}
