//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armoperationalinsights

import "time"

// AssociatedWorkspace - The list of Log Analytics workspaces associated with the cluster.
type AssociatedWorkspace struct {
	// READ-ONLY; The time of workspace association.
	AssociateDate *string

	// READ-ONLY; The ResourceId id the assigned workspace.
	ResourceID *string

	// READ-ONLY; The id of the assigned workspace.
	WorkspaceID *string

	// READ-ONLY; The name id the assigned workspace.
	WorkspaceName *string
}

// AvailableServiceTier - Service Tier details.
type AvailableServiceTier struct {
	// READ-ONLY; The capacity reservation level in GB per day. Returned for the Capacity Reservation Service Tier.
	CapacityReservationLevel *int64

	// READ-ONLY; The default retention for the Service Tier, in days.
	DefaultRetention *int64

	// READ-ONLY; True if the Service Tier is enabled for the workspace.
	Enabled *bool

	// READ-ONLY; Time when the sku was last updated for the workspace. Returned for the Capacity Reservation Service Tier.
	LastSKUUpdate *string

	// READ-ONLY; The maximum retention for the Service Tier, in days.
	MaximumRetention *int64

	// READ-ONLY; The minimum retention for the Service Tier, in days.
	MinimumRetention *int64

	// READ-ONLY; The name of the Service Tier.
	ServiceTier *SKUNameEnum
}

// AzureEntityResource - The resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CapacityReservationProperties - The Capacity Reservation properties.
type CapacityReservationProperties struct {
	// READ-ONLY; The last time Sku was updated.
	LastSKUUpdate *string

	// READ-ONLY; Minimum CapacityReservation value in GB.
	MinCapacity *int64
}

// Cluster - The top level Log Analytics cluster resource container.
type Cluster struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The identity of the resource.
	Identity *Identity

	// Log Analytics cluster properties.
	Properties *ClusterProperties

	// The sku properties.
	SKU *ClusterSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ClusterListResult - The list clusters operation response.
type ClusterListResult struct {
	// The link used to get the next page of recommendations.
	NextLink *string

	// A list of Log Analytics clusters.
	Value []*Cluster
}

// ClusterPatch - The top level Log Analytics cluster resource container.
type ClusterPatch struct {
	// The identity of the resource.
	Identity *Identity

	// Log Analytics cluster properties.
	Properties *ClusterPatchProperties

	// The sku properties.
	SKU *ClusterSKU

	// Resource tags.
	Tags map[string]*string
}

// ClusterPatchProperties - Log Analytics cluster patch properties.
type ClusterPatchProperties struct {
	// The cluster's billing type.
	BillingType *BillingType

	// The associated key properties.
	KeyVaultProperties *KeyVaultProperties
}

// ClusterProperties - Cluster properties.
type ClusterProperties struct {
	// The list of Log Analytics workspaces associated with the cluster
	AssociatedWorkspaces []*AssociatedWorkspace

	// The cluster's billing type.
	BillingType *BillingType

	// Additional properties for capacity reservation
	CapacityReservationProperties *CapacityReservationProperties

	// Sets whether the cluster will support availability zones. This can be set as true only in regions where Azure Data Explorer
	// support Availability Zones. This Property can not be modified after cluster
	// creation. Default value is 'true' if region supports Availability Zones.
	IsAvailabilityZonesEnabled *bool

	// Configures whether cluster will use double encryption. This Property can not be modified after cluster creation. Default
	// value is 'true'
	IsDoubleEncryptionEnabled *bool

	// The associated key properties.
	KeyVaultProperties *KeyVaultProperties

	// READ-ONLY; The ID associated with the cluster.
	ClusterID *string

	// READ-ONLY; The cluster creation time
	CreatedDate *string

	// READ-ONLY; The last time the cluster was updated.
	LastModifiedDate *string

	// READ-ONLY; The provisioning state of the cluster.
	ProvisioningState *ClusterEntityStatus
}

// ClusterSKU - The cluster sku definition.
type ClusterSKU struct {
	// The capacity value
	Capacity *Capacity

	// The name of the SKU.
	Name *ClusterSKUNameEnum
}

// CoreSummary - The core summary of a search.
type CoreSummary struct {
	// REQUIRED; The number of documents of a core summary.
	NumberOfDocuments *int64

	// The status of a core summary.
	Status *string
}

// DataExport - The top level data export resource container.
type DataExport struct {
	// data export properties.
	Properties *DataExportProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataExportListResult - Result of the request to list data exports.
type DataExportListResult struct {
	// List of data export instances within a workspace..
	Value []*DataExport
}

// DataExportProperties - Data Export properties.
type DataExportProperties struct {
	// REQUIRED; An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
	TableNames []*string

	// The latest data export rule modification time.
	CreatedDate *string

	// The data export rule ID.
	DataExportID *string

	// destination properties.
	Destination *Destination

	// Active when enabled.
	Enable *bool

	// Date and time when the export was last modified.
	LastModifiedDate *string
}

// DataSource - Datasources under OMS Workspace.
type DataSource struct {
	// REQUIRED; The kind of the DataSource.
	Kind *DataSourceKind

	// REQUIRED; The data source properties in raw json format, each kind of data source have it's own schema.
	Properties any

	// The ETag of the data source.
	Etag *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataSourceFilter - DataSource filter. Right now, only filter by kind is supported.
type DataSourceFilter struct {
	// The kind of the DataSource.
	Kind *DataSourceKind
}

// DataSourceListResult - The list data source by workspace operation response.
type DataSourceListResult struct {
	// The link (url) to the next page of datasources.
	NextLink *string

	// A list of datasources.
	Value []*DataSource
}

// Destination properties.
type Destination struct {
	// REQUIRED; The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
	ResourceID *string

	// destination meta data.
	MetaData *DestinationMetaData

	// READ-ONLY; The type of the destination resource
	Type *Type
}

// DestinationMetaData - Destination meta data.
type DestinationMetaData struct {
	// Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
	EventHubName *string
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// Identity for the resource.
type Identity struct {
	// REQUIRED; Type of managed service identity.
	Type *IdentityType

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of resource.
	TenantID *string
}

// IntelligencePack - Intelligence Pack containing a string name and boolean indicating if it's enabled.
type IntelligencePack struct {
	// The display name of the intelligence pack.
	DisplayName *string

	// The enabled boolean for the intelligence pack.
	Enabled *bool

	// The name of the intelligence pack.
	Name *string
}

// KeyVaultProperties - The key vault properties.
type KeyVaultProperties struct {
	// The name of the key associated with the Log Analytics cluster.
	KeyName *string

	// Selected key minimum required size.
	KeyRsaSize *int32

	// The Key Vault uri which holds they key associated with the Log Analytics cluster.
	KeyVaultURI *string

	// The version of the key associated with the Log Analytics cluster.
	KeyVersion *string
}

// LinkedService - The top level Linked service resource container.
type LinkedService struct {
	// REQUIRED; The properties of the linked service.
	Properties *LinkedServiceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LinkedServiceListResult - The list linked service operation response.
type LinkedServiceListResult struct {
	// The list of linked service instances
	Value []*LinkedService
}

// LinkedServiceProperties - Linked service properties.
type LinkedServiceProperties struct {
	// The provisioning state of the linked service.
	ProvisioningState *LinkedServiceEntityStatus

	// The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require
	// read access
	ResourceID *string

	// The resource id of the resource that will be linked to the workspace. This should be used for linking resources which require
	// write access
	WriteAccessResourceID *string
}

// LinkedStorageAccountsListResult - The list linked storage accounts service operation response.
type LinkedStorageAccountsListResult struct {
	// A list of linked storage accounts instances.
	Value []*LinkedStorageAccountsResource
}

// LinkedStorageAccountsProperties - Linked storage accounts properties.
type LinkedStorageAccountsProperties struct {
	// Linked storage accounts resources ids.
	StorageAccountIDs []*string

	// READ-ONLY; Linked storage accounts type.
	DataSourceType *DataSourceType
}

// LinkedStorageAccountsResource - Linked storage accounts top level resource container.
type LinkedStorageAccountsResource struct {
	// REQUIRED; Linked storage accounts properties.
	Properties *LinkedStorageAccountsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ManagementGroup - A management group that is connected to a workspace
type ManagementGroup struct {
	// The properties of the management group.
	Properties *ManagementGroupProperties
}

// ManagementGroupProperties - Management group properties.
type ManagementGroupProperties struct {
	// The datetime that the management group was created.
	Created *time.Time

	// The last datetime that the management group received data.
	DataReceived *time.Time

	// The unique ID of the management group.
	ID *string

	// Gets or sets a value indicating whether the management group is a gateway.
	IsGateway *bool

	// The name of the management group.
	Name *string

	// The SKU of System Center that is managing the management group.
	SKU *string

	// The number of servers connected to the management group.
	ServerCount *int32

	// The version of System Center that is managing the management group.
	Version *string
}

// MetricName - The name of a metric.
type MetricName struct {
	// The localized name of the metric.
	LocalizedValue *string

	// The system name of the metric.
	Value *string
}

// Operation - Supported operation of OperationalInsights resource provider.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of operation
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Service provider: Microsoft OperationsManagement.
	Provider *string

	// Resource on which the operation is performed etc.
	Resource *string
}

// OperationListResult - Result of the request to list solution operations.
type OperationListResult struct {
	// List of solution operations supported by the OperationsManagement resource provider.
	Value []*Operation

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

// OperationStatus - The status of operation.
type OperationStatus struct {
	// The end time of the operation.
	EndTime *string

	// The error detail of the operation if any.
	Error *ErrorResponse

	// The operation Id.
	ID *string

	// The operation name.
	Name *string

	// The start time of the operation.
	StartTime *string

	// The status of the operation.
	Status *string
}

// PrivateLinkScopedResource - The private link scope resource reference.
type PrivateLinkScopedResource struct {
	// The full resource Id of the private link scope resource.
	ResourceID *string

	// The private link scope unique Identifier.
	ScopeID *string
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SavedSearch - Value object for saved search results.
type SavedSearch struct {
	// REQUIRED; The properties of the saved search.
	Properties *SavedSearchProperties

	// The ETag of the saved search. To override an existing saved search, use "*" or specify the current Etag
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SavedSearchProperties - Value object for saved search results.
type SavedSearchProperties struct {
	// REQUIRED; The category of the saved search. This helps the user to find a saved search faster.
	Category *string

	// REQUIRED; Saved search display name.
	DisplayName *string

	// REQUIRED; The query expression for the saved search.
	Query *string

	// The function alias if query serves as a function.
	FunctionAlias *string

	// The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1
	// = defaultvalue1, param-name2:type2 = defaultvalue2'. For more examples and
	// proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
	FunctionParameters *string

	// The tags attached to the saved search.
	Tags []*Tag

	// The version number of the query language. The current version is 2 and is the default.
	Version *int64
}

// SavedSearchesListResult - The saved search list operation response.
type SavedSearchesListResult struct {
	// The array of result values.
	Value []*SavedSearch
}

// SearchGetSchemaResponse - The get schema operation response.
type SearchGetSchemaResponse struct {
	// The metadata from search results.
	Metadata *SearchMetadata

	// The array of result values.
	Value []*SearchSchemaValue
}

// SearchMetadata - Metadata for search results.
type SearchMetadata struct {
	// The aggregated grouping fields.
	AggregatedGroupingFields *string

	// The aggregated value field.
	AggregatedValueField *string

	// The core summaries.
	CoreSummaries []*CoreSummary

	// The ETag of the search results.
	ETag *string

	// The id of the search results request.
	ID *string

	// The time of last update.
	LastUpdated *time.Time

	// The max of all aggregates returned in the result set.
	Max *int64

	// The request time.
	RequestTime *int64

	// The search result type.
	ResultType *string

	// The schema.
	Schema *SearchMetadataSchema

	// The request id of the search.
	SearchID *string

	// How the results are sorted.
	Sort []*SearchSort

	// The start time for the search.
	StartTime *time.Time

	// The status of the search results.
	Status *string

	// The sum of all aggregates returned in the result set.
	Sum *int64

	// The number of top search results.
	Top *int64

	// The total number of search results.
	Total *int64
}

// SearchMetadataSchema - Schema metadata for search.
type SearchMetadataSchema struct {
	// The name of the metadata schema.
	Name *string

	// The version of the metadata schema.
	Version *int32
}

// SearchSchemaValue - Value object for schema results.
type SearchSchemaValue struct {
	// REQUIRED; The boolean that indicates whether or not the field is a facet.
	Facet *bool

	// REQUIRED; The boolean that indicates the field is searchable as free text.
	Indexed *bool

	// REQUIRED; The boolean that indicates whether or not the field is stored.
	Stored *bool

	// The display name of the schema.
	DisplayName *string

	// The name of the schema.
	Name *string

	// The array of workflows containing the field.
	OwnerType []*string

	// The type.
	Type *string
}

// SearchSort - The sort parameters for search.
type SearchSort struct {
	// The name of the field the search query is sorted on.
	Name *string

	// The sort order of the search.
	Order *SearchSortEnum
}

// SharedKeys - The shared keys for a workspace.
type SharedKeys struct {
	// The primary shared key of a workspace.
	PrimarySharedKey *string

	// The secondary shared key of a workspace.
	SecondarySharedKey *string
}

// StorageAccount - Describes a storage account connection.
type StorageAccount struct {
	// REQUIRED; The Azure Resource Manager ID of the storage account resource.
	ID *string

	// REQUIRED; The storage account key.
	Key *string
}

// StorageInsight - The top level storage insight resource container.
type StorageInsight struct {
	// The ETag of the storage insight.
	ETag *string

	// Storage insight properties.
	Properties *StorageInsightProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StorageInsightListResult - The list storage insights operation response.
type StorageInsightListResult struct {
	// The link (url) to the next page of results.
	ODataNextLink *string

	// A list of storage insight items.
	Value []*StorageInsight
}

// StorageInsightProperties - Storage insight properties.
type StorageInsightProperties struct {
	// REQUIRED; The storage account connection details
	StorageAccount *StorageAccount

	// The names of the blob containers that the workspace should read
	Containers []*string

	// The names of the Azure tables that the workspace should read
	Tables []*string

	// READ-ONLY; The status of the storage insight
	Status *StorageInsightStatus
}

// StorageInsightStatus - The status of the storage insight.
type StorageInsightStatus struct {
	// REQUIRED; The state of the storage insight connection to the workspace
	State *StorageInsightState

	// Description of the state of the storage insight.
	Description *string
}

// Table - Workspace data table definition.
type Table struct {
	// Table properties.
	Properties *TableProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TableProperties - Table properties.
type TableProperties struct {
	// The data table data retention in days, between 30 and 730. Setting this property to null will default to the workspace
	// retention.
	RetentionInDays *int32
}

// TablesListResult - The list tables operation response.
type TablesListResult struct {
	// A list of data tables.
	Value []*Table
}

// Tag - A tag of a saved search.
type Tag struct {
	// REQUIRED; The tag name.
	Name *string

	// REQUIRED; The tag value.
	Value *string
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UsageMetric - A metric describing the usage of a resource.
type UsageMetric struct {
	// The current value of the metric.
	CurrentValue *float64

	// The quota limit for the metric.
	Limit *float64

	// The name of the metric.
	Name *MetricName

	// The time that the metric's value will reset.
	NextResetTime *time.Time

	// The quota period that determines the length of time between value resets.
	QuotaPeriod *string

	// The units used for the metric.
	Unit *string
}

// UserIdentityProperties - User assigned identity properties.
type UserIdentityProperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string
}

// Workspace - The top level Workspace resource container.
type Workspace struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The etag of the workspace.
	Etag *string

	// Workspace properties.
	Properties *WorkspaceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkspaceCapping - The daily volume cap for ingestion.
type WorkspaceCapping struct {
	// The workspace daily quota for ingestion.
	DailyQuotaGb *float64

	// READ-ONLY; The status of data ingestion for this workspace.
	DataIngestionStatus *DataIngestionStatus

	// READ-ONLY; The time when the quota will be rest.
	QuotaNextResetTime *string
}

// WorkspaceFeatures - Workspace features.
type WorkspaceFeatures struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]any

	// Dedicated LA cluster resourceId that is linked to the workspaces.
	ClusterResourceID *string

	// Disable Non-AAD based Auth.
	DisableLocalAuth *bool

	// Flag that indicate if data should be exported.
	EnableDataExport *bool

	// Flag that indicate which permission to use - resource or workspace or both.
	EnableLogAccessUsingOnlyResourcePermissions *bool

	// Flag that describes if we want to remove the data after 30 days.
	ImmediatePurgeDataOn30Days *bool
}

// WorkspaceListManagementGroupsResult - The list workspace management groups operation response.
type WorkspaceListManagementGroupsResult struct {
	// Gets or sets a list of management groups attached to the workspace.
	Value []*ManagementGroup
}

// WorkspaceListResult - The list workspaces operation response.
type WorkspaceListResult struct {
	// A list of workspaces.
	Value []*Workspace
}

// WorkspaceListUsagesResult - The list workspace usages operation response.
type WorkspaceListUsagesResult struct {
	// Gets or sets a list of usage metrics for a workspace.
	Value []*UsageMetric
}

// WorkspacePatch - The top level Workspace resource container.
type WorkspacePatch struct {
	// Workspace properties.
	Properties *WorkspaceProperties

	// Resource tags. Optional.
	Tags map[string]*string

	// READ-ONLY; Resource Etag.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// WorkspaceProperties - Workspace properties.
type WorkspaceProperties struct {
	// Workspace features.
	Features *WorkspaceFeatures

	// Indicates whether customer managed storage is mandatory for query management.
	ForceCmkForQuery *bool

	// The provisioning state of the workspace.
	ProvisioningState *WorkspaceEntityStatus

	// The network access type for accessing Log Analytics ingestion.
	PublicNetworkAccessForIngestion *PublicNetworkAccessType

	// The network access type for accessing Log Analytics query.
	PublicNetworkAccessForQuery *PublicNetworkAccessType

	// The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
	RetentionInDays *int32

	// The SKU of the workspace.
	SKU *WorkspaceSKU

	// The daily volume cap for ingestion.
	WorkspaceCapping *WorkspaceCapping

	// READ-ONLY; Workspace creation date.
	CreatedDate *string

	// READ-ONLY; This is a read-only property. Represents the ID associated with the workspace.
	CustomerID *string

	// READ-ONLY; Workspace modification date.
	ModifiedDate *string

	// READ-ONLY; List of linked private link scope resources.
	PrivateLinkScopedResources []*PrivateLinkScopedResource
}

// WorkspacePurgeBody - Describes the body of a purge request for an App Insights Workspace
type WorkspacePurgeBody struct {
	// REQUIRED; The set of columns and filters (queries) to run over them to purge the resulting data.
	Filters []*WorkspacePurgeBodyFilters

	// REQUIRED; Table from which to purge data.
	Table *string
}

// WorkspacePurgeBodyFilters - User-defined filters to return data which will be purged from the table.
type WorkspacePurgeBodyFilters struct {
	// The column of the table over which the given query should run
	Column *string

	// When filtering over custom dimensions, this key will be used as the name of the custom dimension.
	Key *string

	// A query operator to evaluate over the provided column and value(s). Supported operators are ==, =~, in, in~, >, >=, <,
	// <=, between, and have the same behavior as they would in a KQL query.
	Operator *string

	// the value for the operator to function over. This can be a number (e.g., > 100), a string (timestamp >= '2017-09-01') or
	// array of values.
	Value any
}

// WorkspacePurgeResponse - Response containing operationId for a specific purge action.
type WorkspacePurgeResponse struct {
	// REQUIRED; Id to use when querying for status for a particular purge operation.
	OperationID *string
}

// WorkspacePurgeStatusResponse - Response containing status for a specific purge operation.
type WorkspacePurgeStatusResponse struct {
	// REQUIRED; Status of the operation represented by the requested Id.
	Status *PurgeState
}

// WorkspaceSKU - The SKU (tier) of a workspace.
type WorkspaceSKU struct {
	// REQUIRED; The name of the SKU.
	Name *WorkspaceSKUNameEnum

	// The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
	CapacityReservationLevel *CapacityReservationLevel

	// READ-ONLY; The last time when the sku was updated.
	LastSKUUpdate *string
}
