//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkfunction

import "time"

// AzureTrafficCollector - Azure Traffic Collector resource.
type AzureTrafficCollector struct {
	// REQUIRED; Resource location.
	Location *string

	// Properties of the Azure Traffic Collector.
	Properties *AzureTrafficCollectorPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *TrackedResourceSystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AzureTrafficCollectorListResult - Response for the ListTrafficCollectors API service call.
type AzureTrafficCollectorListResult struct {
	// A list of Traffic Collector resources.
	Value []*AzureTrafficCollector

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// AzureTrafficCollectorPropertiesFormat - Azure Traffic Collector resource properties.
type AzureTrafficCollectorPropertiesFormat struct {
	// The virtualHub to which the Azure Traffic Collector belongs.
	VirtualHub *ResourceReference

	// READ-ONLY; Collector Policies for Azure Traffic Collector.
	CollectorPolicies []*ResourceReference

	// READ-ONLY; The provisioning state of the application rule collection resource.
	ProvisioningState *ProvisioningState
}

// CollectorPolicy - Collector policy resource.
type CollectorPolicy struct {
	// REQUIRED; Resource location.
	Location *string

	// Properties of the Collector Policy.
	Properties *CollectorPolicyPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *TrackedResourceSystemData

	// READ-ONLY; Resource type.
	Type *string
}

// CollectorPolicyListResult - Response for the ListCollectorPolicies API service call.
type CollectorPolicyListResult struct {
	// A list of collection policies.
	Value []*CollectorPolicy

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// CollectorPolicyPropertiesFormat - Collection policy properties.
type CollectorPolicyPropertiesFormat struct {
	// Emission policies.
	EmissionPolicies []*EmissionPoliciesPropertiesFormat

	// Ingestion policies.
	IngestionPolicy *IngestionPolicyPropertiesFormat

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState
}

// EmissionPoliciesPropertiesFormat - Emission policy properties.
type EmissionPoliciesPropertiesFormat struct {
	// Emission policy destinations.
	EmissionDestinations []*EmissionPolicyDestination

	// Emission format type.
	EmissionType *EmissionType
}

// EmissionPolicyDestination - Emission policy destination properties.
type EmissionPolicyDestination struct {
	// Emission destination type.
	DestinationType *DestinationType
}

// IngestionPolicyPropertiesFormat - Ingestion Policy properties.
type IngestionPolicyPropertiesFormat struct {
	// Ingestion Sources.
	IngestionSources []*IngestionSourcesPropertiesFormat

	// The ingestion type.
	IngestionType *IngestionType
}

// IngestionSourcesPropertiesFormat - Ingestion policy properties.
type IngestionSourcesPropertiesFormat struct {
	// Resource ID.
	ResourceID *string

	// Ingestion source type.
	SourceType *SourceType
}

// Operation - Azure Traffic Collector REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// Origin of the operation
	Origin *string
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Service provider: Microsoft NetworkFunction.
	Provider *string

	// Resource on which the operation is performed etc.
	Resource *string
}

// OperationListResult - Result of the request to list Azure Traffic Collector operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of operations supported by the Azure Traffic Collector resource provider.
	Value []*Operation
}

// ProxyResource - An azure resource object
type ProxyResource struct {
	// READ-ONLY; Azure resource Id
	ID *string

	// READ-ONLY; Azure resource name
	Name *string

	// READ-ONLY; Azure resource type
	Type *string
}

// ResourceReference - Resource reference properties.
type ResourceReference struct {
	// READ-ONLY; Resource ID.
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// TrackedResource - Common resource representation.
type TrackedResource struct {
	// REQUIRED; Resource location.
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *TrackedResourceSystemData

	// READ-ONLY; Resource type.
	Type *string
}

// TrackedResourceSystemData - Metadata pertaining to creation and last modification of the resource.
type TrackedResourceSystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
