//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupDelete.json
func ExampleSecurityGroupsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSecurityGroupsClient().BeginDelete(ctx, "rg1", "testnsg", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupGet.json
func ExampleSecurityGroupsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSecurityGroupsClient().Get(ctx, "rg1", "testnsg", &armnetwork.SecurityGroupsClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SecurityGroup = armnetwork.SecurityGroup{
	// 	Name: to.Ptr("testnsg"),
	// 	Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armnetwork.SecurityGroupPropertiesFormat{
	// 		DefaultSecurityRules: []*armnetwork.SecurityRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetInBound"),
	// 				Name: to.Ptr("AllowVnetInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
	// 				Name: to.Ptr("AllowAzureLoadBalancerInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from azure load balancer"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllInBound"),
	// 				Name: to.Ptr("DenyAllInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all inbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetOutBound"),
	// 				Name: to.Ptr("AllowVnetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowInternetOutBound"),
	// 				Name: to.Ptr("AllowInternetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("Internet"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllOutBound"),
	// 				Name: to.Ptr("DenyAllOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all outbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		SecurityRules: []*armnetwork.SecurityRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/securityRules/rule1"),
	// 				Name: to.Ptr("rule1"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("80"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](130),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupCreate.json
func ExampleSecurityGroupsClient_BeginCreateOrUpdate_createNetworkSecurityGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSecurityGroupsClient().BeginCreateOrUpdate(ctx, "rg1", "testnsg", armnetwork.SecurityGroup{
		Location: to.Ptr("eastus"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SecurityGroup = armnetwork.SecurityGroup{
	// 	Name: to.Ptr("testnsg"),
	// 	Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armnetwork.SecurityGroupPropertiesFormat{
	// 		DefaultSecurityRules: []*armnetwork.SecurityRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetInBound"),
	// 				Name: to.Ptr("AllowVnetInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
	// 				Name: to.Ptr("AllowAzureLoadBalancerInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from azure load balancer"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllInBound"),
	// 				Name: to.Ptr("DenyAllInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all inbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetOutBound"),
	// 				Name: to.Ptr("AllowVnetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowInternetOutBound"),
	// 				Name: to.Ptr("AllowInternetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("Internet"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllOutBound"),
	// 				Name: to.Ptr("DenyAllOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all outbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 		}},
	// 		FlushConnection: to.Ptr(false),
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		SecurityRules: []*armnetwork.SecurityRule{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupCreateWithRule.json
func ExampleSecurityGroupsClient_BeginCreateOrUpdate_createNetworkSecurityGroupWithRule() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSecurityGroupsClient().BeginCreateOrUpdate(ctx, "rg1", "testnsg", armnetwork.SecurityGroup{
		Location: to.Ptr("eastus"),
		Properties: &armnetwork.SecurityGroupPropertiesFormat{
			SecurityRules: []*armnetwork.SecurityRule{
				{
					Name: to.Ptr("rule1"),
					Properties: &armnetwork.SecurityRulePropertiesFormat{
						Access:                   to.Ptr(armnetwork.SecurityRuleAccessAllow),
						DestinationAddressPrefix: to.Ptr("*"),
						DestinationPortRange:     to.Ptr("80"),
						Direction:                to.Ptr(armnetwork.SecurityRuleDirectionInbound),
						Priority:                 to.Ptr[int32](130),
						SourceAddressPrefix:      to.Ptr("*"),
						SourcePortRange:          to.Ptr("*"),
						Protocol:                 to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
					},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SecurityGroup = armnetwork.SecurityGroup{
	// 	Name: to.Ptr("testnsg"),
	// 	Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg"),
	// 	Location: to.Ptr("eastus"),
	// 	Properties: &armnetwork.SecurityGroupPropertiesFormat{
	// 		DefaultSecurityRules: []*armnetwork.SecurityRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetInBound"),
	// 				Name: to.Ptr("AllowVnetInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
	// 				Name: to.Ptr("AllowAzureLoadBalancerInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from azure load balancer"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllInBound"),
	// 				Name: to.Ptr("DenyAllInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all inbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetOutBound"),
	// 				Name: to.Ptr("AllowVnetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowInternetOutBound"),
	// 				Name: to.Ptr("AllowInternetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("Internet"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllOutBound"),
	// 				Name: to.Ptr("DenyAllOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all outbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		SecurityRules: []*armnetwork.SecurityRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/securityRules/rule1"),
	// 				Name: to.Ptr("rule1"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("80"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](130),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupUpdateTags.json
func ExampleSecurityGroupsClient_UpdateTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSecurityGroupsClient().UpdateTags(ctx, "rg1", "testnsg", armnetwork.TagsObject{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
			"tag2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SecurityGroup = armnetwork.SecurityGroup{
	// 	Name: to.Ptr("testnsg"),
	// 	Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg"),
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"tag1": to.Ptr("value1"),
	// 		"tag2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armnetwork.SecurityGroupPropertiesFormat{
	// 		DefaultSecurityRules: []*armnetwork.SecurityRule{
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetInBound"),
	// 				Name: to.Ptr("AllowVnetInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
	// 				Name: to.Ptr("AllowAzureLoadBalancerInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow inbound traffic from azure load balancer"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllInBound"),
	// 				Name: to.Ptr("DenyAllInBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all inbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowVnetOutBound"),
	// 				Name: to.Ptr("AllowVnetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65000),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("VirtualNetwork"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/AllowInternetOutBound"),
	// 				Name: to.Ptr("AllowInternetOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
	// 					DestinationAddressPrefix: to.Ptr("Internet"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65001),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/testnsg/defaultSecurityRules/DenyAllOutBound"),
	// 				Name: to.Ptr("DenyAllOutBound"),
	// 				Properties: &armnetwork.SecurityRulePropertiesFormat{
	// 					Description: to.Ptr("Deny all outbound traffic"),
	// 					Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
	// 					DestinationAddressPrefix: to.Ptr("*"),
	// 					DestinationPortRange: to.Ptr("*"),
	// 					Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
	// 					Priority: to.Ptr[int32](65500),
	// 					ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 					SourceAddressPrefix: to.Ptr("*"),
	// 					SourcePortRange: to.Ptr("*"),
	// 					Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
	// 				},
	// 		}},
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 		SecurityRules: []*armnetwork.SecurityRule{
	// 		},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupListAll.json
func ExampleSecurityGroupsClient_NewListAllPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSecurityGroupsClient().NewListAllPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SecurityGroupListResult = armnetwork.SecurityGroupListResult{
		// 	Value: []*armnetwork.SecurityGroup{
		// 		{
		// 			Name: to.Ptr("nsg1"),
		// 			Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armnetwork.SecurityGroupPropertiesFormat{
		// 				DefaultSecurityRules: []*armnetwork.SecurityRule{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowVnetInBound"),
		// 						Name: to.Ptr("AllowVnetInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
		// 						Name: to.Ptr("AllowAzureLoadBalancerInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from azure load balancer"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/DenyAllInBound"),
		// 						Name: to.Ptr("DenyAllInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all inbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowVnetOutBound"),
		// 						Name: to.Ptr("AllowVnetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowInternetOutBound"),
		// 						Name: to.Ptr("AllowInternetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("Internet"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/DenyAllOutBound"),
		// 						Name: to.Ptr("DenyAllOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all outbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				SecurityRules: []*armnetwork.SecurityRule{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("nsg3"),
		// 			Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armnetwork.SecurityGroupPropertiesFormat{
		// 				DefaultSecurityRules: []*armnetwork.SecurityRule{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowVnetInBound"),
		// 						Name: to.Ptr("AllowVnetInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
		// 						Name: to.Ptr("AllowAzureLoadBalancerInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from azure load balancer"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/DenyAllInBound"),
		// 						Name: to.Ptr("DenyAllInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all inbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowVnetOutBound"),
		// 						Name: to.Ptr("AllowVnetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowInternetOutBound"),
		// 						Name: to.Ptr("AllowInternetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("Internet"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/DenyAllOutBound"),
		// 						Name: to.Ptr("DenyAllOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all outbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				SecurityRules: []*armnetwork.SecurityRule{
		// 				},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/NetworkSecurityGroupList.json
func ExampleSecurityGroupsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSecurityGroupsClient().NewListPager("rg1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SecurityGroupListResult = armnetwork.SecurityGroupListResult{
		// 	Value: []*armnetwork.SecurityGroup{
		// 		{
		// 			Name: to.Ptr("nsg1"),
		// 			Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armnetwork.SecurityGroupPropertiesFormat{
		// 				DefaultSecurityRules: []*armnetwork.SecurityRule{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowVnetInBound"),
		// 						Name: to.Ptr("AllowVnetInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
		// 						Name: to.Ptr("AllowAzureLoadBalancerInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from azure load balancer"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/DenyAllInBound"),
		// 						Name: to.Ptr("DenyAllInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all inbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowVnetOutBound"),
		// 						Name: to.Ptr("AllowVnetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/AllowInternetOutBound"),
		// 						Name: to.Ptr("AllowInternetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("Internet"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg1/defaultSecurityRules/DenyAllOutBound"),
		// 						Name: to.Ptr("DenyAllOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all outbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				SecurityRules: []*armnetwork.SecurityRule{
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("nsg3"),
		// 			Type: to.Ptr("Microsoft.Network/networkSecurityGroups"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armnetwork.SecurityGroupPropertiesFormat{
		// 				DefaultSecurityRules: []*armnetwork.SecurityRule{
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowVnetInBound"),
		// 						Name: to.Ptr("AllowVnetInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowAzureLoadBalancerInBound"),
		// 						Name: to.Ptr("AllowAzureLoadBalancerInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow inbound traffic from azure load balancer"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("AzureLoadBalancer"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/DenyAllInBound"),
		// 						Name: to.Ptr("DenyAllInBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all inbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionInbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowVnetOutBound"),
		// 						Name: to.Ptr("AllowVnetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to all VMs in VNET"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65000),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("VirtualNetwork"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/AllowInternetOutBound"),
		// 						Name: to.Ptr("AllowInternetOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Allow outbound traffic from all VMs to Internet"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessAllow),
		// 							DestinationAddressPrefix: to.Ptr("Internet"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65001),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 					},
		// 					{
		// 						ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkSecurityGroups/nsg3/defaultSecurityRules/DenyAllOutBound"),
		// 						Name: to.Ptr("DenyAllOutBound"),
		// 						Properties: &armnetwork.SecurityRulePropertiesFormat{
		// 							Description: to.Ptr("Deny all outbound traffic"),
		// 							Access: to.Ptr(armnetwork.SecurityRuleAccessDeny),
		// 							DestinationAddressPrefix: to.Ptr("*"),
		// 							DestinationPortRange: to.Ptr("*"),
		// 							Direction: to.Ptr(armnetwork.SecurityRuleDirectionOutbound),
		// 							Priority: to.Ptr[int32](65500),
		// 							ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 							SourceAddressPrefix: to.Ptr("*"),
		// 							SourcePortRange: to.Ptr("*"),
		// 							Protocol: to.Ptr(armnetwork.SecurityRuleProtocolAsterisk),
		// 						},
		// 				}},
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 				SecurityRules: []*armnetwork.SecurityRule{
		// 				},
		// 			},
		// 	}},
		// }
	}
}
