//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/netapp/armnetapp/v6"
	"net/http"
	"net/url"
	"regexp"
)

// SubvolumesServer is a fake server for instances of the armnetapp.SubvolumesClient type.
type SubvolumesServer struct {
	// BeginCreate is the fake for method SubvolumesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, subvolumeName string, body armnetapp.SubvolumeInfo, options *armnetapp.SubvolumesClientBeginCreateOptions) (resp azfake.PollerResponder[armnetapp.SubvolumesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method SubvolumesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, subvolumeName string, options *armnetapp.SubvolumesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetapp.SubvolumesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SubvolumesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, subvolumeName string, options *armnetapp.SubvolumesClientGetOptions) (resp azfake.Responder[armnetapp.SubvolumesClientGetResponse], errResp azfake.ErrorResponder)

	// BeginGetMetadata is the fake for method SubvolumesClient.BeginGetMetadata
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetMetadata func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, subvolumeName string, options *armnetapp.SubvolumesClientBeginGetMetadataOptions) (resp azfake.PollerResponder[armnetapp.SubvolumesClientGetMetadataResponse], errResp azfake.ErrorResponder)

	// NewListByVolumePager is the fake for method SubvolumesClient.NewListByVolumePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByVolumePager func(resourceGroupName string, accountName string, poolName string, volumeName string, options *armnetapp.SubvolumesClientListByVolumeOptions) (resp azfake.PagerResponder[armnetapp.SubvolumesClientListByVolumeResponse])

	// BeginUpdate is the fake for method SubvolumesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, accountName string, poolName string, volumeName string, subvolumeName string, body armnetapp.SubvolumePatchRequest, options *armnetapp.SubvolumesClientBeginUpdateOptions) (resp azfake.PollerResponder[armnetapp.SubvolumesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSubvolumesServerTransport creates a new instance of SubvolumesServerTransport with the provided implementation.
// The returned SubvolumesServerTransport instance is connected to an instance of armnetapp.SubvolumesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSubvolumesServerTransport(srv *SubvolumesServer) *SubvolumesServerTransport {
	return &SubvolumesServerTransport{
		srv:                  srv,
		beginCreate:          newTracker[azfake.PollerResponder[armnetapp.SubvolumesClientCreateResponse]](),
		beginDelete:          newTracker[azfake.PollerResponder[armnetapp.SubvolumesClientDeleteResponse]](),
		beginGetMetadata:     newTracker[azfake.PollerResponder[armnetapp.SubvolumesClientGetMetadataResponse]](),
		newListByVolumePager: newTracker[azfake.PagerResponder[armnetapp.SubvolumesClientListByVolumeResponse]](),
		beginUpdate:          newTracker[azfake.PollerResponder[armnetapp.SubvolumesClientUpdateResponse]](),
	}
}

// SubvolumesServerTransport connects instances of armnetapp.SubvolumesClient to instances of SubvolumesServer.
// Don't use this type directly, use NewSubvolumesServerTransport instead.
type SubvolumesServerTransport struct {
	srv                  *SubvolumesServer
	beginCreate          *tracker[azfake.PollerResponder[armnetapp.SubvolumesClientCreateResponse]]
	beginDelete          *tracker[azfake.PollerResponder[armnetapp.SubvolumesClientDeleteResponse]]
	beginGetMetadata     *tracker[azfake.PollerResponder[armnetapp.SubvolumesClientGetMetadataResponse]]
	newListByVolumePager *tracker[azfake.PagerResponder[armnetapp.SubvolumesClientListByVolumeResponse]]
	beginUpdate          *tracker[azfake.PollerResponder[armnetapp.SubvolumesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for SubvolumesServerTransport.
func (s *SubvolumesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SubvolumesClient.BeginCreate":
		resp, err = s.dispatchBeginCreate(req)
	case "SubvolumesClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "SubvolumesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SubvolumesClient.BeginGetMetadata":
		resp, err = s.dispatchBeginGetMetadata(req)
	case "SubvolumesClient.NewListByVolumePager":
		resp, err = s.dispatchNewListByVolumePager(req)
	case "SubvolumesClient.BeginUpdate":
		resp, err = s.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SubvolumesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := s.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subvolumes/(?P<subvolumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.SubvolumeInfo](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		subvolumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subvolumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreate(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, subvolumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		s.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		s.beginCreate.remove(req)
	}

	return resp, nil
}

func (s *SubvolumesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subvolumes/(?P<subvolumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		subvolumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subvolumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, subvolumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *SubvolumesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subvolumes/(?P<subvolumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
	if err != nil {
		return nil, err
	}
	volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
	if err != nil {
		return nil, err
	}
	subvolumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subvolumeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, subvolumeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SubvolumeInfo, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SubvolumesServerTransport) dispatchBeginGetMetadata(req *http.Request) (*http.Response, error) {
	if s.srv.BeginGetMetadata == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetMetadata not implemented")}
	}
	beginGetMetadata := s.beginGetMetadata.get(req)
	if beginGetMetadata == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subvolumes/(?P<subvolumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getMetadata`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		subvolumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subvolumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginGetMetadata(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, subvolumeNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetMetadata = &respr
		s.beginGetMetadata.add(req, beginGetMetadata)
	}

	resp, err := server.PollerResponderNext(beginGetMetadata, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginGetMetadata.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetMetadata) {
		s.beginGetMetadata.remove(req)
	}

	return resp, nil
}

func (s *SubvolumesServerTransport) dispatchNewListByVolumePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByVolumePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByVolumePager not implemented")}
	}
	newListByVolumePager := s.newListByVolumePager.get(req)
	if newListByVolumePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subvolumes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByVolumePager(resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, nil)
		newListByVolumePager = &resp
		s.newListByVolumePager.add(req, newListByVolumePager)
		server.PagerResponderInjectNextLinks(newListByVolumePager, req, func(page *armnetapp.SubvolumesClientListByVolumeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByVolumePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByVolumePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByVolumePager) {
		s.newListByVolumePager.remove(req)
	}
	return resp, nil
}

func (s *SubvolumesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := s.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetApp/netAppAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capacityPools/(?P<poolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/volumes/(?P<volumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/subvolumes/(?P<subvolumeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetapp.SubvolumePatchRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		poolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("poolName")])
		if err != nil {
			return nil, err
		}
		volumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("volumeName")])
		if err != nil {
			return nil, err
		}
		subvolumeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("subvolumeName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdate(req.Context(), resourceGroupNameParam, accountNameParam, poolNameParam, volumeNameParam, subvolumeNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		s.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		s.beginUpdate.remove(req)
	}

	return resp, nil
}
