//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mysql/armmysqlflexibleservers/v2"
	"net/http"
	"net/url"
	"regexp"
)

// LocationBasedCapabilitiesServer is a fake server for instances of the armmysqlflexibleservers.LocationBasedCapabilitiesClient type.
type LocationBasedCapabilitiesServer struct {
	// NewListPager is the fake for method LocationBasedCapabilitiesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(locationName string, options *armmysqlflexibleservers.LocationBasedCapabilitiesClientListOptions) (resp azfake.PagerResponder[armmysqlflexibleservers.LocationBasedCapabilitiesClientListResponse])
}

// NewLocationBasedCapabilitiesServerTransport creates a new instance of LocationBasedCapabilitiesServerTransport with the provided implementation.
// The returned LocationBasedCapabilitiesServerTransport instance is connected to an instance of armmysqlflexibleservers.LocationBasedCapabilitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLocationBasedCapabilitiesServerTransport(srv *LocationBasedCapabilitiesServer) *LocationBasedCapabilitiesServerTransport {
	return &LocationBasedCapabilitiesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmysqlflexibleservers.LocationBasedCapabilitiesClientListResponse]](),
	}
}

// LocationBasedCapabilitiesServerTransport connects instances of armmysqlflexibleservers.LocationBasedCapabilitiesClient to instances of LocationBasedCapabilitiesServer.
// Don't use this type directly, use NewLocationBasedCapabilitiesServerTransport instead.
type LocationBasedCapabilitiesServerTransport struct {
	srv          *LocationBasedCapabilitiesServer
	newListPager *tracker[azfake.PagerResponder[armmysqlflexibleservers.LocationBasedCapabilitiesClientListResponse]]
}

// Do implements the policy.Transporter interface for LocationBasedCapabilitiesServerTransport.
func (l *LocationBasedCapabilitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LocationBasedCapabilitiesClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LocationBasedCapabilitiesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DBforMySQL/locations/(?P<locationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("locationName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListPager(locationNameParam, nil)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmysqlflexibleservers.LocationBasedCapabilitiesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}
