//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmaps_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/maps/armmaps"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/CreateAccountEncryption.json
func ExampleAccountsClient_CreateOrUpdate_createAccountWithEncryption() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CreateOrUpdate(ctx, "myResourceGroup", "myMapsAccount", armmaps.Account{
		Location: to.Ptr("eastus"),
		Identity: &armmaps.ManagedServiceIdentity{
			Type: to.Ptr(armmaps.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
				"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": {},
			},
		},
		Kind: to.Ptr(armmaps.KindGen2),
		Properties: &armmaps.AccountProperties{
			Encryption: &armmaps.Encryption{
				CustomerManagedKeyEncryption: &armmaps.CustomerManagedKeyEncryption{
					KeyEncryptionKeyIdentity: &armmaps.CustomerManagedKeyEncryptionKeyIdentity{
						IdentityType:                   to.Ptr(armmaps.IdentityTypeUserAssignedIdentity),
						UserAssignedIdentityResourceID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName"),
					},
					KeyEncryptionKeyURL: to.Ptr("https://contosovault.vault.azure.net/keys/contosokek"),
				},
			},
		},
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameG2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"test": to.Ptr("true"),
	// 	},
	// 	Identity: &armmaps.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmaps.ManagedServiceIdentityTypeUserAssigned),
	// 		PrincipalID: to.Ptr("77f72dac-e0aa-484e-9acd-e5e7075310ef"),
	// 		TenantID: to.Ptr("06006684-60c1-4954-a20c-ffd8fbea7276"),
	// 		UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
	// 			"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": &armmaps.UserAssignedIdentity{
	// 				ClientID: to.Ptr("b602d315-01b5-4265-af23-859edc4f2431"),
	// 				PrincipalID: to.Ptr("ac287332-364a-41d9-a567-9ad86b9fc299"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen2),
	// 	Properties: &armmaps.AccountProperties{
	// 		Encryption: &armmaps.Encryption{
	// 			CustomerManagedKeyEncryption: &armmaps.CustomerManagedKeyEncryption{
	// 				KeyEncryptionKeyIdentity: &armmaps.CustomerManagedKeyEncryptionKeyIdentity{
	// 					IdentityType: to.Ptr(armmaps.IdentityTypeUserAssignedIdentity),
	// 					UserAssignedIdentityResourceID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName"),
	// 				},
	// 				KeyEncryptionKeyURL: to.Ptr("https://contosovault.vault.azure.net/keys/contosokek"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameG2),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/CreateAccountManagedIdentity.json
func ExampleAccountsClient_CreateOrUpdate_createAccountWithManagedIdentities() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CreateOrUpdate(ctx, "myResourceGroup", "myMapsAccount", armmaps.Account{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"test": to.Ptr("true"),
		},
		Identity: &armmaps.ManagedServiceIdentity{
			Type: to.Ptr(armmaps.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
				"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": {},
			},
		},
		Kind: to.Ptr(armmaps.KindGen2),
		Properties: &armmaps.AccountProperties{
			DisableLocalAuth: to.Ptr(false),
			LinkedResources: []*armmaps.LinkedResource{
				{
					ID:         to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Storage/accounts/mystorageacc"),
					UniqueName: to.Ptr("myBatchStorageAccount"),
				},
				{
					ID:         to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Storage/accounts/mystorageacc"),
					UniqueName: to.Ptr("myBlobDataSource"),
				}},
		},
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameG2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"test": to.Ptr("true"),
	// 	},
	// 	Identity: &armmaps.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmaps.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("77f72dac-e0aa-484e-9acd-e5e7075310ef"),
	// 		TenantID: to.Ptr("06006684-60c1-4954-a20c-ffd8fbea7276"),
	// 		UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
	// 			"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": &armmaps.UserAssignedIdentity{
	// 				ClientID: to.Ptr("b602d315-01b5-4265-af23-859edc4f2431"),
	// 				PrincipalID: to.Ptr("ac287332-364a-41d9-a567-9ad86b9fc299"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen2),
	// 	Properties: &armmaps.AccountProperties{
	// 		DisableLocalAuth: to.Ptr(true),
	// 		LinkedResources: []*armmaps.LinkedResource{
	// 			{
	// 				ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Storage/accounts/mystorageacc"),
	// 				UniqueName: to.Ptr("myBatchStorageAccount"),
	// 			},
	// 			{
	// 				ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Storage/accounts/mystorageacc"),
	// 				UniqueName: to.Ptr("myBlobDataSource"),
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameG2),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/CreateAccount.json
func ExampleAccountsClient_CreateOrUpdate_createGen1Account() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CreateOrUpdate(ctx, "myResourceGroup", "myMapsAccount", armmaps.Account{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"test": to.Ptr("true"),
		},
		Kind: to.Ptr(armmaps.KindGen1),
		Properties: &armmaps.AccountProperties{
			Cors: &armmaps.CorsRules{
				CorsRules: []*armmaps.CorsRule{
					{
						AllowedOrigins: []*string{
							to.Ptr("http://www.contoso.com"),
							to.Ptr("http://www.fabrikam.com")},
					}},
			},
			DisableLocalAuth: to.Ptr(false),
		},
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameS0),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"test": to.Ptr("true"),
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen1),
	// 	Properties: &armmaps.AccountProperties{
	// 		Cors: &armmaps.CorsRules{
	// 			CorsRules: []*armmaps.CorsRule{
	// 				{
	// 					AllowedOrigins: []*string{
	// 						to.Ptr("http://www.contoso.com"),
	// 						to.Ptr("http://www.fabrikam.com")},
	// 				}},
	// 			},
	// 			DisableLocalAuth: to.Ptr(false),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 		},
	// 		SKU: &armmaps.SKU{
	// 			Name: to.Ptr(armmaps.NameS0),
	// 			Tier: to.Ptr("Standard"),
	// 		},
	// 		SystemData: &armmaps.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/CreateAccountGen2.json
func ExampleAccountsClient_CreateOrUpdate_createGen2Account() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().CreateOrUpdate(ctx, "myResourceGroup", "myMapsAccount", armmaps.Account{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"test": to.Ptr("true"),
		},
		Kind: to.Ptr(armmaps.KindGen2),
		Properties: &armmaps.AccountProperties{
			Cors: &armmaps.CorsRules{
				CorsRules: []*armmaps.CorsRule{
					{
						AllowedOrigins: []*string{
							to.Ptr("http://www.contoso.com"),
							to.Ptr("http://www.fabrikam.com")},
					}},
			},
			DisableLocalAuth: to.Ptr(true),
		},
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameG2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"test": to.Ptr("true"),
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen2),
	// 	Properties: &armmaps.AccountProperties{
	// 		Cors: &armmaps.CorsRules{
	// 			CorsRules: []*armmaps.CorsRule{
	// 				{
	// 					AllowedOrigins: []*string{
	// 						to.Ptr("http://www.contoso.com"),
	// 						to.Ptr("http://www.fabrikam.com")},
	// 				}},
	// 			},
	// 			DisableLocalAuth: to.Ptr(true),
	// 			ProvisioningState: to.Ptr("Succeeded"),
	// 			UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 		},
	// 		SKU: &armmaps.SKU{
	// 			Name: to.Ptr(armmaps.NameG2),
	// 			Tier: to.Ptr("Standard"),
	// 		},
	// 		SystemData: &armmaps.SystemData{
	// 			CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 			CreatedBy: to.Ptr("string"),
	// 			CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 			LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 			LastModifiedBy: to.Ptr("string"),
	// 			LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/UpdateAccountEncryption.json
func ExampleAccountsClient_Update_updateAccountEncryption() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "myResourceGroup", "myMapsAccount", armmaps.AccountUpdateParameters{
		Identity: &armmaps.ManagedServiceIdentity{
			Type: to.Ptr(armmaps.ManagedServiceIdentityTypeSystemAssigned),
			UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
				"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": nil,
			},
		},
		Properties: &armmaps.AccountProperties{
			Encryption: &armmaps.Encryption{
				CustomerManagedKeyEncryption: &armmaps.CustomerManagedKeyEncryption{
					KeyEncryptionKeyIdentity: &armmaps.CustomerManagedKeyEncryptionKeyIdentity{
						IdentityType: to.Ptr(armmaps.IdentityTypeSystemAssignedIdentity),
					},
					KeyEncryptionKeyURL: to.Ptr("https://contosovault.vault.azure.net/keys/contosokek"),
				},
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Identity: &armmaps.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmaps.ManagedServiceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("77f72dac-e0aa-484e-9acd-e5e7075310ef"),
	// 		TenantID: to.Ptr("06006684-60c1-4954-a20c-ffd8fbea7276"),
	// 		UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
	// 			"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": &armmaps.UserAssignedIdentity{
	// 				ClientID: to.Ptr("b602d315-01b5-4265-af23-859edc4f2431"),
	// 				PrincipalID: to.Ptr("ac287332-364a-41d9-a567-9ad86b9fc299"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen2),
	// 	Properties: &armmaps.AccountProperties{
	// 		Encryption: &armmaps.Encryption{
	// 			CustomerManagedKeyEncryption: &armmaps.CustomerManagedKeyEncryption{
	// 				KeyEncryptionKeyIdentity: &armmaps.CustomerManagedKeyEncryptionKeyIdentity{
	// 					IdentityType: to.Ptr(armmaps.IdentityTypeSystemAssignedIdentity),
	// 				},
	// 				KeyEncryptionKeyURL: to.Ptr("https://contosovault.vault.azure.net/keys/contosokek"),
	// 			},
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameG2),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/UpdateAccountManagedIdentity.json
func ExampleAccountsClient_Update_updateAccountManagedIdentities() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "myResourceGroup", "myMapsAccount", armmaps.AccountUpdateParameters{
		Identity: &armmaps.ManagedServiceIdentity{
			Type: to.Ptr(armmaps.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
				"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": {},
			},
		},
		Kind: to.Ptr(armmaps.KindGen2),
		Properties: &armmaps.AccountProperties{
			LinkedResources: []*armmaps.LinkedResource{
				{
					ID:         to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/accounts/{storageName}"),
					UniqueName: to.Ptr("myBatchStorageAccount"),
				}},
		},
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameG2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Identity: &armmaps.ManagedServiceIdentity{
	// 		Type: to.Ptr(armmaps.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("77f72dac-e0aa-484e-9acd-e5e7075310ef"),
	// 		TenantID: to.Ptr("06006684-60c1-4954-a20c-ffd8fbea7276"),
	// 		UserAssignedIdentities: map[string]*armmaps.UserAssignedIdentity{
	// 			"/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityName": &armmaps.UserAssignedIdentity{
	// 				ClientID: to.Ptr("b602d315-01b5-4265-af23-859edc4f2431"),
	// 				PrincipalID: to.Ptr("ac287332-364a-41d9-a567-9ad86b9fc299"),
	// 			},
	// 		},
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen2),
	// 	Properties: &armmaps.AccountProperties{
	// 		DisableLocalAuth: to.Ptr(false),
	// 		LinkedResources: []*armmaps.LinkedResource{
	// 			{
	// 				ID: to.Ptr("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/accounts/{storageName}"),
	// 				UniqueName: to.Ptr("myBatchStorageAccount"),
	// 		}},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameG2),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/UpdateAccount.json
func ExampleAccountsClient_Update_updateAccountTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "myResourceGroup", "myMapsAccount", armmaps.AccountUpdateParameters{
		Tags: map[string]*string{
			"specialTag": to.Ptr("true"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"specialTag": to.Ptr("true"),
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen1),
	// 	Properties: &armmaps.AccountProperties{
	// 		DisableLocalAuth: to.Ptr(false),
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameS0),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/UpdateAccountGen1.json
func ExampleAccountsClient_Update_updateToGen1Account() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "myResourceGroup", "myMapsAccount", armmaps.AccountUpdateParameters{
		Kind: to.Ptr(armmaps.KindGen1),
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameS1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Kind: to.Ptr(armmaps.KindGen1),
	// 	Properties: &armmaps.AccountProperties{
	// 		DisableLocalAuth: to.Ptr(false),
	// 		LinkedResources: []*armmaps.LinkedResource{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameS1),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/UpdateAccountGen2.json
func ExampleAccountsClient_Update_updateToGen2Account() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Update(ctx, "myResourceGroup", "myMapsAccount", armmaps.AccountUpdateParameters{
		Kind: to.Ptr(armmaps.KindGen2),
		SKU: &armmaps.SKU{
			Name: to.Ptr(armmaps.NameG2),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Kind: to.Ptr(armmaps.KindGen2),
	// 	Properties: &armmaps.AccountProperties{
	// 		DisableLocalAuth: to.Ptr(false),
	// 		LinkedResources: []*armmaps.LinkedResource{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameG2),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/DeleteAccount.json
func ExampleAccountsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewAccountsClient().Delete(ctx, "myResourceGroup", "myMapsAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/GetAccount.json
func ExampleAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().Get(ctx, "myResourceGroup", "myMapsAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Account = armmaps.Account{
	// 	Name: to.Ptr("myMapsAccount"),
	// 	Type: to.Ptr("Microsoft.Maps/accounts"),
	// 	ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"test": to.Ptr("true"),
	// 	},
	// 	Kind: to.Ptr(armmaps.KindGen1),
	// 	Properties: &armmaps.AccountProperties{
	// 		DisableLocalAuth: to.Ptr(false),
	// 		LinkedResources: []*armmaps.LinkedResource{
	// 		},
	// 		ProvisioningState: to.Ptr("Succeeded"),
	// 		UniqueID: to.Ptr("string"),
	// 	},
	// 	SKU: &armmaps.SKU{
	// 		Name: to.Ptr(armmaps.NameS0),
	// 		Tier: to.Ptr("Standard"),
	// 	},
	// 	SystemData: &armmaps.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		CreatedBy: to.Ptr("string"),
	// 		CreatedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-07-02T01:01:01.107Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("string"),
	// 		LastModifiedByType: to.Ptr(armmaps.CreatedByTypeApplication),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/ListAccountsByResourceGroup.json
func ExampleAccountsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Accounts = armmaps.Accounts{
		// 	Value: []*armmaps.Account{
		// 		{
		// 			Name: to.Ptr("myMapsAccount2"),
		// 			Type: to.Ptr("Microsoft.Maps/accounts"),
		// 			ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount2"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"test": to.Ptr("true"),
		// 			},
		// 			Kind: to.Ptr(armmaps.KindGen1),
		// 			Properties: &armmaps.AccountProperties{
		// 				DisableLocalAuth: to.Ptr(false),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
		// 			},
		// 			SKU: &armmaps.SKU{
		// 				Name: to.Ptr(armmaps.NameS0),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myMapsAccount"),
		// 			Type: to.Ptr("Microsoft.Maps/accounts"),
		// 			ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"test": to.Ptr("true"),
		// 			},
		// 			Kind: to.Ptr(armmaps.KindGen2),
		// 			Properties: &armmaps.AccountProperties{
		// 				DisableLocalAuth: to.Ptr(true),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c592"),
		// 			},
		// 			SKU: &armmaps.SKU{
		// 				Name: to.Ptr(armmaps.NameG2),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/ListAccountsBySubscription.json
func ExampleAccountsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAccountsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.Accounts = armmaps.Accounts{
		// 	Value: []*armmaps.Account{
		// 		{
		// 			Name: to.Ptr("myMapsAccount2"),
		// 			Type: to.Ptr("Microsoft.Maps/accounts"),
		// 			ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount2"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"test": to.Ptr("true"),
		// 			},
		// 			Kind: to.Ptr(armmaps.KindGen1),
		// 			Properties: &armmaps.AccountProperties{
		// 				DisableLocalAuth: to.Ptr(false),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c593"),
		// 			},
		// 			SKU: &armmaps.SKU{
		// 				Name: to.Ptr(armmaps.NameS0),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("myMapsAccount"),
		// 			Type: to.Ptr("Microsoft.Maps/accounts"),
		// 			ID: to.Ptr("/subscriptions/21a9967a-e8a9-4656-a70b-96ff1c4d05a0/resourceGroups/myResourceGroup/providers/Microsoft.Maps/accounts/myMapsAccount"),
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"test": to.Ptr("true"),
		// 			},
		// 			Kind: to.Ptr(armmaps.KindGen2),
		// 			Properties: &armmaps.AccountProperties{
		// 				DisableLocalAuth: to.Ptr(true),
		// 				ProvisioningState: to.Ptr("Succeeded"),
		// 				UniqueID: to.Ptr("b2e763e6-d6f3-4858-9e2b-7cf8df85c592"),
		// 			},
		// 			SKU: &armmaps.SKU{
		// 				Name: to.Ptr(armmaps.NameG2),
		// 				Tier: to.Ptr("Standard"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/AccountListSAS.json
func ExampleAccountsClient_ListSas() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().ListSas(ctx, "myResourceGroup", "myMapsAccount", armmaps.AccountSasParameters{
		Expiry:           to.Ptr("2017-05-24T11:42:03.1567373Z"),
		MaxRatePerSecond: to.Ptr[int32](500),
		PrincipalID:      to.Ptr("e917f87b-324d-4728-98ed-e31d311a7d65"),
		Regions: []*string{
			to.Ptr("eastus")},
		SigningKey: to.Ptr(armmaps.SigningKeyPrimaryKey),
		Start:      to.Ptr("2017-05-24T10:42:03.1567373Z"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountSasToken = armmaps.AccountSasToken{
	// 	AccountSasToken: to.Ptr("accountSasToken"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/ListKeys.json
func ExampleAccountsClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().ListKeys(ctx, "myResourceGroup", "myMapsAccount", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountKeys = armmaps.AccountKeys{
	// 	PrimaryKey: to.Ptr("<primaryKey>"),
	// 	PrimaryKeyLastUpdated: to.Ptr("2021-07-02T01:01:01.1075056Z"),
	// 	SecondaryKey: to.Ptr("<secondaryKey>"),
	// 	SecondaryKeyLastUpdated: to.Ptr("2021-07-02T01:01:01.1075056Z"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b9403296f0b0e112b0d8222ad05fd1d79ee10e03/specification/maps/resource-manager/Microsoft.Maps/stable/2023-06-01/examples/RegenerateKey.json
func ExampleAccountsClient_RegenerateKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmaps.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAccountsClient().RegenerateKeys(ctx, "myResourceGroup", "myMapsAccount", armmaps.KeySpecification{
		KeyType: to.Ptr(armmaps.KeyTypePrimary),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountKeys = armmaps.AccountKeys{
	// 	PrimaryKey: to.Ptr("<primaryKey>"),
	// 	PrimaryKeyLastUpdated: to.Ptr("2021-07-02T01:01:01.1075056Z"),
	// 	SecondaryKey: to.Ptr("<secondaryKey>"),
	// 	SecondaryKeyLastUpdated: to.Ptr("2021-07-02T01:01:01.1075056Z"),
	// }
}
