//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armloadtesting_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/loadtesting/armloadtesting"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/Operations_List.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armloadtesting.OperationListResult{
		// 	Value: []*armloadtesting.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.LoadTestService/loadTests/Write"),
		// 			Display: &armloadtesting.OperationDisplay{
		// 				Description: to.Ptr("Set LoadTests"),
		// 				Operation: to.Ptr("Creates or updates the LoadTests"),
		// 				Provider: to.Ptr("Microsoft.LoadTestService"),
		// 				Resource: to.Ptr("loadTests"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.LoadTestService/loadTests/Delete"),
		// 			Display: &armloadtesting.OperationDisplay{
		// 				Description: to.Ptr("Delete LoadTests"),
		// 				Operation: to.Ptr("Deletes the LoadTests"),
		// 				Provider: to.Ptr("Microsoft.LoadTestService"),
		// 				Resource: to.Ptr("loadTests"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.LoadTestService/loadTests/Read"),
		// 			Display: &armloadtesting.OperationDisplay{
		// 				Description: to.Ptr("Read LoadTests"),
		// 				Operation: to.Ptr("Reads the LoadTests"),
		// 				Provider: to.Ptr("Microsoft.LoadTestService"),
		// 				Resource: to.Ptr("loadTests"),
		// 			},
		// 			IsDataAction: to.Ptr(false),
		// 	}},
		// }
	}
}
